/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.globalprovider.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.core.activityrepository.IconManager;
import de.aristaflow.adept2.core.globalprovider.IconProvider;
import de.aristaflow.adept2.core.globalprovider.defaultimplementation.AbstractProvider;
import de.aristaflow.adept2.core.globalprovider.defaultimplementation.DefaultGlobalProvider;
import de.aristaflow.adept2.model.common.IconDescriptor;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import org.apache.commons.configuration.Configuration;

public class DefaultIconProvider
extends AbstractProvider
implements IconProvider {
    protected IconManager iconManager;

    public DefaultIconProvider(DefaultGlobalProvider globalProvider, Configuration config, Registry dependencyRegistry, SessionToken initSession) throws AbortServiceException {
        super(globalProvider);
        this.iconManager = dependencyRegistry.getServiceOfType(initSession, "ActivityRepository", ActivityRepository.class).getIconManager();
    }

    @Override
    public IconDescriptor getIconDescriptor(SessionToken session, UUID iconID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        this.sessionActive(session);
        try {
            IconDescriptor iconDescriptor = this.iconManager.getLatestIconDescriptor(session, iconID);
            return iconDescriptor;
        }
        catch (UnknownEntityException unknownEntityException) {
            return null;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getIcon(SessionToken session, UUID iconID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        this.sessionActive(session);
        try {
            IconDescriptor descriptor = this.iconManager.getLatestIconDescriptor(session, iconID);
            byte[] byArray = this.iconManager.getLatestIcon(session, iconID, descriptor.getDimensions()[0]);
            return byArray;
        }
        catch (UnknownEntityException unknownEntityException) {
            return null;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getIcon(SessionToken session, UUID iconID, int width, int height) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        ArgChecks.checkForZero(width, "width");
        ArgChecks.checkForZero(height, "height");
        this.sessionActive(session);
        try {
            byte[] result;
            IconDescriptor descriptor;
            if (width < 0 && height < 0) {
                byte[] byArray = this.getIcon(session, iconID);
                return byArray;
            }
            try {
                descriptor = this.iconManager.getLatestIconDescriptor(session, iconID);
            }
            catch (UnknownEntityException unknownEntityException) {
                this.sessionFinished(session);
                return null;
            }
            IconDescriptor.Dimension iconDim = null;
            IconDescriptor.Dimension[] dimensionArray = descriptor.getDimensions();
            int n = dimensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconDescriptor.Dimension dim = dimensionArray[n2];
                if (iconDim == null) {
                    iconDim = dim;
                } else if (dim.width > width && dim.height > height) {
                    iconDim = dim;
                }
                ++n2;
            }
            if (iconDim == null) {
                return null;
            }
            byte[] iconData = this.iconManager.getLatestIcon(session, iconID, iconDim);
            if (width == iconDim.width && height == iconDim.height) {
                result = iconData;
            } else if (!Arrays.asList(ImageIO.getWriterFormatNames()).contains("png")) {
                result = null;
                String msg = "The icon could not be scaled because there was no registered image writer for 'png'!";
                this.getLogger().log(Level.SEVERE, msg);
            } else {
                try {
                    BufferedImage icon = ImageIO.read(new ByteArrayInputStream(iconData));
                    AffineTransform tx = new AffineTransform();
                    tx.scale((double)width / (double)iconDim.width, (double)height / (double)iconDim.height);
                    AffineTransformOp op = new AffineTransformOp(tx, 3);
                    icon = op.filter(icon, null);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)icon, "png", out);
                    result = out.toByteArray();
                }
                catch (IOException ex) {
                    result = null;
                    String msg = "The icon was found but it could not be scaled to the desired size!";
                    this.getLogger().log(Level.SEVERE, msg, ex);
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getIcon(SessionToken session, IconDescriptor iconDescriptor) {
        ArgChecks.checkForNull(iconDescriptor, "iconDescriptor");
        this.sessionActive(session);
        try {
            byte[] byArray = this.getIcon(session, iconDescriptor.getID());
            return byArray;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getIcon(SessionToken session, IconDescriptor iconDescriptor, int width, int height) {
        ArgChecks.checkForNull(iconDescriptor, "iconDescriptor");
        this.sessionActive(session);
        try {
            byte[] byArray = this.getIcon(session, iconDescriptor.getID(), width, height);
            return byArray;
        }
        finally {
            this.sessionFinished(session);
        }
    }
}

