/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.globalprovider.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.core.activityrepository.ResourceManager;
import de.aristaflow.adept2.core.globalprovider.ResourceProvider;
import de.aristaflow.adept2.core.globalprovider.defaultimplementation.AbstractProvider;
import de.aristaflow.adept2.core.globalprovider.defaultimplementation.DefaultGlobalProvider;
import de.aristaflow.adept2.model.common.ResourceDescriptor;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;

public class DefaultResourceProvider
extends AbstractProvider
implements ResourceProvider {
    protected ResourceManager resourceManager;

    public DefaultResourceProvider(DefaultGlobalProvider globalProvider, Configuration config, Registry dependencyRegistry, SessionToken initSession) throws AbortServiceException {
        super(globalProvider);
        this.resourceManager = dependencyRegistry.getServiceOfType(initSession, "ActivityRepository", ActivityRepository.class).getResourceManager();
    }

    @Override
    public ResourceDescriptor getResourceDescriptor(SessionToken session, UUID resourceID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        this.sessionActive(session);
        try {
            ResourceDescriptor resourceDescriptor = this.resourceManager.getLatestResourceDescriptor(session, resourceID);
            return resourceDescriptor;
        }
        catch (UnknownEntityException unknownEntityException) {
            return null;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getResource(SessionToken session, UUID resourceID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        this.sessionActive(session);
        try {
            byte[] byArray = this.resourceManager.getLatestResource(session, resourceID);
            return byArray;
        }
        catch (UnknownEntityException unknownEntityException) {
            return null;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getResource(SessionToken session, ResourceDescriptor resourceDescriptor) {
        this.sessionActive(session);
        try {
            ArgChecks.checkForNull(resourceDescriptor, "resourceDescriptor");
            byte[] byArray = this.getResource(session, resourceDescriptor.getID());
            return byArray;
        }
        finally {
            this.sessionFinished(session);
        }
    }
}

