/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.globalprovider.defaultimplementation.sql;

final class Constants {
    static final String TABLE = "GC_Configurations";

    private Constants() {
    }

    static final class Columns {
        static final String NAMESPACE = "namespace";
        static final String EC_NAME = "ecName";
        static final String OP_NAME = "operationName";
        static final String ACTIVITY_NAME = "activityName";
        static final String CONFIGURATION = "configuration";
        static final String TEST_CONFIGURATION = "testConfiguration";

        private Columns() {
        }
    }

    static final class Queries {
        private static String[] COLUMNS = new String[]{"namespace", "ecName", "operationName", "activityName", "configuration", "testConfiguration"};
        static final String getNamespaces = String.format("SELECT DISTINCT %s FROM %s", "namespace", "GC_Configurations");
        static final String getConfiguration = Queries.GET_CONF("IS NULL", "IS NULL", "IS NULL");
        static final String getConfiguration_ecd = Queries.GET_CONF("= ?", "IS NULL", "IS NULL");
        static final String getConfiguration_op = Queries.GET_CONF("= ?", "= ?", "IS NULL");
        static final String getConfiguration_act = Queries.GET_CONF("= ?", "= ?", "= ?");
        static final String CLEAN = String.format("DELETE FROM %s WHERE %s IS NULL AND %s IS NULL", "GC_Configurations", "configuration", "testConfiguration");

        static String setConfiguration_insert(boolean testConfiguration) {
            return Queries.SET_CONF_INSERT("null", "null", "null", testConfiguration);
        }

        static String setConfiguration_update(boolean testConfiguration) {
            return Queries.SET_CONF_UPDATE("IS NULL", "IS NULL", "IS NULL", testConfiguration);
        }

        static String setConfiguration_ecd_insert(boolean testConfiguration) {
            return Queries.SET_CONF_INSERT("?", "null", "null", testConfiguration);
        }

        static String setConfiguration_ecd_update(boolean testConfiguration) {
            return Queries.SET_CONF_UPDATE("= ?", "IS NULL", "IS NULL", testConfiguration);
        }

        static String setConfiguration_op_insert(boolean testConfiguration) {
            return Queries.SET_CONF_INSERT("?", "?", "null", testConfiguration);
        }

        static String setConfiguration_op_update(boolean testConfiguration) {
            return Queries.SET_CONF_UPDATE("= ?", "= ?", "IS NULL", testConfiguration);
        }

        static String setConfiguration_act_insert(boolean testConfiguration) {
            return Queries.SET_CONF_INSERT("?", "?", "?", testConfiguration);
        }

        static String setConfiguration_act_update(boolean testConfiguration) {
            return Queries.SET_CONF_UPDATE("= ?", "= ?", "= ?", testConfiguration);
        }

        private static String GET_CONF(String ecName, String opName, String actName) {
            return String.format("SELECT %s, %s FROM %s WHERE %s = ? AND %s %s AND %s %s AND %s %s", "configuration", "testConfiguration", Constants.TABLE, "namespace", "ecName", ecName, "operationName", opName, "activityName", actName);
        }

        private static String SET_CONF_INSERT(String ecName, String opName, String actName, boolean testConfiguration) {
            String confValue = testConfiguration ? "null" : "?";
            String testConfValue = testConfiguration ? "?" : "null";
            return String.format("INSERT INTO %s (%s, %s, %s, %s, %s, %s) VALUES(?, %s, %s, %s, %s, %s)", Constants.TABLE, "namespace", "ecName", "operationName", "activityName", "configuration", "testConfiguration", ecName, opName, actName, confValue, testConfValue);
        }

        private static String SET_CONF_UPDATE(String ecName, String opName, String actName, boolean testConfiguration) {
            String confColumn = testConfiguration ? "testConfiguration" : "configuration";
            return String.format("UPDATE %s SET %s = ? WHERE %s = ? AND %s %s AND %s %s AND %s %s", Constants.TABLE, confColumn, "namespace", "ecName", ecName, "operationName", opName, "activityName", actName);
        }

        private Queries() {
        }
    }
}

