/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.globalprovider.defaultimplementation.sql;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.SQLTools;
import de.aristaflow.adept2.base.service.DataConsistencyException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.globalprovider.defaultimplementation.sql.Constants;
import de.aristaflow.adept2.core.globalprovider.defaultimplementation.storage.GlobalConfigurationStorage;
import de.aristaflow.adept2.core.internal.SQLSessionManager;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.common.CommonModelFactory;
import de.aristaflow.adept2.model.common.XMLExportTools;
import de.aristaflow.adept2.model.common.XMLImportTools;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SQLGlobalConfigurationStorage
implements GlobalConfigurationStorage {
    private CommonModelFactory modelFactory;
    private SQLSessionManager sessionManager;

    public SQLGlobalConfigurationStorage(Configuration config, Registry dependencyRegistry, SessionToken initSession) throws AbortServiceException {
        this.modelFactory = dependencyRegistry.getModelFactory("ActivityModelFactory", ActivityModelFactory.class);
        JDBCDataSource dataSource = dependencyRegistry.getServiceOfType(initSession, "JDBCDataSource", JDBCDataSource.class);
        this.sessionManager = new SQLSessionManager(dataSource);
        this.sessionManager.startSession(initSession);
        try {
            try {
                this.sessionManager.startTransaction(initSession);
                ExtendedConnection con = this.sessionManager.getConnection(initSession);
                if (!con.tableExists("GC_Configurations")) {
                    SQLTools.runSQLScript(con, SQLGlobalConfigurationStorage.class.getResourceAsStream("sqlscripts/gc-create.sql"));
                }
                this.sessionManager.finishTransaction(initSession);
            }
            catch (Exception ex) {
                String msg = "An error occured while trying to verify/create the database structure.";
                LoggerTools.getLogger(this).log(Level.SEVERE, msg, ex);
                this.sessionManager.endSession(initSession);
            }
        }
        finally {
            this.sessionManager.endSession(initSession);
        }
    }

    @Override
    public Set<String> getNamespaces(SessionToken session) {
        HashSet<String> hashSet;
        ArgChecks.checkForNull(session, "session");
        ExtendedConnection con = this.sessionManager.getConnection(session);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(Constants.Queries.getNamespaces);
            HashSet<String> result = new HashSet<String>();
            while (rs.next()) {
                result.add(rs.getString("namespace"));
            }
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            hashSet = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(stmt, rs);
        return hashSet;
    }

    @Override
    public de.aristaflow.adept2.model.common.Configuration getConfiguration(SessionToken session, String namespace) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        return this.getConfiguration(session, namespace, null, null, null, false);
    }

    @Override
    public void setConfiguration(SessionToken session, String namespace, de.aristaflow.adept2.model.common.Configuration configuration) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        this.setConfiguration(session, namespace, null, null, null, false, configuration);
    }

    @Override
    public de.aristaflow.adept2.model.common.Configuration getTestConfiguration(SessionToken session, String namespace) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        return this.getConfiguration(session, namespace, null, null, null, true);
    }

    @Override
    public void setTestConfiguration(SessionToken session, String namespace, de.aristaflow.adept2.model.common.Configuration configuration) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        this.setConfiguration(session, namespace, null, null, null, true, configuration);
    }

    @Override
    public de.aristaflow.adept2.model.common.Configuration getConfiguration(SessionToken session, String namespace, String ecName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        return this.getConfiguration(session, namespace, ecName, null, null, false);
    }

    @Override
    public void setConfiguration(SessionToken session, String namespace, String ecName, de.aristaflow.adept2.model.common.Configuration configuration) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        this.setConfiguration(session, namespace, ecName, null, null, false, configuration);
    }

    @Override
    public de.aristaflow.adept2.model.common.Configuration getTestConfiguration(SessionToken session, String namespace, String ecName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        return this.getConfiguration(session, namespace, ecName, null, null, true);
    }

    @Override
    public void setTestConfiguration(SessionToken session, String namespace, String ecName, de.aristaflow.adept2.model.common.Configuration configuration) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        this.setConfiguration(session, namespace, ecName, null, null, true, configuration);
    }

    @Override
    public de.aristaflow.adept2.model.common.Configuration getConfiguration(SessionToken session, String namespace, String ecName, String opName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(opName, "opName");
        return this.getConfiguration(session, namespace, ecName, opName, null, false);
    }

    @Override
    public void setConfiguration(SessionToken session, String namespace, String ecName, String opName, de.aristaflow.adept2.model.common.Configuration configuration) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(opName, "opName");
        this.setConfiguration(session, namespace, ecName, opName, null, false, configuration);
    }

    @Override
    public de.aristaflow.adept2.model.common.Configuration getTestConfiguration(SessionToken session, String namespace, String ecName, String opName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(opName, "opName");
        return this.getConfiguration(session, namespace, ecName, opName, null, true);
    }

    @Override
    public void setTestConfiguration(SessionToken session, String namespace, String ecName, String opName, de.aristaflow.adept2.model.common.Configuration configuration) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(opName, "opName");
        this.setConfiguration(session, namespace, ecName, opName, null, false, configuration);
    }

    @Override
    public de.aristaflow.adept2.model.common.Configuration getConfiguration(SessionToken session, String namespace, String ecName, String opName, String actName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(opName, "opName");
        ArgChecks.checkForEmpty(actName, "actName");
        return this.getConfiguration(session, namespace, ecName, opName, actName, false);
    }

    @Override
    public void setConfiguration(SessionToken session, String namespace, String ecName, String opName, String actName, de.aristaflow.adept2.model.common.Configuration configuration) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(opName, "opName");
        ArgChecks.checkForEmpty(actName, "actName");
        this.setConfiguration(session, namespace, ecName, opName, actName, false, configuration);
    }

    @Override
    public de.aristaflow.adept2.model.common.Configuration getTestConfiguration(SessionToken session, String namespace, String ecName, String opName, String actName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(opName, "opName");
        ArgChecks.checkForEmpty(actName, "actName");
        return this.getConfiguration(session, namespace, ecName, opName, actName, true);
    }

    @Override
    public void setTestConfiguration(SessionToken session, String namespace, String ecName, String opName, String actName, de.aristaflow.adept2.model.common.Configuration configuration) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(namespace, "namespace");
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(opName, "opName");
        ArgChecks.checkForEmpty(actName, "actName");
        this.setConfiguration(session, namespace, ecName, opName, actName, true, configuration);
    }

    private de.aristaflow.adept2.model.common.Configuration getConfiguration(SessionToken session, String namespace, String ecName, String opName, String actName, boolean testConfiguration) {
        de.aristaflow.adept2.model.common.Configuration configuration;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForEmpty(namespace, "namespace");
        ExtendedConnection con = this.sessionManager.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = ecName == null ? Constants.Queries.getConfiguration : (opName == null ? Constants.Queries.getConfiguration_ecd : (actName == null ? Constants.Queries.getConfiguration_op : Constants.Queries.getConfiguration_act));
            pstmt = con.prepareStatement(query);
            int col = 0;
            pstmt.setString(++col, namespace);
            if (ecName != null) {
                pstmt.setString(++col, ecName);
                if (opName != null) {
                    pstmt.setString(++col, opName);
                    if (actName != null) {
                        pstmt.setString(++col, actName);
                    }
                }
            }
            de.aristaflow.adept2.model.common.Configuration result = (rs = pstmt.executeQuery()).next() ? this.readConfiguration(rs, testConfiguration) : null;
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            configuration = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return configuration;
    }

    private void setConfiguration(SessionToken session, String namespace, String ecName, String opName, String actName, boolean testConfiguration, de.aristaflow.adept2.model.common.Configuration configuration) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForEmpty(namespace, "namespace");
        ExtendedConnection con = this.sessionManager.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String sqlUpdate;
                String sqlInsert;
                String sqlGet;
                if (ecName == null) {
                    sqlGet = Constants.Queries.getConfiguration;
                    sqlInsert = Constants.Queries.setConfiguration_insert(testConfiguration);
                    sqlUpdate = Constants.Queries.setConfiguration_update(testConfiguration);
                } else if (opName == null) {
                    sqlGet = Constants.Queries.getConfiguration_ecd;
                    sqlInsert = Constants.Queries.setConfiguration_ecd_insert(testConfiguration);
                    sqlUpdate = Constants.Queries.setConfiguration_ecd_update(testConfiguration);
                } else if (actName == null) {
                    sqlGet = Constants.Queries.getConfiguration_op;
                    sqlInsert = Constants.Queries.setConfiguration_op_insert(testConfiguration);
                    sqlUpdate = Constants.Queries.setConfiguration_op_update(testConfiguration);
                } else {
                    sqlGet = Constants.Queries.getConfiguration_act;
                    sqlInsert = Constants.Queries.setConfiguration_act_insert(testConfiguration);
                    sqlUpdate = Constants.Queries.setConfiguration_act_update(testConfiguration);
                }
                pstmt = con.prepareStatement(sqlGet);
                int col = 0;
                pstmt.setString(++col, namespace);
                if (ecName != null) {
                    pstmt.setString(++col, ecName);
                    if (opName != null) {
                        pstmt.setString(++col, opName);
                        if (actName != null) {
                            pstmt.setString(++col, actName);
                        }
                    }
                }
                rs = pstmt.executeQuery();
                boolean exists = rs.next();
                rs = JDBCTools.close(rs);
                pstmt = JDBCTools.close(pstmt);
                if (exists) {
                    pstmt = con.prepareStatement(sqlUpdate);
                    col = 0;
                    this.writeConfiguration(pstmt, ++col, configuration);
                    pstmt.setString(++col, namespace);
                    if (ecName != null) {
                        pstmt.setString(++col, ecName);
                        if (opName != null) {
                            pstmt.setString(++col, opName);
                            if (actName != null) {
                                pstmt.setString(++col, actName);
                            }
                        }
                    }
                } else {
                    pstmt = con.prepareStatement(sqlInsert);
                    col = 0;
                    pstmt.setString(++col, namespace);
                    if (ecName != null) {
                        pstmt.setString(++col, ecName);
                        if (opName != null) {
                            pstmt.setString(++col, opName);
                            if (actName != null) {
                                pstmt.setString(++col, actName);
                            }
                        }
                    }
                    this.writeConfiguration(pstmt, ++col, configuration);
                }
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
                if (configuration == null) {
                    pstmt = con.prepareStatement(Constants.Queries.CLEAN);
                    pstmt.executeUpdate();
                    pstmt = JDBCTools.close(pstmt);
                }
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
    }

    private de.aristaflow.adept2.model.common.Configuration readConfiguration(ResultSet rs, boolean testConfiguration) throws SQLException {
        de.aristaflow.adept2.model.common.Configuration result;
        String columnName = testConfiguration ? "testConfiguration" : "configuration";
        byte[] value = rs.getBytes(columnName);
        if (value == null) {
            result = null;
        } else {
            try {
                Document document = XMLHelperTools.getDocumentFromStream(new ByteArrayInputStream(value));
                result = XMLImportTools.getConfiguration(this.modelFactory, document.getDocumentElement());
            }
            catch (XMLFormatException xMLFormatException) {
                String msg = "";
                throw new DataConsistencyException(msg);
            }
            catch (IOException iOException) {
                String msg = "";
                throw new InternalServiceException(msg);
            }
        }
        return result;
    }

    private void writeConfiguration(PreparedStatement pstmt, int parameterIndex, de.aristaflow.adept2.model.common.Configuration configuration) throws SQLException {
        byte[] value;
        if (configuration != null) {
            try {
                Document document = XMLHelperTools.createDocument();
                Element element = XMLExportTools.createConfigurationElement(document, "http://www.aristaflow.de/adept2/activitymodel", configuration, "configuration", null, null);
                document.appendChild(element);
                value = XMLHelperTools.getByteArrayForDocument(document);
            }
            catch (IOException iOException) {
                String msg = "";
                throw new InternalServiceException(msg);
            }
        } else {
            value = null;
        }
        pstmt.setBytes(parameterIndex, value);
    }

    @Override
    public void startSession(SessionToken session) {
        this.sessionManager.startSession(session);
    }

    @Override
    public void endSession(SessionToken session) {
        this.sessionManager.endSession(session);
    }
}

