/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.inittab.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.executionmanager.InstanceStateListener;
import de.aristaflow.adept2.core.executionmanager.InstanceStateNotification;
import de.aristaflow.adept2.core.inittab.InitTabEntry;
import de.aristaflow.adept2.core.inittab.InitTabManager;
import de.aristaflow.adept2.core.inittab.InternalInitTabEntry;
import de.aristaflow.adept2.core.inittab.defaultimplementation.DefaultInitTabEntry;
import de.aristaflow.adept2.core.inittab.defaultimplementation.DefaultInternalInitTabEntry;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="StorageDir", type=Property.Type.STRING, description="The directory where the init tab entries are stored.", isRequired=true), @Property(name="UserName", type=Property.Type.STRING, description="The user name of the init tab agent.", defaultValue="system"), @Property(name="UserOrgPositionID", type=Property.Type.LONG, description="The org position ID of the init tab agent.", defaultValue="-2"), @Property(name="UserPassword", type=Property.Type.STRING, description="The password of the init tab agent.", defaultValue="password")})
public class DefaultInitTabManager
extends AbstractADEPT2Service
implements InitTabManager,
InstanceStateListener,
InstanceStateNotification {
    protected static final String CFG_STORAGE_DIR = "StorageDir";
    protected static final String CFG_USER_NAME = "UserName";
    protected static final String CFG_ORG_POSITION_ID = "UserOrgPositionID";
    protected static final String CFG_PASSWORD = "UserPassword";
    protected static final String FILE_INITTAB = "InitTab";
    private static final String[] STARTUP_REQUIRED_SERVICES = new String[]{"SubprocessManager", "DataManager", "WorklistManager", "ExecutionManager", "ProcessManager"};
    private static final boolean PROPAGATE_TO_RUNNING_ACTIVITIES = false;
    private final Map<InitTabManager.InitType, TreeMap<Integer, InternalInitTabEntry>> initTab = Collections.synchronizedMap(new HashMap());
    private final File dir;
    private final File initTabFile;
    private final File initTabTempFile;
    protected ClientSessionFactory csf;
    protected InstanceControl instanceControl;
    private ExecutionFactory executionFactory;
    private final Configuration configuration;
    protected final Map<UUID, CountDownLatch> awaiting = Collections.synchronizedMap(new HashMap());
    protected final Map<UUID, InternalInitTabEntry> instanceEntries = Collections.synchronizedMap(new HashMap());
    private boolean shuttingDown = false;

    public DefaultInitTabManager(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry, STARTUP_REQUIRED_SERVICES, new String[0]);
        this.configuration = configuration;
        String dirName = configuration.getString(CFG_STORAGE_DIR);
        this.dir = new File(dirName);
        try {
            if (!(!this.dir.exists() || this.dir.canRead() && this.dir.canWrite())) {
                String msg = String.format("Configuration directory '%s' doesn't exist or is not accessible.", this.dir);
                throw new ConfigurationException(msg);
            }
            if (!this.dir.exists() && !this.dir.mkdirs()) {
                String msg = String.format("Could not create configuration directory '%s'.", this.dir);
                throw new ConfigurationException(msg);
            }
        }
        catch (SecurityException securityException) {
            String msg = String.format("Could not access configuration directory '%s'.", this.dir);
            throw new ConfigurationException(msg);
        }
        this.initTabFile = new File(this.dir, FILE_INITTAB);
        try {
            if (!this.initTabFile.exists() && !this.initTabFile.createNewFile()) {
                String msg = String.format("Could not create init tab file '%s'.", this.initTabFile);
                throw new ConfigurationException(msg);
            }
        }
        catch (IOException e) {
            String msg = String.format("Could not create init tab file '%s'.", this.initTabFile);
            throw new ConfigurationException(msg, e);
        }
        catch (SecurityException securityException) {
            String msg = String.format("Could not access init tab file '%s'.", this.initTabFile);
            throw new ConfigurationException(msg);
        }
        this.initTabTempFile = new File(this.dir, "InitTab.tmp");
        try {
            if (this.initTabTempFile.exists()) {
                String msg = String.format("The temporary init tab temp file (%s) exists \u00e2\u20ac\u201c unfinished transaction?", this.initTabTempFile);
                this.logger.severe(msg);
                throw new ConfigurationException(msg);
            }
        }
        catch (SecurityException securityException) {
            String msg = String.format("Could not access init tab temporary file '%s'.", this.initTabTempFile);
            throw new ConfigurationException(msg);
        }
        this.reloadInitTab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadInitTab() throws ConfigurationException {
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(this.initTabFile));
            }
            catch (FileNotFoundException e) {
                String msg = "Constructor checked existence!";
                this.logger.log(Level.SEVERE, msg, e);
                throw new IllegalStateException(msg, e);
            }
            this.initTab.clear();
            try {
                String line = br.readLine();
                while (line != null) {
                    if (!line.trim().equals("") && !line.startsWith("#")) {
                        boolean enabled;
                        boolean isForking;
                        UUID templateID;
                        int priority;
                        InitTabManager.InitType type;
                        String[] strings = line.split(":");
                        if (strings.length < 6) {
                            String msg = String.format("Invalid line found: '%s'.", line);
                            this.logger.severe(msg);
                            throw new ConfigurationException(msg);
                        }
                        UUID instanceID = null;
                        boolean suspendedByUser = false;
                        try {
                            type = InitTabManager.InitType.valueOf(strings[0].trim());
                            priority = Integer.valueOf(strings[1].trim());
                            templateID = UUID.fromString(strings[2].trim());
                            isForking = Boolean.valueOf(strings[3].trim());
                            enabled = Boolean.valueOf(strings[5].trim());
                            if (strings.length >= 7 && strings[6].length() > 0) {
                                instanceID = UUID.fromString(strings[6]);
                            }
                            if (strings.length >= 8) {
                                suspendedByUser = Boolean.valueOf(strings[7]);
                            }
                        }
                        catch (NumberFormatException e) {
                            String msg = String.format("Could not parse the priority from value '%s' in line '%s'.", strings[1].trim(), line);
                            this.logger.log(Level.SEVERE, msg, e);
                            throw new ConfigurationException(msg, e);
                        }
                        catch (IllegalArgumentException e) {
                            String msg = String.format("Could not parse the type, the template ID or the instance ID, from value '%s', '%s' or '%s' in line '%s'.", strings[0].trim(), strings[2].trim(), strings.length >= 7 ? strings[6] : "n/a", line);
                            this.logger.log(Level.SEVERE, msg, e);
                            throw new ConfigurationException(msg, e);
                        }
                        String comment = strings[4];
                        InternalInitTabEntry entry = this.createInternalInitTabEntry(type, priority, templateID, isForking, comment, enabled, instanceID, suspendedByUser);
                        File inputDataFile = this.getInputDataFile(entry);
                        try {
                            if (inputDataFile.exists()) {
                                entry.setInputData(null);
                            }
                        }
                        catch (SecurityException securityException) {
                            String msg = String.format("Could not access init tab data file '%s'.", inputDataFile);
                            throw new ConfigurationException(msg);
                        }
                        Map<InitTabManager.InitType, TreeMap<Integer, InternalInitTabEntry>> map = this.initTab;
                        synchronized (map) {
                            this.getTabForType(type).put(priority, entry);
                        }
                    }
                    line = br.readLine();
                }
                br.close();
            }
            catch (IOException e) {
                String msg = "Exception while reading init tab.";
                this.logger.log(Level.SEVERE, msg, e);
                throw new ConfigurationException(msg, e);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    String msg = "Exception while closing buffered init tab reader.";
                    this.logger.log(Level.SEVERE, msg, e);
                    throw new ConfigurationException(msg, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TreeMap<Integer, InternalInitTabEntry> getTabForType(InitTabManager.InitType type) {
        Map<InitTabManager.InitType, TreeMap<Integer, InternalInitTabEntry>> map = this.initTab;
        synchronized (map) {
            if (!this.initTab.containsKey((Object)type)) {
                this.initTab.put(type, new TreeMap());
            }
            return this.initTab.get((Object)type);
        }
    }

    private File getInputDataFile(InitTabEntry entry) {
        return new File(this.dir, (Object)((Object)entry.getInitType()) + "_" + entry.getLevel());
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        try {
            String userName = this.configuration.getString(CFG_USER_NAME);
            long orgPositionID = this.configuration.getLong(CFG_ORG_POSITION_ID);
            String password = this.configuration.getString(CFG_PASSWORD);
            this.csf = this.registry.getSecurityManager().authenticate(userName, orgPositionID, password);
            password = null;
            this.csf.setClientURIs(myURIs);
        }
        catch (AuthenticationException ae) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to wrongauthentication data. Check the configuration of this DataManager.", ae);
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to unavailability of the data.", dse);
        }
        SessionToken session = this.csf.getSessionToken();
        this.instanceControl = this.registry.getServiceOfType(session, "ExecutionManager", ExecutionManager.class).getInstanceControl();
        this.executionFactory = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
    }

    @Override
    public void start() throws AbortServiceException {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (InternalInitTabEntry entry : DefaultInitTabManager.this.getTabForType(InitTabManager.InitType.BOOT).values()) {
                    String message;
                    try {
                        DefaultInitTabManager.this.executeTemplate(entry, !entry.isForking());
                    }
                    catch (InvalidTemplateStateException e) {
                        message = String.format("Could not instantiate the template of init tab entry, '%s'.", entry);
                        DefaultInitTabManager.this.logger.log(Level.SEVERE, message, e);
                    }
                    catch (InterruptedException ie) {
                        message = String.format("Caught interrupt while executing boot processes, ", new Object[0]);
                        DefaultInitTabManager.this.logger.log(Level.WARNING, message, ie);
                        Thread.interrupted();
                        if (entry.getInstanceID() == null) break;
                        CountDownLatch latch = null;
                        Map<UUID, CountDownLatch> map = DefaultInitTabManager.this.awaiting;
                        synchronized (map) {
                            if (DefaultInitTabManager.this.awaiting.containsKey(entry.getInstanceID())) {
                                latch = DefaultInitTabManager.this.awaiting.get(entry.getInstanceID());
                            }
                        }
                        if (latch == null) break;
                        try {
                            latch.await();
                        }
                        catch (InterruptedException interruptedException) {
                            String message2 = String.format("Caught second interrupt while waiting for finish, aborting instance %s.", entry.getInstanceID());
                            try {
                                DefaultInitTabManager.this.instanceControl.stopAndAbortInstance(DefaultInitTabManager.this.csf.getSessionToken(), entry.getInstanceID(), true, message2, "Abort due to second interrupt", 1001L);
                            }
                            catch (InvalidInstanceStateException e2) {
                                DefaultInitTabManager.this.logger.log(Level.INFO, "Could not stop instance.", e2);
                            }
                        }
                        break;
                    }
                }
                for (InternalInitTabEntry entry : DefaultInitTabManager.this.getTabForType(InitTabManager.InitType.RESPAWN).values()) {
                    String message;
                    ProcessConstants.InstanceExecutionStatus instanceExecutionStatus;
                    block28: {
                        if (entry.getInstanceID() != null) {
                            if (!entry.isSuspendedByUser()) {
                                try {
                                    int retries = 5;
                                    InvalidServiceStateException lastISSE = null;
                                    while (retries > 0) {
                                        try {
                                            DefaultInitTabManager.this.instanceControl.resumeInstance(DefaultInitTabManager.this.csf.getSessionToken(), entry.getInstanceID(), DefaultInitTabManager.this.getURIs());
                                            lastISSE = null;
                                            break;
                                        }
                                        catch (InvalidServiceStateException e) {
                                            lastISSE = e;
                                            if (!(e.getCause() instanceof TimeoutException)) break;
                                            --retries;
                                        }
                                    }
                                    if (retries == 0 || lastISSE != null) {
                                        instanceExecutionStatus = ProcessConstants.InstanceExecutionStatus.IE_SUSPENDED;
                                        String msg = String.format("Could not resume the instance of init tab entry, '%s', because of an InvalidServiceStateException. Retries left: %s.", entry, retries);
                                        DefaultInitTabManager.this.logger.log(Level.SEVERE, msg, lastISSE);
                                        break block28;
                                    }
                                    instanceExecutionStatus = ProcessConstants.InstanceExecutionStatus.IE_RUNNING;
                                    DefaultInitTabManager.this.instanceEntries.put(entry.getInstanceID(), entry);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    instanceExecutionStatus = null;
                                    DefaultInitTabManager.this.logger.warning(String.format("Could not resume the instance of init tab entry, '%s', since the instance has been deleted!", entry));
                                }
                                catch (InvalidInstanceStateException e) {
                                    instanceExecutionStatus = e.getInstanceExecutionStatus();
                                    if (instanceExecutionStatus == ProcessConstants.InstanceExecutionStatus.IE_RUNNING) {
                                        DefaultInitTabManager.this.logger.warning(String.format("Could not resume the instance of init tab entry, '%s', since the instance was still running - unclean shutdown?.", entry));
                                        break block28;
                                    }
                                    message = String.format("Could not resume the instance of init tab entry, '%s', since the instance is in state %s.", new Object[]{entry, instanceExecutionStatus});
                                    DefaultInitTabManager.this.logger.severe(message);
                                }
                            } else {
                                instanceExecutionStatus = ProcessConstants.InstanceExecutionStatus.IE_SUSPENDED;
                            }
                        } else {
                            instanceExecutionStatus = null;
                        }
                    }
                    if (instanceExecutionStatus != null && instanceExecutionStatus != ProcessConstants.InstanceExecutionStatus.IE_FINISHED && instanceExecutionStatus != ProcessConstants.InstanceExecutionStatus.IE_ABORTED && instanceExecutionStatus != ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_ABORTED) continue;
                    try {
                        DefaultInitTabManager.this.executeTemplate(entry, false);
                    }
                    catch (InvalidTemplateStateException e) {
                        message = String.format("Could not instantiate the template of init tab entry, '%s'.", entry);
                        DefaultInitTabManager.this.logger.log(Level.SEVERE, message, e);
                    }
                    catch (InterruptedException ie) {
                        message = String.format("Interrupted during startup while spawning instances.", new Object[0]);
                        DefaultInitTabManager.this.logger.log(Level.WARNING, message, ie);
                        break;
                    }
                }
            }
        }).start();
        super.start();
    }

    protected void executeTemplate(InternalInitTabEntry entry, boolean await) throws InvalidTemplateStateException, InterruptedException {
        UUID instanceID;
        if (!entry.isEnabled()) {
            return;
        }
        URI[] stateListener = entry.isForking() ? null : this.getURIs();
        ExecutionContext executionContext = this.executionFactory.getExecutionContext(this.csf.getAuthenticatedAgent().getQualifiedAgent(), null, entry.getInputData(), null, null);
        try {
            instanceID = this.instanceControl.createAndStartInstance(this.csf.getSessionToken(), entry.getTemplateID(), executionContext, stateListener);
        }
        catch (InvalidDataContainerException e) {
            String message = String.format("Found an invalid data container for entry '%s'!", entry);
            this.logger.log(Level.SEVERE, message, e);
            return;
        }
        entry.setInstanceID(instanceID);
        entry.setSuspendedByUser(false);
        if (entry.getInitType() == InitTabManager.InitType.RESPAWN) {
            this.updateInitTabFile(InitFileUpdateOperation.UPDATE_ENTRY, entry.getInitType(), entry.getLevel(), entry);
        }
        this.instanceEntries.put(instanceID, entry);
        CountDownLatch latch = this.getOrInitialiseLatch(instanceID);
        if (await) {
            latch.await();
            this.awaiting.remove(instanceID);
        }
    }

    @Override
    public InstanceStateNotification getInstanceStateNotification() {
        return this;
    }

    protected void respawnInstance(InternalInitTabEntry entry) {
        block3: {
            try {
                this.executeTemplate(entry, false);
            }
            catch (InvalidTemplateStateException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"Unreachable code");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CountDownLatch getOrInitialiseLatch(UUID instanceID) {
        CountDownLatch latch;
        Map<UUID, CountDownLatch> map = this.awaiting;
        synchronized (map) {
            if (this.awaiting.containsKey(instanceID)) {
                latch = this.awaiting.get(instanceID);
            } else {
                latch = new CountDownLatch(1);
                this.awaiting.put(instanceID, latch);
            }
        }
        return latch;
    }

    @Override
    public void shutdown() {
        String message;
        this.shuttingDown = true;
        super.shutdown();
        this.consoleLog("Stopping RESPAWN processes...");
        for (InternalInitTabEntry entry : this.getTabForType(InitTabManager.InitType.RESPAWN).values()) {
            String message2;
            if (entry.getInstanceID() == null) {
                if (!entry.isEnabled()) continue;
                message2 = String.format("RESPAWN entry (level %s, template %s) did not have a running instance!", entry.getLevel(), entry.getTemplateID());
                this.logger.warning(message2);
                continue;
            }
            if (entry.isSuspendedByUser()) {
                message2 = String.format("RESPAWN entry (level %s, template %s) was suspended by the user.", entry.getLevel(), entry.getTemplateID());
                this.logger.info(message2);
                continue;
            }
            try {
                this.instanceControl.suspendInstance(this.csf.getSessionToken(), entry.getInstanceID(), false);
            }
            catch (InvalidInstanceStateException e) {
                message = String.format("Instance not abortable any more.", new Object[0]);
                this.logger.log(Level.INFO, message, e);
            }
        }
        this.consoleLog("Running SHUTDOWN processes...");
        for (InternalInitTabEntry entry : this.getTabForType(InitTabManager.InitType.SHUTDOWN).values()) {
            try {
                this.executeTemplate(entry, true);
            }
            catch (InvalidTemplateStateException e) {
                message = String.format("Illegal state exception while executing entry '%s'", entry);
                this.logger.log(Level.SEVERE, message, e);
            }
            catch (InterruptedException interruptedException) {
                UUID instanceID = entry.getInstanceID();
                if (instanceID == null) break;
                try {
                    long errorCode = 1001L;
                    String state = "Interrupt On Shutdown";
                    String errorMessage = "The instance has been aborted since the init tab manager is shutting down and caught an interrupt.";
                    this.instanceControl.stopAndAbortInstance(this.csf.getSessionToken(), instanceID, false, errorMessage, state, errorCode);
                }
                catch (InvalidInstanceStateException e1) {
                    this.logger.log(Level.INFO, "Invalid instance state while trying to stop an instance during interrupted shutdown, this may be just fine.", e1);
                }
                break;
            }
        }
        this.consoleLog("Shut down complete");
    }

    protected InternalInitTabEntry createInternalInitTabEntry(InitTabManager.InitType type, int level, UUID templateID, boolean isForking, String comment, boolean enabled, UUID instanceID, boolean suspendedByUser) {
        return new DefaultInternalInitTabEntry(type, level, templateID, isForking, comment, enabled, instanceID, suspendedByUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<InitTabManager.InitType, TreeMap<Integer, InitTabEntry>> getInitTab(SessionToken session) {
        super.sessionActive(session);
        try {
            HashMap<InitTabManager.InitType, TreeMap<Integer, InitTabEntry>> tab = new HashMap<InitTabManager.InitType, TreeMap<Integer, InitTabEntry>>();
            Map<InitTabManager.InitType, TreeMap<Integer, InternalInitTabEntry>> map = this.initTab;
            synchronized (map) {
                InitTabManager.InitType[] initTypeArray = InitTabManager.InitType.values();
                int n = initTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    InitTabManager.InitType type = initTypeArray[n2];
                    TreeMap<Integer, DefaultInitTabEntry> map2 = new TreeMap<Integer, DefaultInitTabEntry>();
                    tab.put(type, map2);
                    for (Map.Entry<Integer, InternalInitTabEntry> entry : this.getTabForType(type).entrySet()) {
                        int level = entry.getKey();
                        UUID templateID = entry.getValue().getTemplateID();
                        boolean forking = entry.getValue().isForking();
                        String comment = entry.getValue().getComment();
                        boolean enabled = entry.getValue().isEnabled();
                        DefaultInitTabEntry newEntry = new DefaultInitTabEntry(type, level, templateID, forking, comment, enabled);
                        map2.put(level, newEntry);
                    }
                    ++n2;
                }
            }
            HashMap<InitTabManager.InitType, TreeMap<Integer, InitTabEntry>> hashMap = tab;
            return hashMap;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public DataContainer getInitTabInputData(SessionToken session, InitTabManager.InitType type, int level) {
        super.sessionActive(session);
        try {
            throw new RuntimeException("Input data not yet supported.");
        }
        catch (Throwable throwable) {
            super.sessionFinished(session);
            throw throwable;
        }
    }

    @Override
    public UUID getInstanceIDForEntry(SessionToken session, InitTabManager.InitType type, int level) {
        super.sessionActive(session);
        try {
            if (this.getTabForType(type).containsKey(level)) {
                UUID uUID = this.getTabForType(type).get(level).getInstanceID();
                return uUID;
            }
            String message = String.format("No entry for type '%s' in level %s.", new Object[]{type, level});
            throw new IllegalArgumentException(message);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNewEntry(SessionToken session, InitTabEntry entry, DataContainer inputData) {
        block26: {
            super.sessionActive(session);
            try {
                Object bw;
                if (inputData != null) {
                    throw new RuntimeException("Input data not yet supported.");
                }
                if (this.getTabForType(entry.getInitType()).containsKey(entry.getLevel())) {
                    String message = String.format("An entry of type %s at level %s exists already.", new Object[]{entry.getInitType(), entry.getLevel()});
                    this.logger.info(message);
                    throw new IllegalArgumentException(message);
                }
                String entryString = this.getEntryString(entry, null, false);
                File file = this.initTabFile;
                synchronized (file) {
                    bw = null;
                    try {
                        try {
                            bw = new BufferedWriter(new FileWriter(this.initTabFile, true));
                            ((Writer)bw).append(entryString);
                            ((BufferedWriter)bw).close();
                        }
                        catch (IOException e) {
                            String message = String.format("Could not write entry to init tab.", new Object[0]);
                            throw new InternalServiceException(message, e);
                        }
                    }
                    finally {
                        if (bw != null) {
                            try {
                                ((BufferedWriter)bw).close();
                            }
                            catch (IOException e) {
                                String message = String.format("Could not write entry to init tab.", new Object[0]);
                                throw new InternalServiceException(message, e);
                            }
                        }
                    }
                }
                InternalInitTabEntry internalEntry = this.createInternalInitTabEntry(entry.getInitType(), entry.getLevel(), entry.getTemplateID(), entry.isForking(), entry.getComment(), entry.isEnabled(), null, false);
                bw = this.initTab;
                synchronized (bw) {
                    this.getTabForType(entry.getInitType()).put(entry.getLevel(), internalEntry);
                }
                if (!entry.isEnabled() || entry.getInitType() != InitTabManager.InitType.RESPAWN) break block26;
                try {
                    this.executeTemplate(internalEntry, false);
                }
                catch (InvalidTemplateStateException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    assert (false) : "Unreachable code!";
                }
            }
            finally {
                super.sessionFinished(session);
            }
        }
    }

    private String getEntryString(InitTabEntry entry, UUID instanceID, boolean suspendedByUser) {
        String entryString = instanceID != null ? String.format("%s:%s:%s:%s:%s:%s:%s:%s\n", entry.getInitType().name(), entry.getLevel(), entry.getTemplateID(), entry.isForking(), entry.getComment(), entry.isEnabled(), instanceID.toString(), suspendedByUser) : String.format("%s:%s:%s:%s:%s:%s\n", entry.getInitType().name(), entry.getLevel(), entry.getTemplateID(), entry.isForking(), entry.getComment(), entry.isEnabled());
        return entryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInitTabEntry(SessionToken session, InitTabManager.InitType type, int level, boolean abortInstance) {
        super.sessionActive(session);
        try {
            InternalInitTabEntry entry = this.getTabForType(type).get(level);
            if (entry == null) {
                String message = String.format("No entry of type %s at level %s", new Object[]{type, level});
                this.logger.info(message);
                throw new IllegalArgumentException(message);
            }
            this.updateInitTabFile(InitFileUpdateOperation.REMOVE_ENTRY, type, level, null);
            UUID instanceID = entry.getInstanceID();
            Map<InitTabManager.InitType, TreeMap<Integer, InternalInitTabEntry>> map = this.initTab;
            synchronized (map) {
                this.getTabForType(entry.getInitType()).remove(entry.getLevel());
                this.instanceEntries.remove(instanceID);
            }
            if (abortInstance && instanceID != null) {
                try {
                    String errorMessage = "User requested stop while removing the init tab entry.";
                    String state = "Removed";
                    long errorCode = 0L;
                    this.instanceControl.stopAndAbortInstance(this.csf.getSessionToken(), instanceID, false, errorMessage, state, errorCode);
                }
                catch (InvalidInstanceStateException e) {
                    String message = String.format("Instance not abortable any more.", new Object[0]);
                    this.logger.log(Level.INFO, message, e);
                }
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInitTabFile(InitFileUpdateOperation operation, InitTabManager.InitType type, Integer level, InternalInitTabEntry entry) {
        ArgChecks.checkForNull((Object)operation, "operation");
        ArgChecks.checkForNull((Object)type, "type");
        ArgChecks.checkForNull(level, "level");
        if (operation == InitFileUpdateOperation.UPDATE_ENTRY) {
            ArgChecks.checkForNull(entry, "entry");
            ArgChecks.check(!type.equals((Object)entry.getInitType()), "type", "type does not match entry.getInitType()");
            ArgChecks.check(!level.equals(entry.getLevel()), "level", "level does not match entry.getLevel()");
        } else if (operation != InitFileUpdateOperation.REMOVE_ENTRY) {
            throw new IllegalArgumentException("Unknown operation: " + (Object)((Object)operation));
        }
        File file = this.initTabFile;
        synchronized (file) {
            if (!this.initTabFile.renameTo(this.initTabTempFile)) {
                throw new InternalServiceException("Could not move to temp file!");
            }
            BufferedReader br = null;
            BufferedWriter bw = null;
            try {
                try {
                    bw = new BufferedWriter(new FileWriter(this.initTabFile));
                    br = new BufferedReader(new FileReader(this.initTabTempFile));
                }
                catch (FileNotFoundException e) {
                    String message = "Constructor checked existence!";
                    this.logger.log(Level.SEVERE, message, e);
                    throw new IllegalStateException(message, e);
                }
                catch (IOException iOException) {
                    if (!this.initTabTempFile.renameTo(this.initTabFile)) {
                        this.logger.severe("Could not restore init tab file!!");
                    }
                    throw new InternalServiceException("Could not open a file writer to the init tab file");
                }
            }
            finally {
                try {
                    if (br == null && bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    this.logger.log(Level.INFO, "Error closing stream within exception handling.", e);
                }
                try {
                    if (bw == null && br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    this.logger.log(Level.INFO, "Error closing stream within exception handling.", e);
                }
            }
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] strings;
                    boolean skip = false;
                    if (!line.trim().equals("") && !line.startsWith("#") && (strings = line.split(":")).length >= 2 && strings[0].trim().equals(type.name()) && strings[1].trim().equals(level.toString())) {
                        if (operation == InitFileUpdateOperation.REMOVE_ENTRY) {
                            skip = true;
                        } else if (operation == InitFileUpdateOperation.UPDATE_ENTRY) {
                            bw.write(this.getEntryString(entry, entry.getInstanceID(), entry.isSuspendedByUser()));
                            skip = true;
                        }
                    }
                    if (!skip) {
                        bw.write(String.valueOf(line) + "\n");
                    }
                    line = br.readLine();
                }
                bw.close();
                bw = null;
                br.close();
                br = null;
            }
            catch (IOException e) {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e1) {
                        this.logger.log(Level.INFO, "Error closing stream within exception handling.", e1);
                    }
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e1) {
                        this.logger.log(Level.INFO, "Error closing stream within exception handling.", e1);
                    }
                }
                String message = String.format("Exception while accessing the init tab file", new Object[0]);
                throw new InternalServiceException(message, e);
            }
            if (!this.initTabTempFile.delete() && !this.initTabTempFile.delete()) {
                throw new InternalServiceException("Could not delete init tab temp file");
            }
        }
    }

    @Override
    public void instanceFailed(UUID instanceID, DataContainer dataContainer, String errorMessage, String state, long errorCode) {
        InternalInitTabEntry entry = this.instanceEntries.remove(instanceID);
        if (entry == null) {
            return;
        }
        String message = String.format("The instance '%s' for init tab entry '%s' has failed!", instanceID, entry);
        this.logger.warning(message);
        this.getOrInitialiseLatch(instanceID).countDown();
        if (entry.getInitType() == InitTabManager.InitType.RESPAWN && !this.shuttingDown) {
            entry.setSuspendedByUser(false);
            this.updateInitTabFile(InitFileUpdateOperation.UPDATE_ENTRY, entry.getInitType(), entry.getLevel(), entry);
            this.respawnInstance(entry);
        }
    }

    @Override
    public void instanceFinished(UUID instanceID, DataContainer dataContainer) {
        InternalInitTabEntry entry = this.instanceEntries.remove(instanceID);
        if (entry == null) {
            return;
        }
        String message = String.format("The instance '%s' for init tab entry '%s' has finished", instanceID, entry);
        this.logger.info(message);
        this.getOrInitialiseLatch(instanceID).countDown();
        if (entry.getInitType() == InitTabManager.InitType.RESPAWN) {
            entry.setSuspendedByUser(false);
            entry.setInstanceID(null);
            this.updateInitTabFile(InitFileUpdateOperation.UPDATE_ENTRY, entry.getInitType(), entry.getLevel(), entry);
            this.respawnInstance(entry);
        }
    }

    @Override
    public void instanceResumed(UUID instanceID) {
        this.logger.info(String.format("Instance %s has been resumed!", instanceID));
        InternalInitTabEntry entry = this.instanceEntries.get(instanceID);
        if (entry == null) {
            return;
        }
        if (entry.getInitType() == InitTabManager.InitType.RESPAWN) {
            entry.setSuspendedByUser(false);
            this.updateInitTabFile(InitFileUpdateOperation.UPDATE_ENTRY, entry.getInitType(), entry.getLevel(), entry);
        }
    }

    @Override
    public void instanceSuspended(UUID instanceID) {
        this.logger.info(String.format("Instance %s has been suspended!", instanceID));
        InternalInitTabEntry entry = this.instanceEntries.get(instanceID);
        if (entry == null || this.shuttingDown) {
            return;
        }
        if (entry.getInitType() == InitTabManager.InitType.RESPAWN) {
            entry.setSuspendedByUser(true);
            this.updateInitTabFile(InitFileUpdateOperation.UPDATE_ENTRY, entry.getInitType(), entry.getLevel(), entry);
        }
    }

    private static enum InitFileUpdateOperation {
        REMOVE_ENTRY,
        UPDATE_ENTRY;

    }
}

