/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.internal;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.core.internal.UpdateException;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbUpdateManager {
    private final String serviceName;
    private final Logger logger;
    private final Map<Integer, Update> updates = new HashMap<Integer, Update>();
    private int latestVersion = -1;

    public DbUpdateManager(String serviceName, Logger logger) {
        ArgChecks.checkForNull(serviceName, "serviceName");
        this.serviceName = serviceName;
        this.logger = logger != null ? logger : LoggerTools.getLogger(this);
    }

    public DbUpdateManager(Class<?> serviceInterface, Logger logger) {
        this(serviceInterface.getSimpleName(), logger);
    }

    public void registerUpdate(Update update) {
        ArgChecks.checkForNull(update, "update");
        if (this.updates.containsKey(update.getSourceVersion())) {
            String msg = "there's already a registered update for source version %d";
            msg = String.format(msg, update.getSourceVersion());
            throw new IllegalArgumentException();
        }
        this.latestVersion = Math.max(this.latestVersion, update.getTargetVersion());
        this.updates.put(update.getSourceVersion(), update);
        update.logger = this.logger;
    }

    public int getLatestVersion() {
        return this.latestVersion;
    }

    public void performUpdates(ExtendedConnection con) throws UpdateException {
        try {
            String msg;
            int currentVersion = con.getSchemaVersion(this.serviceName);
            Update update = this.updates.get(currentVersion);
            while (update != null) {
                if (update.getSourceVersion() >= 0) {
                    msg = "Performing database schema update of %s from version %d to %d.";
                    msg = String.format(msg, this.serviceName, update.getSourceVersion(), update.getTargetVersion());
                    this.logger.warning(msg);
                }
                try {
                    update.performUpdate(con);
                }
                catch (Exception ex) {
                    if (update.getSourceVersion() >= 0) {
                        String msg2 = "Database schema update of %s from version %d to %d failed.";
                        msg2 = String.format(msg2, this.serviceName, update.getSourceVersion(), update.getTargetVersion());
                        this.logger.log(Level.SEVERE, msg2, ex);
                    }
                    throw ex;
                }
                currentVersion = update.getTargetVersion();
                con.setSchemaVersion(this.serviceName, currentVersion);
                update = this.updates.get(currentVersion);
            }
            if (currentVersion < this.getLatestVersion()) {
                msg = "No update path found for %s to update database schema from version %d to %d.";
                msg = String.format(msg, this.serviceName, currentVersion, this.getLatestVersion());
                this.logger.log(Level.SEVERE, msg);
            }
        }
        catch (UpdateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = "Updating the database schema failed.";
            throw new UpdateException(msg, ex);
        }
    }

    public static abstract class Update {
        private Logger logger;
        private final int sourceVersion;
        private final int targetVersion;

        protected Update(int sourceVersion, int targetVersion) {
            ArgChecks.checkForNegative(targetVersion, "targetVersion");
            this.sourceVersion = sourceVersion;
            this.targetVersion = targetVersion;
        }

        protected Logger getLogger() {
            return this.logger;
        }

        protected final int getSourceVersion() {
            return this.sourceVersion;
        }

        protected final int getTargetVersion() {
            return this.targetVersion;
        }

        public abstract void performUpdate(ExtendedConnection var1) throws Exception;
    }
}

