/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.internal;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.util.ArgChecks;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class SQLSessionManager {
    public static final String DATA_SOURCE_EXCEPTION_MSG = "An error occurred while accessing the database!";
    private JDBCDataSource dataSource;
    private Map<UUID, SessionData> sessions = new ConcurrentHashMap<UUID, SessionData>();

    public SQLSessionManager(JDBCDataSource dataSource) {
        ArgChecks.checkForNull(dataSource, "dataSource");
        this.dataSource = dataSource;
    }

    public void startSession(SessionToken session) {
        ArgChecks.checkForNull(session, "session");
        SessionData data = this.sessions.get(session.getSessionID());
        if (data == null) {
            this.sessions.put(session.getSessionID(), new SessionData());
        } else {
            SessionData sessionData = data;
            sessionData.reentries = sessionData.reentries + 1;
        }
    }

    public void endSession(SessionToken session) {
        ArgChecks.checkForNull(session, "session");
        this.ensureSessionExists(session);
        SessionData data = this.sessions.get(session.getSessionID());
        if (data.reentries == 0) {
            this.sessions.remove(session.getSessionID());
            if (data.con != null) {
                JDBCTools.rollbackQuietly(data.con);
                JDBCTools.closeQuietly(data.con);
            }
        } else {
            SessionData sessionData = data;
            sessionData.reentries = sessionData.reentries - 1;
        }
    }

    public void startTransaction(SessionToken session) {
        ArgChecks.checkForNull(session, "session");
        this.ensureSessionExists(session);
        ExtendedConnection con = this.getConnection(session);
        try {
            con.setAutoCommit(false);
        }
        catch (SQLException ex) {
            String msg = DATA_SOURCE_EXCEPTION_MSG;
            throw new InternalServiceException(msg, ex);
        }
    }

    public void finishTransaction(SessionToken session) {
        ArgChecks.checkForNull(session, "session");
        this.ensureSessionExists(session);
        SessionData data = this.sessions.get(session.getSessionID());
        ExtendedConnection con = data.con;
        try {
            try {
                if (con == null || con.getAutoCommit()) {
                    String msg = "There is no active transaction for the session %s!";
                    msg = String.format(msg, session.getSessionID());
                    throw new IllegalStateException(msg);
                }
                con.commit();
                con.setAutoCommit(true);
                con = JDBCTools.close(con);
            }
            catch (SQLException ex) {
                String msg = DATA_SOURCE_EXCEPTION_MSG;
                throw new InternalServiceException(msg, ex);
            }
        }
        finally {
            data.con = null;
            JDBCTools.closeQuietly(con);
        }
    }

    public ExtendedConnection getConnection(SessionToken session) {
        ArgChecks.checkForNull(session, "session");
        this.ensureSessionExists(session);
        SessionData data = this.sessions.get(session.getSessionID());
        ExtendedConnection con = data.con;
        if (con == null) {
            try {
                con = this.dataSource.getConnection();
                data.con = con;
            }
            catch (SQLException ex) {
                String msg = DATA_SOURCE_EXCEPTION_MSG;
                throw new InternalServiceException(msg, ex);
            }
        }
        return con;
    }

    private void ensureSessionExists(SessionToken session) {
        if (!this.sessions.containsKey(session.getSessionID())) {
            String msg = "No transaction has been started for the session %s!";
            msg = String.format(msg, session.getSessionID());
            throw new IllegalStateException(msg);
        }
    }

    private void ensureSessionNotExists(SessionToken session) {
        if (this.sessions.containsKey(session.getSessionID())) {
            String msg = "A transaction has already been started for the session %s!";
            msg = String.format(msg, session.getSessionID());
            throw new IllegalStateException(msg);
        }
    }

    static class SessionData {
        private int reentries = 0;
        private ExtendedConnection con;
    }
}

