/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.logmanager.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.logmanager.Log;
import de.aristaflow.adept2.core.logmanager.defaultimplementation.DefaultLogEntrySet;
import de.aristaflow.adept2.core.logmanager.defaultimplementation.DefaultLogManager;
import de.aristaflow.adept2.model.logmanagement.Column;
import de.aristaflow.adept2.model.logmanagement.DataType;
import de.aristaflow.adept2.model.logmanagement.LogEntry;
import de.aristaflow.adept2.model.logmanagement.LogEntrySet;
import de.aristaflow.adept2.model.logmanagement.Schema;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.UUID;

public abstract class AbstractDefaultLog
implements Log {
    private final DefaultLogManager logManager;
    private final String name;
    private Schema schema;

    protected AbstractDefaultLog(DefaultLogManager logManager, String logName, Schema logSchema) {
        ArgChecks.checkForNull(logManager, "logManager");
        ArgChecks.checkForBlank(logName, "logName");
        ArgChecks.checkForNull(logSchema, "logSchema");
        this.logManager = logManager;
        this.name = logName;
        this.schema = logSchema;
    }

    protected DefaultLogManager getLogManager() {
        return this.logManager;
    }

    private JDBCDataSource getDataSource() {
        return this.getLogManager().getDataSource();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    protected void write(SessionToken session, LogEntry logEntry) throws DataSourceException {
        ArgChecks.checkForNull(logEntry, "logEntrySet");
        if (!logEntry.getSchema().equals(this.getSchema())) {
            throw new RuntimeException("schemas don't match");
        }
        this.logManager.sessionActive(session);
        try {
            ExtendedConnection con = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    this.write(con, null, -1L, this.getName(), logEntry);
                    con = JDBCTools.close(con);
                }
                catch (SQLException ex) {
                    String msg = "The log entry could not be written!";
                    throw new DataSourceException(msg, ex);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con);
                throw throwable;
            }
            JDBCTools.closeQuietly(con);
        }
        finally {
            this.logManager.sessionFinished(session);
        }
    }

    private void write(ExtendedConnection con, String parentTableName, long parentID, String tableName, LogEntry logEntry) throws SQLException {
        Statement stmt = null;
        try {
            Column column;
            long id = con.nextID(String.valueOf(tableName) + "_ID");
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ");
            sb.append(tableName);
            sb.append(" (id");
            if (parentTableName != null) {
                sb.append(", refId");
            }
            ArrayList<Column> complexColumns = new ArrayList<Column>();
            Column[] columnArray = logEntry.getSchema().getColumns();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                column = columnArray[n2];
                if (column.getDataType() == DataType.COMPLEX) {
                    complexColumns.add(column);
                } else {
                    sb.append(", ").append(column.getName());
                }
                ++n2;
            }
            sb.append(") VALUES (");
            sb.append(id);
            if (parentTableName != null) {
                sb.append(", ").append(parentID);
            }
            columnArray = logEntry.getSchema().getColumns();
            n = columnArray.length;
            n2 = 0;
            while (n2 < n) {
                column = columnArray[n2];
                if (column.getDataType() != DataType.COMPLEX) {
                    sb.append(", ").append(AbstractDefaultLog.toDBFormat(con, logEntry, column.getName()));
                }
                ++n2;
            }
            sb.append(")");
            String update = sb.toString();
            stmt = con.createStatement();
            stmt.executeUpdate(update);
            stmt = JDBCTools.close(stmt);
            for (Column complexCol : complexColumns) {
                LogEntrySet entries = logEntry.getEntrySet(complexCol.getName());
                if (entries == null) continue;
                for (LogEntry entry : entries) {
                    this.write(con, tableName, id, String.valueOf(tableName) + "_" + complexCol.getName(), entry);
                }
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt);
    }

    /*
     * Loose catch block
     */
    @Override
    public LogEntry read(SessionToken session, long logEntryID, String ... columnNames) throws DataSourceException {
        ArgChecks.checkForNulls(columnNames, "columnNames");
        this.logManager.sessionActive(session);
        try {
            Schema selectedColumnsSchema;
            Column[] selectedColumns;
            if (columnNames.length == 0) {
                selectedColumns = this.getSchema().getColumns();
                selectedColumnsSchema = this.getSchema();
            } else {
                selectedColumns = new Column[columnNames.length];
                int i = 0;
                while (i < columnNames.length) {
                    String columnName = columnNames[i];
                    Column column = this.getSchema().getColumn(columnName);
                    if (column == null) {
                        throw new IllegalArgumentException("unknown column: " + columnName);
                    }
                    selectedColumns[i] = column;
                    ++i;
                }
                selectedColumnsSchema = new Schema(selectedColumns);
            }
            ExtendedConnection con = null;
            try {
                con = this.getDataSource().getConnection();
                String sqlWhereClause = "id = " + logEntryID;
                LogEntrySet logEntrySet = this.read(con, Long.MIN_VALUE, selectedColumnsSchema, selectedColumns, this.getName(), sqlWhereClause, null, 1, 1);
                con = JDBCTools.close(con);
                if (logEntrySet.getEntryCount() == 0) {
                    return null;
                }
                LogEntrySet.Cursor cursor = logEntrySet.getCursor(0);
                return cursor;
            }
            catch (SQLException ex) {
                String msg = "The log entries could not be read!";
                throw new DataSourceException(msg, ex);
            }
            finally {
                JDBCTools.closeQuietly(con);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.logManager.sessionFinished(session);
        }
    }

    @Override
    public LogEntrySet read(SessionToken session, String sqlWhereClause, String sqlOrderByClause, int maxEntries, String ... columnNames) throws DataSourceException {
        return this.read(session, sqlWhereClause, sqlOrderByClause, 1, maxEntries, columnNames);
    }

    /*
     * Loose catch block
     */
    @Override
    public LogEntrySet read(SessionToken session, String sqlWhereClause, String sqlOrderByClause, int startEntry, int maxEntries, String ... columnNames) throws DataSourceException {
        if (sqlWhereClause != null) {
            ArgChecks.checkForBlank(sqlWhereClause, "sqlWhereClause");
        }
        if (sqlOrderByClause != null) {
            ArgChecks.checkForBlank(sqlOrderByClause, "sqlOrderByClause");
        }
        ArgChecks.checkForNonpositive(startEntry, "startEntry");
        ArgChecks.checkForNegative(maxEntries, "maxEntries");
        ArgChecks.checkForNulls(columnNames, "columnNames");
        this.logManager.sessionActive(session);
        try {
            Schema selectedColumnsSchema;
            Column[] selectedColumns;
            if (columnNames.length == 0) {
                selectedColumns = this.getSchema().getColumns();
                selectedColumnsSchema = this.getSchema();
            } else {
                selectedColumns = new Column[columnNames.length];
                int i = 0;
                while (i < columnNames.length) {
                    String columnName = columnNames[i];
                    Column column = this.getSchema().getColumn(columnName);
                    if (column == null) {
                        throw new IllegalArgumentException("unknown column: " + columnName);
                    }
                    selectedColumns[i] = column;
                    ++i;
                }
                selectedColumnsSchema = new Schema(selectedColumns);
            }
            ExtendedConnection con = null;
            try {
                con = this.getDataSource().getConnection();
                LogEntrySet logEntrySet = this.read(con, Long.MIN_VALUE, selectedColumnsSchema, selectedColumns, this.getName(), sqlWhereClause, sqlOrderByClause, startEntry, maxEntries);
                con = JDBCTools.close(con);
                LogEntrySet logEntrySet2 = logEntrySet;
                return logEntrySet2;
            }
            catch (SQLException ex) {
                String msg = "The log entries could not be read!";
                throw new DataSourceException(msg, ex);
            }
            finally {
                JDBCTools.closeQuietly(con);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.logManager.sessionFinished(session);
        }
    }

    private LogEntrySet read(ExtendedConnection con, long parentID, Schema schema, Column[] columns, String tableName, String sqlWhereClause, String sqlOrderByClause, int startEntry, int maxEntries) throws SQLException {
        DefaultLogEntrySet defaultLogEntrySet;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT id");
        if (parentID > Long.MIN_VALUE) {
            sb.append(", refId");
        }
        Column[] columnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            if (column.getDataType() != DataType.COMPLEX) {
                sb.append(", ").append(column.getName());
            }
            ++n2;
        }
        sb.append(" FROM ");
        sb.append(tableName);
        if (parentID > Long.MIN_VALUE) {
            sb.append(" WHERE ");
            sb.append("refId = ").append(parentID);
        } else if (sqlWhereClause != null) {
            sb.append(" WHERE ");
            sb.append(sqlWhereClause);
        }
        if (parentID == Long.MIN_VALUE) {
            sb.append(" ORDER BY ");
            if (sqlOrderByClause == null) {
                sb.append("id");
            } else {
                sb.append(sqlOrderByClause);
            }
        }
        String query = sb.toString();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            boolean hasEntries;
            stmt = startEntry > 1 ? con.createStatement(1004, 1007) : con.createStatement();
            int maxRows = startEntry - 1 + maxEntries;
            if (maxRows > 0) {
                stmt.setMaxRows(maxRows);
            }
            rs = stmt.executeQuery(query);
            DefaultLogEntrySet logEntrySet = new DefaultLogEntrySet(schema);
            if (startEntry > 1) {
                hasEntries = rs.next();
                if (hasEntries) {
                    hasEntries = rs.relative(startEntry - 1);
                }
            } else {
                hasEntries = rs.next();
            }
            if (hasEntries) {
                do {
                    LogEntrySet.Cursor cursor = logEntrySet.appendEntry();
                    long id = rs.getLong("id");
                    cursor.setID(id);
                    Column[] columnArray2 = schema.getColumns();
                    int n3 = columnArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Column selCol = columnArray2[n4];
                        if (selCol.getDataType() == DataType.COMPLEX) {
                            LogEntrySet nested = this.read(con, id, selCol.getSubSchema(), selCol.getSubSchema().getColumns(), String.valueOf(tableName) + "_" + selCol.getName(), null, null, 1, 0);
                            cursor.setEntrySet(selCol.getName(), nested);
                        } else {
                            AbstractDefaultLog.fromDBFormat(rs, cursor, selCol.getName());
                        }
                        ++n4;
                    }
                } while (rs.next());
            }
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            defaultLogEntrySet = logEntrySet;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return defaultLogEntrySet;
    }

    @Override
    public long count(SessionToken session, String sqlWhereClause) throws DataSourceException {
        this.logManager.sessionActive(session);
        try {
            long l;
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT count(id) FROM ");
            sb.append(this.getName());
            if (sqlWhereClause != null) {
                sb.append(" WHERE ");
                sb.append(sqlWhereClause);
            }
            String query = sb.toString();
            ExtendedConnection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                stmt = con.createStatement();
                rs = stmt.executeQuery(query);
                rs.next();
                long result = rs.getLong(1);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                l = result;
            }
            catch (SQLException ex) {
                try {
                    String msg = "The log entries could not be read!";
                    throw new DataSourceException(msg, ex);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, stmt, rs);
            return l;
        }
        finally {
            this.logManager.sessionFinished(session);
        }
    }

    protected void delete(SessionToken session, String sqlWhereClause) throws DataSourceException {
        ArgChecks.checkForEmpty(sqlWhereClause, "sqlWhereClause");
        this.logManager.sessionActive(session);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("DELETE FROM ");
            sb.append(this.getName());
            sb.append(" WHERE ");
            sb.append(sqlWhereClause);
            String update = sb.toString();
            ExtendedConnection con = null;
            Statement stmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    stmt = con.createStatement();
                    stmt.executeUpdate(update);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException ex) {
                    String msg = "The log entries could not be deleted!";
                    throw new DataSourceException(msg, ex);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, stmt);
        }
        finally {
            this.logManager.sessionFinished(session);
        }
    }

    @Override
    public ResultSet query(SessionToken session, String sqlQuery, int maxEntries) throws SQLException {
        return this.logManager.query(session, sqlQuery, maxEntries);
    }

    protected ResultSet localQuery(SessionToken session, String sqlQuery, int maxEntries) throws SQLException {
        return this.logManager.localQuery(session, sqlQuery, maxEntries);
    }

    @Override
    public String formatCondition(SessionToken session, String conditionFormat, Object ... values) throws DataSourceException {
        return this.logManager.formatCondition(session, conditionFormat, values);
    }

    protected static String toDBFormat(ExtendedConnection con, LogEntry entry, String resultSetColumnName, String logColumnName) {
        Column column = entry.getSchema().getColumn(logColumnName);
        if (entry.isNull(logColumnName)) {
            return con.formatValue(null, DefaultLogManager.mapToJdbcTypeCode(column.getDataType()));
        }
        switch (column.getDataType()) {
            case BOOLEAN: {
                return con.formatValue(entry.getBoolean(resultSetColumnName), DefaultLogManager.mapToJdbcTypeCode(DataType.BOOLEAN));
            }
            case BYTE: {
                return con.formatValue(entry.getByte(resultSetColumnName), DefaultLogManager.mapToJdbcTypeCode(DataType.BYTE));
            }
            case SHORT: {
                return con.formatValue(entry.getShort(resultSetColumnName), DefaultLogManager.mapToJdbcTypeCode(DataType.SHORT));
            }
            case INTEGER: {
                return con.formatValue(entry.getInteger(resultSetColumnName), DefaultLogManager.mapToJdbcTypeCode(DataType.INTEGER));
            }
            case LONG: {
                return con.formatValue(entry.getLong(resultSetColumnName), DefaultLogManager.mapToJdbcTypeCode(DataType.LONG));
            }
            case FLOAT: {
                return con.formatValue(Float.valueOf(entry.getFloat(resultSetColumnName)), DefaultLogManager.mapToJdbcTypeCode(DataType.FLOAT));
            }
            case DOUBLE: {
                return con.formatValue(entry.getDouble(resultSetColumnName), DefaultLogManager.mapToJdbcTypeCode(DataType.DOUBLE));
            }
            case STRING: {
                return con.formatValue(entry.getString(resultSetColumnName), DefaultLogManager.mapToJdbcTypeCode(DataType.STRING));
            }
            case UUID: {
                return con.formatValue(entry.getUUID(resultSetColumnName).toString(), DefaultLogManager.mapToJdbcTypeCode(DataType.UUID));
            }
            case TIMESTAMP: {
                return con.formatValue(entry.getTimestamp(resultSetColumnName), DefaultLogManager.mapToJdbcTypeCode(DataType.TIMESTAMP));
            }
            case COMPLEX: {
                throw new IllegalArgumentException("DataType.COMPLEX not allowed here");
            }
        }
        throw new AssertionError((Object)column.getDataType());
    }

    protected static String toDBFormat(ExtendedConnection con, LogEntry entry, String columnName) {
        return AbstractDefaultLog.toDBFormat(con, entry, columnName, columnName);
    }

    protected static void fromDBFormat(ResultSet rs, LogEntry logEntry, String resultSetColumnName, String logColumnName) throws SQLException {
        Column col = logEntry.getSchema().getColumn(logColumnName);
        switch (col.getDataType()) {
            case BOOLEAN: {
                logEntry.setBoolean(logColumnName, rs.getBoolean(resultSetColumnName));
                if (!rs.wasNull()) break;
                logEntry.setNull(logColumnName);
                break;
            }
            case BYTE: {
                logEntry.setByte(logColumnName, rs.getByte(resultSetColumnName));
                if (!rs.wasNull()) break;
                logEntry.setNull(logColumnName);
                break;
            }
            case SHORT: {
                logEntry.setShort(logColumnName, rs.getShort(resultSetColumnName));
                if (!rs.wasNull()) break;
                logEntry.setNull(logColumnName);
                break;
            }
            case INTEGER: {
                logEntry.setInteger(logColumnName, rs.getInt(resultSetColumnName));
                if (!rs.wasNull()) break;
                logEntry.setNull(logColumnName);
                break;
            }
            case LONG: {
                logEntry.setLong(logColumnName, rs.getLong(resultSetColumnName));
                if (!rs.wasNull()) break;
                logEntry.setNull(logColumnName);
                break;
            }
            case FLOAT: {
                logEntry.setFloat(logColumnName, rs.getFloat(resultSetColumnName));
                if (!rs.wasNull()) break;
                logEntry.setNull(logColumnName);
                break;
            }
            case DOUBLE: {
                logEntry.setDouble(logColumnName, rs.getDouble(resultSetColumnName));
                if (!rs.wasNull()) break;
                logEntry.setNull(logColumnName);
                break;
            }
            case STRING: {
                logEntry.setString(logColumnName, rs.getString(resultSetColumnName));
                break;
            }
            case UUID: {
                logEntry.setUUID(logColumnName, UUID.fromString(rs.getString(resultSetColumnName)));
                break;
            }
            case TIMESTAMP: {
                Timestamp timestamp = rs.getTimestamp(resultSetColumnName, JDBCTools.createUTCCalendar());
                if (timestamp != null && timestamp.getClass() != Timestamp.class) {
                    Timestamp newTimestamp = new Timestamp(timestamp.getTime());
                    newTimestamp.setNanos(timestamp.getNanos());
                    timestamp = newTimestamp;
                }
                logEntry.setTimestamp(logColumnName, timestamp);
                break;
            }
            case COMPLEX: {
                throw new IllegalArgumentException("DataType.COMPLEX not allowed here");
            }
            default: {
                throw new AssertionError((Object)col.getDataType());
            }
        }
    }

    protected static void fromDBFormat(ResultSet rs, LogEntry logEntry, String columnName) throws SQLException {
        AbstractDefaultLog.fromDBFormat(rs, logEntry, columnName, columnName);
    }
}

