/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.logmanager.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.logmanager.defaultimplementation.AbstractDefaultLog;
import de.aristaflow.adept2.core.logmanager.defaultimplementation.DefaultLogEntrySet;
import de.aristaflow.adept2.core.logmanager.defaultimplementation.DefaultLogManager;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistoryWriteAccess;
import de.aristaflow.adept2.model.logmanagement.Column;
import de.aristaflow.adept2.model.logmanagement.DataType;
import de.aristaflow.adept2.model.logmanagement.LogEntry;
import de.aristaflow.adept2.model.logmanagement.LogEntrySet;
import de.aristaflow.adept2.model.logmanagement.Schema;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.Serializable;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.UUID;

public class DefaultExecutionHistory
extends AbstractDefaultLog
implements ExecutionHistory {
    public DefaultExecutionHistory(DefaultLogManager logManager) {
        super(logManager, "ExecutionHistory", SCHEMA);
    }

    @Override
    public LogEntrySet readInstanceHistory(SessionToken session, UUID instanceLogID) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(instanceLogID, "instanceLogID");
        this.getLogManager().sessionActive(session);
        try {
            String where = "{c:instanceLogID}";
            where = this.formatCondition(session, where, instanceLogID);
            LogEntrySet logEntrySet = this.read(session, where, "id DESC", 0, new String[0]);
            return logEntrySet;
        }
        finally {
            this.getLogManager().sessionFinished(session);
        }
    }

    @Override
    public LogEntrySet readInstanceHistory(SessionToken session, UUID instanceLogID, int startEntry, int entryCount) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(instanceLogID, "instanceLogID");
        this.getLogManager().sessionActive(session);
        try {
            String where = "{c:instanceLogID}";
            where = this.formatCondition(session, where, instanceLogID);
            LogEntrySet logEntrySet = this.read(session, where, "id DESC", startEntry, entryCount, new String[0]);
            return logEntrySet;
        }
        finally {
            this.getLogManager().sessionFinished(session);
        }
    }

    @Override
    public long countInstanceHistoryEntries(SessionToken session, UUID instanceLogID) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(instanceLogID, "instanceLogID");
        this.getLogManager().sessionActive(session);
        try {
            String where = "{c:instanceLogID}";
            where = this.formatCondition(session, where, instanceLogID);
            long l = this.count(session, where);
            return l;
        }
        finally {
            this.getLogManager().sessionFinished(session);
        }
    }

    @Override
    public LogEntrySet readPreviousSteps(SessionToken session, UUID instanceLogID, int nodeID, int iteration) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(instanceLogID, "instanceLogID");
        this.getLogManager().sessionActive(session);
        try {
            String where = "{c:instanceLogID} AND {c:nodeID} AND {c:iteration} AND {c:stateChange}";
            where = this.formatCondition(session, where, instanceLogID, nodeID, iteration, ExecutionHistory.StateChange.NODE_FINISHED.getCode());
            LogEntrySet result = this.read(session, where, "id DESC", 0, "instanceLogID");
            LogEntrySet.Cursor cursor = result.getCursor();
            if (!cursor.nextEntry()) {
                return null;
            }
            if (result.getEntryCount() > 1) {
                String msg = String.format("Only one log entry is expected here, but %s entries are available!", result.getEntryCount());
                LoggerTools.getLogger(this).warning(msg);
            }
            long entryId = cursor.getID();
            where = "{c:instanceLogID} AND {c:stateChange} AND {c:id <}";
            where = this.formatCondition(session, where, instanceLogID, ExecutionHistory.StateChange.NODE_FINISHED.getCode(), entryId);
            LogEntrySet logEntrySet = this.read(session, where, "id DESC", 0, new String[0]);
            return logEntrySet;
        }
        finally {
            this.getLogManager().sessionFinished(session);
        }
    }

    @Override
    public LogEntrySet readCompletedSteps(SessionToken session, long fromTimestamp, long toTimestamp, long agentID, long ... orgPositionIDs) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(orgPositionIDs, "orgPositionIDs");
        this.getLogManager().sessionActive(session);
        try {
            DefaultLogEntrySet defaultLogEntrySet;
            StringBuilder whereSb = new StringBuilder();
            whereSb.append("{c:e1.agentID} AND {c:e1.stateChange} AND {c:e1.timestamp >=} AND {c:e1.timestamp <=} AND {c:e2.stateChange}");
            ArrayList<Serializable> args = new ArrayList<Serializable>();
            args.add(Long.valueOf(agentID));
            args.add(Byte.valueOf(ExecutionHistory.StateChange.NODE_FINISHED.getCode()));
            args.add(JDBCTools.trim(new Timestamp(fromTimestamp)));
            args.add(JDBCTools.trim(new Timestamp(toTimestamp)));
            args.add(Byte.valueOf(ExecutionHistory.StateChange.NODE_ACTIVATED.getCode()));
            if (orgPositionIDs.length > 0) {
                whereSb.append(" AND (");
                boolean first = true;
                long[] lArray = orgPositionIDs;
                int n = orgPositionIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    long orgPositionID = lArray[n2];
                    if (first) {
                        first = false;
                    } else {
                        whereSb.append(" OR ");
                    }
                    whereSb.append("{c:e1.agentOrgPositionID}");
                    args.add(Long.valueOf(orgPositionID));
                    ++n2;
                }
                whereSb.append(")");
            }
            String where = this.formatCondition(session, whereSb.toString(), args.toArray());
            String query = "SELECT a.activationTime, b.* FROM (SELECT e1.id, MIN(e2.timestamp) AS activationTime FROM %s e1 JOIN %s e2 ON e1.instanceLogID = e2.instanceLogID AND e1.nodeID = e2.nodeID AND e1.iteration = e2.iteration WHERE %s GROUP BY e1.id, e1.timestamp, e1.instanceLogID, e1.nodeID, e1.iteration ) a JOIN %s b ON a.id = b.id ORDER BY b.timestamp DESC";
            query = String.format(query, this.getName(), this.getName(), where, this.getName());
            ResultSet rs = null;
            try {
                rs = this.localQuery(session, query, 100);
                ArrayList<Column> columns = new ArrayList<Column>();
                columns.add(new Column("completionTime", DataType.TIMESTAMP));
                columns.add(new Column("activationTime", DataType.TIMESTAMP));
                columns.add(SCHEMA.getColumn("instanceLogID"));
                columns.add(SCHEMA.getColumn("nodeID"));
                columns.add(SCHEMA.getColumn("iteration"));
                columns.add(SCHEMA.getColumn("nodeName"));
                columns.add(SCHEMA.getColumn("instanceName"));
                columns.add(SCHEMA.getColumn("templateName"));
                columns.add(SCHEMA.getColumn("supportsViewOnly"));
                columns.add(SCHEMA.getColumn("executionManagerURIs"));
                DefaultLogEntrySet logEntrySet = new DefaultLogEntrySet(new Schema(columns.toArray(new Column[columns.size()])));
                while (rs.next()) {
                    LogEntrySet.Cursor logEntry = logEntrySet.appendEntry();
                    DefaultExecutionHistory.fromDBFormat(rs, logEntry, "timestamp", "completionTime");
                    DefaultExecutionHistory.fromDBFormat(rs, logEntry, "activationTime", "activationTime");
                    DefaultExecutionHistory.fromDBFormat(rs, logEntry, "instanceLogID");
                    DefaultExecutionHistory.fromDBFormat(rs, logEntry, "nodeID");
                    DefaultExecutionHistory.fromDBFormat(rs, logEntry, "iteration");
                    DefaultExecutionHistory.fromDBFormat(rs, logEntry, "nodeName");
                    DefaultExecutionHistory.fromDBFormat(rs, logEntry, "instanceName");
                    DefaultExecutionHistory.fromDBFormat(rs, logEntry, "templateName");
                    DefaultExecutionHistory.fromDBFormat(rs, logEntry, "supportsViewOnly");
                    DefaultExecutionHistory.fromDBFormat(rs, logEntry, "executionManagerURIs");
                }
                rs = JDBCTools.close(rs);
                defaultLogEntrySet = logEntrySet;
            }
            catch (SQLException ex) {
                try {
                    String msg = "The query could not be executed!";
                    throw new DataSourceException(msg, ex);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(rs);
            return defaultLogEntrySet;
        }
        finally {
            this.getLogManager().sessionFinished(session);
        }
    }

    @Override
    public LogEntry readInstanceErrorInformation(SessionToken session, UUID instanceLogID) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(instanceLogID, "instanceLogID");
        this.getLogManager().sessionActive(session);
        try {
            String where = "{c:instanceLogID} AND {c:stateChange}";
            where = this.formatCondition(session, where, instanceLogID, ExecutionHistory.StateChange.INSTANCE_FAILED.getCode());
            LogEntrySet result = this.read(session, where, null, 0, "error");
            LogEntrySet.Cursor cursor = result.getCursor();
            if (!cursor.nextEntry()) {
                return null;
            }
            LogEntrySet.Cursor cursor2 = cursor.getEntrySet("error").getCursor(0);
            return cursor2;
        }
        finally {
            this.getLogManager().sessionFinished(session);
        }
    }

    @Override
    public LogEntry readNodeErrorInformation(SessionToken session, long logEntryID) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        this.getLogManager().sessionActive(session);
        try {
            LogEntry result = this.read(session, logEntryID, "error");
            if (result == null) {
                return null;
            }
            LogEntrySet error = result.getEntrySet("error");
            if (error.getEntryCount() > 0) {
                LogEntrySet.Cursor cursor = error.getCursor(0);
                return cursor;
            }
            return null;
        }
        finally {
            this.getLogManager().sessionFinished(session);
        }
    }

    @Override
    public ExecutionHistoryWriteAccess getWriteAccess() {
        return new ExecutionHistoryWriteAccess(){

            protected String stripString(String s, int length) {
                if (s != null && s.length() > length) {
                    StringBuilder stripped = new StringBuilder(s);
                    stripped.delete(length - 3, s.length());
                    stripped.append("...");
                    s = stripped.toString();
                }
                return s;
            }

            @Override
            public void logInstanceStarted(SessionToken session, long timestamp, Instance instance) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonInstanceColumns(entry, timestamp, instance, ExecutionHistory.StateChange.INSTANCE_STARTED, session);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logInstanceSuspended(SessionToken session, long timestamp, Instance instance) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonInstanceColumns(entry, timestamp, instance, ExecutionHistory.StateChange.INSTANCE_SUSPENDED, session);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logInstanceResumed(SessionToken session, long timestamp, Instance instance) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonInstanceColumns(entry, timestamp, instance, ExecutionHistory.StateChange.INSTANCE_RESUMED, session);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logInstanceFinished(SessionToken session, long timestamp, Instance instance) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonInstanceColumns(entry, timestamp, instance, ExecutionHistory.StateChange.INSTANCE_FINISHED, session);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logInstanceFailed(SessionToken session, long timestamp, Instance instance, long errorCode, String errorState, String errorMessage) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonInstanceColumns(entry, timestamp, instance, ExecutionHistory.StateChange.INSTANCE_FAILED, session);
                this.fillErrorColumn(entry, errorCode, errorState, errorMessage);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logInstanceChanged(SessionToken session, long timestamp, Instance instance) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonInstanceColumns(entry, timestamp, instance, ExecutionHistory.StateChange.INSTANCE_CHANGED, session);
                DefaultExecutionHistory.this.write(session, entry);
            }

            private void fillCommonInstanceColumns(LogEntry entry, long timestamp, Instance instance, ExecutionHistory.StateChange stateChange, SessionToken session) {
                entry.setTimestamp("timestamp", new Timestamp(timestamp));
                entry.setUUID("instanceLogID", instance.getLogID());
                entry.setByte("stateChange", stateChange.getCode());
                this.fillAgentColumns(entry, this.getAgentFromSession(session));
            }

            @Override
            public void logNodeActivated(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonNodeColumns(entry, timestamp, null, instance, nodeID, iteration, ExecutionHistory.StateChange.NODE_ACTIVATED);
                this.fillAgentColumns(entry, null);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logNodeSelected(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonNodeColumns(entry, timestamp, null, instance, nodeID, iteration, ExecutionHistory.StateChange.NODE_SELECTED);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logNodeDeselected(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonNodeColumns(entry, timestamp, null, instance, nodeID, iteration, ExecutionHistory.StateChange.NODE_DESELECTED);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logNodeStarted(SessionToken session, long timestamp, Instance instance, int nodeID, String nodeName, int iteration) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonNodeColumns(entry, timestamp, null, instance, nodeID, iteration, ExecutionHistory.StateChange.NODE_STARTED);
                this.fillNameColumns(entry, instance, nodeName);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logNodeSuspended(SessionToken session, long timestamp, Long clientDelay, Instance instance, int nodeID, int iteration) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonNodeColumns(entry, timestamp, clientDelay, instance, nodeID, iteration, ExecutionHistory.StateChange.NODE_SUSPENDED);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logNodeResumed(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonNodeColumns(entry, timestamp, null, instance, nodeID, iteration, ExecutionHistory.StateChange.NODE_RESUMED);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logNodeResetSoft(SessionToken session, long timestamp, Long clientDelay, Instance instance, int nodeID, int iteration) throws DataSourceException {
                this._logNodeReset(session, timestamp, clientDelay, instance, nodeID, iteration, false);
            }

            @Override
            public void logNodeResetHard(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
                this._logNodeReset(session, timestamp, null, instance, nodeID, iteration, true);
            }

            private void _logNodeReset(SessionToken session, long timestamp, Long clientDelay, Instance instance, int nodeID, int iteration, boolean hardReset) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                ExecutionHistory.StateChange resetStateChange = hardReset ? ExecutionHistory.StateChange.NODE_RESET_HARD : ExecutionHistory.StateChange.NODE_RESET_SOFT;
                this.fillCommonNodeColumns(entry, timestamp, clientDelay, instance, nodeID, iteration, resetStateChange);
                this.fillAgentColumns(entry, this.getAgentFromSession(session));
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logNodeSkipped(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonNodeColumns(entry, timestamp, null, instance, nodeID, iteration, ExecutionHistory.StateChange.NODE_SKIPPED);
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logNodeFinished(SessionToken session, long timestamp, Long clientDelay, Instance instance, int nodeID, String nodeName, int iteration, URI[] executionManagerURIs) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonNodeColumns(entry, timestamp, clientDelay, instance, nodeID, iteration, ExecutionHistory.StateChange.NODE_FINISHED);
                this.fillNameColumns(entry, instance, nodeName);
                ExecutableBusinessProcess ebp = instance.getTemplate().getNode(nodeID).getExecutableBusinessProcess();
                if (ebp instanceof Activity) {
                    Activity activity = (Activity)ebp;
                    entry.setBoolean("supportsViewOnly", activity.supportsViewOnly());
                } else {
                    entry.setBoolean("supportsViewOnly", false);
                }
                int maxLength = DefaultExecutionHistory.this.getSchema().getColumn("executionManagerURIs").getSizeHint();
                StringBuilder urisString = new StringBuilder();
                boolean first = true;
                URI[] uRIArray = executionManagerURIs;
                int n = executionManagerURIs.length;
                int n2 = 0;
                while (n2 < n) {
                    URI uri = uRIArray[n2];
                    if (first) {
                        first = false;
                    } else {
                        urisString.append("::");
                    }
                    urisString.append(uri.toString());
                    ++n2;
                }
                entry.setString("executionManagerURIs", this.stripString(urisString.toString(), maxLength));
                DefaultExecutionHistory.this.write(session, entry);
            }

            @Override
            public void logNodeFailed(SessionToken session, long timestamp, Long clientDelay, Instance instance, int nodeID, int iteration, long errorCode, String errorState, String errorMessage) throws DataSourceException {
                LogEntrySet.Cursor entry = new DefaultLogEntrySet(DefaultExecutionHistory.this.getSchema()).appendEntry();
                this.fillCommonNodeColumns(entry, timestamp, clientDelay, instance, nodeID, iteration, ExecutionHistory.StateChange.NODE_FAILED);
                this.fillErrorColumn(entry, errorCode, errorState, errorMessage);
                DefaultExecutionHistory.this.write(session, entry);
            }

            private QualifiedAgent getAgentFromSession(SessionToken session) {
                try {
                    return DefaultExecutionHistory.this.getLogManager().getSessionFactory().checkAndGetTopLevelAgent(session);
                }
                catch (SecurityTokenIntegrityException ex) {
                    String msg = "";
                    throw new InternalServiceException(msg, ex);
                }
            }

            private void fillCommonNodeColumns(LogEntry entry, long timestamp, Long clientDelay, Instance instance, int nodeID, int iteration, ExecutionHistory.StateChange stateChange) {
                entry.setTimestamp("timestamp", new Timestamp(timestamp));
                if (clientDelay != null) {
                    entry.setLong("clientTimestamp", (long)clientDelay);
                } else {
                    entry.setNull("clientTimestamp");
                }
                entry.setUUID("instanceLogID", instance.getLogID());
                entry.setInteger("nodeID", nodeID);
                entry.setInteger("iteration", iteration);
                entry.setByte("stateChange", stateChange.getCode());
                this.fillAgentColumns(entry, instance.getPerformingAgent(nodeID));
            }

            private void fillAgentColumns(LogEntry entry, QualifiedAgent agent) {
                if (agent != null) {
                    entry.setLong("agentID", agent.getAgentID());
                    entry.setLong("agentOrgPositionID", agent.getOrgPositionID());
                } else {
                    entry.setNull("agentID");
                    entry.setNull("agentOrgPositionID");
                }
            }

            private void fillNameColumns(LogEntry entry, Instance instance, String nodeName) {
                int maxLength = DefaultExecutionHistory.this.getSchema().getColumn("nodeName").getSizeHint();
                entry.setString("nodeName", this.stripString(nodeName, maxLength));
                maxLength = DefaultExecutionHistory.this.getSchema().getColumn("instanceName").getSizeHint();
                entry.setString("instanceName", this.stripString(instance.getName(), maxLength));
                maxLength = DefaultExecutionHistory.this.getSchema().getColumn("templateName").getSizeHint();
                entry.setString("templateName", this.stripString(instance.getTemplate().getName(), maxLength));
            }

            private void fillErrorColumn(LogEntry entry, long errorCode, String errorState, String errorMessage) {
                Column errCol = DefaultExecutionHistory.this.getSchema().getColumn("error");
                DefaultLogEntrySet error = new DefaultLogEntrySet(errCol.getSubSchema());
                LogEntrySet.Cursor errorEntry = error.appendEntry();
                errorEntry.setLong("code", errorCode);
                int maxLength = errCol.getSubSchema().getColumn("state").getSizeHint();
                errorEntry.setString("state", this.stripString(errorState, maxLength));
                maxLength = errCol.getSubSchema().getColumn("message").getSizeHint();
                errorEntry.setString("message", this.stripString(errorMessage, maxLength));
                entry.setEntrySet("error", (LogEntrySet)error);
            }
        };
    }
}

