/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.logmanager.defaultimplementation;

import de.aristaflow.adept2.model.logmanagement.Column;
import de.aristaflow.adept2.model.logmanagement.DataType;
import de.aristaflow.adept2.model.logmanagement.LogEntry;
import de.aristaflow.adept2.model.logmanagement.LogEntrySet;
import de.aristaflow.adept2.model.logmanagement.Schema;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;

public class DefaultLogEntrySet
implements LogEntrySet {
    private static final long serialVersionUID = -8042632122181565456L;
    final Schema schema;
    final ArrayList<Serializable[]> entries;

    protected DefaultLogEntrySet(Schema schema) {
        ArgChecks.checkForNull(schema, "schema");
        this.schema = schema;
        this.entries = new ArrayList();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public int getEntryCount() {
        return this.entries.size();
    }

    protected LogEntrySet.Cursor appendEntry() {
        this.entries.add(new Serializable[this.getSchema().getColumnCount() + 1]);
        return this.getCursor(this.entries.size() - 1);
    }

    @Override
    public LogEntrySet.Cursor getCursor() {
        return new DefaultCursor();
    }

    @Override
    public LogEntrySet.Cursor getCursor(int position) {
        return new DefaultCursor(position);
    }

    int getColumnIndex(String columnName) {
        ArgChecks.checkForBlank(columnName, "columnName");
        int columnIndex = this.getSchema().indexOfColumn(columnName);
        if (columnIndex == -1) {
            String msg = "column '%s' not found";
            msg = String.format(msg, columnName);
            throw new IllegalArgumentException(msg);
        }
        return columnIndex;
    }

    void checkIndexAndDataType(int columnIndex, DataType expected) {
        ArgChecks.checkIndex(columnIndex, this.getSchema().getColumnCount(), "columnIndex");
        Column column = this.getSchema().getColumn(columnIndex);
        DataType actual = column.getDataType();
        if (expected != null && actual != expected) {
            String msg = "data type mismatch (expected: '%s', actual: '%s' at column #%d '%s')";
            msg = String.format(msg, new Object[]{expected, actual, columnIndex, column.getName()});
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public Iterator<LogEntry> iterator() {
        return new Iterator<LogEntry>(){
            private LogEntrySet.Cursor cursor;
            {
                this.cursor = DefaultLogEntrySet.this.getCursor();
            }

            @Override
            public boolean hasNext() {
                return this.cursor.getPosition() + 1 < DefaultLogEntrySet.this.getEntryCount();
            }

            @Override
            public LogEntry next() {
                this.cursor.nextEntry();
                return this.cursor;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private class DefaultCursor
    implements LogEntrySet.Cursor {
        private static final long serialVersionUID = 249430640051505858L;
        private int cursorPos = -1;

        public DefaultCursor() {
        }

        public DefaultCursor(int cursorPos) {
            this.setPosition(cursorPos);
        }

        @Override
        public Schema getSchema() {
            return DefaultLogEntrySet.this.schema;
        }

        @Override
        public int getPosition() {
            return this.cursorPos;
        }

        @Override
        public void setPosition(int cursorPos) {
            if (cursorPos < -1 || cursorPos > DefaultLogEntrySet.this.getEntryCount()) {
                throw new IndexOutOfBoundsException("cursor is not at an accessible entry or one index before first or one index after last entry: " + cursorPos);
            }
            this.cursorPos = cursorPos;
        }

        @Override
        public boolean nextEntry() {
            if (this.getPosition() < DefaultLogEntrySet.this.getEntryCount() - 1) {
                ++this.cursorPos;
                return true;
            }
            return false;
        }

        @Override
        public boolean prevEntry() {
            if (this.getPosition() > 0) {
                --this.cursorPos;
                return true;
            }
            return false;
        }

        @Override
        public void beforeFirstEntry() {
            this.cursorPos = -1;
        }

        @Override
        public void afterLastEntry() {
            this.cursorPos = DefaultLogEntrySet.this.getEntryCount();
        }

        @Override
        public long getID() {
            Serializable id = DefaultLogEntrySet.this.entries.get(this.cursorPos)[this.getSchema().getColumnCount()];
            if (id == null) {
                return Long.MIN_VALUE;
            }
            return (Long)id;
        }

        @Override
        public void setID(long id) {
            DefaultLogEntrySet.this.entries.get((int)this.cursorPos)[this.getSchema().getColumnCount()] = Long.valueOf(id);
        }

        @Override
        public Object get(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, null);
            return this.getValue(columnIndex);
        }

        @Override
        public Object get(String columnName) {
            this.checkCursorPosForAccess();
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.get(columnIndex);
        }

        @Override
        public boolean getBoolean(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.BOOLEAN);
            Object value = this.getValue(columnIndex);
            return value == null ? false : (Boolean)value;
        }

        @Override
        public boolean getBoolean(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.getBoolean(columnIndex);
        }

        @Override
        public void setBoolean(int columnIndex, boolean value) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.BOOLEAN);
            this.setValue(columnIndex, Boolean.valueOf(value));
        }

        @Override
        public void setBoolean(String columnName, boolean value) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setBoolean(columnIndex, value);
        }

        @Override
        public byte getByte(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.BYTE);
            Object value = this.getValue(columnIndex);
            return value == null ? (byte)0 : (Byte)value;
        }

        @Override
        public byte getByte(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.getByte(columnIndex);
        }

        @Override
        public void setByte(int columnIndex, byte value) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.BYTE);
            this.setValue(columnIndex, Byte.valueOf(value));
        }

        @Override
        public void setByte(String columnName, byte value) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setByte(columnIndex, value);
        }

        @Override
        public short getShort(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.SHORT);
            Object value = this.getValue(columnIndex);
            return value == null ? (short)0 : (Short)value;
        }

        @Override
        public short getShort(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.getShort(columnIndex);
        }

        @Override
        public void setShort(int columnIndex, short value) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.SHORT);
            this.setValue(columnIndex, Short.valueOf(value));
        }

        @Override
        public void setShort(String columnName, short value) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setShort(columnIndex, value);
        }

        @Override
        public int getInteger(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.INTEGER);
            Object value = this.getValue(columnIndex);
            return value == null ? 0 : (Integer)value;
        }

        @Override
        public int getInteger(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.getInteger(columnIndex);
        }

        @Override
        public void setInteger(int columnIndex, int value) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.INTEGER);
            this.setValue(columnIndex, Integer.valueOf(value));
        }

        @Override
        public void setInteger(String columnName, int value) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setInteger(columnIndex, value);
        }

        @Override
        public long getLong(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.LONG);
            Object value = this.getValue(columnIndex);
            return value == null ? 0L : (Long)value;
        }

        @Override
        public long getLong(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.getLong(columnIndex);
        }

        @Override
        public void setLong(int columnIndex, long value) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.LONG);
            this.setValue(columnIndex, Long.valueOf(value));
        }

        @Override
        public void setLong(String columnName, long value) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setLong(columnIndex, value);
        }

        @Override
        public float getFloat(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.FLOAT);
            Object value = this.getValue(columnIndex);
            return value == null ? 0.0f : ((Float)value).floatValue();
        }

        @Override
        public float getFloat(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.getFloat(columnIndex);
        }

        @Override
        public void setFloat(int columnIndex, float value) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.FLOAT);
            this.setValue(columnIndex, Float.valueOf(value));
        }

        @Override
        public void setFloat(String columnName, float value) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setFloat(columnIndex, value);
        }

        @Override
        public double getDouble(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.DOUBLE);
            Object value = this.getValue(columnIndex);
            return value == null ? 0.0 : (Double)value;
        }

        @Override
        public double getDouble(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.getDouble(columnIndex);
        }

        @Override
        public void setDouble(int columnIndex, double value) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.DOUBLE);
            this.setValue(columnIndex, Double.valueOf(value));
        }

        @Override
        public void setDouble(String columnName, double value) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setDouble(columnIndex, value);
        }

        @Override
        public String getString(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.STRING);
            return (String)this.getValue(columnIndex);
        }

        @Override
        public String getString(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.getString(columnIndex);
        }

        @Override
        public void setString(int columnIndex, String value) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.STRING);
            this.setValue(columnIndex, (Serializable)((Object)value));
        }

        @Override
        public void setString(String columnName, String value) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setString(columnIndex, value);
        }

        @Override
        public UUID getUUID(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.UUID);
            return (UUID)this.getValue(columnIndex);
        }

        @Override
        public UUID getUUID(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.getUUID(columnIndex);
        }

        @Override
        public void setUUID(int columnIndex, UUID value) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.UUID);
            this.setValue(columnIndex, value);
        }

        @Override
        public void setUUID(String columnName, UUID value) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setUUID(columnIndex, value);
        }

        @Override
        public Timestamp getTimestamp(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.TIMESTAMP);
            return (Timestamp)this.getValue(columnIndex);
        }

        @Override
        public Timestamp getTimestamp(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.getTimestamp(columnIndex);
        }

        @Override
        public void setTimestamp(int columnIndex, Timestamp value) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.TIMESTAMP);
            this.setValue(columnIndex, value);
        }

        @Override
        public void setTimestamp(String columnName, Timestamp value) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setTimestamp(columnIndex, value);
        }

        @Override
        public LogEntrySet getEntrySet(int columnIndex) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.COMPLEX);
            return (LogEntrySet)this.getValue(columnIndex);
        }

        @Override
        public LogEntrySet getEntrySet(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.getEntrySet(columnIndex);
        }

        @Override
        public void setEntrySet(int columnIndex, LogEntrySet value) {
            this.checkCursorPosForAccess();
            DefaultLogEntrySet.this.checkIndexAndDataType(columnIndex, DataType.COMPLEX);
            if (!this.getSchema().getColumn(columnIndex).getSubSchema().equals(value.getSchema())) {
                throw new IllegalArgumentException("schema of provided log entry set does not match sub-schema of column");
            }
            this.setValue(columnIndex, value);
        }

        @Override
        public void setEntrySet(String columnName, LogEntrySet value) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setEntrySet(columnIndex, value);
        }

        @Override
        public boolean isNull(int columnIndex) {
            this.checkCursorPosForAccess();
            ArgChecks.checkIndex(columnIndex, this.getSchema().getColumnCount(), "columnIndex");
            return this.getValue(columnIndex) == null;
        }

        @Override
        public boolean isNull(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            return this.isNull(columnIndex);
        }

        @Override
        public void setNull(int columnIndex) {
            this.checkCursorPosForAccess();
            ArgChecks.checkIndex(columnIndex, this.getSchema().getColumnCount(), "columnIndex");
            this.setValue(columnIndex, null);
        }

        @Override
        public void setNull(String columnName) {
            int columnIndex = DefaultLogEntrySet.this.getColumnIndex(columnName);
            this.setNull(columnIndex);
        }

        private void checkCursorPosForAccess() {
            this.checkCursorPosForAccess(this.cursorPos);
        }

        private void checkCursorPosForAccess(int cursorPos) {
            if (cursorPos < 0 || cursorPos >= DefaultLogEntrySet.this.getEntryCount()) {
                throw new IllegalStateException("cursor is not at an accessible position: " + cursorPos);
            }
        }

        private Object getValue(int columnIndex) {
            return DefaultLogEntrySet.this.entries.get(this.cursorPos)[columnIndex];
        }

        private void setValue(int columnIndex, Serializable value) {
            DefaultLogEntrySet.this.entries.get((int)this.cursorPos)[columnIndex] = value;
        }
    }
}

