/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.logmanager.defaultimplementation;

import com.sun.rowset.CachedRowSetImpl;
import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.logmanager.Log;
import de.aristaflow.adept2.core.logmanager.LogManager;
import de.aristaflow.adept2.core.logmanager.defaultimplementation.AbstractDefaultLog;
import de.aristaflow.adept2.core.logmanager.defaultimplementation.DefaultExecutionHistory;
import de.aristaflow.adept2.core.logmanager.defaultimplementation.ResultSetWrapper;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.model.logmanagement.CmpOperator;
import de.aristaflow.adept2.model.logmanagement.Column;
import de.aristaflow.adept2.model.logmanagement.DataType;
import de.aristaflow.adept2.model.logmanagement.Schema;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;

public class DefaultLogManager
extends AbstractADEPT2Service
implements LogManager {
    protected Configuration configuration;
    private JDBCDataSource dataSource;
    protected Map<Class<? extends Log>, AbstractDefaultLog> logs = new HashMap<Class<? extends Log>, AbstractDefaultLog>();
    public static final Pattern COND_FRAME_PATTERN = Pattern.compile("\\{c\\:(.*?)\\}", 2);
    public static final Pattern COND_PATTERN = Pattern.compile("^\\s*(.+?)(?:\\s+(.+?))?\\s*$");

    public DefaultLogManager(Configuration configuration, Registry registry) {
        super(configuration, registry, new String[]{"JDBCDataSource"}, new String[0]);
        this.configuration = configuration;
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs, -2, -2, "password");
        SessionToken initSession = this.createSessionToken();
        this.dataSource = this.registry.getServiceOfType(initSession, "JDBCDataSource", JDBCDataSource.class);
        this.logs.put(ExecutionHistory.class, new DefaultExecutionHistory(this));
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        for (Class<? extends Log> logInterface : this.logs.keySet()) {
            Log log = this.logs.get(logInterface);
            ExtendedConnection con = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    boolean exists = con.tableExists(log.getName());
                    con = JDBCTools.close(con);
                    if (!exists) {
                        this.createTables(log);
                    }
                }
                catch (SQLException ex) {
                    String msg = "Creating tables for the log '%s' failed!";
                    msg = String.format(msg, log.getName());
                    throw new RuntimeException(msg, ex);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con);
                throw throwable;
            }
            JDBCTools.closeQuietly(con);
        }
    }

    @Override
    public ExecutionHistory getExecutionHistory() {
        return (ExecutionHistory)((Object)this.logs.get(ExecutionHistory.class));
    }

    public boolean hasLog(SessionToken session, Class<? extends Log> logInterface) {
        ArgChecks.checkForNull(logInterface, "logInterface");
        this.sessionActive(session);
        try {
            boolean bl = this.logs.get(logInterface) != null;
            return bl;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    public <L extends Log> L getLog(SessionToken session, Class<L> logInterface) throws ConfigurationException {
        ArgChecks.checkForNull(logInterface, "logInterface");
        this.sessionActive(session);
        try {
            Log log = this.logs.get(logInterface);
            if (log == null) {
                String msg = "%s is not available!";
                msg = String.format(msg, logInterface.getName());
                throw new ConfigurationException(msg);
            }
            Log log2 = log;
            return (L)log2;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ResultSet query(SessionToken session, String sqlQuery, int maxEntries) throws SQLException {
        ArgChecks.checkForBlank(sqlQuery, "sqlQuery");
        ArgChecks.checkForNegative(maxEntries, "maxEntries");
        this.sessionActive(session);
        try {
            CachedRowSetImpl cachedRowSetImpl;
            ExtendedConnection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                stmt = con.createStatement();
                if (maxEntries > 0) {
                    stmt.setMaxRows(maxEntries);
                }
                rs = stmt.executeQuery(sqlQuery);
                CachedRowSetImpl rowSet = new CachedRowSetImpl();
                rowSet.populate(rs);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                cachedRowSetImpl = rowSet;
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, stmt, rs);
            return cachedRowSetImpl;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    ResultSet localQuery(SessionToken session, String sqlQuery, int maxEntries) throws SQLException {
        ArgChecks.checkForBlank(sqlQuery, "sqlQuery");
        ArgChecks.checkForNegative(maxEntries, "maxEntries");
        this.sessionActive(session);
        try {
            ResultSetWrapper resultSetWrapper;
            ExtendedConnection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                stmt = con.createStatement();
                if (maxEntries > 0) {
                    stmt.setMaxRows(maxEntries);
                }
                rs = stmt.executeQuery(sqlQuery);
                ResultSetWrapper ret = new ResultSetWrapper(con, stmt, rs);
                rs = null;
                stmt = null;
                con = null;
                resultSetWrapper = ret;
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, stmt, rs);
            return resultSetWrapper;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public String formatCondition(SessionToken session, String conditionFormat, Object ... values) throws DataSourceException {
        ArgChecks.checkForBlank(conditionFormat, "conditionFormat");
        ArgChecks.checkForNull(values, "values");
        this.sessionActive(session);
        try {
            String msg;
            Matcher frameMatcher = COND_FRAME_PATTERN.matcher(conditionFormat);
            StringBuffer formattedCondition = null;
            Matcher condMatcher = null;
            int index = 0;
            while (frameMatcher.find()) {
                CmpOperator cmpOp;
                if (index >= values.length) {
                    msg = "not enough values";
                    throw new IllegalArgumentException(msg);
                }
                if (formattedCondition == null || condMatcher == null) {
                    formattedCondition = new StringBuffer();
                    condMatcher = COND_PATTERN.matcher("");
                }
                Object value = values[index];
                String rawCond = frameMatcher.group(1);
                condMatcher.reset(rawCond);
                if (!condMatcher.matches()) {
                    String msg2 = "invalid condition format: '%s'";
                    msg2 = String.format(msg2, frameMatcher.group());
                    throw new IllegalArgumentException(msg2);
                }
                String columnName = condMatcher.group(1);
                if (condMatcher.group(2) == null) {
                    cmpOp = CmpOperator.EQUAL;
                } else {
                    cmpOp = CmpOperator.getCmpOperatorForSymbol(condMatcher.group(2));
                    if (cmpOp == null) {
                        String msg3 = "unknown comparison operator: '%s'";
                        msg3 = String.format(msg3, condMatcher.group(2));
                        throw new IllegalArgumentException(msg3);
                    }
                }
                frameMatcher.appendReplacement(formattedCondition, this.formatCondition(session, columnName, DataType.getDataTypeForObject(value), cmpOp, value));
                ++index;
            }
            if (values.length > index) {
                msg = "too many values";
                msg = String.format(msg, new Object[0]);
                throw new IllegalArgumentException(msg);
            }
            frameMatcher.appendTail(formattedCondition);
            String string = formattedCondition == null ? conditionFormat : formattedCondition.toString();
            return string;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    /*
     * Loose catch block
     */
    private String formatCondition(SessionToken session, String columnName, DataType columnDataType, CmpOperator cmpOp, Object value) throws DataSourceException {
        ArgChecks.checkForNull(columnName, "columnName");
        ArgChecks.checkForNull((Object)columnDataType, "columnDataType");
        ArgChecks.checkForNull((Object)cmpOp, "cmpOp");
        this.sessionActive(session);
        try {
            DataType valueDataType = DataType.getDataTypeForObject(value);
            if (!cmpOp.canCompare(columnDataType, valueDataType)) {
                String msg;
                if (!cmpOp.canCompare(columnDataType)) {
                    msg = "The comparison operator %s can't operator on the column's data type %s!";
                    msg = String.format(msg, new Object[]{cmpOp, columnDataType});
                } else if (!cmpOp.canCompare(valueDataType)) {
                    msg = "The comparison operator %s can't operate on the value's data type %s!";
                    msg = String.format(msg, new Object[]{cmpOp, valueDataType});
                } else {
                    msg = "The comparison operator %s can't compare the column's data type %s and the value's data type %s!";
                    msg = String.format(msg, new Object[]{cmpOp, columnDataType, valueDataType});
                }
                throw new IllegalArgumentException(msg);
            }
            if (value == null) {
                if (cmpOp == CmpOperator.EQUAL) {
                    String string = String.valueOf(columnName) + " IS NULL";
                    return string;
                }
                if (cmpOp == CmpOperator.NOT_EQUAL) {
                    String string = String.valueOf(columnName) + " IS NOT NULL";
                    return string;
                }
                String msg = "Encountered an unexpected comparison operator that is apparently able to deal with null!";
                throw new AssertionError((Object)msg);
            }
            ExtendedConnection con = null;
            try {
                con = this.getDataSource().getConnection();
                String cmpOpSymbol = DefaultLogManager.cmpOperatorToSqlSymbol(cmpOp);
                String preparedValue = con.formatValue(value, DefaultLogManager.mapToJdbcTypeCode(columnDataType));
                con = JDBCTools.close(con);
                if (cmpOp == CmpOperator.LIKE_IGNORECASE || cmpOp == CmpOperator.NOT_LIKE_IGNORECASE) {
                    String string = "UPPER(" + columnName + ") " + cmpOpSymbol + " " + preparedValue.toUpperCase();
                    return string;
                }
                String string = String.valueOf(columnName) + " " + cmpOpSymbol + " " + preparedValue;
                return string;
            }
            catch (SQLException ex) {
                String msg = "Couldn't format value to DB specific format!";
                throw new DataSourceException(msg, ex);
            }
            finally {
                JDBCTools.closeQuietly(con);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.sessionFinished(session);
        }
    }

    private static String cmpOperatorToSqlSymbol(CmpOperator cmpOp) {
        switch (cmpOp) {
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "<>";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_OR_EQUAL: {
                return ">=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_OR_EQUAL: {
                return "<=";
            }
            case LIKE: 
            case LIKE_IGNORECASE: {
                return "LIKE";
            }
            case NOT_LIKE: 
            case NOT_LIKE_IGNORECASE: {
                return "NOT LIKE";
            }
        }
        throw new AssertionError((Object)("cmpOperatorToSqlSymbol(): " + (Object)((Object)cmpOp)));
    }

    void createTables(Log log) throws SQLException {
        ExtendedConnection con = null;
        try {
            con = this.getDataSource().getConnection();
            con.setAutoCommit(false);
            this.createTables(con, null, log.getName(), log.getSchema());
            con = JDBCTools.close(con);
        }
        finally {
            JDBCTools.closeQuietly(con);
        }
    }

    private void createTables(ExtendedConnection con, String parentTableName, String tableName, Schema logSchema) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(tableName);
        sb.append(" (");
        sb.append("id ");
        sb.append(con.getCorrespondingDBType(-5));
        sb.append(" NOT NULL");
        if (parentTableName != null) {
            sb.append(", refId ");
            sb.append(con.getCorrespondingDBType(-5));
            sb.append(" NOT NULL");
        }
        ArrayList<Column> complexColumns = new ArrayList<Column>();
        Column[] columnArray = logSchema.getColumns();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column col = columnArray[n2];
            if (col.getDataType() == DataType.COMPLEX) {
                complexColumns.add(col);
            } else {
                int jdbcTypeCode;
                sb.append(", ");
                sb.append(col.getName());
                sb.append(" ");
                if (col.getDataType() == DataType.STRING) {
                    jdbcTypeCode = DefaultLogManager.mapToJdbcTypeCode(col.getDataType());
                    if (col.getSizeHint() >= 4000) {
                        jdbcTypeCode = -1;
                    }
                    sb.append(con.getCorrespondingDBType(jdbcTypeCode, col.getSizeHint()));
                } else if (col.getDataType() == DataType.UUID) {
                    jdbcTypeCode = DefaultLogManager.mapToJdbcTypeCode(col.getDataType());
                    sb.append(con.getCorrespondingDBType(jdbcTypeCode, 36));
                } else {
                    jdbcTypeCode = DefaultLogManager.mapToJdbcTypeCode(col.getDataType());
                    sb.append(con.getCorrespondingDBType(jdbcTypeCode));
                }
            }
            ++n2;
        }
        sb.append(", PRIMARY KEY (id)");
        if (parentTableName != null) {
            sb.append(", FOREIGN KEY (refId) REFERENCES ");
            sb.append(parentTableName);
            sb.append("(id) ON DELETE CASCADE");
        }
        sb.append(")");
        String query = sb.toString();
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeUpdate(query);
            con.createSequence(String.valueOf(tableName) + "_ID", 1L, 1L);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
        for (Column complexCol : complexColumns) {
            String childTableName = String.valueOf(tableName) + "_" + complexCol.getName();
            this.createTables(con, tableName, childTableName, complexCol.getSubSchema());
        }
    }

    static int mapToJdbcTypeCode(DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return 16;
            }
            case BYTE: {
                return -6;
            }
            case SHORT: {
                return 5;
            }
            case INTEGER: {
                return 4;
            }
            case LONG: {
                return -5;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 8;
            }
            case STRING: {
                return 12;
            }
            case UUID: {
                return 12;
            }
            case TIMESTAMP: {
                return 93;
            }
            case COMPLEX: {
                throw new IllegalArgumentException("There can't be a matching JDBC type code for DataType.COMPLEX!");
            }
        }
        throw new AssertionError((Object)dataType);
    }

    @Override
    protected SessionFactory getSessionFactory() {
        return super.getSessionFactory();
    }

    JDBCDataSource getDataSource() {
        return this.dataSource;
    }
}

