/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.logmanager.eventimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.complexeventmanager.EventManager;
import de.aristaflow.adept2.core.logmanager.defaultimplementation.AbstractDefaultLog;
import de.aristaflow.adept2.core.logmanager.eventimplementation.DefaultEventLogManager;
import de.aristaflow.adept2.core.logmanager.eventimplementation.DelegatingExecutionHistoryWriteAccess;
import de.aristaflow.adept2.core.logmanager.eventimplementation.EventManagerWriteAccess;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistoryWriteAccess;
import de.aristaflow.adept2.model.logmanagement.LogEntry;
import de.aristaflow.adept2.model.logmanagement.LogEntrySet;
import de.aristaflow.adept2.model.logmanagement.Schema;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public class DelegatingExecutionHistory
extends AbstractDefaultLog
implements ExecutionHistory {
    private static final String SECONDARY_EXECUTION_HISTORY = "SecondaryExecutionHistory";
    private static final String PLUGIN_TYPE_EXECUTION_HISTORY_WRITE_ACCESS = null;
    protected final Logger logger = LoggerTools.getLogger(this);
    private ExecutionHistory primaryExecutionHistory;
    private final Registry registry;
    private final Set<ExecutionHistoryWriteAccess> secondaryExecutionHistories;
    private final DefaultEventLogManager defaultLogManager;
    private DelegatingExecutionHistoryWriteAccess writeAccess;

    public DelegatingExecutionHistory(DefaultEventLogManager defaultLogManager, Configuration configuration, Registry registry, ExecutionHistory primaryExecutionHistory) throws AbortServiceException {
        super(defaultLogManager, "ExecutionHistory", SCHEMA);
        this.defaultLogManager = defaultLogManager;
        this.registry = registry;
        this.primaryExecutionHistory = primaryExecutionHistory;
        this.secondaryExecutionHistories = new HashSet<ExecutionHistoryWriteAccess>();
        EventManager eventManager = registry.getServiceOfType(this.getSessionToken(), "ComplexEventManager", EventManager.class);
        try {
            this.initSecondaryExecutionHistory(configuration);
        }
        catch (ServiceNotKnownException e) {
            throw new ConfigurationException("unexpected problem", e);
        }
        this.secondaryExecutionHistories.add(new EventManagerWriteAccess(eventManager));
        this.writeAccess = new DelegatingExecutionHistoryWriteAccess(this);
    }

    private void initSecondaryExecutionHistory(Configuration configuration) throws ServiceNotKnownException {
        List historyIDs = configuration.getList(SECONDARY_EXECUTION_HISTORY);
        int i = 0;
        while (i < historyIDs.size()) {
            this.secondaryExecutionHistories.add(this.getExecutionHistory((String)historyIDs.get(i)));
            ++i;
        }
    }

    public ExecutionHistoryWriteAccess getExecutionHistory(String historyID) throws ServiceNotKnownException {
        return this.registry.getConfiguredPlugin(this.getSessionToken(), this, PLUGIN_TYPE_EXECUTION_HISTORY_WRITE_ACCESS, ExecutionHistoryWriteAccess.class, historyID);
    }

    private SessionToken getSessionToken() {
        return this.defaultLogManager.getSessionFactory() != null ? this.defaultLogManager.getSessionFactory().getSessionToken(this.defaultLogManager.getURIs()) : null;
    }

    @Override
    public long countInstanceHistoryEntries(SessionToken session, UUID instanceLogID) throws DataSourceException {
        return this.primaryExecutionHistory.countInstanceHistoryEntries(session, instanceLogID);
    }

    @Override
    public ExecutionHistoryWriteAccess getWriteAccess() {
        return this.writeAccess;
    }

    @Override
    public LogEntrySet readCompletedSteps(SessionToken session, long fromTimestamp, long toTimestamp, long agentID, long ... orgPositionID) throws DataSourceException {
        return this.primaryExecutionHistory.readCompletedSteps(session, fromTimestamp, toTimestamp, agentID, orgPositionID);
    }

    @Override
    public LogEntry readInstanceErrorInformation(SessionToken session, UUID instanceLogID) throws DataSourceException {
        return this.primaryExecutionHistory.readInstanceErrorInformation(session, instanceLogID);
    }

    @Override
    public LogEntrySet readInstanceHistory(SessionToken session, UUID instanceLogID) throws DataSourceException {
        return this.primaryExecutionHistory.readInstanceHistory(session, instanceLogID);
    }

    @Override
    public LogEntrySet readInstanceHistory(SessionToken session, UUID instanceLogID, int startEntry, int entryCount) throws DataSourceException {
        return this.primaryExecutionHistory.readInstanceHistory(session, instanceLogID, startEntry, entryCount);
    }

    @Override
    public LogEntry readNodeErrorInformation(SessionToken session, long logEntryID) throws DataSourceException {
        return this.primaryExecutionHistory.readNodeErrorInformation(session, logEntryID);
    }

    @Override
    public LogEntrySet readPreviousSteps(SessionToken session, UUID instanceLogID, int nodeID, int iteration) throws DataSourceException {
        return this.primaryExecutionHistory.readPreviousSteps(session, instanceLogID, nodeID, iteration);
    }

    @Override
    public long count(SessionToken session, String sqlWhereClause) throws DataSourceException {
        return this.primaryExecutionHistory.count(session, sqlWhereClause);
    }

    @Override
    public String formatCondition(SessionToken session, String conditionFormat, Object ... values) throws DataSourceException {
        return this.primaryExecutionHistory.formatCondition(session, conditionFormat, values);
    }

    @Override
    public String getName() {
        return this.primaryExecutionHistory.getName();
    }

    @Override
    public Schema getSchema() {
        return this.primaryExecutionHistory.getSchema();
    }

    @Override
    public ResultSet query(SessionToken session, String sqlQuery, int maxEntries) throws SQLException {
        return this.primaryExecutionHistory.query(session, sqlQuery, maxEntries);
    }

    @Override
    public LogEntry read(SessionToken session, long logEntryID, String ... columnNames) throws DataSourceException {
        return this.primaryExecutionHistory.read(session, logEntryID, columnNames);
    }

    @Override
    public LogEntrySet read(SessionToken session, String sqlWhereClause, String sqlOrderByClause, int maxEntries, String ... columnNames) throws DataSourceException {
        return this.primaryExecutionHistory.read(session, sqlWhereClause, sqlOrderByClause, maxEntries, columnNames);
    }

    @Override
    public LogEntrySet read(SessionToken session, String sqlWhereClause, String sqlOrderByClause, int startEntry, int maxEntries, String ... columnNames) throws DataSourceException {
        return this.primaryExecutionHistory.read(session, sqlWhereClause, sqlOrderByClause, startEntry, maxEntries, columnNames);
    }

    ExecutionHistoryWriteAccess[] getSecondaryExecutionHistoryWriteAccess() {
        return this.secondaryExecutionHistories.toArray(new ExecutionHistoryWriteAccess[this.secondaryExecutionHistories.size()]);
    }

    protected ExecutionHistoryWriteAccess getPrimaryWriteAccess() {
        return this.primaryExecutionHistory.getWriteAccess();
    }
}

