/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.logmanager.eventimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.logmanager.eventimplementation.DelegatingExecutionHistory;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistoryWriteAccess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DelegatingExecutionHistoryWriteAccess
implements ExecutionHistoryWriteAccess {
    protected final Logger logger = LoggerTools.getLogger(this);
    private static final boolean MULTITHREADED = false;
    private final ExecutorService executor;
    private final DelegatingExecutionHistory executionHistory;

    public DelegatingExecutionHistoryWriteAccess(DelegatingExecutionHistory executionHistory) {
        this.executionHistory = executionHistory;
        this.executor = null;
    }

    protected ExecutionHistoryWriteAccess[] getSecondaryWriteAccesses() {
        return this.executionHistory.getSecondaryExecutionHistoryWriteAccess();
    }

    private ExecutionHistoryWriteAccess getPrimaryWriteAccess() {
        return this.executionHistory.getPrimaryWriteAccess();
    }

    @Override
    public void logInstanceChanged(final SessionToken session, final long timestamp, final Instance instance) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logInstanceChanged(session, timestamp, instance);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logInstanceChanged(session, timestamp, instance);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logInstanceFailed(final SessionToken session, final long timestamp, final Instance instance, final long errorCode, final String errorState, final String errorMessage) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logInstanceFailed(session, timestamp, instance, errorCode, errorState, errorMessage);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logInstanceFailed(session, timestamp, instance, errorCode, errorState, errorMessage);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logInstanceFinished(final SessionToken session, final long timestamp, final Instance instance) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logInstanceFinished(session, timestamp, instance);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logInstanceFinished(session, timestamp, instance);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logInstanceResumed(final SessionToken session, final long timestamp, final Instance instance) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logInstanceResumed(session, timestamp, instance);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logInstanceResumed(session, timestamp, instance);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logInstanceStarted(final SessionToken session, final long timestamp, final Instance instance) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logInstanceStarted(session, timestamp, instance);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logInstanceStarted(session, timestamp, instance);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logInstanceSuspended(final SessionToken session, final long timestamp, final Instance instance) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logInstanceSuspended(session, timestamp, instance);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logInstanceSuspended(session, timestamp, instance);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logNodeActivated(final SessionToken session, final long timestamp, final Instance instance, final int nodeID, final int iteration) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logNodeActivated(session, timestamp, instance, nodeID, iteration);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logNodeActivated(session, timestamp, instance, nodeID, iteration);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logNodeFailed(final SessionToken session, final long timestamp, final Long clientDelay, final Instance instance, final int nodeID, final int iteration, final long errorCode, final String errorState, final String errorMessage) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logNodeFailed(session, timestamp, clientDelay, instance, nodeID, iteration, errorCode, errorState, errorMessage);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logNodeFailed(session, timestamp, clientDelay, instance, nodeID, iteration, errorCode, errorState, errorMessage);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logNodeFinished(final SessionToken session, final long timestamp, final Long clientDelay, final Instance instance, final int nodeID, final String nodeName, final int iteration, final URI[] executionManagerURIs) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logNodeFinished(session, timestamp, clientDelay, instance, nodeID, nodeName, iteration, executionManagerURIs);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logNodeFinished(session, timestamp, clientDelay, instance, nodeID, nodeName, iteration, executionManagerURIs);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logNodeResetHard(final SessionToken session, final long timestamp, final Instance instance, final int nodeID, final int iteration) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logNodeResetHard(session, timestamp, instance, nodeID, iteration);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logNodeResetHard(session, timestamp, instance, nodeID, iteration);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logNodeResetSoft(final SessionToken session, final long timestamp, final Long clientDelay, final Instance instance, final int nodeID, final int iteration) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logNodeResetSoft(session, timestamp, clientDelay, instance, nodeID, iteration);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logNodeResetSoft(session, timestamp, clientDelay, instance, nodeID, iteration);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logNodeResumed(final SessionToken session, final long timestamp, final Instance instance, final int nodeID, final int iteration) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logNodeResumed(session, timestamp, instance, nodeID, iteration);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logNodeResumed(session, timestamp, instance, nodeID, iteration);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logNodeStarted(final SessionToken session, final long timestamp, final Instance instance, final int nodeID, final String nodeName, final int iteration) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logNodeStarted(session, timestamp, instance, nodeID, nodeName, iteration);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logNodeStarted(session, timestamp, instance, nodeID, nodeName, iteration);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logNodeSuspended(final SessionToken session, final long timestamp, Long clientDelay, final Instance instance, int nodeID, int iteration) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logInstanceSuspended(session, timestamp, instance);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logInstanceSuspended(session, timestamp, instance);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    private void executeTask(Runnable task) {
        task.run();
    }

    @Override
    public void logNodeDeselected(final SessionToken session, final long timestamp, final Instance instance, final int nodeID, final int iteration) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logNodeDeselected(session, timestamp, instance, nodeID, iteration);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logNodeDeselected(session, timestamp, instance, nodeID, iteration);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logNodeSelected(final SessionToken session, final long timestamp, final Instance instance, final int nodeID, final int iteration) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logNodeSelected(session, timestamp, instance, nodeID, iteration);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logNodeSelected(session, timestamp, instance, nodeID, iteration);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void logNodeSkipped(final SessionToken session, final long timestamp, final Instance instance, final int nodeID, final int iteration) throws DataSourceException {
        DataSourceException primaryException = null;
        try {
            this.getPrimaryWriteAccess().logNodeSkipped(session, timestamp, instance, nodeID, iteration);
        }
        catch (DataSourceException dse) {
            primaryException = dse;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExecutionHistoryWriteAccess[] executionHistoryWriteAccessArray = DelegatingExecutionHistoryWriteAccess.this.getSecondaryWriteAccesses();
                int n = executionHistoryWriteAccessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionHistoryWriteAccess delegate = executionHistoryWriteAccessArray[n2];
                    try {
                        delegate.logNodeSkipped(session, timestamp, instance, nodeID, iteration);
                    }
                    catch (DataSourceException e) {
                        DelegatingExecutionHistoryWriteAccess.this.logger.log(Level.SEVERE, "DataSource Exception occurred during notifying Secondary Write Access!", e);
                    }
                    ++n2;
                }
            }
        };
        this.executeTask(task);
        if (primaryException != null) {
            throw primaryException;
        }
    }
}

