/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.logmanager.eventimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.complexeventmanager.EventClassManager;
import de.aristaflow.adept2.core.complexeventmanager.EventManager;
import de.aristaflow.adept2.core.complexeventmanager.EventSource;
import de.aristaflow.adept2.core.complexeventmanager.EventSourceConfiguration;
import de.aristaflow.adept2.core.complexeventmanager.EventSourceManager;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistoryWriteAccess;
import de.aristaflow.adept2.model.eventmodel.EventClass;
import de.aristaflow.adept2.model.eventmodel.EventReference;
import de.aristaflow.adept2.model.globals.ExecutionEventConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.util.DataSourceException;
import java.net.URI;
import java.util.HashMap;
import java.util.UUID;

public class EventManagerWriteAccess
implements ExecutionHistoryWriteAccess {
    private static final String ID = "ExecutionManagerEventSource";
    private final EventSource eventSource;
    private final EventClass processEventClass;
    private final EventClass subProcessEventClass;
    private final EventClass activityEventClass;
    private final EventClass instanceEventClass;
    private EventSourceManager eventSourceManager;

    public EventManagerWriteAccess(EventManager eventManager) {
        EventClassManager eventTypeManager = eventManager.getEventClassManager();
        this.eventSourceManager = eventManager.getEventSourceManager();
        this.instanceEventClass = this.createOrGetInstanceEventClass(eventTypeManager);
        this.processEventClass = this.createOrGetProcessEventClass(eventTypeManager, this.instanceEventClass);
        this.subProcessEventClass = this.createOrGetSubprocessEventClass(eventTypeManager, this.processEventClass);
        this.activityEventClass = this.createOrGetActivityEventClass(eventTypeManager, this.instanceEventClass);
        EventSourceConfiguration configuration = this.eventSourceManager.createEventSourceConfiguration(this.instanceEventClass.getEventClassID(), this.processEventClass.getEventClassID(), this.subProcessEventClass.getEventClassID(), this.activityEventClass.getEventClassID());
        this.eventSource = this.eventSourceManager.createEventSource(ID, configuration);
        this.eventSourceManager.registerEventSource(this.eventSource);
    }

    private EventClass createOrGetActivityEventClass(EventClassManager eventTypeManager, EventClass instanceEventClass) {
        EventClass activityEventClass = eventTypeManager.getEventClass("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity");
        if (activityEventClass == null) {
            HashMap activityEventAttributes = new HashMap();
            activityEventAttributes.putAll(instanceEventClass.getAttributes());
            activityEventAttributes.put("NodeID", Integer.class);
            activityEventAttributes.put("NodeIteration", Integer.class);
            activityEventAttributes.put("ActivityEventType", Enum.class);
            activityEventClass = eventTypeManager.createAndRegisterEventClass("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", "ActivityInstanceEvent", "A Activity Instance Event", activityEventAttributes, instanceEventClass.getEventClassID());
        }
        return activityEventClass;
    }

    private EventClass createOrGetProcessEventClass(EventClassManager eventTypeManager, EventClass instanceEventClass) {
        EventClass processEventClass = eventTypeManager.getEventClass("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Process");
        if (processEventClass == null) {
            HashMap processEventAttributes = new HashMap();
            processEventAttributes.putAll(instanceEventClass.getAttributes());
            processEventAttributes.put("ProcessEventType", Enum.class);
            processEventClass = eventTypeManager.createAndRegisterEventClass("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Process", "ProcessInstanceEvent", "A Process Instance Event", processEventAttributes, instanceEventClass.getEventClassID());
        }
        return processEventClass;
    }

    private EventClass createOrGetSubprocessEventClass(EventClassManager eventTypeManager, EventClass processEventClass) {
        EventClass subprocessEventClass = eventTypeManager.getEventClass("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Process.SubProcess");
        if (subprocessEventClass == null) {
            HashMap subprocessEventAttributes = new HashMap();
            subprocessEventAttributes.putAll(processEventClass.getAttributes());
            subprocessEventAttributes.put("ParentInstanceID", UUID.class);
            subprocessEventAttributes.put("NodeID", Integer.class);
            subprocessEventAttributes.put("NodeIteration", Integer.class);
            subprocessEventClass = eventTypeManager.createAndRegisterEventClass("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Process.SubProcess", "SubProcessInstanceEvent", "A SubProcess Instance Event", subprocessEventAttributes, processEventClass.getEventClassID());
        }
        return subprocessEventClass;
    }

    private EventClass createOrGetInstanceEventClass(EventClassManager eventTypeManager) {
        EventClass instanceEventClass = eventTypeManager.getEventClass("de.aristaflow.adept2.core.executionmanager.InstanceEvent");
        if (instanceEventClass == null) {
            HashMap instanceEventAttributes = new HashMap();
            instanceEventAttributes.put("InstanceID", UUID.class);
            instanceEventAttributes.put("TemplateID", UUID.class);
            instanceEventClass = eventTypeManager.createAndRegisterEventClass("de.aristaflow.adept2.core.executionmanager.InstanceEvent", "InstanceEvent", "A Instance Event", instanceEventAttributes, null);
        }
        return instanceEventClass;
    }

    @Override
    public void logInstanceChanged(SessionToken session, long timestamp, Instance instance) throws DataSourceException {
    }

    @Override
    public void logInstanceFailed(SessionToken session, long timestamp, Instance instance, long errorCode, String errorState, String errorMessage) throws DataSourceException {
    }

    @Override
    public void logInstanceFinished(SessionToken session, long timestamp, Instance instance) throws DataSourceException {
        boolean subProcess;
        boolean bl = subProcess = instance.getParentEBPReference() != null;
        if (subProcess) {
            this.logSubProcessFinished(session, timestamp, instance.getParentEBPReference(), instance);
        } else {
            String eventID = this.createEventID(instance.getID(), ExecutionEventConstants.ProcessEventType.FINISHED);
            HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
            eventAttributes.put("InstanceID", instance.getID());
            eventAttributes.put("TemplateID", instance.getBaseTemplateID());
            eventAttributes.put("ProcessEventType", (Object)ExecutionEventConstants.ProcessEventType.FINISHED);
            EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Process", eventID, timestamp, eventAttributes);
            this.eventSource.publishEvent(event);
        }
    }

    @Override
    public void logInstanceResumed(SessionToken session, long timestamp, Instance instance) throws DataSourceException {
    }

    @Override
    public void logInstanceStarted(SessionToken session, long timestamp, Instance instance) throws DataSourceException {
        boolean subProcess;
        boolean bl = subProcess = instance.getParentEBPReference() != null;
        if (subProcess) {
            this.logSubProcessStarted(session, timestamp, instance.getParentEBPReference(), instance);
        } else {
            String eventID = this.createEventID(instance.getID(), ExecutionEventConstants.ProcessEventType.STARTED);
            HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
            eventAttributes.put("InstanceID", instance.getID());
            eventAttributes.put("TemplateID", instance.getBaseTemplateID());
            eventAttributes.put("ProcessEventType", (Object)ExecutionEventConstants.ProcessEventType.STARTED);
            EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Process", eventID, timestamp, eventAttributes);
            this.eventSource.publishEvent(event);
        }
    }

    private String createEventID(UUID instanceID, ExecutionEventConstants.ProcessEventType type) {
        return instanceID + "." + (Object)((Object)type);
    }

    @Override
    public void logInstanceSuspended(SessionToken session, long timestamp, Instance instance) throws DataSourceException {
    }

    public void logSubProcessStarted(SessionToken session, long timestamp, EBPInstanceReference parentEBPReference, Instance instance) {
        String eventID = this.createEventID(instance.getID(), ExecutionEventConstants.ProcessEventType.STARTED);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ProcessEventType", (Object)ExecutionEventConstants.ProcessEventType.STARTED);
        eventAttributes.put("ParentInstanceID", instance.getParentEBPReference().getInstanceID());
        eventAttributes.put("NodeID", instance.getParentEBPReference().getNodeID());
        eventAttributes.put("NodeIteration", instance.getParentEBPReference().getNodeIteration());
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Process.SubProcess", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    public void logSubProcessFinished(SessionToken session, long timestamp, EBPInstanceReference parentEBPReference, Instance instance) {
        String eventID = this.createEventID(instance.getID(), ExecutionEventConstants.ProcessEventType.FINISHED);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ProcessEventType", (Object)ExecutionEventConstants.ProcessEventType.FINISHED);
        eventAttributes.put("ParentInstanceID", instance.getParentEBPReference().getInstanceID());
        eventAttributes.put("NodeID", instance.getParentEBPReference().getNodeID());
        eventAttributes.put("NodeIteration", instance.getParentEBPReference().getNodeIteration());
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Process.SubProcess", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    @Override
    public void logNodeActivated(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
        String eventID = this.createID(instance.getID(), nodeID, iteration, ExecutionEventConstants.ActivityEventType.ACTIVATED);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ActivityEventType", (Object)ExecutionEventConstants.ActivityEventType.ACTIVATED);
        eventAttributes.put("NodeID", nodeID);
        eventAttributes.put("NodeIteration", iteration);
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    private String createID(UUID instanceID, int nodeID, int iteration, ExecutionEventConstants.ActivityEventType type) {
        return instanceID + ":" + nodeID + ":" + iteration + "." + (Object)((Object)type);
    }

    @Override
    public void logNodeFailed(SessionToken session, long timestamp, Long clientDelay, Instance instance, int nodeID, int iteration, long errorCode, String errorState, String errorMessage) throws DataSourceException {
        String eventID = this.createID(instance.getID(), nodeID, iteration, ExecutionEventConstants.ActivityEventType.FAILED);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ActivityEventType", (Object)ExecutionEventConstants.ActivityEventType.FAILED);
        eventAttributes.put("NodeID", nodeID);
        eventAttributes.put("NodeIteration", iteration);
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    @Override
    public void logNodeFinished(SessionToken session, long timestamp, Long clientDelay, Instance instance, int nodeID, String nodeName, int iteration, URI[] executionManagerURIs) throws DataSourceException {
        String eventID = this.createID(instance.getID(), nodeID, iteration, ExecutionEventConstants.ActivityEventType.FINISHED);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ActivityEventType", (Object)ExecutionEventConstants.ActivityEventType.FINISHED);
        eventAttributes.put("NodeID", nodeID);
        eventAttributes.put("NodeIteration", iteration);
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    @Override
    public void logNodeResetHard(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
        String eventID = this.createID(instance.getID(), nodeID, iteration, ExecutionEventConstants.ActivityEventType.RESET);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ActivityEventType", (Object)ExecutionEventConstants.ActivityEventType.RESET);
        eventAttributes.put("NodeID", nodeID);
        eventAttributes.put("NodeIteration", iteration);
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    @Override
    public void logNodeResetSoft(SessionToken session, long timestamp, Long clientDelay, Instance instance, int nodeID, int iteration) throws DataSourceException {
        String eventID = this.createID(instance.getID(), nodeID, iteration, ExecutionEventConstants.ActivityEventType.RESET);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ActivityEventType", (Object)ExecutionEventConstants.ActivityEventType.RESET);
        eventAttributes.put("NodeID", nodeID);
        eventAttributes.put("NodeIteration", iteration);
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    @Override
    public void logNodeResumed(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
        String eventID = this.createID(instance.getID(), nodeID, iteration, ExecutionEventConstants.ActivityEventType.RESUMED);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ActivityEventType", (Object)ExecutionEventConstants.ActivityEventType.RESUMED);
        eventAttributes.put("NodeID", nodeID);
        eventAttributes.put("NodeIteration", iteration);
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    @Override
    public void logNodeStarted(SessionToken session, long timestamp, Instance instance, int nodeID, String nodeName, int iteration) throws DataSourceException {
        String eventID = this.createID(instance.getID(), nodeID, iteration, ExecutionEventConstants.ActivityEventType.STARTED);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ActivityEventType", (Object)ExecutionEventConstants.ActivityEventType.STARTED);
        eventAttributes.put("NodeID", nodeID);
        eventAttributes.put("NodeIteration", iteration);
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    @Override
    public void logNodeDeselected(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
        String eventID = this.createID(instance.getID(), nodeID, iteration, ExecutionEventConstants.ActivityEventType.DESELECTED);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ActivityEventType", (Object)ExecutionEventConstants.ActivityEventType.DESELECTED);
        eventAttributes.put("NodeID", nodeID);
        eventAttributes.put("NodeIteration", iteration);
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    @Override
    public void logNodeSelected(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
        String eventID = this.createID(instance.getID(), nodeID, iteration, ExecutionEventConstants.ActivityEventType.SELECTED);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ActivityEventType", (Object)ExecutionEventConstants.ActivityEventType.SELECTED);
        eventAttributes.put("NodeID", nodeID);
        eventAttributes.put("NodeIteration", iteration);
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    @Override
    public void logNodeSkipped(SessionToken session, long timestamp, Instance instance, int nodeID, int iteration) throws DataSourceException {
        String eventID = this.createID(instance.getID(), nodeID, iteration, ExecutionEventConstants.ActivityEventType.SKIPPED);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ActivityEventType", (Object)ExecutionEventConstants.ActivityEventType.SKIPPED);
        eventAttributes.put("NodeID", nodeID);
        eventAttributes.put("NodeIteration", iteration);
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }

    @Override
    public void logNodeSuspended(SessionToken session, long timestamp, Long clientDelay, Instance instance, int nodeID, int iteration) throws DataSourceException {
        String eventID = this.createID(instance.getID(), nodeID, iteration, ExecutionEventConstants.ActivityEventType.SUSPENDED);
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("InstanceID", instance.getID());
        eventAttributes.put("TemplateID", instance.getBaseTemplateID());
        eventAttributes.put("ActivityEventType", (Object)ExecutionEventConstants.ActivityEventType.SUSPENDED);
        eventAttributes.put("NodeID", nodeID);
        eventAttributes.put("NodeIteration", iteration);
        EventReference event = this.eventSource.createEvent("de.aristaflow.adept2.core.executionmanager.InstanceEvent.Activity", eventID, timestamp, eventAttributes);
        this.eventSource.publishEvent(event);
    }
}

