/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.logmanager.eventimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.complexeventmanager.EventManager;
import de.aristaflow.adept2.core.logmanager.eventimplementation.NullEventExecutionHistory;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.logmanager.nullimplementation.NullLogManager;
import java.net.URI;
import org.apache.commons.configuration.Configuration;

public class NullEventLogManager
extends NullLogManager {
    private ExecutionHistory executionHistory;

    public NullEventLogManager(Configuration configuration, Registry registry) {
        super(configuration, registry);
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs, -2, -2, "password");
        SessionToken sessionToken = this.getSessionFactory() != null ? this.getSessionFactory().getSessionToken(this.getURIs()) : null;
        try {
            EventManager eventManager = this.registry.getServiceOfType(sessionToken, "ComplexEventManager", EventManager.class);
            this.executionHistory = new NullEventExecutionHistory(eventManager);
        }
        catch (ServiceNotKnownException e) {
            this.logger.warning("No Event Manager configured! Switching to Null Execution History");
            throw e;
        }
    }

    @Override
    public ExecutionHistory getExecutionHistory() {
        return this.executionHistory;
    }
}

