/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.logmanager.logs;

import de.aristaflow.adept2.base.communication.annotations.ProxyAllow;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.logmanager.Log;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistoryWriteAccess;
import de.aristaflow.adept2.model.logmanagement.Column;
import de.aristaflow.adept2.model.logmanagement.DataType;
import de.aristaflow.adept2.model.logmanagement.LogEntry;
import de.aristaflow.adept2.model.logmanagement.LogEntrySet;
import de.aristaflow.adept2.model.logmanagement.Schema;
import de.aristaflow.adept2.util.DataSourceException;
import java.util.UUID;

@ProxyAllow
public interface ExecutionHistory
extends Log {
    public static final String NAME = "ExecutionHistory";
    public static final Schema SCHEMA = new Schema(new Column("timestamp", DataType.TIMESTAMP), new Column("instanceLogID", DataType.UUID), new Column("nodeID", DataType.INTEGER), new Column("iteration", DataType.INTEGER), new Column("stateChange", DataType.BYTE), new Column("agentID", DataType.LONG), new Column("agentOrgPositionID", DataType.LONG), new Column("clientTimestamp", DataType.LONG), new Column("nodeName", 254), new Column("instanceName", 254), new Column("templateName", 254), new Column("supportsViewOnly", DataType.BOOLEAN), new Column("executionManagerURIs", 4000), new Column("error", new Schema(new Column("code", DataType.LONG), new Column("state", 4000), new Column("message", 10000))));

    public LogEntrySet readInstanceHistory(SessionToken var1, UUID var2) throws DataSourceException;

    public LogEntrySet readInstanceHistory(SessionToken var1, UUID var2, int var3, int var4) throws DataSourceException;

    public long countInstanceHistoryEntries(SessionToken var1, UUID var2) throws DataSourceException;

    public LogEntrySet readPreviousSteps(SessionToken var1, UUID var2, int var3, int var4) throws DataSourceException;

    public LogEntrySet readCompletedSteps(SessionToken var1, long var2, long var4, long var6, long ... var8) throws DataSourceException;

    public LogEntry readInstanceErrorInformation(SessionToken var1, UUID var2) throws DataSourceException;

    public LogEntry readNodeErrorInformation(SessionToken var1, long var2) throws DataSourceException;

    public ExecutionHistoryWriteAccess getWriteAccess();

    public static final class ColumnName {
        public static final String TIMESTAMP = "timestamp";
        public static final String INSTANCE_LOG_ID = "instanceLogID";
        public static final String NODE_ID = "nodeID";
        public static final String ITERATION = "iteration";
        public static final String STATE_CHANGE = "stateChange";
        public static final String AGENT_ID = "agentID";
        public static final String AGENT_ORGPOSITION_ID = "agentOrgPositionID";
        public static final String CLIENT_DELAY = "clientTimestamp";
        public static final String NODE_NAME = "nodeName";
        public static final String INSTANCE_NAME = "instanceName";
        public static final String TEMPLATE_NAME = "templateName";
        public static final String SUPPORTS_VIEW_ONLY = "supportsViewOnly";
        public static final String EXECUTION_MANAGER_URIS = "executionManagerURIs";
        public static final String ERROR = "error";
        public static final String ERROR_CODE = "code";
        public static final String ERROR_STATE = "state";
        public static final String ERROR_MESSAGE = "message";

        private ColumnName() {
        }
    }

    public static enum StateChange {
        INSTANCE_STARTED(1),
        INSTANCE_SUSPENDED(2),
        INSTANCE_RESUMED(3),
        INSTANCE_FINISHED(4),
        INSTANCE_FAILED(5),
        INSTANCE_CHANGED(6),
        NODE_ACTIVATED(11),
        NODE_SELECTED(12),
        NODE_DESELECTED(13),
        NODE_STARTED(14),
        NODE_SUSPENDED(15),
        NODE_RESUMED(16),
        NODE_RESET_HARD(20),
        NODE_RESET_SOFT(21),
        NODE_SKIPPED(17),
        NODE_FINISHED(18),
        NODE_FAILED(19);

        private final byte code;

        private StateChange(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static StateChange valueOf(String string) {
            return Enum.valueOf(StateChange.class, string);
        }
    }
}

