/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager;

import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AttributeMetaData
implements Iterable<MetaDataElement>,
Serializable {
    private static final long serialVersionUID = -3668707840061420377L;
    MetaDataElement[] metaDataElements;
    private Map<String, MetaDataElement> metaMap;

    public AttributeMetaData(MetaDataElement[] metaDataElements) {
        ArgChecks.checkForNulls(metaDataElements, "metaDataElements");
        this.metaDataElements = (MetaDataElement[])metaDataElements.clone();
        this.metaMap = new HashMap<String, MetaDataElement>();
        MetaDataElement[] metaDataElementArray = metaDataElements;
        int n = metaDataElements.length;
        int n2 = 0;
        while (n2 < n) {
            MetaDataElement element = metaDataElementArray[n2];
            this.metaMap.put(element.name.toLowerCase(), element);
            ++n2;
        }
    }

    public String[] getNames() {
        String[] names = new String[this.getCount()];
        int i = 0;
        int count = this.getCount();
        while (i < count) {
            names[i] = this.get((int)i).name;
            ++i;
        }
        return names;
    }

    public int getCount() {
        return this.metaDataElements.length;
    }

    public MetaDataElement get(int index) {
        return this.metaDataElements[index];
    }

    public MetaDataElement get(String attrName) {
        return this.metaMap.get(attrName.toLowerCase());
    }

    public MetaDataElement[] toArray() {
        return (MetaDataElement[])this.metaDataElements.clone();
    }

    @Override
    public Iterator<MetaDataElement> iterator() {
        return new AttributeMetaDataIterator();
    }

    private class AttributeMetaDataIterator
    implements Iterator<MetaDataElement> {
        private int nextIndex;

        AttributeMetaDataIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < AttributeMetaData.this.metaDataElements.length;
        }

        @Override
        public MetaDataElement next() {
            MetaDataElement element = AttributeMetaData.this.metaDataElements[this.nextIndex];
            ++this.nextIndex;
            return element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MetaDataElement
    implements Serializable {
        private static final long serialVersionUID = -868315028627518820L;
        private EntityType entityType;
        String name;
        private DataType dataType;
        private int sizeHint;
        private String mappedTo;
        private boolean imported;
        private boolean isMandatory;
        private boolean isReadOnly;

        public MetaDataElement(EntityType entityType, String name, DataType dataType, int sizeHint, String mappedTo, boolean imported, boolean isReadOnly) {
            ArgChecks.checkForNull((Object)entityType, "entityType");
            ArgChecks.checkForNull(name, "name");
            ArgChecks.checkForNull((Object)dataType, "dataType");
            this.entityType = entityType;
            this.name = name;
            this.dataType = dataType;
            this.sizeHint = sizeHint;
            this.isMandatory = entityType.hasMandatoryAttribute(name);
            this.isReadOnly = entityType.hasReadOnlyAttribute(name);
            if (mappedTo != null) {
                ArgChecks.checkForBlank(mappedTo, "mappedTo");
            }
            this.mappedTo = mappedTo;
            boolean bl = this.imported = mappedTo == null ? false : imported;
            if (!this.isReadOnly && isReadOnly) {
                this.isReadOnly = true;
            }
        }

        public EntityType getEntityType() {
            return this.entityType;
        }

        public String getName() {
            return this.name;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public int getSizeHint() {
            return this.sizeHint;
        }

        public String getMappedTo() {
            return this.mappedTo;
        }

        public boolean isImported() {
            return this.getMappedTo() != null;
        }

        public boolean isMandatory() {
            return this.isMandatory;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }
    }
}

