/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager;

import de.aristaflow.adept2.model.orgmodel.CmpOperator;
import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.List;

public class Filter {
    private List<Selection> selections = new ArrayList<Selection>();

    public int getSelectionCount() {
        return this.selections.size();
    }

    public Selection getSelectionAt(int index) {
        return this.selections.get(index);
    }

    public Selection[] getSelections() {
        return this.selections.toArray(new Selection[this.selections.size()]);
    }

    public void addSelection(String attrName, CmpOperator cmpOperator, Object value) {
        ArgChecks.checkForNull(attrName, "attrName");
        ArgChecks.checkForNull((Object)cmpOperator, "cmpOperator");
        if (DataType.getDataTypeForObject(value) == null) {
            throw new IllegalArgumentException("Object type of parameter 'value' could not be mapped to one of the defined DataTypes!");
        }
        this.selections.add(new Selection(attrName, cmpOperator, value));
    }

    public void clear() {
        this.selections.clear();
    }

    public static class Selection {
        private final String attrName;
        private final CmpOperator operator;
        private final Object value;

        Selection(String attrName, CmpOperator operator, Object value) {
            this.attrName = attrName;
            this.operator = operator;
            this.value = value;
        }

        public String getAttributeName() {
            return this.attrName;
        }

        public CmpOperator getOperator() {
            return this.operator;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

