/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.security.PasswordPolicyException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.ClientAdministration;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultOrgModelManager;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LocaleTools;
import java.util.Locale;

public class DefaultClientAdministration
implements ClientAdministration {
    private DefaultOrgModelManager orgModelManager;

    DefaultClientAdministration(DefaultOrgModelManager orgModelManager) {
        this.orgModelManager = orgModelManager;
    }

    @Override
    public void changePassword(SessionToken session, String oldPassword, String newPassword) throws AuthenticationException, PasswordPolicyException, DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(oldPassword, "oldPassword");
        ArgChecks.checkForNull(newPassword, "newPassword");
        if (newPassword.equals("")) {
            throw new PasswordPolicyException("The new password must not be the empty string!");
        }
        long agentID = this.orgModelManager.checkAndGetTopLevelAgent(session).getAgentID();
        this.orgModelManager.getSecurityManager().authenticate(agentID, oldPassword);
        if (newPassword.equals(oldPassword)) {
            return;
        }
        Entity agentUpdate = new Entity(EntityType.AGENT, agentID);
        agentUpdate.setString("password", newPassword);
        this.orgModelManager.getModelChangeOperations().updateEntity(session, agentUpdate);
    }

    @Override
    public String getMailAddress(SessionToken session) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        QualifiedAgent agent = this.orgModelManager.checkAndGetTopLevelAgent(session);
        return this.orgModelManager.getModelExplorer().getEntity(session, EntityType.AGENT, agent.getAgentID(), new String[0]).getString("email");
    }

    @Override
    public RichAgent changeMailAddress(SessionToken session, String mailAddress) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(session, "mailAddress");
        QualifiedAgent agent = this.orgModelManager.checkAndGetTopLevelAgent(session);
        Entity agentUpdate = new Entity(EntityType.AGENT);
        agentUpdate.setInteger("id", agent.getAgentID());
        agentUpdate.setString("email", mailAddress);
        this.orgModelManager.getModelChangeOperations().updateEntity(session, agentUpdate);
        return this.orgModelManager.getModelExplorer().getRichAgent(session, agent);
    }

    @Override
    public Locale getPreferredLocale(SessionToken session) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        QualifiedAgent agent = this.orgModelManager.checkAndGetTopLevelAgent(session);
        String localeString = this.orgModelManager.getModelExplorer().getEntity(session, EntityType.AGENT, agent.getAgentID(), new String[0]).getString("locale");
        if (localeString == null) {
            return null;
        }
        return LocaleTools.parseLocaleString(localeString);
    }

    @Override
    public void changePreferredLocale(SessionToken session, Locale locale) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        QualifiedAgent agent = this.orgModelManager.checkAndGetTopLevelAgent(session);
        Entity agentUpdate = new Entity(EntityType.AGENT);
        agentUpdate.setInteger("id", agent.getAgentID());
        agentUpdate.setString("locale", locale == null ? null : locale.toString());
        this.orgModelManager.getModelChangeOperations().updateEntity(session, agentUpdate);
    }
}

