/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.LdapRelationResolver;
import de.aristaflow.adept2.model.orgmodel.NavFunction;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.configuration.Configuration;

public class DefaultLdapRelationResolver
extends LdapRelationResolver {
    public static final String CFG_MEMBER_ATTRIBUTE_DN = "MemberAttributeDN";
    public static final String CFG_MEMBER_ATTRIBUTe_UID = "MemberAttributeUID";
    private String memberAttribute;
    private boolean memberAttributeIsUID;

    public DefaultLdapRelationResolver(Configuration configuration) throws ConfigurationException {
        if (configuration.getProperty(CFG_MEMBER_ATTRIBUTE_DN) != null && configuration.getProperty(CFG_MEMBER_ATTRIBUTe_UID) != null) {
            String msg = "Only one of '%1$s.%2$s' and '%1$s.%3$s' may be set!";
            msg = String.format(msg, "RelationResolver", CFG_MEMBER_ATTRIBUTE_DN, CFG_MEMBER_ATTRIBUTe_UID);
            throw new ConfigurationException(msg);
        }
        this.memberAttribute = configuration.getString(CFG_MEMBER_ATTRIBUTE_DN);
        if (configuration.getProperty(CFG_MEMBER_ATTRIBUTe_UID) != null) {
            this.memberAttribute = configuration.getString(CFG_MEMBER_ATTRIBUTe_UID);
            this.memberAttributeIsUID = true;
        }
    }

    @Override
    public boolean getAutoGenerateOrgPositions() {
        return true;
    }

    @Override
    public boolean canProvideRelatedEntities(NavFunction navFunction) {
        return navFunction.relationType() == RelationType.ORG_POSITION_AFFILIATION && navFunction.isLeftToRight();
    }

    @Override
    public List<String> getRelatedEntities(String sourceDN, NavFunction navFunction, DirContext ctx) throws NamingException {
        if (navFunction.relationType() == RelationType.ORG_POSITION_AFFILIATION && navFunction.isLeftToRight()) {
            List<String> result;
            Attribute memberAttribute;
            String memberAttributeName = this.memberAttribute;
            boolean isUID = this.memberAttributeIsUID;
            Attributes attrs = ctx.getAttributes(sourceDN);
            if (memberAttributeName == null) {
                Attribute objectClass = attrs.get("objectClass");
                if (objectClass.contains("groupofuniquenames")) {
                    memberAttributeName = "uniqueMember";
                    isUID = false;
                } else if (objectClass.contains("groupofnames")) {
                    memberAttributeName = "member";
                    isUID = true;
                }
            }
            if ((memberAttribute = attrs.get(memberAttributeName)) != null) {
                result = new ArrayList<String>(memberAttribute.size());
                int i = 0;
                while (i < memberAttribute.size()) {
                    String member = memberAttribute.get(i).toString();
                    if (isUID) {
                        member = this.resolveUID(member);
                    }
                    result.add(member);
                    ++i;
                }
            } else {
                result = Collections.emptyList();
            }
            return result;
        }
        return null;
    }
}

