/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.ParentToChildConnection;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.ModelChangeOperations;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelException;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultModelExplorer;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultOrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.OmmDefImplTools;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.SQLTableNames;
import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.OrgModelTools;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public class DefaultModelChangeOperations
implements ModelChangeOperations {
    protected Logger logger = LoggerTools.getLogger(this);
    private int maxRecursionDepth;
    private DefaultOrgModelManager orgModelManager;

    DefaultModelChangeOperations(DefaultOrgModelManager orgModelManager, Configuration configuration) {
        this.orgModelManager = orgModelManager;
        this.maxRecursionDepth = configuration.getInt("MaxRecursionDepth");
    }

    @Override
    public void addAttribute(SessionToken session, EntityType entType, String attrName, DataType dataType) throws OrgModelException, DataSourceException {
        this.addAttribute(session, entType, attrName, dataType, -1);
    }

    @Override
    public void addAttribute(SessionToken session, EntityType entType, String attrName, DataType dataType, String mappedTo, boolean isImported, boolean isReadOnly) throws OrgModelException, DataSourceException {
        this.addAttribute(session, entType, attrName, dataType, -1, mappedTo, isImported, isReadOnly);
    }

    @Override
    public void addAttribute(SessionToken session, EntityType entType, String attrName, DataType dataType, int sizeHint) throws OrgModelException, DataSourceException {
        this.addAttribute(session, entType, attrName, dataType, sizeHint, null, false, false);
    }

    @Override
    public void addAttribute(SessionToken session, EntityType entType, String attrName, DataType dataType, int sizeHint, String mappedTo, boolean isImported, boolean isReadOnly) throws OrgModelException, DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull((Object)entType, "entType");
        ArgChecks.checkForNull(attrName, "attrName");
        ArgChecks.checkForNull((Object)dataType, "dataType");
        ArgChecks.check(dataType == DataType.STRING && sizeHint < 1, "sizeHint", "When the data type is STRING the sizeHint must be set (to a positive value)!");
        ArgChecks.check(dataType != DataType.STRING && sizeHint > 0, "sizeHint", "The data type " + (Object)((Object)dataType) + " does not support a sizeHint!");
        this.orgModelManager.sessionActive(session);
        try {
            if (dataType == DataType.NULL) {
                String msg = "The DataType NULL can't be used as data type for an attribute!";
                throw new IllegalArgumentException(msg);
            }
            if (mappedTo != null && dataType != DataType.INTEGER && dataType != DataType.STRING) {
                String msg = "LDAP mapping is only supported for the data types INTEGER and STRING!";
                throw new IllegalArgumentException(msg);
            }
            this.ensureAttributeNameIsValid(attrName);
            if (this.exp().hasAttribute(session, entType, attrName)) {
                String msg = "Entity type " + (Object)((Object)entType) + " already has an attribute '" + attrName + "'!";
                throw new OrgModelException(msg);
            }
            ExtendedConnection con = null;
            Statement stmt = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    con.setAutoCommit(false);
                    stmt = con.createStatement();
                    String entityTypeTableName = SQLTableNames.getTableNameFor(entType);
                    String query = String.format("ALTER TABLE %s ADD %s %s", entityTypeTableName, attrName, OmmDefImplTools.dataTypeToSqlType(dataType, sizeHint, con));
                    stmt.executeUpdate(query);
                    stmt = JDBCTools.close(stmt);
                    String update = "INSERT INTO %sMeta (attrName, dataType, sizeHint, mappedTo, imported, readOnly) VALUES (?, ?, ?, ?, ?, ?)";
                    update = String.format(update, entType.policyToken());
                    pstmt = con.prepareStatement(update);
                    pstmt.setString(1, attrName);
                    pstmt.setString(2, dataType.toString());
                    if (sizeHint > 0) {
                        pstmt.setInt(3, sizeHint);
                    } else {
                        pstmt.setNull(3, 4);
                    }
                    pstmt.setString(4, mappedTo);
                    pstmt.setBoolean(5, mappedTo == null ? false : isImported);
                    pstmt.setBoolean(6, mappedTo == null ? false : isReadOnly);
                    pstmt.executeUpdate();
                    pstmt = JDBCTools.close(pstmt);
                    con = JDBCTools.close(con);
                    this.exp().invalidateCachedEntityAttributes(entType);
                }
                catch (SQLException e) {
                    throw new DataSourceException(e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt);
                JDBCTools.closeQuietly(con, stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly((Statement)pstmt);
            JDBCTools.closeQuietly(con, stmt);
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public void modifyAttribute(SessionToken session, EntityType entType, String attrName, String mappedTo, boolean isImported, boolean isReadOnly) throws OrgModelException, DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull((Object)entType, "entType");
        ArgChecks.checkForNull(attrName, "attrName");
        this.orgModelManager.sessionActive(session);
        try {
            this.ensureAttributeNameIsValid(attrName);
            if (entType.hasReadOnlyAttribute(attrName)) {
                String msg = "The attribute '%s' of entity type %s cannot be mapped!";
                msg = String.format(msg, new Object[]{attrName, entType});
                throw new OrgModelException(msg);
            }
            if (!this.exp().hasAttribute(session, entType, attrName)) {
                String msg = "Entity type " + (Object)((Object)entType) + " doesn't have an attribute '" + attrName + "'!";
                throw new OrgModelException(msg);
            }
            ExtendedConnection con = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    String update = "UPDATE %sMeta SET mappedTo = ?, imported = ?, readOnly = ? WHERE attrName = ?";
                    update = String.format(update, entType.policyToken());
                    pstmt = con.prepareStatement(update);
                    pstmt.setString(1, mappedTo);
                    pstmt.setBoolean(2, mappedTo == null ? false : isImported);
                    pstmt.setBoolean(3, mappedTo == null ? false : isReadOnly);
                    pstmt.setString(4, attrName);
                    pstmt.executeUpdate();
                    pstmt = JDBCTools.close(pstmt);
                    this.exp().invalidateCachedEntityAttributes(entType);
                }
                catch (SQLException ex) {
                    throw new DataSourceException(ex);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, pstmt);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)pstmt);
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public void deleteAttribute(SessionToken session, EntityType entType, String attrName) throws OrgModelException, DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull((Object)entType, "entType");
        ArgChecks.checkForNull(attrName, "attrName");
        this.orgModelManager.sessionActive(session);
        try {
            this.ensureAttributeNameIsValid(attrName);
            if (entType.hasMandatoryAttribute(attrName)) {
                String msg = "The attribute " + attrName + " is mandatory in " + (Object)((Object)entType) + " and can't be deleted!";
                throw new OrgModelException(msg);
            }
            if (!this.exp().hasAttribute(session, entType, attrName)) {
                String msg = "Entity type " + (Object)((Object)entType) + " doesn't have an attribute '" + attrName + "'!";
                throw new OrgModelException(msg);
            }
            ExtendedConnection con = null;
            Statement stmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    con.setAutoCommit(false);
                    String entityTypeTableName = SQLTableNames.getTableNameFor(entType);
                    con.dropColumn(entityTypeTableName, attrName);
                    String query = String.format("DELETE FROM %sMeta WHERE attrName = '%s'", entityTypeTableName, attrName);
                    stmt = con.createStatement();
                    stmt.executeUpdate(query);
                    this.exp().invalidateCachedEntityAttributes(entType);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException ex) {
                    throw new DataSourceException(ex);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(stmt);
                JDBCTools.closeQuietly(con);
                throw throwable;
            }
            JDBCTools.closeQuietly(stmt);
            JDBCTools.closeQuietly(con);
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public long createAgent(SessionToken session, String agentUserName, String password) throws OrgModelException, DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(agentUserName, "agentUserName");
        ArgChecks.checkForEmpty(password, "password");
        this.orgModelManager.sessionActive(session);
        try {
            Entity agent = new Entity(EntityType.AGENT);
            agent.setString("userName", agentUserName);
            agent.setString("password", password);
            long l = this.createEntity(session, agent);
            return l;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public long createEntity(SessionToken session, EntityType entType) throws DataSourceException {
        ArgChecks.checkForNull((Object)entType, "entType");
        this.omm().sessionActive(session);
        try {
            Entity entity = new Entity(entType);
            if (entType == EntityType.AGENT) {
                entity.setString("userName", Double.toString(Math.random() * 1.0E7));
                entity.setString("password", Double.toString(Math.random() * 1.0E7));
            }
            long l = this.createOrUpdateEntity(session, entity, true, false);
            return l;
        }
        finally {
            this.omm().sessionFinished(session);
        }
    }

    @Override
    public long createEntity(SessionToken session, Entity entity) throws OrgModelException, DataSourceException {
        ArgChecks.checkForNull(entity, "entity");
        if (entity.containsAttribute("id") && !entity.isNull("id")) {
            String msg = "The entity ID cannot be explicitly set.";
            throw new IllegalArgumentException(msg);
        }
        this.omm().sessionActive(session);
        try {
            long l = this.createOrUpdateEntity(session, entity, true, false);
            return l;
        }
        finally {
            this.omm().sessionFinished(session);
        }
    }

    void createSystemEntity(SessionToken session, Entity entity) throws OrgModelException, DataSourceException {
        this.omm().sessionActive(session);
        try {
            if (!entity.containsAttribute("id") || entity.isNull("id") || entity.getInteger("id") >= 20L) {
                String msg = "ID for system entity is missing or not negative.";
                throw new IllegalArgumentException(msg);
            }
            this.createOrUpdateEntity(session, entity, true, false);
        }
        finally {
            this.omm().sessionFinished(session);
        }
    }

    @Override
    public void updateEntity(SessionToken session, Entity entity) throws OrgModelException, DataSourceException {
        if (!entity.containsAttribute("id") || entity.isNull("id")) {
            String msg = "The attribute 'id' must be provided in the given entity!";
            throw new IllegalArgumentException(msg);
        }
        this.omm().sessionActive(session);
        try {
            this.createOrUpdateEntity(session, entity, false, false);
        }
        finally {
            this.omm().sessionFinished(session);
        }
    }

    /*
     * Exception decompiling
     */
    long createOrUpdateEntity(SessionToken session, Entity entity, boolean create, boolean ldapSync) throws OrgModelException, DataSourceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void deleteEntity(SessionToken session, EntityType entType, long id) throws OrgModelException, DataSourceException {
        this.deleteEntity(session, entType, id, false);
    }

    @Override
    public void deleteEntity(SessionToken session, EntityType entType, long id, boolean recursive) throws OrgModelException, DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull((Object)entType, "entType");
        this.orgModelManager.sessionActive(session);
        try {
            this.ensureEntityExists(session, entType, id);
            ExtendedConnection con = null;
            Statement stmt = null;
            try {
                try {
                    List<Entity> rules;
                    con = this.getDataSource().getConnection();
                    stmt = con.createStatement();
                    String entityTypeTableName = SQLTableNames.getTableNameFor(entType);
                    if (entType == EntityType.ORG_UNIT || entType == EntityType.PROJECT_GROUP || entType == EntityType.ROLE) {
                        RelationType relType;
                        if (recursive) {
                            if (entType == EntityType.ORG_UNIT) {
                                List<Entity> orgPositions = this.exp().getRelatedEntities(session, EntityType.ORG_UNIT, id, RelationType.ORG_POSITION_AFFILIATION, true, new String[0]);
                                for (Entity orgPos : orgPositions) {
                                    this.deleteEntity(session, EntityType.ORG_POSITION, orgPos.getInteger("id"));
                                }
                            }
                            switch (entType) {
                                case ORG_UNIT: {
                                    relType = RelationType.ORG_UNIT_SUBORDINATION;
                                    break;
                                }
                                case PROJECT_GROUP: {
                                    relType = RelationType.PROJECT_GROUP_SUBORDINATION;
                                    break;
                                }
                                case ROLE: {
                                    relType = RelationType.ROLE_SPECIALISATION;
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)("entity type not allowed/supported here: " + (Object)((Object)entType)));
                                }
                            }
                            List<Entity> subEntities = this.exp().getRelatedEntities(session, entType, id, relType, true, new String[0]);
                            for (Entity sub : subEntities) {
                                this.deleteEntity(session, entType, sub.getInteger("id"), true);
                            }
                        } else {
                            relType = null;
                            switch (entType) {
                                case ORG_UNIT: {
                                    relType = RelationType.ORG_UNIT_SUBORDINATION;
                                    break;
                                }
                                case PROJECT_GROUP: {
                                    relType = RelationType.PROJECT_GROUP_SUBORDINATION;
                                    break;
                                }
                                case ROLE: {
                                    relType = RelationType.ROLE_SPECIALISATION;
                                    break;
                                }
                                default: {
                                    String msg = String.format("Nonrelevant entity type '%s' found!", new Object[]{entType});
                                    this.logger.finest(msg);
                                }
                            }
                            List<Entity> subEntities = this.exp().getRelatedEntities(session, entType, id, relType, true, new String[0]);
                            for (Entity sub : subEntities) {
                                this.deleteRelation(session, relType, id, sub.getInteger("id"));
                            }
                        }
                    } else if (entType == EntityType.ORG_POSITION) {
                        rules = this.exp().getRelatedEntities(session, EntityType.ORG_POSITION, id, RelationType.ORG_POSITION_SUBSTITUTION, true, new String[0]);
                        for (Entity rule : rules) {
                            this.deleteRelation(session, RelationType.ORG_POSITION_SUBSTITUTION, id, rule.getInteger("id"));
                        }
                        rules = this.exp().getRelatedEntities(session, EntityType.ORG_POSITION, id, RelationType.ORG_POSITION_SUBSTITUTE, true, new String[0]);
                        for (Entity rule : rules) {
                            this.deleteRelation(session, RelationType.ORG_POSITION_SUBSTITUTE, id, rule.getInteger("id"));
                        }
                    } else if (entType == EntityType.ROLE) {
                        rules = this.exp().getRelatedEntities(session, EntityType.ROLE, id, RelationType.ROLE_SUBSTITUTION, true, new String[0]);
                        for (Entity rule : rules) {
                            this.deleteRelation(session, RelationType.ROLE_SUBSTITUTION, id, rule.getInteger("id"));
                        }
                    }
                    String query = String.format("DELETE FROM %s WHERE id = %d", entityTypeTableName, id);
                    stmt.executeUpdate(query);
                    this.omm().getPolicyResolution().invalidateRecTablesFor(entType);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new DataSourceException(e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, stmt);
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public void addRelation(SessionToken session, RelationType relType, long id1, long id2) throws OrgModelException, DataSourceException {
        this.orgModelManager.sessionActive(session);
        try {
            if (relType == null) {
                throw new NullArgumentException("The parameter 'relType' must not be null!");
            }
            this.ensureEntityExists(session, relType.leftHandEntityType(), id1);
            this.ensureEntityExists(session, relType.rightHandEntityType(), id2);
            ExtendedConnection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            String recTableName = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    stmt = con.createStatement();
                    this.checkRelation(session, relType, id1, id2, false);
                    if (relType == RelationType.ORG_POSITION_SUBSTITUTION && this.exp().relationExists(session, RelationType.ORG_POSITION_SUBSTITUTE, id1, id2) || relType == RelationType.ORG_POSITION_SUBSTITUTE && this.exp().relationExists(session, RelationType.ORG_POSITION_SUBSTITUTION, id1, id2)) {
                        throw new OrgModelException(String.format("An OrgPosition (id = %s) can't substitute itself!", id1));
                    }
                    if (relType.isNMRelation()) {
                        String column1 = OmmDefImplTools.getColumnNameInNMRelation(relType.leftHandEntityType());
                        String column2 = OmmDefImplTools.getColumnNameInNMRelation(relType.rightHandEntityType());
                        String relationTypeTableName = SQLTableNames.getTableNameFor(relType);
                        String query = String.format("INSERT INTO %s (%s, %s) VALUES( %d, %d )", relationTypeTableName, column1, column2, id1, id2);
                        stmt.executeUpdate(query);
                    } else {
                        if (relType.isRecursive()) {
                            String[] attributes = this.exp().getAttributeNames(session, relType.leftHandEntityType());
                            String startCondition = "id = " + id2;
                            ParentToChildConnection[] cons = new ParentToChildConnection[]{new ParentToChildConnection("id", "=", relType.oneToMReferenceAttribute())};
                            recTableName = con.createRecursionTable(attributes, relType.leftHandEntityType().policyToken(), startCondition, cons, this.maxRecursionDepth);
                            String query = String.format("SELECT id FROM %s WHERE id = %d", recTableName, id1);
                            rs = stmt.executeQuery(query);
                            boolean cycleDetected = rs.next();
                            rs.close();
                            con.dropRecursionTable(recTableName);
                            if (cycleDetected) {
                                throw new OrgModelException(String.format("Adding the relation %s(id = %d) -> %s(id = %d) of type %s would create a cycle!", new Object[]{relType.leftHandEntityType(), id1, relType.rightHandEntityType(), id2, relType}));
                            }
                        }
                        String rightHandEntityTypeTableName = SQLTableNames.getTableNameFor(relType.rightHandEntityType());
                        String query = String.format("SELECT id FROM %s WHERE id = %d AND %s IS NOT NULL", rightHandEntityTypeTableName, id2, relType.oneToMReferenceAttribute());
                        rs = stmt.executeQuery(query);
                        boolean inRelation = rs.next();
                        rs.close();
                        if (inRelation) {
                            throw new OrgModelException(String.format("The entity %s(id = %d) is already in a relation of the type %s and can only be in one!", new Object[]{relType.rightHandEntityType(), id2, relType}));
                        }
                        query = String.format("UPDATE %s SET %s = %d WHERE id = %d", rightHandEntityTypeTableName, relType.oneToMReferenceAttribute(), id1, id2);
                        stmt.executeUpdate(query);
                    }
                    this.omm().getPolicyResolution().invalidateRecTables(relType);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new DataSourceException(e);
                }
            }
            catch (Throwable throwable) {
                if (con != null) {
                    try {
                        con.dropRecursionTable(recTableName);
                    }
                    catch (SQLException ex) {
                        String msg = String.format("A SQLException occurred while trying to drop the recursion table %s", recTableName);
                        this.logger.log(Level.INFO, msg, ex);
                    }
                }
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
            if (con != null) {
                try {
                    con.dropRecursionTable(recTableName);
                }
                catch (SQLException ex) {
                    String msg = String.format("A SQLException occurred while trying to drop the recursion table %s", recTableName);
                    this.logger.log(Level.INFO, msg, ex);
                }
            }
            JDBCTools.closeQuietly(con, stmt, rs);
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public void deleteRelation(SessionToken session, RelationType relType, long id1, long id2) throws OrgModelException, DataSourceException {
        this.orgModelManager.sessionActive(session);
        try {
            if (relType == null) {
                throw new NullArgumentException("The parameter 'relType' must not be null!");
            }
            this.ensureEntityExists(session, relType.leftHandEntityType(), id1);
            this.ensureEntityExists(session, relType.rightHandEntityType(), id2);
            ExtendedConnection con = null;
            Statement stmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    stmt = con.createStatement();
                    this.checkRelation(session, relType, id1, id2, true);
                    if (relType.isNMRelation()) {
                        String column1 = OmmDefImplTools.getColumnNameInNMRelation(relType.leftHandEntityType());
                        String column2 = OmmDefImplTools.getColumnNameInNMRelation(relType.rightHandEntityType());
                        String relationTypeTableName = SQLTableNames.getTableNameFor(relType);
                        String query = String.format("DELETE FROM %s WHERE %s = %d AND %s = %d", relationTypeTableName, column1, id1, column2, id2);
                        stmt.executeUpdate(query);
                    } else {
                        String rightHandEntityTypeTableName = SQLTableNames.getTableNameFor(relType.rightHandEntityType());
                        String query = String.format("UPDATE %s SET %s = null WHERE id = %d", rightHandEntityTypeTableName, relType.oneToMReferenceAttribute(), id2);
                        stmt.executeUpdate(query);
                    }
                    this.omm().getPolicyResolution().invalidateRecTables(relType);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new DataSourceException(e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, stmt);
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    private void ensureEntityExists(SessionToken session, EntityType entType, long id) throws OrgModelException, DataSourceException {
        if (!this.exp().entityExists(session, entType, id)) {
            throw new OrgModelException(String.format("The entity %s(id = %d) does not exist!", new Object[]{entType, id}));
        }
    }

    private void ensureAttributeNameIsValid(String attrName) throws IllegalArgumentException {
        if (!OrgModelTools.isValidAttributeName(attrName)) {
            String msg = "The parameter 'attrName' = " + attrName + " is not a valid attribute name!";
            throw new IllegalArgumentException(msg);
        }
    }

    private void checkRelation(SessionToken session, RelationType relType, long id1, long id2, boolean mustExist) throws OrgModelException, DataSourceException {
        boolean exists = this.exp().relationExists(session, relType, id1, id2);
        if (mustExist) {
            if (!exists) {
                String msg = "The relation %s(id = %d) -> %s(id = %d) of type %s does not exist!";
                msg = String.format(msg, new Object[]{relType.leftHandEntityType(), id1, relType.rightHandEntityType(), id2, relType});
                throw new OrgModelException(msg);
            }
        } else if (exists) {
            String msg = "The relation %s(id = %d) -> %s(id = %d) of type %s already exists!";
            msg = String.format(msg, new Object[]{relType.leftHandEntityType(), id1, relType.rightHandEntityType(), id2, relType});
            throw new OrgModelException(msg);
        }
    }

    private DefaultOrgModelManager omm() {
        return this.orgModelManager;
    }

    private JDBCDataSource getDataSource() {
        return this.orgModelManager.getDataSource();
    }

    private DefaultModelExplorer exp() {
        return this.orgModelManager.getModelExplorer();
    }
}

