/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.AttributeMetaData;
import de.aristaflow.adept2.core.orgmodelmanager.Filter;
import de.aristaflow.adept2.core.orgmodelmanager.ModelExplorer;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelException;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultOrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.LdapAdapter;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.OmmDefImplTools;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.SQLTableNames;
import de.aristaflow.adept2.model.orgmodel.CmpOperator;
import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.NavFunction;
import de.aristaflow.adept2.model.orgmodel.OrgModelTools;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.apache.commons.configuration.Configuration;

public class DefaultModelExplorer
implements ModelExplorer {
    protected final Logger logger;
    private DefaultOrgModelManager orgModelManager;
    private Map<EntityType, AttributeMetaData> attributeCache = new HashMap<EntityType, AttributeMetaData>();
    private boolean isCaching;
    boolean testing = false;

    DefaultModelExplorer(DefaultOrgModelManager orgModelManager, Configuration configuration) {
        this.logger = LoggerTools.getLogger(this);
        this.orgModelManager = orgModelManager;
        this.isCaching = configuration.getBoolean("Caching");
    }

    private boolean isCaching() {
        return this.isCaching && !this.testing;
    }

    @Override
    public RichAgent getRichAgent(SessionToken session, QualifiedAgent agent) throws DataSourceException {
        Entity agentEntity = this.getEntity(session, EntityType.AGENT, agent.getAgentID(), new String[0]);
        String localeString = agentEntity.getString("locale");
        String mailAddress = agentEntity.getString("email");
        if (mailAddress == null) {
            mailAddress = "";
        }
        String name = agentEntity.containsAttribute("readableName") ? agentEntity.getString("readableName") : (agentEntity.containsAttribute("firstName") && agentEntity.containsAttribute("lastName") ? String.valueOf(agentEntity.getString("firstName")) + " " + agentEntity.getString("lastName") : String.format("%s (%s)", agent.getAgentUserName(), agent.getOrgPositionName()));
        String[] mandAttrs = EntityType.AGENT.getMandatoryAttributes();
        HashMap<String, String> add = new HashMap<String, String>();
        String[] stringArray = agentEntity.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attrName = stringArray[n2];
            if (!agentEntity.isNull(attrName) && !this.isMandatoryAttr(attrName, mandAttrs)) {
                String valueString;
                AttributeMetaData metaData = this.getAttributeMetaData(session, agentEntity.getType());
                Object value = agentEntity.get(attrName);
                switch (metaData.get(attrName).getDataType()) {
                    case DATE: 
                    case TIME: 
                    case TIMESTAMP: {
                        valueString = OrgModelTools.toPolicyToken(value);
                        break;
                    }
                    default: {
                        valueString = value.toString();
                    }
                }
                add.put(attrName, valueString);
            }
            ++n2;
        }
        return new RichAgent(agent, name, mailAddress, localeString, add);
    }

    @Override
    public Map<QualifiedAgent, RichAgent> getRichAgent(SessionToken session, Collection<QualifiedAgent> agents) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(agents, "agents");
        HashMap<QualifiedAgent, RichAgent> ret = new HashMap<QualifiedAgent, RichAgent>(agents.size());
        for (QualifiedAgent agent : agents) {
            try {
                ret.put(agent, this.getRichAgent(session, agent));
            }
            catch (OrgModelException ome) {
                String msg = "Cannot retrieve RichAgent for QualifiedAgent '%s'. Ignoring.";
                this.logger.log(Level.FINE, String.format(msg, agent), ome);
            }
        }
        return ret;
    }

    protected boolean isMandatoryAttr(String attrName, String[] mandAttrs) {
        boolean ret = false;
        String[] stringArray = mandAttrs;
        int n = mandAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            String mandAttr = stringArray[n2];
            ret = ret || attrName.equalsIgnoreCase(mandAttr);
            ++n2;
        }
        return ret;
    }

    @Override
    public String[] getAttributeNames(SessionToken session, EntityType entType) throws DataSourceException {
        this.orgModelManager.sessionActive(session);
        try {
            if (entType == null) {
                throw new NullArgumentException("The parameter 'entType' must not be null!");
            }
            ArrayList<String> attrNames = new ArrayList<String>();
            for (AttributeMetaData.MetaDataElement attrMeta : this.getAttributeMetaData(session, entType)) {
                attrNames.add(attrMeta.getName());
            }
            String[] stringArray = attrNames.toArray(new String[attrNames.size()]);
            return stringArray;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public boolean hasAttribute(SessionToken session, EntityType entType, String attrName) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull((Object)entType, "entType");
        ArgChecks.checkForNull(attrName, "attrName");
        this.orgModelManager.sessionActive(session);
        try {
            for (AttributeMetaData.MetaDataElement attrMeta : this.getAttributeMetaData(session, entType)) {
                if (!attrMeta.getName().equalsIgnoreCase(attrName)) continue;
                return true;
            }
            return false;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public DataType getAttributeDataType(SessionToken session, EntityType entType, String attrName) throws OrgModelException, DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull((Object)entType, "entType");
        ArgChecks.checkForNull(attrName, "attrName");
        this.orgModelManager.sessionActive(session);
        try {
            for (AttributeMetaData.MetaDataElement attrMeta : this.getAttributeMetaData(session, entType)) {
                if (!attrMeta.getName().equalsIgnoreCase(attrName)) continue;
                DataType dataType = attrMeta.getDataType();
                return dataType;
            }
            throw new OrgModelException("entityType (" + (Object)((Object)entType) + ") doesn't have attribute " + attrName);
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeMetaData getAttributeMetaData(SessionToken session, EntityType entType) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull((Object)entType, "entType");
        this.orgModelManager.sessionActive(session);
        try {
            AttributeMetaData attributeMetaData;
            if (this.isCaching()) {
                Map<EntityType, AttributeMetaData> map = this.attributeCache;
                synchronized (map) {
                    attributeMetaData = this.attributeCache.get((Object)entType);
                    if (attributeMetaData == null) {
                        attributeMetaData = this.getAttributeMetaDataFromDB(session, entType);
                        this.attributeCache.put(entType, attributeMetaData);
                    }
                }
            } else {
                attributeMetaData = this.getAttributeMetaDataFromDB(session, entType);
            }
            AttributeMetaData attributeMetaData2 = attributeMetaData;
            return attributeMetaData2;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    AttributeMetaData getAttributeMetaDataFromDB(SessionToken session, EntityType entType) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull((Object)entType, "entType");
        this.orgModelManager.sessionActive(session);
        try {
            AttributeMetaData attributeMetaData;
            ExtendedConnection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                stmt = con.createStatement();
                String entityTypeTableName = SQLTableNames.getTableNameFor(entType);
                String query = String.format("SELECT * FROM %sMeta", entityTypeTableName);
                ArrayList<AttributeMetaData.MetaDataElement> cachedAttributesTempList = new ArrayList<AttributeMetaData.MetaDataElement>();
                rs = stmt.executeQuery(query);
                while (rs.next()) {
                    DataType attrDataType;
                    String attrName = rs.getString("attrName");
                    String attrDataTypeString = rs.getString("dataType");
                    int attrSizeHint = rs.getInt("sizeHint");
                    String attrMappedTo = rs.getString("mappedTo");
                    boolean attrImported = rs.getBoolean("imported");
                    boolean attrReadOnly = rs.getBoolean("readonly");
                    if (!attrReadOnly) {
                        attrReadOnly = entType.hasReadOnlyAttribute(attrName);
                    }
                    try {
                        attrDataType = DataType.valueOf(attrDataTypeString);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.logger.severe("Encountered the unrecognised '" + attrDataTypeString + "' as attribute type in the metadata table of " + (Object)((Object)entType) + "!");
                        attrDataType = DataType.STRING;
                    }
                    AttributeMetaData.MetaDataElement cachedAttr = new AttributeMetaData.MetaDataElement(entType, attrName, attrDataType, attrSizeHint, attrMappedTo, attrImported, attrReadOnly);
                    cachedAttributesTempList.add(cachedAttr);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                attributeMetaData = new AttributeMetaData(cachedAttributesTempList.toArray(new AttributeMetaData.MetaDataElement[cachedAttributesTempList.size()]));
            }
            catch (SQLException e) {
                try {
                    throw new DataSourceException(e);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, stmt, rs);
            return attributeMetaData;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateCachedEntityAttributes(EntityType entType) {
        ArgChecks.checkForNull((Object)entType, "entType");
        Map<EntityType, AttributeMetaData> map = this.attributeCache;
        synchronized (map) {
            this.attributeCache.remove((Object)entType);
        }
    }

    @Override
    public boolean entityExists(SessionToken session, EntityType entType, long id) throws DataSourceException {
        this.orgModelManager.sessionActive(session);
        try {
            boolean bl;
            if (entType == null) {
                throw new NullArgumentException("The parameter 'entType' must not be null!");
            }
            ExtendedConnection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                stmt = con.createStatement();
                String entityTypeTableName = SQLTableNames.getTableNameFor(entType);
                String query = String.format("SELECT id FROM %s WHERE id = %d", entityTypeTableName, id);
                rs = stmt.executeQuery(query);
                boolean exists = rs.next();
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                bl = exists;
            }
            catch (SQLException e) {
                try {
                    throw new DataSourceException(e);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, stmt, rs);
            return bl;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public Entity getEntity(SessionToken session, EntityType entType, long id, String ... attributes) throws OrgModelException, DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull((Object)entType, "entType");
        this.orgModelManager.sessionActive(session);
        try {
            Entity entity;
            ExtendedConnection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                stmt = con.createStatement();
                String entityTypeTableName = SQLTableNames.getTableNameFor(entType);
                String query = String.format("SELECT * FROM %s WHERE id = %d", entityTypeTableName, id);
                AttributeMetaData attrMetas = this.getAttributeMetaData(session, entType);
                rs = stmt.executeQuery(query);
                if (!rs.next()) {
                    String msg = "The entity %s(id = %d) does not exist!";
                    msg = String.format(msg, new Object[]{entType, id});
                    throw new OrgModelException(msg);
                }
                Entity ent = this.rowToEntity(entType, rs, attrMetas, attributes);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                entity = ent;
            }
            catch (SQLException e) {
                try {
                    throw new DataSourceException(e);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, stmt, rs);
            return entity;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public List<Entity> getEntities(SessionToken session, EntityType entType, String ... attributes) throws DataSourceException {
        ArgChecks.checkForNull((Object)entType, "entType");
        this.orgModelManager.sessionActive(session);
        try {
            List<Entity> list = this.getEntities(session, entType, (Filter)null, attributes);
            return list;
        }
        catch (OrgModelException ex) {
            String msg = "Encountered unexpected OrgModelException!";
            throw new IllegalStateException(msg, ex);
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public List<Entity> getEntities(SessionToken session, EntityType entType, String attrName, CmpOperator cmpOperator, Serializable value, String ... attributes) throws OrgModelException, DataSourceException {
        Filter filter = new Filter();
        filter.addSelection(attrName, cmpOperator, value);
        return this.getEntities(session, entType, filter, attributes);
    }

    @Override
    public List<Entity> getEntities(SessionToken session, EntityType entType, Filter filter, String ... attributes) throws OrgModelException, DataSourceException {
        ArgChecks.checkForNull((Object)entType, "entType");
        this.orgModelManager.sessionActive(session);
        try {
            ArrayList<Entity> arrayList;
            if (filter != null) {
                this.getEntities_verifyAttributes(session, filter, entType);
            }
            String entityTypeTableName = SQLTableNames.getTableNameFor(entType);
            ExtendedConnection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                stmt = con.createStatement();
                StringBuilder qb = new StringBuilder();
                qb.append("SELECT * FROM ").append(entityTypeTableName);
                if (filter != null) {
                    String filterString = this.getEntities_getSQLWherePartFromFilter(con, filter);
                    if (!filterString.equals("")) {
                        qb.append(" WHERE ").append(filterString);
                    }
                } else {
                    qb.append(" WHERE id >= 0");
                }
                ArrayList<Entity> resultList = new ArrayList<Entity>();
                AttributeMetaData attrMeta = this.getAttributeMetaData(session, entType);
                rs = stmt.executeQuery(qb.toString());
                while (rs.next()) {
                    Entity entity = this.rowToEntity(entType, rs, attrMeta, attributes);
                    resultList.add(entity);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                arrayList = resultList;
            }
            catch (SQLException e) {
                try {
                    throw new DataSourceException(e);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, stmt, rs);
            return arrayList;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    private String getEntities_getSQLWherePartFromFilter(ExtendedConnection con, Filter filter) {
        StringBuilder sqlSelection = new StringBuilder();
        boolean first = true;
        Filter.Selection[] selectionArray = filter.getSelections();
        int n = selectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Filter.Selection sel = selectionArray[n2];
            if (first) {
                first = false;
            } else {
                sqlSelection.append(" AND ");
            }
            String qualifiedAttributeName = sel.getAttributeName();
            sqlSelection.append(OmmDefImplTools.formatAsSqlCondition(con, qualifiedAttributeName, sel.getOperator(), sel.getValue()));
            ++n2;
        }
        return sqlSelection.toString();
    }

    private void getEntities_verifyAttributes(SessionToken session, Filter filter, EntityType entityType) throws OrgModelException, DataSourceException {
        Filter.Selection[] selectionArray = filter.getSelections();
        int n = selectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Filter.Selection sel = selectionArray[n2];
            if (!this.hasAttribute(session, entityType, sel.getAttributeName())) {
                throw new OrgModelException("Entity type " + (Object)((Object)entityType) + " doesn't have an attribute " + sel.getAttributeName());
            }
            DataType odt = DataType.getDataTypeForObject(sel.getValue());
            if (odt == null) {
                throw new IllegalStateException("Object type of value could not be mapped to one of the defined DataTypes!");
            }
            DataType adt = this.getAttributeDataType(session, entityType, sel.getAttributeName());
            if (!sel.getOperator().canCompare(adt, odt)) {
                throw new OrgModelException("The given object value type " + (Object)((Object)odt) + " is not comparable to the attribute value type " + (Object)((Object)adt) + "!");
            }
            ++n2;
        }
    }

    private Entity rowToEntity(EntityType entType, ResultSet rs, AttributeMetaData attributeMetas, String[] attributes) throws SQLException, DataSourceException {
        String ldapNodeDN;
        ArrayList<String> attrList;
        long id = rs.getLong("id");
        if (attributes.length == 0) {
            attrList = null;
        } else {
            attrList = new ArrayList<String>(attributes.length);
            String[] stringArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                attrList.add(attr.toLowerCase());
                ++n2;
            }
        }
        Entity entity = new Entity(entType, rs.getMetaData().getColumnCount());
        try {
            int columnIndex = rs.findColumn("ldapDN");
            ldapNodeDN = rs.getString(columnIndex);
        }
        catch (SQLException sQLException) {
            ldapNodeDN = null;
        }
        block17: for (AttributeMetaData.MetaDataElement attrMeta : attributeMetas) {
            String omName = attrMeta.getName();
            if (attrList != null && !attrList.contains(omName.toLowerCase())) continue;
            DataType dataType = attrMeta.getDataType();
            LdapAdapter ldapAdapter = this.orgModelManager.getLdapAdapter();
            if (attrMeta.getMappedTo() == null || attrMeta.isImported() || ldapNodeDN == null || ldapAdapter == null) {
                String msg;
                if (attrMeta.getMappedTo() != null && !attrMeta.isImported() && ldapNodeDN != null) {
                    msg = "There's no LDAP adapter configured even though there's at least one attribute ('%s') for which a mapping is defined and which is not imported!";
                    msg = String.format(msg, attrMeta.getName());
                    this.logger.warning(msg);
                }
                switch (dataType) {
                    case INTEGER: {
                        long value = rs.getLong(omName);
                        if (rs.wasNull()) {
                            entity.setNull(omName);
                            continue block17;
                        }
                        entity.setInteger(omName, value);
                        continue block17;
                    }
                    case FLOAT: {
                        double value = rs.getDouble(omName);
                        if (rs.wasNull()) {
                            entity.setNull(omName);
                            continue block17;
                        }
                        entity.setFloat(omName, value);
                        continue block17;
                    }
                    case STRING: {
                        Object value = rs.getString(omName);
                        if (rs.wasNull()) {
                            entity.setNull(omName);
                            continue block17;
                        }
                        entity.setString(omName, (String)value);
                        continue block17;
                    }
                    case DATE: {
                        Object value = rs.getDate(omName, JDBCTools.createUTCCalendar());
                        if (rs.wasNull()) {
                            entity.setNull(omName);
                            continue block17;
                        }
                        entity.setDate(omName, (Date)value);
                        continue block17;
                    }
                    case TIME: {
                        Object value = rs.getTime(omName, JDBCTools.createUTCCalendar());
                        if (rs.wasNull()) {
                            entity.setNull(omName);
                            continue block17;
                        }
                        entity.setDate(omName, (Date)value);
                        continue block17;
                    }
                    case TIMESTAMP: {
                        Object value = rs.getTimestamp(omName, JDBCTools.createUTCCalendar());
                        if (rs.wasNull()) {
                            entity.setNull(omName);
                            continue block17;
                        }
                        entity.setDate(omName, (Date)value);
                        continue block17;
                    }
                    default: {
                        msg = "Unknown DataType encountered: " + (Object)((Object)dataType);
                        throw new IllegalStateException(msg);
                    }
                }
            }
            if (id < 0L) {
                entity.setNull(omName);
                continue;
            }
            String ldapName = attrMeta.getMappedTo();
            try {
                String value = ldapAdapter.getLdapAttributes(ldapNodeDN, ldapName)[0];
                if (value == null) {
                    entity.setNull(omName);
                    continue;
                }
                switch (dataType) {
                    case INTEGER: {
                        entity.setInteger(omName, Long.parseLong(value));
                        continue block17;
                    }
                    case STRING: {
                        entity.setString(omName, value);
                        continue block17;
                    }
                    default: {
                        throw new OrgModelException();
                    }
                }
            }
            catch (NamingException ex) {
                throw new DataSourceException(ex);
            }
        }
        return entity;
    }

    @Override
    public int getEntityCount(SessionToken session, EntityType entType) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull((Object)entType, "entType");
        this.orgModelManager.sessionActive(session);
        ExtendedConnection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            int n;
            try {
                con = this.getDataSource().getConnection();
                stmt = con.createStatement();
                String query = "SELECT count(*) FROM %s";
                query = String.format(query, SQLTableNames.getTableNameFor(entType));
                rs = stmt.executeQuery(query);
                int count = rs.getInt(1);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                n = count;
            }
            catch (SQLException ex) {
                try {
                    throw new DataSourceException(ex);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, stmt, rs);
            return n;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public boolean relationExists(SessionToken session, RelationType relType, long id1, long id2) throws OrgModelException, DataSourceException {
        this.orgModelManager.sessionActive(session);
        try {
            boolean bl;
            this.ensureEntityExists(session, relType.leftHandEntityType(), id1);
            this.ensureEntityExists(session, relType.rightHandEntityType(), id2);
            ExtendedConnection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                String query;
                con = this.getDataSource().getConnection();
                stmt = con.createStatement();
                if (relType.isNMRelation()) {
                    String relationTypeTableName = SQLTableNames.getTableNameFor(relType);
                    String column1 = OmmDefImplTools.getColumnNameInNMRelation(relType.leftHandEntityType());
                    String column2 = OmmDefImplTools.getColumnNameInNMRelation(relType.rightHandEntityType());
                    query = String.format("SELECT * FROM %s WHERE %s = %d AND %s = %d", relationTypeTableName, column1, id1, column2, id2);
                } else {
                    String rightHandEntityTypeTableName = SQLTableNames.getTableNameFor(relType.rightHandEntityType());
                    query = String.format("SELECT id FROM %s WHERE id = %d AND %s = %d", rightHandEntityTypeTableName, id2, relType.oneToMReferenceAttribute(), id1);
                }
                rs = stmt.executeQuery(query);
                boolean exists = rs.next();
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                bl = exists;
            }
            catch (SQLException e) {
                try {
                    this.logger.log(Level.SEVERE, "There's a problem with the data source.", e);
                    throw new DataSourceException(e);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, stmt, rs);
            return bl;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public List<Entity> getRelatedEntities(SessionToken session, EntityType entType, long id, RelationType relType, boolean leftToRight, String ... attributes) throws OrgModelException, DataSourceException {
        this.orgModelManager.sessionActive(session);
        try {
            ArrayList<Entity> arrayList;
            ResultSet rs;
            Statement stmt;
            ExtendedConnection con;
            EntityType targetEntType;
            block16: {
                this.ensureEntityExists(session, entType, id);
                if (leftToRight) {
                    if (entType != relType.leftHandEntityType()) {
                        throw new IllegalArgumentException("The parameter 'entType' = " + entType.name() + " is not the left-hand entity type in 'relType' = " + relType.name());
                    }
                    targetEntType = relType.rightHandEntityType();
                } else {
                    if (entType != relType.rightHandEntityType()) {
                        throw new IllegalArgumentException("The parameter 'entType' = " + entType.name() + " is not the right-hand" + " entity type in 'relType' = " + relType.name());
                    }
                    targetEntType = relType.leftHandEntityType();
                }
                con = null;
                stmt = null;
                rs = null;
                con = this.getDataSource().getConnection();
                stmt = con.createStatement();
                if (!relType.isNMRelation()) break block16;
                String columnLeft = OmmDefImplTools.getColumnNameInNMRelation(relType.leftHandEntityType());
                String columnRight = OmmDefImplTools.getColumnNameInNMRelation(relType.rightHandEntityType());
                String relationTypeTableName = SQLTableNames.getTableNameFor(relType);
                String leftHandEntityTypeTableName = SQLTableNames.getTableNameFor(relType.leftHandEntityType());
                String rightHandEntityTypeTableName = SQLTableNames.getTableNameFor(relType.rightHandEntityType());
                String query = leftToRight ? "SELECT E2.* FROM %s E1 JOIN %s R ON E1.id = R.%s JOIN %s E2 ON E2.id = R.%s WHERE E1.id = %d" : "SELECT E1.* FROM %s E1 JOIN %s R ON E1.id = R.%s JOIN %s E2 ON E2.id = R.%s WHERE E2.id = %d";
                query = String.format(query, leftHandEntityTypeTableName, relationTypeTableName, columnLeft, rightHandEntityTypeTableName, columnRight, id);
                ArrayList<Entity> resultList = new ArrayList<Entity>();
                AttributeMetaData attrMetas = this.getAttributeMetaData(session, targetEntType);
                rs = stmt.executeQuery(query);
                while (rs.next()) {
                    Entity entity = this.rowToEntity(targetEntType, rs, attrMetas, attributes);
                    resultList.add(entity);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                ArrayList<Entity> arrayList2 = resultList;
                JDBCTools.closeQuietly(con, stmt, rs);
                return arrayList2;
            }
            try {
                String leftHandEntityTypeTableName = SQLTableNames.getTableNameFor(relType.leftHandEntityType());
                String rightHandEntityTypeTableName = SQLTableNames.getTableNameFor(relType.rightHandEntityType());
                String query = leftToRight ? "SELECT E2.* FROM %s E1 JOIN %s E2 ON E1.id = E2.%s WHERE E1.id = %d" : "SELECT E1.* FROM %s E1 JOIN %s E2 ON E1.id = E2.%s WHERE E2.id = %d";
                query = String.format(query, leftHandEntityTypeTableName, rightHandEntityTypeTableName, relType.oneToMReferenceAttribute(), id);
                ArrayList<Entity> resultList = new ArrayList<Entity>();
                AttributeMetaData attrMetas = this.getAttributeMetaData(session, targetEntType);
                rs = stmt.executeQuery(query);
                while (rs.next()) {
                    Entity entity = this.rowToEntity(targetEntType, rs, attrMetas, attributes);
                    resultList.add(entity);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                arrayList = resultList;
            }
            catch (SQLException e) {
                try {
                    this.logger.log(Level.SEVERE, "There's a problem with the data source.", e);
                    throw new DataSourceException(e);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, stmt, rs);
            return arrayList;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public List<Entity> getRelatedEntities(SessionToken session, EntityType entType, long id, NavFunction navFunction, String ... attributes) throws OrgModelException, DataSourceException {
        return this.getRelatedEntities(session, entType, id, navFunction.relationType(), navFunction.isLeftToRight(), attributes);
    }

    private void ensureEntityExists(SessionToken session, EntityType entType, long id) throws OrgModelException, DataSourceException {
        if (!this.entityExists(session, entType, id)) {
            throw new OrgModelException(String.format("The entity %s(%d) does not exist!", new Object[]{entType, id}));
        }
    }

    private JDBCDataSource getDataSource() {
        return this.orgModelManager.getDataSource();
    }
}

