/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.SQLTools;
import de.aristaflow.adept2.base.security.SecurityManager;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.ClientAdministration;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelException;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultClientAdministration;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultModelChangeOperations;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultModelExplorer;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultPolicyResolution;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.GlobalSecurityManager;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.LdapAdapter;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.LdapSynchroniser;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.OrgModelManagerConfigurationValidator;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.SQLTableNames;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.util.ArrayTools;
import de.aristaflow.adept2.util.DataSourceException;
import java.io.InputStream;
import java.net.URI;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="Caching", type=Property.Type.BOOLEAN, defaultValue="off", description="Determines whether the ModelExplorer should try to cache information. More specifically it will cache meta data about the attributes which are usually needed rather frequently."), @Property(name="MaxRecursionDepth", type=Property.Type.INT, defaultValue="20", description="Determines the maximum recursion depth in the PolicyResolution when resolving transitive functions. This configuration field is only supposed to protect against infinite loops. The OrgModelManager is responsible for preventing them, but they could still exist.", restrictions={"range: 1 to x"}), @Property(name="CaseSensitiveUserNames", type=Property.Type.BOOLEAN, defaultValue="true", description="Determines whether user names are treated case sensitively in certain methods, e.g. in the authentication."), @Property(name="SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.activityrepositoryeditor", defaultValue="Agent()", description="The SAR for the agents that qualify to log on from the activity repository editor application. Set this to the empty string to prevent any logon from the application."), @Property(name="SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.client", defaultValue="Agent()", description="The SAR for the agents that qualify to log on from the client application. Set this to the empty string to prevent any logon from the application."), @Property(name="SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.flexclient", defaultValue="Agent()", description="The SAR for the agents that qualify to log on from the flex client application. Set this to the empty string to prevent any logon from the application."), @Property(name="SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.monitoring", defaultValue="Agent()", description="The SAR for the agents that qualify to log on from the monitoring application. Set this to the empty string to prevent any logon from the application."), @Property(name="SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.orgmodeleditor", defaultValue="Agent()", description="The SAR for the agents that qualify to log on from the editor application for the organisational model. Set this to the empty string to prevent any logon from the application."), @Property(name="SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.processtemplateeditor", defaultValue="Agent()", description="The SAR for the agents that qualify to log on from the process template editor application. Set this to the empty string to prevent any logon from the application."), @Property(name="SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.testclient", defaultValue="Agent()", description="The SAR for the agents that qualify to log on from the test client application. Set this to the empty string to prevent any logon from the application."), @Property(name="SecurityManager.ACL.Logon.Application.Other", defaultNull=true, description="The SAR for the agents that qualify to log on from other applications, that are applications with names this security manager does not know. Set this to \"Agent()\" to allow acccess for everyone from the application."), @Property(name="SecurityManager.ACL.Logon.Application.Null", defaultValue="Agent()", description="The SAR for the agents that qualify to log on without an application ID. Set this to the empty string to prevent any logon without application ID.")}, validator=OrgModelManagerConfigurationValidator.class)
public class DefaultOrgModelManager
extends AbstractADEPT2Service
implements OrgModelManager {
    protected static final String CONF_SEC_MGR_PREFIX = "SecurityManager";
    protected static final String CONF_CASE_SENSITIVE_USERNAME = "CaseSensitiveUserNames";
    static final String CFG_CACHING = "Caching";
    static final String CFG_MAX_RECURSION_DEPTH = "MaxRecursionDepth";
    static final String CFG_USE_LDAP = "UseLDAP";
    static final String CONF_ACL_APPNAME_PREFIX = "ACL.Logon.Application";
    static final String CONF_ACL_APPNAME_ARE = "de.aristaflow.adept2.app.activityrepositoryeditor";
    static final String CONF_PRFXD_ACL_APPNAME_ARE = "SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.activityrepositoryeditor";
    static final String CONF_ACL_APPNAME_CLIENT = "de.aristaflow.adept2.app.client";
    static final String CONF_PRFXD_ACL_APPNAME_CLIENT = "SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.client";
    static final String CONF_ACL_APPNAME_FLEX_CLIENT = "de.aristaflow.adept2.app.flexclient";
    static final String CONF_PRFXD_ACL_APPNAME_FLEX_CLIENT = "SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.flexclient";
    static final String CONF_ACL_APPNAME_MONITORING = "de.aristaflow.adept2.app.monitoring";
    static final String CONF_PRFXD_ACL_APPNAME_MONITORING = "SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.monitoring";
    static final String CONF_ACL_APPNAME_OME = "de.aristaflow.adept2.app.orgmodeleditor";
    static final String CONF_PRFXD_ACL_APPNAME_OME = "SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.orgmodeleditor";
    static final String CONF_ACL_APPNAME_PTE = "de.aristaflow.adept2.app.processtemplateeditor";
    static final String CONF_PRFXD_ACL_APPNAME_PTE = "SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.processtemplateeditor";
    static final String CONF_ACL_APPNAME_TEST_CLIENT = "de.aristaflow.adept2.app.testclient";
    static final String CONF_PRFXD_ACL_APPNAME_TEST_CLIENT = "SecurityManager.ACL.Logon.Application.de.aristaflow.adept2.app.testclient";
    static final String CONF_ACL_APPNAME_OTHER = "Other";
    static final String CONF_PRFXD_ACL_APPNAME_OTHER = "SecurityManager.ACL.Logon.Application.Other";
    static final String CONF_ACL_APPNAME_NULL = "Null";
    static final String CONF_PRFXD_ACL_APPNAME_NULL = "SecurityManager.ACL.Logon.Application.Null";
    protected final Configuration configuration;
    private JDBCDataSource dataSource;
    private DefaultPolicyResolution policyResolution;
    private DefaultModelExplorer modelExplorer;
    private DefaultModelChangeOperations modelChangeOperations;
    private DefaultClientAdministration clientAdministration;
    protected GlobalSecurityManager securityManager;
    private LdapAdapter ldapAdapter;
    private LdapSynchroniser ldapSynchroniser;

    @Override
    protected SessionToken createSessionToken() {
        return super.createSessionToken();
    }

    public DefaultOrgModelManager(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry, new String[]{"JDBCDataSource"}, new String[0]);
        this.configuration = configuration;
        Configuration ldapConf = configuration.subset("LDAP");
        if (ldapConf.getBoolean(CFG_USE_LDAP, false)) {
            String msg = "Using LDAP for the organisational model.";
            this.logger.info(msg);
            this.ldapAdapter = new LdapAdapter(this, ldapConf);
            this.ldapSynchroniser = new LdapSynchroniser(this, ldapConf);
        }
    }

    protected DefaultOrgModelManager(Configuration configuration, Registry registry, String[] startupRequiredServices, String[] runtimeRequiredServices) throws ConfigurationException {
        super(configuration, registry, ArrayTools.join(startupRequiredServices, {"JDBCDataSource"}), runtimeRequiredServices);
        this.configuration = configuration;
        Configuration ldapConf = configuration.subset("LDAP");
        if (ldapConf.getBoolean(CFG_USE_LDAP, false)) {
            String msg = "Using LDAP for the organisational model.";
            this.logger.info(msg);
            this.ldapAdapter = new LdapAdapter(this, ldapConf);
            this.ldapSynchroniser = new LdapSynchroniser(this, ldapConf);
        }
    }

    @Override
    public DefaultPolicyResolution getPolicyResolution() {
        if (this.policyResolution == null) {
            this.policyResolution = new DefaultPolicyResolution(this, this.configuration);
        }
        return this.policyResolution;
    }

    @Override
    public DefaultModelExplorer getModelExplorer() {
        if (this.modelExplorer == null) {
            this.modelExplorer = new DefaultModelExplorer(this, this.configuration);
        }
        return this.modelExplorer;
    }

    @Override
    public DefaultModelChangeOperations getModelChangeOperations() {
        if (this.modelChangeOperations == null) {
            this.modelChangeOperations = new DefaultModelChangeOperations(this, this.configuration);
        }
        return this.modelChangeOperations;
    }

    @Override
    public ClientAdministration getClientAdministration() {
        if (this.clientAdministration == null) {
            this.clientAdministration = new DefaultClientAdministration(this);
        }
        return this.clientAdministration;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public void synchroniseModel(SessionToken session) {
        this.sessionActive(session);
        try {
            this.getLdapSynchroniser().synchronise(false);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    LdapAdapter getLdapAdapter() {
        return this.ldapAdapter;
    }

    LdapSynchroniser getLdapSynchroniser() {
        return this.ldapSynchroniser;
    }

    @Override
    public void init(URI[] exportedURIs) throws AbortServiceException {
        super.init(exportedURIs, -2, -2, "password");
        SessionToken initSession = this.createSessionToken();
        this.dataSource = this.registry.getServiceOfType(initSession, "JDBCDataSource", JDBCDataSource.class);
        ExtendedConnection con = null;
        try {
            try {
                con = this.dataSource.getConnection();
                con.setAutoCommit(false);
                if (!con.tableExists(SQLTableNames.getTableNameFor(EntityType.AGENT))) {
                    SQLTools.runSQLScript(con, DefaultOrgModelManager.class.getResourceAsStream("sqlscripts/omm-create.sql"));
                    SQLTools.runSQLScript(con, DefaultOrgModelManager.class.getResourceAsStream("sqlscripts/omm-defaultattributes.sql"));
                    InputStream testData = DefaultOrgModelManager.class.getResourceAsStream("sqlscripts/omm-testdata.sql");
                    if (testData != null) {
                        SQLTools.runSQLScript(con, testData);
                    }
                }
                con.commit();
                this.createSystemRoles(initSession);
                con.commit();
                con = JDBCTools.close(con);
            }
            catch (Exception ex) {
                String msg = "An error occured while trying to verify/create the database structure.";
                throw new AbortServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.rollbackQuietly(con);
            JDBCTools.closeQuietly(con);
            throw throwable;
        }
        JDBCTools.rollbackQuietly(con);
        JDBCTools.closeQuietly(con);
        boolean caseSensitive = this.configuration.getBoolean(CONF_CASE_SENSITIVE_USERNAME);
        Configuration secMgrConf = this.configuration.subset(CONF_SEC_MGR_PREFIX);
        this.securityManager = new GlobalSecurityManager(this.getDataSource(), caseSensitive, this.getSessionFactory(), exportedURIs, this, secMgrConf);
    }

    void createSystemRoles(SessionToken session) {
        boolean svr = this.verifySystemRole(session, -1L, "Supervisor");
        boolean sr = this.verifySystemRole(session, -2L, "System");
        boolean acr = this.verifySystemRole(session, -3L, "Automatic Client");
        boolean emr = this.verifySystemRole(session, -4L, "Event Manager");
        if (svr && sr && acr && emr) {
            String msg;
            if (this.orgPosExists(session, -1L, "supervisor")) {
                try {
                    this.getModelChangeOperations().addRelation(session, RelationType.ORG_POSITION_DESCRIPTION, -1L, -1L);
                }
                catch (DataSourceException dse) {
                    msg = "Creating relation supervisor-Supervisor (OrgPos-Role) failed.Ignoring.";
                    this.logger.log(Level.INFO, msg, dse);
                }
            }
            if (this.orgPosExists(session, -2L, "system")) {
                try {
                    this.getModelChangeOperations().addRelation(session, RelationType.ORG_POSITION_DESCRIPTION, -2L, -2L);
                }
                catch (DataSourceException dse) {
                    msg = "Creating relation system-System (OrgPos-Role) failed. Ignoring.";
                    this.logger.log(Level.INFO, msg, dse);
                }
            }
            if (this.orgPosExists(session, 9L, "automaticclient")) {
                try {
                    this.getModelChangeOperations().addRelation(session, RelationType.ORG_POSITION_DESCRIPTION, 9L, -3L);
                }
                catch (DataSourceException dse) {
                    msg = "Creating relation automaticclient-Automatic Client (OrgPos-Role) failed. Ignoring.";
                    this.logger.log(Level.INFO, msg, dse);
                }
            }
            this.verifySystemAgent(session, 9L, "eventmanager", "password", "eventmanager", "eventmanager");
            this.verifySystemOrgPosition(session, 10L, "eventmanager");
            try {
                this.getModelChangeOperations().addRelation(session, RelationType.ORG_POSITION_DESCRIPTION, 10L, -4L);
            }
            catch (DataSourceException dse) {
                msg = "Creating relation eventmanager-Event Manager (OrgPos-Role) failed. Ignoring.";
                this.logger.log(Level.INFO, msg, dse);
            }
            try {
                if (!this.getModelExplorer().relationExists(session, RelationType.ORG_POSITION_OCCUPATION, 10L, 9L)) {
                    this.getModelChangeOperations().addRelation(session, RelationType.ORG_POSITION_OCCUPATION, 10L, 9L);
                }
            }
            catch (DataSourceException dse) {
                msg = "Creating relation eventmanager-eventmanager (OrgPos-Agent) failed. Ignoring.";
                this.logger.log(Level.INFO, msg, dse);
            }
        }
    }

    boolean agentExists(SessionToken session, long id, String userName, String password, String firstName, String lastName) {
        Entity entity = new Entity(EntityType.AGENT);
        entity.setInteger("id", id);
        entity.setString("userName", userName);
        entity.setString("password", password);
        entity.setString("firstName", firstName);
        entity.setString("lastName", lastName);
        return this.entityExists(session, entity);
    }

    boolean orgPosExists(SessionToken session, long id, String name) {
        Entity entity = new Entity(EntityType.ORG_POSITION);
        entity.setInteger("id", -1L);
        entity.setString("name", "supervisor");
        return this.entityExists(session, entity);
    }

    boolean entityExists(SessionToken session, Entity entity) {
        boolean ret = false;
        try {
            this.getModelExplorer().getEntity(session, entity.getType(), entity.getInteger("id"), new String[0]);
            ret = true;
        }
        catch (OrgModelException ome) {
            String msg = "Checking for whether the entity with ID '%s' exists faild. Ignoring.";
            msg = String.format(msg, entity.getInteger("id"));
            this.logger.log(Level.INFO, msg, ome);
        }
        catch (DataSourceException dse) {
            String msg = "Checking for whether the entity with ID '%s' exists faild. Ignoring.";
            msg = String.format(msg, entity.getInteger("id"));
            this.logger.log(Level.INFO, msg, dse);
        }
        return ret;
    }

    boolean verifySystemAgent(SessionToken session, long id, String userName, String password, String firstName, String lastName) {
        Entity entity = new Entity(EntityType.AGENT);
        entity.setInteger("id", id);
        entity.setString("userName", userName);
        entity.setString("password", password);
        entity.setString("firstName", firstName);
        entity.setString("lastName", lastName);
        return this.verifySystemEntity(session, entity);
    }

    boolean verifySystemOrgPosition(SessionToken session, long id, String name) {
        Entity entity = new Entity(EntityType.ORG_POSITION);
        entity.setInteger("id", id);
        entity.setString("name", name);
        return this.verifySystemEntity(session, entity);
    }

    boolean verifySystemRole(SessionToken session, long id, String name) {
        Entity entity = new Entity(EntityType.ROLE);
        entity.setInteger("id", id);
        entity.setString("name", name);
        return this.verifySystemEntity(session, entity);
    }

    private boolean verifySystemEntity(SessionToken session, Entity entity) {
        boolean ret = false;
        try {
            long id = entity.getInteger("id");
            try {
                this.getModelExplorer().getEntity(session, entity.getType(), id, new String[0]);
            }
            catch (OrgModelException orgModelException) {
                this.getModelChangeOperations().createSystemEntity(session, entity);
                ret = true;
            }
        }
        catch (DataSourceException dse) {
            dse.printStackTrace();
        }
        return ret;
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        if (this.ldapSynchroniser != null) {
            this.ldapSynchroniser.start();
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.ldapSynchroniser != null) {
            this.ldapSynchroniser.shutdown();
        }
        this.dataSource = null;
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        if (this.ldapSynchroniser != null) {
            this.ldapSynchroniser.emergencyShutdown();
        }
        this.dataSource = null;
    }

    public QualifiedAgent checkAndGetTopLevelAgent(SessionToken sessionToken) {
        super.sessionActive(sessionToken);
        try {
            QualifiedAgent qualifiedAgent = this.getSessionFactory().checkAndGetTopLevelAgent(sessionToken);
            return qualifiedAgent;
        }
        catch (SecurityTokenIntegrityException e) {
            throw new ServiceAccessControlException("The agent could not be retrieved from the session token!", e);
        }
        finally {
            super.sessionFinished(sessionToken);
        }
    }
}

