/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.AttributeMetaData;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultModelExplorer;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultOrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.OmmDefImplTools;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.OrgPolicyQueryBuilder;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.RecTableRef;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.SQLTableNames;
import de.aristaflow.adept2.core.orgmodelmanager.parser.AtomicEntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.AtomicSelection;
import de.aristaflow.adept2.core.orgmodelmanager.parser.ComplexEntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.ComplexSelection;
import de.aristaflow.adept2.core.orgmodelmanager.parser.DynamicEntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.EntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.NavFunctionInstance;
import de.aristaflow.adept2.core.orgmodelmanager.parser.OrgPolicyParser;
import de.aristaflow.adept2.core.orgmodelmanager.parser.Selection;
import de.aristaflow.adept2.core.orgmodelmanager.parser.TokenInfo;
import de.aristaflow.adept2.core.orgmodelmanager.parser.TokenInfoContainer;
import de.aristaflow.adept2.core.orgmodelmanager.parser.TransitivityType;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.orgmodel.CmpOperator;
import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.NavFunction;
import de.aristaflow.adept2.model.orgmodel.OrgPolicyReport;
import de.aristaflow.adept2.model.orgmodel.PathCompletion;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public class DefaultPolicyResolution
implements PolicyResolution {
    int maxRecursionDepth;
    protected Map<RelationType, Boolean> recTableValidLeftToRight = new HashMap<RelationType, Boolean>();
    protected Map<RelationType, Boolean> recTableValidRightToLeft = new HashMap<RelationType, Boolean>();
    protected final Logger logger = LoggerTools.getLogger(this);
    private DefaultOrgModelManager orgModelManager;
    private PathCompletion pathCompletion = new PathCompletion();

    DefaultPolicyResolution(DefaultOrgModelManager orgModelManager, Configuration configuration) {
        this.orgModelManager = orgModelManager;
        this.maxRecursionDepth = configuration.getInt("MaxRecursionDepth");
        RelationType[] relationTypeArray = RelationType.values();
        int n = relationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelationType relType = relationTypeArray[n2];
            if (relType.isRecursive()) {
                this.invalidateRecTables(relType);
            }
            ++n2;
        }
    }

    @Override
    public PathCompletion getPathCompletion() {
        return this.pathCompletion.clone();
    }

    @Override
    public void setPathCompletion(SessionToken session, PathCompletion pathCompletion) {
        this.orgModelManager.sessionActive(session);
        try {
            if (pathCompletion == null) {
                throw new NullArgumentException("The parameter 'pathCompletion' must not be null!");
            }
            this.pathCompletion = pathCompletion.clone();
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public OrgPolicyReport checkSyntax(String orgPolicy, boolean createFullReport, boolean rejectParameterReferences) {
        ArgChecks.checkForNull(orgPolicy, "orgPolicy");
        OrgPolicyReport report = new OrgPolicyReport();
        OrgPolicyParser.getInstance().parse(orgPolicy, report, true, !createFullReport, rejectParameterReferences, null);
        return report;
    }

    @Override
    public OrgPolicyReport checkResolvability(SessionToken session, String orgPolicy, boolean createFullReport, boolean rejectParameterReferences) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(orgPolicy, "orgPolicy");
        this.orgModelManager.sessionActive(session);
        try {
            OrgPolicyReport report = new OrgPolicyReport();
            this.parseResolvable(session, orgPolicy, this.pathCompletion, report, true, !createFullReport, rejectParameterReferences);
            OrgPolicyReport orgPolicyReport = report;
            return orgPolicyReport;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    void invalidateRecTablesFor(EntityType entType) {
        RelationType[] relationTypeArray = RelationType.values();
        int n = relationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelationType relType = relationTypeArray[n2];
            if (relType.isRecursive() && relType.leftHandEntityType() == entType) {
                this.invalidateRecTables(relType);
            }
            ++n2;
        }
    }

    void invalidateRecTables(RelationType relType) {
        if (!relType.isRecursive()) {
            return;
        }
        this.recTableValidLeftToRight.put(relType, Boolean.FALSE);
        this.recTableValidRightToLeft.put(relType, Boolean.FALSE);
    }

    synchronized void prepareRecTable(RelationType relType, boolean leftToRight) throws SQLException {
        if (relType == null) {
            throw new NullArgumentException("The parameter 'relType' must not be null!");
        }
        if (!relType.isRecursive()) {
            throw new IllegalArgumentException("The given relation type " + (Object)((Object)relType) + " is not recursive!");
        }
        String recTableName = OmmDefImplTools.getRecTableName(relType, leftToRight);
        if (leftToRight ? this.recTableValidLeftToRight.get((Object)relType) != false : this.recTableValidRightToLeft.get((Object)relType) != false) {
            return;
        }
        ExtendedConnection con = null;
        Statement stmt = null;
        try {
            con = this.getDataSource().getConnection();
            stmt = con.createStatement();
            if (!con.tableExists(recTableName)) {
                String bigintType = con.getCorrespondingDBType(-5);
                stmt.executeUpdate(String.format("CREATE TABLE %1$s (depth INTEGER, origin %2$s, id %2$s)", recTableName, bigintType));
            }
            stmt.executeUpdate("DELETE FROM " + recTableName);
            String rightHandEntityTypeTableName = SQLTableNames.getTableNameFor(relType.rightHandEntityType());
            stmt.executeUpdate("INSERT INTO " + recTableName + " (depth, origin, id) SELECT 0, id, id FROM " + rightHandEntityTypeTableName);
            if (leftToRight) {
                int i = 0;
                while (i < this.maxRecursionDepth) {
                    String query = "INSERT INTO " + recTableName + " (depth, origin, id)" + " SELECT " + (i + 1) + ", R.origin, E.id FROM " + recTableName + " R" + " JOIN " + rightHandEntityTypeTableName + " E ON R.id = E." + relType.oneToMReferenceAttribute() + " WHERE depth = " + i;
                    int insertedRows = stmt.executeUpdate(query);
                    if (insertedRows == 0) break;
                    ++i;
                }
                this.recTableValidLeftToRight.put(relType, Boolean.TRUE);
            } else {
                int i = 0;
                while (i < this.maxRecursionDepth) {
                    String query = "INSERT INTO " + recTableName + " (depth, origin, id)" + " SELECT " + (i + 1) + ", R.origin, E2.id FROM " + recTableName + " R" + " JOIN " + rightHandEntityTypeTableName + " E1 ON R.id = E1.id" + " JOIN " + rightHandEntityTypeTableName + " E2 ON E1." + relType.oneToMReferenceAttribute() + " = E2.id" + " WHERE depth = " + i;
                    int insertedRows = stmt.executeUpdate(query);
                    if (insertedRows == 0) break;
                    ++i;
                }
                this.recTableValidRightToLeft.put(relType, Boolean.TRUE);
            }
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly(con, stmt);
    }

    @Override
    public Set<QualifiedAgent> resolvePolicy(SessionToken session, String orgPolicy) throws PolicyResolutionException, DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(orgPolicy, "orgPolicy");
        this.orgModelManager.sessionActive(session);
        try {
            HashSet<QualifiedAgent> hashSet;
            RecTableRef[] recTables;
            String query;
            OrgPolicyReport report = new OrgPolicyReport();
            EntityExpression entExp = this.parseResolvable(session, orgPolicy, this.pathCompletion, report, false, true, true);
            if (report.getOverallResult() == OrgPolicyReport.ResultType.ERROR) {
                throw new PolicyResolutionException("The OrgPolicy is not resolvable: " + orgPolicy);
            }
            OrgPolicyQueryBuilder builder = new OrgPolicyQueryBuilder(this.omm());
            try {
                query = builder.buildSqlQuery(entExp);
                recTables = builder.getRequiredRecursionTables();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
            ExtendedConnection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                stmt = con.createStatement();
                RecTableRef[] recTableRefArray = recTables;
                int n = recTables.length;
                int n2 = 0;
                while (n2 < n) {
                    RecTableRef rec = recTableRefArray[n2];
                    this.prepareRecTable(rec.relType, rec.leftToRight);
                    ++n2;
                }
                HashSet<QualifiedAgent> results = new HashSet<QualifiedAgent>();
                rs = stmt.executeQuery(query);
                while (rs.next()) {
                    long agentId = rs.getLong(3);
                    String agentUserName = rs.getString(4);
                    String orgPositionName = rs.getString(2);
                    long orgPositionId = rs.getLong(1);
                    results.add(new QualifiedAgent(agentId, agentUserName, orgPositionId, orgPositionName));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                hashSet = results;
            }
            catch (SQLException ex) {
                try {
                    throw new DataSourceException(ex);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, stmt, rs);
            return hashSet;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    private EntityExpression parseResolvable(SessionToken session, String orgPolicy, PathCompletion completion, OrgPolicyReport report, boolean reportOnly, boolean binaryReport, boolean rejectParameterReferences) throws DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(orgPolicy, "orgPolicy");
        ArgChecks.checkForNull(report, "report");
        this.orgModelManager.sessionActive(session);
        try {
            TokenInfoContainer tokenInfos = new TokenInfoContainer();
            EntityExpression policy = OrgPolicyParser.getInstance().parse(orgPolicy, report, false, binaryReport, rejectParameterReferences, tokenInfos);
            DefaultModelExplorer explorer = this.orgModelManager.getModelExplorer();
            boolean failed = false;
            if (report.getOverallResult() == OrgPolicyReport.ResultType.ERROR) {
                failed = true;
            } else {
                ArrayList<EntityExpression> entStack = new ArrayList<EntityExpression>();
                ArrayList<Selection> selStack = new ArrayList<Selection>();
                HashMap<EntityExpression, ComplexEntityExpression> parentage = new HashMap<EntityExpression, ComplexEntityExpression>();
                entStack.add(policy);
                while (entStack.size() > 0) {
                    EntityExpression exp = (EntityExpression)entStack.remove(entStack.size() - 1);
                    if (exp instanceof ComplexEntityExpression) {
                        ComplexEntityExpression complexExp = (ComplexEntityExpression)exp;
                        int i = 0;
                        int count = complexExp.getSubExpressionCount();
                        while (i < count) {
                            EntityExpression subExp = complexExp.getSubExpressionAt(i);
                            parentage.put(subExp, complexExp);
                            entStack.add(subExp);
                            ++i;
                        }
                        continue;
                    }
                    if (exp instanceof AtomicEntityExpression) {
                        EntityExpression result;
                        AtomicEntityExpression atomicExp = (AtomicEntityExpression)exp;
                        int typeIndex = 0;
                        int count = atomicExp.getChainLength();
                        while (typeIndex < count) {
                            EntityType entType = atomicExp.getEntityTypeAt(typeIndex);
                            if (atomicExp.getSelectionAt(typeIndex) != null) {
                                selStack.add(atomicExp.getSelectionAt(typeIndex));
                            }
                            while (selStack.size() > 0) {
                                Selection sel = (Selection)selStack.remove(selStack.size() - 1);
                                if (sel instanceof ComplexSelection) {
                                    ComplexSelection complexSel = (ComplexSelection)sel;
                                    int j = 0;
                                    int selCount = complexSel.getSubSelectionCount();
                                    while (j < selCount) {
                                        selStack.add(complexSel.getSubSelectionAt(j));
                                        ++j;
                                    }
                                    continue;
                                }
                                if (sel instanceof AtomicSelection) {
                                    AtomicSelection atomicSel = (AtomicSelection)sel;
                                    EntityType localEntType = atomicSel.getEntityType();
                                    String attrName = atomicSel.getAttriubteName();
                                    CmpOperator cmpOperator = atomicSel.getCmpOperator();
                                    Object value = atomicSel.getValue();
                                    EntityType entityTypeToCheck = entType;
                                    if (localEntType != null && entType != localEntType) {
                                        if (entType == EntityType.SUBSTITUTION_RULE && localEntType == EntityType.ROLE) {
                                            entityTypeToCheck = localEntType;
                                        } else {
                                            entityTypeToCheck = null;
                                            failed = true;
                                            if (!binaryReport) {
                                                if (typeIndex == 0) {
                                                    this.reportError(report, "The entity type " + (Object)((Object)localEntType) + " cannot be used within a selection on the entity type " + (Object)((Object)entType) + "!", DefaultPolicyResolution.tokenInfoToRange(tokenInfos.get(atomicSel + ".entityType")), DefaultPolicyResolution.tokenInfoToRange(tokenInfos.get(atomicExp + ".startEntityType")));
                                                } else {
                                                    NavFunctionInstance funcInst = atomicExp.getFunctionAt(typeIndex - 1);
                                                    this.reportError(report, "The entity type " + (Object)((Object)localEntType) + " cannot be used within a selection on the entity type " + (Object)((Object)entType) + "!", DefaultPolicyResolution.tokenInfoToRange(tokenInfos.get(atomicSel + ".entityType")), DefaultPolicyResolution.tokenInfoToRange(tokenInfos.get(funcInst)));
                                                }
                                            }
                                        }
                                    }
                                    if (entityTypeToCheck == null) continue;
                                    AttributeMetaData meta = explorer.getAttributeMetaData(session, entityTypeToCheck);
                                    AttributeMetaData.MetaDataElement attr = meta.get(attrName);
                                    if (attr == null) {
                                        failed = true;
                                        if (binaryReport) continue;
                                        this.reportError(report, "The entity type " + (Object)((Object)entityTypeToCheck) + " doesn't have an attribute '" + attrName + "'", DefaultPolicyResolution.tokenInfoToRange(tokenInfos.get(atomicSel + ".attributeName")));
                                        continue;
                                    }
                                    DataType odt = value instanceof ParameterRef ? DataType.fromAdeptDataType(((ParameterRef)value).getDataType()) : DataType.getDataTypeForObject(value);
                                    DataType adt = attr.getDataType();
                                    if (cmpOperator != null && !cmpOperator.canCompare(adt, odt)) {
                                        String valueMetaType = value instanceof ParameterRef ? "parameter" : "literal";
                                        failed = true;
                                        if (!binaryReport) {
                                            String msg = "The given %s type %s is not comparable to the attribute type %s!";
                                            msg = String.format(msg, new Object[]{valueMetaType, odt, adt});
                                            this.reportError(report, msg, DefaultPolicyResolution.tokenInfoToRange(tokenInfos.get(atomicSel + ".attributeName")), DefaultPolicyResolution.tokenInfoToRange(tokenInfos.get(atomicSel + ".value")));
                                        }
                                    }
                                    if (attr.getMappedTo() == null || attr.isImported() || binaryReport) continue;
                                    String msg = "The attribute '%s' cannot be accessed in an OrgPolicy. Mapped LDAP attributes can only be accessed if they are imported.";
                                    msg = String.format(msg, attrName);
                                    this.reportError(report, msg, DefaultPolicyResolution.tokenInfoToRange(tokenInfos.get(atomicSel + ".attributeName")));
                                    continue;
                                }
                                String msg = "Unrecognised/unknown subclass of Selection encountered: " + sel.getClass();
                                throw new AssertionError((Object)msg);
                            }
                            ++typeIndex;
                        }
                        if (completion == null || atomicExp.getEndOfChainEntityType() == EntityType.AGENT || (result = this.completePath(atomicExp, completion, report, tokenInfos)) == atomicExp) continue;
                        ComplexEntityExpression parent = (ComplexEntityExpression)parentage.get(atomicExp);
                        if (parent == null) {
                            policy = result;
                            continue;
                        }
                        boolean found = false;
                        int i = 0;
                        int count2 = parent.getSubExpressionCount();
                        while (i < count2) {
                            if (parent.getSubExpressionAt(i) == atomicExp) {
                                parent.replaceSubExpressionAt(i, result);
                                found = true;
                                break;
                            }
                            ++i;
                        }
                        if (!found) {
                            throw new AssertionError((Object)"Sorry, I screwed up!");
                        }
                        continue;
                    }
                    if (exp instanceof DynamicEntityExpression) continue;
                    String msg = "Unrecognised/unknown subclass of EntityExpression encountered: " + exp.getClass();
                    throw new IllegalStateException(msg);
                }
            }
            if (failed && binaryReport) {
                report.addEntry(OrgPolicyReport.ResultType.ERROR, "The parsing failed!", new OrgPolicyReport.Range[0]);
            }
            if (failed || reportOnly) {
                return null;
            }
            EntityExpression entityExpression = policy;
            return entityExpression;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    private EntityExpression completePath(AtomicEntityExpression origAtomicExp, PathCompletion completion, OrgPolicyReport report, TokenInfoContainer tokenInfos) {
        boolean failed = false;
        AtomicEntityExpression atomicExp = origAtomicExp;
        ArrayList<AtomicEntityExpression> forks = new ArrayList<AtomicEntityExpression>(2);
        ComplexEntityExpression cmplExp = null;
        forks.add(atomicExp);
        while (forks.size() > 0) {
            atomicExp = (AtomicEntityExpression)forks.remove(forks.size() - 1);
            EntityType endOfPathType = atomicExp.getEntityTypeAt(atomicExp.getChainLength() - 1);
            if (endOfPathType != EntityType.AGENT) {
                NavFunction[] functions = completion.getCompletionsFor(endOfPathType);
                if (functions == null) {
                    failed = true;
                    if (report == null) {
                        return null;
                    }
                    this.reportError(report, "There is no path completion defined for the entity type " + (Object)((Object)endOfPathType) + "!", DefaultPolicyResolution.tokenInfoToRange(tokenInfos.get(origAtomicExp)));
                    continue;
                }
                int i = 0;
                while (i < functions.length) {
                    NavFunction func = functions[i];
                    if (i == functions.length - 1) {
                        atomicExp.appendFunction(func, TransitivityType.NONE, null);
                        forks.add(atomicExp);
                    } else {
                        AtomicEntityExpression copy = atomicExp.duplicate();
                        copy.appendFunction(func, TransitivityType.NONE, null);
                        forks.add(copy);
                    }
                    ++i;
                }
                continue;
            }
            if (forks.size() > 0 && cmplExp == null) {
                cmplExp = new ComplexEntityExpression(ComplexEntityExpression.Type.UNION);
            }
            if (cmplExp == null) continue;
            cmplExp.addSubExpression(atomicExp);
        }
        if (failed) {
            return null;
        }
        if (cmplExp == null) {
            return atomicExp;
        }
        return cmplExp;
    }

    private static OrgPolicyReport.Range tokenInfoToRange(TokenInfo info) {
        return new OrgPolicyReport.Range(info.getBeginColumn(), info.getEndColumn());
    }

    private void reportWarning(OrgPolicyReport report, String message, OrgPolicyReport.Range ... ranges) {
        if (report != null) {
            report.addEntry(OrgPolicyReport.ResultType.WARNING, message, ranges);
        }
    }

    private void reportError(OrgPolicyReport report, String message, OrgPolicyReport.Range ... ranges) {
        if (report != null) {
            report.addEntry(OrgPolicyReport.ResultType.ERROR, message, ranges);
        }
    }

    @Override
    public boolean isMember(SessionToken session, long orgPositionID, String agentUserName, String orgPolicy) throws PolicyResolutionException, DataSourceException {
        this.orgModelManager.sessionActive(session);
        try {
            if (agentUserName == null) {
                throw new NullArgumentException("The parameter 'agentUserName' must not be null!");
            }
            if (agentUserName.equals("")) {
                throw new NullArgumentException("The parameter 'agentUserName' must not be empty string!");
            }
            Set<QualifiedAgent> results = this.resolvePolicy(session, orgPolicy);
            for (QualifiedAgent res : results) {
                if (res.getOrgPositionID() != orgPositionID || !res.getAgentUserName().equals(agentUserName)) continue;
                return true;
            }
            return false;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public boolean isMember(SessionToken session, long orgPositionID, String orgPolicy) throws PolicyResolutionException, DataSourceException {
        this.orgModelManager.sessionActive(session);
        try {
            Set<QualifiedAgent> results = this.resolvePolicy(session, orgPolicy);
            for (QualifiedAgent res : results) {
                if (res.getOrgPositionID() != orgPositionID) continue;
                return true;
            }
            return false;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    @Override
    public boolean isMember(SessionToken session, String agentUserName, String orgPolicy) throws PolicyResolutionException, DataSourceException {
        this.orgModelManager.sessionActive(session);
        try {
            if (agentUserName == null) {
                throw new NullArgumentException("The parameter 'agentUserName' must not be null!");
            }
            if (agentUserName.equals("")) {
                throw new NullArgumentException("The parameter 'agentUserName' must not be empty string!");
            }
            Set<QualifiedAgent> results = this.resolvePolicy(session, orgPolicy);
            for (QualifiedAgent res : results) {
                if (!res.getAgentUserName().equals(agentUserName)) continue;
                return true;
            }
            return false;
        }
        finally {
            this.orgModelManager.sessionFinished(session);
        }
    }

    private DefaultOrgModelManager omm() {
        return this.orgModelManager;
    }

    private JDBCDataSource getDataSource() {
        return this.orgModelManager.getDataSource();
    }
}

