/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.security.AFCallbackHandler;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.security.SecurityManager;
import de.aristaflow.adept2.base.security.callbackhandler.NameOrgPosSesIDAppNameHandler;
import de.aristaflow.adept2.base.security.callbacks.AppNameCallback;
import de.aristaflow.adept2.base.security.callbacks.OrgPositionChoiceCallback;
import de.aristaflow.adept2.base.security.callbacks.UserSessionIDCallback;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.base.sessionmanagement.defaultimplementation.DefaultClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.defaultimplementation.DefaultSessionFactory;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelException;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultOrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultPolicyResolution;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.OmmDefImplTools;
import de.aristaflow.adept2.model.orgmodel.CmpOperator;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.OrgPolicyReport;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.StreamTools;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;

public class GlobalSecurityManager
implements SecurityManager {
    private final PrivateKey privateKey;
    private final RSAPublicKey publicKey;
    private static final byte[] MODULUS;
    private static final byte[] PUBLIC_EXPONENT;
    private static final byte[] PRIVATE_EXPONENT;
    private final JDBCDataSource dataSource;
    protected final SessionFactory sessionFactory;
    protected final URI[] exportedURIs;
    protected final DefaultOrgModelManager orgModelManager;
    private final boolean caseSensitiveUserName;
    protected final Map<String, String> appNameACL;
    protected final String ACL_APPNAME_OTHER;
    protected final String ACL_APPNAME_NULL;

    static {
        byte[] byArray = new byte[257];
        byArray[1] = -73;
        byArray[2] = -42;
        byArray[3] = -120;
        byArray[4] = -6;
        byArray[5] = 28;
        byArray[6] = 99;
        byArray[7] = 88;
        byArray[8] = 77;
        byArray[9] = -89;
        byArray[10] = -30;
        byArray[11] = 21;
        byArray[12] = -63;
        byArray[13] = -71;
        byArray[14] = 10;
        byArray[15] = -116;
        byArray[16] = -74;
        byArray[17] = 4;
        byArray[18] = -111;
        byArray[19] = -112;
        byArray[20] = 113;
        byArray[21] = 103;
        byArray[22] = 116;
        byArray[23] = 77;
        byArray[24] = -118;
        byArray[25] = 29;
        byArray[26] = 124;
        byArray[27] = 52;
        byArray[28] = 103;
        byArray[29] = 93;
        byArray[30] = -18;
        byArray[31] = 98;
        byArray[32] = 46;
        byArray[33] = 25;
        byArray[34] = -87;
        byArray[35] = -122;
        byArray[36] = 87;
        byArray[37] = -43;
        byArray[38] = -68;
        byArray[39] = -108;
        byArray[40] = -34;
        byArray[41] = 77;
        byArray[42] = 54;
        byArray[43] = 99;
        byArray[44] = 52;
        byArray[45] = -108;
        byArray[46] = -49;
        byArray[47] = -68;
        byArray[48] = -101;
        byArray[49] = 56;
        byArray[50] = 4;
        byArray[51] = 80;
        byArray[52] = 79;
        byArray[53] = 41;
        byArray[54] = -112;
        byArray[55] = 79;
        byArray[56] = 91;
        byArray[57] = -119;
        byArray[58] = 95;
        byArray[59] = -32;
        byArray[60] = -90;
        byArray[61] = -109;
        byArray[62] = 84;
        byArray[63] = -96;
        byArray[64] = 44;
        byArray[65] = -4;
        byArray[66] = 72;
        byArray[67] = -40;
        byArray[68] = 118;
        byArray[69] = -73;
        byArray[70] = -32;
        byArray[71] = 75;
        byArray[72] = 82;
        byArray[73] = 54;
        byArray[74] = 102;
        byArray[75] = 39;
        byArray[76] = -36;
        byArray[77] = 53;
        byArray[78] = -63;
        byArray[79] = -60;
        byArray[80] = 111;
        byArray[81] = 80;
        byArray[82] = 93;
        byArray[83] = -17;
        byArray[84] = -126;
        byArray[85] = 77;
        byArray[86] = -116;
        byArray[87] = -47;
        byArray[88] = -49;
        byArray[89] = 21;
        byArray[90] = -96;
        byArray[91] = 71;
        byArray[92] = -27;
        byArray[93] = 115;
        byArray[94] = -65;
        byArray[95] = 50;
        byArray[96] = -20;
        byArray[97] = 12;
        byArray[98] = 4;
        byArray[99] = 121;
        byArray[100] = 79;
        byArray[101] = 3;
        byArray[102] = 99;
        byArray[103] = -116;
        byArray[104] = -83;
        byArray[105] = -68;
        byArray[106] = -90;
        byArray[107] = -19;
        byArray[108] = -5;
        byArray[109] = -54;
        byArray[110] = 4;
        byArray[111] = -79;
        byArray[112] = 23;
        byArray[113] = -109;
        byArray[114] = 7;
        byArray[115] = -77;
        byArray[116] = 63;
        byArray[117] = -9;
        byArray[118] = -119;
        byArray[119] = 29;
        byArray[120] = 79;
        byArray[121] = -92;
        byArray[122] = 119;
        byArray[123] = 93;
        byArray[124] = 71;
        byArray[125] = 14;
        byArray[126] = -64;
        byArray[127] = -70;
        byArray[128] = 103;
        byArray[129] = -108;
        byArray[130] = 116;
        byArray[131] = 76;
        byArray[132] = -68;
        byArray[133] = -93;
        byArray[134] = 117;
        byArray[135] = -80;
        byArray[136] = -127;
        byArray[137] = 23;
        byArray[138] = -105;
        byArray[139] = 47;
        byArray[140] = -116;
        byArray[141] = 106;
        byArray[142] = 95;
        byArray[143] = -84;
        byArray[144] = -11;
        byArray[145] = 84;
        byArray[146] = 94;
        byArray[147] = 55;
        byArray[148] = -125;
        byArray[149] = 77;
        byArray[150] = 80;
        byArray[151] = -41;
        byArray[152] = 96;
        byArray[153] = 61;
        byArray[154] = 34;
        byArray[155] = -93;
        byArray[156] = -68;
        byArray[157] = 23;
        byArray[158] = 43;
        byArray[159] = 123;
        byArray[160] = 71;
        byArray[161] = -80;
        byArray[162] = 93;
        byArray[163] = 43;
        byArray[164] = -21;
        byArray[165] = 108;
        byArray[166] = -48;
        byArray[167] = 125;
        byArray[168] = 12;
        byArray[169] = 89;
        byArray[170] = 63;
        byArray[171] = 32;
        byArray[172] = -94;
        byArray[173] = 7;
        byArray[174] = 67;
        byArray[175] = -28;
        byArray[176] = 47;
        byArray[177] = -109;
        byArray[178] = 27;
        byArray[179] = 76;
        byArray[180] = -84;
        byArray[181] = -45;
        byArray[182] = -97;
        byArray[183] = -79;
        byArray[184] = -48;
        byArray[185] = 89;
        byArray[186] = 44;
        byArray[187] = -101;
        byArray[188] = 108;
        byArray[189] = -45;
        byArray[190] = -115;
        byArray[191] = -25;
        byArray[192] = 86;
        byArray[193] = -128;
        byArray[194] = 50;
        byArray[195] = 35;
        byArray[196] = -1;
        byArray[197] = 75;
        byArray[198] = -71;
        byArray[199] = -11;
        byArray[200] = 126;
        byArray[201] = 57;
        byArray[202] = -82;
        byArray[203] = 38;
        byArray[204] = 72;
        byArray[205] = -121;
        byArray[206] = -14;
        byArray[207] = -49;
        byArray[208] = -75;
        byArray[209] = 7;
        byArray[210] = 100;
        byArray[211] = 34;
        byArray[212] = 82;
        byArray[213] = -86;
        byArray[214] = 59;
        byArray[215] = -65;
        byArray[216] = -63;
        byArray[217] = -127;
        byArray[218] = 46;
        byArray[219] = -68;
        byArray[220] = 75;
        byArray[221] = -58;
        byArray[222] = 84;
        byArray[223] = -127;
        byArray[224] = -34;
        byArray[225] = 70;
        byArray[226] = -33;
        byArray[227] = 114;
        byArray[228] = -111;
        byArray[229] = -93;
        byArray[230] = -127;
        byArray[231] = -56;
        byArray[232] = -20;
        byArray[233] = 3;
        byArray[234] = 108;
        byArray[235] = -42;
        byArray[236] = 82;
        byArray[237] = 86;
        byArray[238] = 3;
        byArray[239] = 92;
        byArray[240] = -80;
        byArray[241] = 114;
        byArray[242] = 110;
        byArray[243] = 22;
        byArray[244] = -85;
        byArray[245] = 95;
        byArray[246] = 22;
        byArray[247] = 55;
        byArray[248] = -5;
        byArray[249] = 6;
        byArray[250] = -10;
        byArray[251] = -116;
        byArray[252] = -64;
        byArray[253] = 49;
        byArray[254] = 37;
        byArray[255] = -31;
        byArray[256] = -17;
        MODULUS = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[0] = 1;
        byArray2[2] = 1;
        PUBLIC_EXPONENT = byArray2;
        PRIVATE_EXPONENT = new byte[]{112, 57, 117, 122, 48, 97, 102, 121, 121, 118, 108, 53, 121, 103, 52, 118, 118, 119, 55, 118, 114, 107, 53, 102, 51, 110, 110, 105, 51, 98, 110, 105, 108, 110, 52, 55, 53, 111, 48, 98, 107, 97, 109, 108, 97, 114, 56, 111, 102, 114, 53, 109, 99, 54, 117, 114, 104, 119, 117, 114, 105, 121, 105, 98, 50, 108, 48, 101, 121, 119, 99, 52, 117, 108, 100, 121, 99, 103, 104, 100, 108, 55, 108, 97, 106, 121, 115, 55, 114, 112, 112, 104, 107, 108, 114, 104, 48, 101, 53, 49, 53, 54, 57, 105, 52, 55, 54, 53, 105, 52, 116, 54, 48, 112, 55, 100, 116, 103, 114, 109, 112, 116, 98, 51, 107, 119, 53, 98, 114, 54, 119, 50, 107, 112, 49, 115, 117, 107, 120, 112, 98, 101, 112, 115, 52, 116, 51, 97, 113, 118, 115, 109, 97, 112, 104, 110, 53, 97, 106, 51, 49, 98, 108, 122, 99, 120, 117, 50, 54, 117, 121, 103, 111, 111, 112, 116, 99, 54, 112, 49, 99, 103, 99, 49, 122, 48, 118, 51, 113, 120, 115, 50, 49, 57, 115, 50, 108, 55, 120, 52, 106, 120, 120, 121, 51, 119, 119, 117, 105, 100, 107, 118, 103, 50, 109, 114, 109, 53, 103, 53, 113, 57, 115, 50, 111, 102, 99, 53, 108, 106, 106, 120, 49, 100, 57, 51, 51, 110, 48, 49, 56, 56, 53, 113, 110, 53, 120, 54, 55, 49, 50, 114, 121, 110, 121, 102, 97, 55, 101, 55, 52, 57, 112, 117, 116, 119, 110, 116, 121, 107, 116, 118, 107, 103, 109, 110, 107, 109, 120, 110, 102, 111, 98, 51, 51, 49, 101, 115, 107, 53, 105, 98, 120, 54, 108, 55, 114, 53, 57, 50, 101, 104, 56, 50, 53, 107, 109, 48, 103, 102, 101, 117, 49, 117, 103, 48, 99, 49, 111, 97, 114, 116, 107, 103, 118, 115, 116, 107, 115, 97, 113, 107, 111, 120, 122, 114, 117, 116, 97, 98, 98, 122, 51, 99, 100, 111, 111, 119, 121, 104, 52, 100, 102, 110, 100, 113, 108, 101, 57, 48, 104, 116, 114, 111, 120, 108, 109, 112, 56, 98, 115, 97, 57, 48, 56, 118, 106, 101, 121, 113, 111, 107, 56, 50, 110, 122, 106, 56, 98, 51, 119, 117, 113, 116, 56, 104};
    }

    protected GlobalSecurityManager(JDBCDataSource dataSource, SessionFactory sessionFactory, URI[] exportedURIs, DefaultOrgModelManager orgModelManager) throws ConfigurationException {
        this(dataSource, true, sessionFactory, exportedURIs, orgModelManager, GlobalSecurityManager.defaultConfiguration());
    }

    private static Configuration defaultConfiguration() {
        BaseConfiguration conf = new BaseConfiguration();
        return conf;
    }

    protected GlobalSecurityManager(JDBCDataSource dataSource, boolean caseSensitiveUserName, SessionFactory sessionFactory, URI[] exportedURIs, DefaultOrgModelManager orgModelManager, Configuration conf) throws ConfigurationException {
        this.dataSource = dataSource;
        this.sessionFactory = sessionFactory;
        this.exportedURIs = (URI[])exportedURIs.clone();
        this.orgModelManager = orgModelManager;
        this.caseSensitiveUserName = caseSensitiveUserName;
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            String pe = new String(PRIVATE_EXPONENT, "UTF-8");
            BigInteger modulus = new BigInteger(MODULUS);
            this.privateKey = factory.generatePrivate(new RSAPrivateKeySpec(modulus, new BigInteger(pe, 36)));
            this.publicKey = (RSAPublicKey)factory.generatePublic(new RSAPublicKeySpec(modulus, new BigInteger(PUBLIC_EXPONENT)));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new Error("Problems when retrieving the RSA key factory. Aborting.", nsae);
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error("Encoding UTF-8 cannot be found! This is a serious problem.", uee);
        }
        catch (InvalidKeySpecException ikse) {
            throw new Error("Problems when creating the RSA-key pair. Aborting.", ikse);
        }
        HashMap<String, String> acls = new HashMap<String, String>(7);
        SessionToken session = orgModelManager.createSessionToken();
        Configuration appNameACLs = conf.subset("ACL.Logon.Application");
        Iterator appNameACLIt = appNameACLs.getKeys();
        String aclAppnameOther = null;
        String aclAppnameNull = null;
        while (appNameACLIt.hasNext()) {
            String simpleAppName = (String)appNameACLIt.next();
            String acl = appNameACLs.getString(simpleAppName);
            if (acl != null && acl.length() > 0) {
                this.checkResolvability(session, simpleAppName, acl);
            } else {
                acl = null;
            }
            acls.put(simpleAppName, acl);
            if ("Other".equals(simpleAppName)) {
                aclAppnameOther = acl;
                continue;
            }
            if (!"Null".equals(simpleAppName)) continue;
            aclAppnameNull = acl;
        }
        this.appNameACL = Collections.unmodifiableMap(acls);
        this.ACL_APPNAME_OTHER = aclAppnameOther;
        this.ACL_APPNAME_NULL = aclAppnameNull;
    }

    protected void checkResolvability(SessionToken session, String appName, String acl) throws ConfigurationException {
        try {
            DefaultPolicyResolution polRes = this.orgModelManager.getPolicyResolution();
            OrgPolicyReport report = polRes.checkResolvability(session, acl, false, true);
            if (report.getOverallResult() != OrgPolicyReport.ResultType.OK) {
                String msg = "The ACL '%s' restricting access to application '%s' is not a valid SAR. Please adapt the configuration of the org model/security manager.";
                throw new ConfigurationException(String.format(msg, acl, appName));
            }
        }
        catch (DataSourceException dse) {
            String msg = "Could not verify the ACL '%s' restricting access to application '%s' due to problems with the data source.";
            throw new InternalServiceException(String.format(msg, acl, appName), dse);
        }
    }

    @Override
    public List<QualifiedAgent> authenticate(long agentID, String password) throws AuthenticationException, DataSourceException {
        try {
            SessionToken session = this.sessionFactory.getSessionToken(this.exportedURIs);
            Entity agent = this.orgModelManager.getModelExplorer().getEntity(session, EntityType.AGENT, agentID, new String[0]);
            String userName = agent.getString("userName");
            return this.authenticate(userName, password);
        }
        catch (OrgModelException orgModelException) {
            throw new AuthenticationException();
        }
    }

    @Override
    public List<QualifiedAgent> authenticate(String agentName, String password) throws AuthenticationException, DataSourceException {
        ArgChecks.checkForNull(agentName, "agentName");
        ArgChecks.checkForNull(password, "password");
        if (agentName.equals("")) {
            throw new AuthenticationException();
        }
        Long agentID = null;
        if (this.orgModelManager.getLdapAdapter() != null) {
            try {
                this.orgModelManager.getLdapAdapter().authenticate(agentName, password);
                SessionToken session = this.sessionFactory.getSessionToken(this.exportedURIs);
                List<Entity> agents = this.orgModelManager.getModelExplorer().getEntities(session, EntityType.AGENT, "userName", CmpOperator.LIKE_IGNORECASE, (Serializable)((Object)agentName), new String[0]);
                if (agents.size() == 0) {
                    String msg = "The LDAP-authenticated agent '%s' was not found in the Org Model!";
                    msg = String.format(msg, agentName);
                    throw new AuthenticationException(msg);
                }
                Entity agent = agents.get(0);
                agentID = agent.getInteger("id");
                agentName = agent.getString("userName");
            }
            catch (NamingException namingException) {}
        }
        if (agentID == null) {
            password = OmmDefImplTools.hashPassword(password);
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    con = this.dataSource.getConnection();
                    String query = this.caseSensitiveUserName ? "SELECT id, userName FROM Agent WHERE userName = ? AND password = ?" : "SELECT id, userName FROM Agent WHERE UPPER(userName) = UPPER(?) AND password = ?";
                    stmt = con.prepareStatement(query);
                    stmt.setString(1, agentName);
                    stmt.setString(2, password);
                    rs = stmt.executeQuery();
                    boolean correct = rs.next();
                    if (!correct) {
                        throw new AuthenticationException();
                    }
                    agentID = rs.getLong("id");
                    agentName = rs.getString("userName");
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    throw new DataSourceException(e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        }
        if (agentID == null) {
            throw new AuthenticationException();
        }
        return this.getQualifiedAgentsFor(agentID, agentName);
    }

    @Override
    public ClientSessionFactory authenticate(String agentName, long orgPositionID, String password) throws AuthenticationException, DataSourceException {
        List<QualifiedAgent> qualifiedAgents = this.authenticate(agentName, password);
        return this.getAgentAndAuthenticateCombined(orgPositionID, qualifiedAgents, null, password);
    }

    @Override
    public ClientSessionFactory authenticate(String agentName, long orgPositionID, String password, String userSessionID) throws AuthenticationException, DataSourceException {
        List<QualifiedAgent> qualifiedAgents = this.authenticate(agentName, password);
        return this.getAgentAndAuthenticateCombined(orgPositionID, qualifiedAgents, userSessionID, password);
    }

    @Override
    public ClientSessionFactory authenticate(long agentID, long orgPositionID, String password) throws AuthenticationException, DataSourceException {
        List<QualifiedAgent> qualifiedAgents = this.authenticate(agentID, password);
        return this.getAgentAndAuthenticateCombined(orgPositionID, qualifiedAgents, null, password);
    }

    @Override
    public ClientSessionFactory authenticate(long agentID, long orgPositionID, String password, String userSessionID) throws AuthenticationException, DataSourceException {
        List<QualifiedAgent> qualifiedAgents = this.authenticate(agentID, password);
        return this.getAgentAndAuthenticateCombined(orgPositionID, qualifiedAgents, userSessionID, password);
    }

    @Override
    public SessionFactory authenticatePrivileged(String agentName, long orgPositionID, String password) throws AuthenticationException, DataSourceException {
        List<QualifiedAgent> qualifiedAgents = this.authenticate(agentName, password);
        return this.createSessionFactory(orgPositionID, qualifiedAgents);
    }

    @Override
    public SessionFactory authenticatePrivileged(long agentID, long orgPositionID, String password) throws AuthenticationException, DataSourceException {
        List<QualifiedAgent> qualifiedAgents = this.authenticate(agentID, password);
        return this.createSessionFactory(orgPositionID, qualifiedAgents);
    }

    @Override
    public ClientSessionFactory[] authenticateCombined(String method, byte[] authenticationData, AFCallbackHandler callbackHandler) throws AuthenticationException {
        Callback[] callbacks;
        List<QualifiedAgent> agents;
        if (!"UTF-8_PASSWORD".equals(method) || callbackHandler == null) {
            String msg = "In this version of the AristaFlow BPM Suite a combined authentication is only valid with a password and a callback handler accepting at least a NameCallback and optionally a OrgPositionChoiceCallback as well as a UserSessionIDCallback.";
            throw new UnsupportedOperationException(msg);
        }
        ClientSessionFactory[] ret = null;
        try {
            NameCallback name = new NameCallback("Enter the agent name which to authenticate.");
            Callback[] handled = callbackHandler.handle(new Callback[]{name});
            name = (NameCallback)handled[0];
            String agentName = name.getName();
            String password = new String(authenticationData, "UTF-8");
            agents = this.authenticate(agentName, password);
        }
        catch (UnsupportedCallbackException uce) {
            String msg = "No agent name has been provided and the callback handler could not handle the corresponding NameCallback.";
            throw new AuthenticationException(msg, uce);
        }
        catch (UnsupportedEncodingException uee) {
            String msg = "Encoding UTF-8 cannot be found! This is a serious problem. Cannot decode password.";
            throw new RuntimeException(msg, uee);
        }
        catch (IOException ioe) {
            String msg = "No agent name has been provided and the callback handler could not handle the corresponding NameCallback.";
            throw new AuthenticationException(msg, ioe);
        }
        catch (DataSourceException dse) {
            String msg = "Could not authenticate with an UTF-8 password due to problems accessing the database. Please check your OMM database.";
            throw new InternalServiceException(msg, dse);
        }
        OrgPositionChoiceCallback orgPosCallback = null;
        AppNameCallback appName = new AppNameCallback();
        UserSessionIDCallback userSessions = new UserSessionIDCallback(agents);
        if (agents.size() > 1) {
            callbacks = new Callback[3];
            orgPosCallback = new OrgPositionChoiceCallback(agents, true);
            callbacks[0] = orgPosCallback;
            callbacks[1] = appName;
            callbacks[2] = userSessions;
        } else {
            callbacks = new Callback[]{appName, userSessions};
        }
        try {
            callbacks = callbackHandler.handle(callbacks);
            if (callbacks.length > 2) {
                orgPosCallback = (OrgPositionChoiceCallback)callbacks[0];
                appName = (AppNameCallback)callbacks[1];
                userSessions = (UserSessionIDCallback)callbacks[2];
            } else {
                appName = (AppNameCallback)callbacks[0];
                userSessions = (UserSessionIDCallback)callbacks[1];
            }
            if (orgPosCallback != null) {
                agents = orgPosCallback.getSelectedAgentsIDs();
            }
        }
        catch (UnsupportedCallbackException uce) {
            if (uce.getCallback() instanceof OrgPositionChoiceCallback) {
                String msg = "For combined authentication method with more than one organisational positions, a callback handler handling a OrgPositionChoiceCallback needs to be provided.";
                throw new AuthenticationException(msg, uce);
            }
        }
        catch (IOException ioe) {
            String msg = "Choosing the organisational position(s) or retrieving the corresponding user session IDs failed. Since the callback was handled, the callback handler seems to have a problem.";
            throw new AuthenticationException(msg, ioe);
        }
        if ((agents = this.filterAppNameACL(appName.getName(), agents)).size() < 1) {
            String msg = "You are not allowed to logon at this application.";
            throw new AuthenticationException(msg);
        }
        ret = new ClientSessionFactory[agents.size()];
        int i = 0;
        while (i < ret.length) {
            QualifiedAgent agent = agents.get(i);
            ret[i] = this.createClientSessionFactory(agent, userSessions.getUserSessionID(agent));
            ++i;
        }
        return ret;
    }

    protected List<QualifiedAgent> filterAppNameACL(String appName, List<QualifiedAgent> agents) {
        ArrayList<QualifiedAgent> ret = new ArrayList<QualifiedAgent>(agents.size());
        String acl = appName == null ? this.ACL_APPNAME_NULL : (!this.appNameACL.containsKey(appName) ? this.ACL_APPNAME_OTHER : this.appNameACL.get(appName));
        if (acl != null) {
            DefaultPolicyResolution polRes = this.orgModelManager.getPolicyResolution();
            SessionToken session = this.orgModelManager.createSessionToken();
            try {
                Set<QualifiedAgent> allowed = polRes.resolvePolicy(session, acl);
                for (QualifiedAgent agent : agents) {
                    if (!allowed.contains(agent)) continue;
                    ret.add(agent);
                }
            }
            catch (PolicyResolutionException pre) {
                String msg = "Could not resolve the ACL '%s' for application '%s'. This is a serious problem since its resolvability has been checked.";
                msg = String.format(msg, acl, appName);
                throw new InternalServiceException(msg, pre);
            }
            catch (DataSourceException dse) {
                String msg = "Could not resolve the ACL '%s' for application '%s' due to problems with the data source.";
                msg = String.format(msg, acl, appName);
                throw new InternalServiceException(msg, dse);
            }
        }
        return ret;
    }

    protected final <T extends Serializable> T getObjectFromData(String method, byte[] data, Class<T> dataClass) {
        String msg = null;
        Exception exc = null;
        Serializable ret = null;
        try {
            Serializable obj = StreamTools.fromByteArray(data);
            ret = (Serializable)dataClass.cast(obj);
        }
        catch (IOException ioe) {
            msg = "For authentication method '%s' a valid serialised %s needs to be provided.";
            exc = ioe;
        }
        catch (ClassNotFoundException cnfe) {
            msg = "For authentication method '%s' a valid serialised %s needs to be provided.";
            exc = cnfe;
        }
        catch (ClassCastException cce) {
            msg = "For authentication method '%s' a valid serialised %s needs to be provided.";
            exc = cce;
        }
        if (msg != null) {
            msg = String.format(msg, method, dataClass.getCanonicalName());
            throw new IllegalArgumentException(msg, exc);
        }
        return (T)ret;
    }

    protected final ClientSessionFactory getAgentAndAuthenticateCombined(long orgPositionID, List<QualifiedAgent> qualifiedAgents, String userSessionID, String password) throws AuthenticationException {
        QualifiedAgent agent = this.retrieveAgentForPosition(orgPositionID, qualifiedAgents);
        NameOrgPosSesIDAppNameHandler callbackHandler = new NameOrgPosSesIDAppNameHandler(Collections.singletonList(agent), null, userSessionID);
        try {
            return this.authenticateCombined("UTF-8_PASSWORD", password.getBytes("UTF-8"), callbackHandler)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalServiceException("UTF-8 is not available");
        }
    }

    protected final QualifiedAgent retrieveAgentForPosition(long orgPositionID, List<QualifiedAgent> orgPositions) throws AuthenticationException {
        for (QualifiedAgent orgPosition : orgPositions) {
            if (orgPosition.getOrgPositionID() != orgPositionID) continue;
            return orgPosition;
        }
        throw new AuthenticationException();
    }

    protected final List<QualifiedAgent> getQualifiedAgentsFor(long agentID, String agentName) throws DataSourceException {
        SessionToken session = this.sessionFactory.getSessionToken(this.exportedURIs);
        List<Entity> orgPositionEntities = this.orgModelManager.getModelExplorer().getRelatedEntities(session, EntityType.AGENT, agentID, RelationType.ORG_POSITION_OCCUPATION, false, new String[0]);
        ArrayList<QualifiedAgent> ret = new ArrayList<QualifiedAgent>(orgPositionEntities.size());
        for (Entity orgPosition : orgPositionEntities) {
            ret.add(new QualifiedAgent(agentID, agentName, orgPosition.getInteger("id"), orgPosition.getString("name")));
        }
        return ret;
    }

    protected final ClientSessionFactory createClientSessionFactory(QualifiedAgent agent, String userSessionID) {
        DefaultClientSessionFactory ret;
        if (userSessionID != null) {
            agent = new QualifiedAgent(agent.getAgentID(), agent.getAgentUserName(), agent.getOrgPositionID(), agent.getOrgPositionName(), userSessionID);
        }
        try {
            ret = new DefaultClientSessionFactory(agent, new SignedSecurityToken(agent, this.privateKey, SystemProperties.useSignedObject()));
        }
        catch (SecurityTokenIntegrityException stie) {
            throw new InternalServiceException("The security token fo the client session factory could not be created. See encapsulated exception.", stie);
        }
        SessionToken session = ret.getSessionToken(this.exportedURIs);
        try {
            ret.setAuthenticatedAgent(this.orgModelManager.getModelExplorer().getRichAgent(session, agent));
        }
        catch (DataSourceException dse) {
            String msg = String.format("The rich agent for the qualified agent '%s' could not be retrieved. There are problems connecting to the data source for the information. Please contact your database or network administrator.", agent);
            throw new InternalServiceException(msg, dse);
        }
        return ret;
    }

    protected final SessionFactory createSessionFactory(long orgPositionID, List<QualifiedAgent> qualifiedAgents) throws AuthenticationException {
        DefaultSessionFactory ret;
        QualifiedAgent agent = this.retrieveAgentForPosition(orgPositionID, qualifiedAgents);
        try {
            ret = new DefaultSessionFactory(new SignedSecurityToken(agent, this.privateKey, SystemProperties.useSignedObject()), this.publicKey);
        }
        catch (SecurityTokenIntegrityException stie) {
            throw new InternalServiceException("The security token fo the client session factory could not be created. See encapsulated exception.", stie);
        }
        return ret;
    }
}

