/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationDescriptionTools;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.ConfigurationValidator;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.AttributeMetaData;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelException;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultModelExplorer;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultOrgModelManager;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.DataSourceException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="ProviderURL", isRequired=true), @Property(name="AutoAcceptSSLCert", type=Property.Type.BOOLEAN, defaultValue="false"), @Property(name="BaseDN", isRequired=true), @Property(name="UseLDAPAuth", type=Property.Type.BOOLEAN, isRequired=true), @Property(name="AuthMech"), @Property(name="UserDN"), @Property(name="Password")}, validator=ConfValidator.class)
class LdapAdapter {
    static final String CFG_PROVIDER_URL = "ProviderURL";
    static final String CFG_AUTO_ACCEPT_SSLCERT = "AutoAcceptSSLCert";
    static final String CFG_BASE_DN = "BaseDN";
    static final String CFG_USER_DN = "UserDN";
    static final String CFG_PASSWORD = "Password";
    static final String CFG_AUTH_MECH = "AuthMech";
    static final String CFG_USE_LDAP_AUTH = "UseLDAPAuth";
    private DefaultOrgModelManager orgModelManager;
    private String providerURL;
    private boolean autoAcceptSSLCert;
    private String userDN;
    private String password;
    private String authMech;
    private String baseDN;
    private boolean authentication;
    private final Map<EntityType, Set<LdapMapping>> mappings;

    LdapAdapter(DefaultOrgModelManager orgModelManager, Configuration configuration) throws ConfigurationException {
        this.orgModelManager = orgModelManager;
        ConfigurationDescriptionTools.validateConfiguration(configuration, LdapAdapter.class, "LdapAdapter");
        this.providerURL = configuration.getString(CFG_PROVIDER_URL);
        this.autoAcceptSSLCert = configuration.getBoolean(CFG_AUTO_ACCEPT_SSLCERT);
        this.userDN = configuration.getString(CFG_USER_DN);
        try {
            this.password = ConfigurationTools.parsePassword(configuration, CFG_PASSWORD);
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.password = configuration.getString(CFG_PASSWORD);
        }
        this.authMech = configuration.getString(CFG_AUTH_MECH);
        this.baseDN = configuration.getString(CFG_BASE_DN);
        this.authentication = configuration.getBoolean(CFG_USE_LDAP_AUTH);
        this.mappings = new HashMap<EntityType, Set<LdapMapping>>();
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType entityType = entityTypeArray[n2];
            HashSet<LdapMapping> entityTypeMappings = new HashSet<LdapMapping>();
            this.mappings.put(entityType, entityTypeMappings);
            String keyNodeRDN = String.valueOf(entityType.policyToken()) + "-ContextRDN";
            String keyFilter = String.valueOf(entityType.policyToken()) + "-ContextFilter";
            String keyScope = String.valueOf(entityType.policyToken()) + "-ContextSearchScope";
            List list = configuration.getList(keyNodeRDN);
            for (String contextRDN : list) {
                LdapMapping mapping = new LdapMapping();
                if (contextRDN == null) continue;
                mapping.contextDN = String.valueOf(contextRDN) + "," + this.baseDN;
                mapping.contextFilter = configuration.getString(keyFilter);
                String scope = configuration.getString(keyScope);
                if (scope.equalsIgnoreCase("object")) {
                    mapping.contextSearchScope = 0;
                } else if (scope.equalsIgnoreCase("onelevel")) {
                    mapping.contextSearchScope = 1;
                } else if (scope.equalsIgnoreCase("subtree")) {
                    mapping.contextSearchScope = 2;
                }
                entityTypeMappings.add(mapping);
            }
            ++n2;
        }
    }

    void authenticate(String userName, String password) throws NamingException {
        ArgChecks.checkForNull(userName, "userName");
        ArgChecks.checkForNull(password, "password");
        if (!this.authentication) {
            String msg = "LDAP authentication is not activated in the LDAP adapter!";
            throw new NamingException(msg);
        }
        if (password.length() == 0) {
            throw new NamingException("Empty password not allowed.");
        }
        String agentDN = this.resolveUid(userName);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.providerURL);
        env.put("java.naming.security.principal", agentDN);
        env.put("java.naming.security.credentials", password);
        if (this.authMech.length() > 0) {
            env.put("java.naming.security.authentication", this.authMech);
        }
        if (this.autoAcceptSSLCert && this.providerURL.startsWith("ldaps:")) {
            env.put("java.naming.ldap.factory.socket", "de.aristaflow.adept2.util.net.OvertrustfulSSLSocketFactory");
        }
        InitialContext authCtx = null;
        try {
            authCtx = new InitialContext(env);
            authCtx.close();
        }
        catch (Throwable throwable) {
            if (authCtx != null) {
                try {
                    authCtx.close();
                }
                catch (NamingException namingException) {}
            }
            throw throwable;
        }
        if (authCtx != null) {
            try {
                authCtx.close();
            }
            catch (NamingException namingException) {}
        }
    }

    DirContext createContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.providerURL);
        if (this.userDN.length() > 0) {
            env.put("java.naming.security.principal", this.userDN);
            env.put("java.naming.security.credentials", this.password);
        }
        if (this.authMech.length() > 0) {
            env.put("java.naming.security.authentication", this.authMech);
        }
        if (this.autoAcceptSSLCert && this.providerURL.startsWith("ldaps:")) {
            env.put("java.naming.ldap.factory.socket", "de.aristaflow.adept2.util.net.OvertrustfulSSLSocketFactory");
        }
        return new InitialDirContext(env);
    }

    String[] getLdapAttributes(String nodeDN, String ... attrNames) throws NamingException {
        String[] stringArray;
        block8: {
            ArgChecks.checkForNull(nodeDN, "nodeDN");
            ArgChecks.checkForNulls(attrNames, "attrNames");
            DirContext ctx = null;
            try {
                ctx = this.createContext();
                Attributes attrs = ctx.getAttributes(nodeDN);
                String[] values = new String[attrNames.length];
                int i = 0;
                while (i < attrNames.length) {
                    String attrName = attrNames[i];
                    Attribute attr = attrs.get(attrName);
                    values[i] = attr == null || attr.get() == null ? null : attr.get().toString();
                    ++i;
                }
                ctx.close();
                stringArray = values;
                if (ctx == null) break block8;
            }
            catch (Throwable throwable) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException namingException) {}
                }
                throw throwable;
            }
            try {
                ctx.close();
            }
            catch (NamingException namingException) {}
        }
        return stringArray;
    }

    void setLdapAttributes(String nodeDN, Map<String, String> attributes) throws NamingException {
        ArgChecks.checkForNull(nodeDN, "nodeDN");
        ArgChecks.checkForNulls(attributes, "attributes");
        DirContext ctx = null;
        try {
            ctx = this.createContext();
            ModificationItem[] mods = new ModificationItem[attributes.size()];
            int i = 0;
            for (Map.Entry<String, String> attrEntry : attributes.entrySet()) {
                mods[i] = new ModificationItem(2, new BasicAttribute(attrEntry.getKey(), attrEntry.getValue()));
                ++i;
            }
            ctx.modifyAttributes(nodeDN, mods);
            ctx.close();
        }
        catch (Throwable throwable) {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
            throw throwable;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {}
        }
    }

    String resolveUid(String uid) throws NamingException {
        try {
            SessionToken session = this.orgModelManager.createSessionToken();
            DefaultModelExplorer exp = this.orgModelManager.getModelExplorer();
            AttributeMetaData meta = exp.getAttributeMetaData(session, EntityType.AGENT);
            Set<LdapMapping> mappings = this.getMappings(EntityType.AGENT);
            if (mappings.isEmpty()) {
                throw new IllegalStateException("LDAP authentication requires a synchronisation mapping for Agents.");
            }
            String agentDN = null;
            for (LdapMapping mapping : mappings) {
                String userNameFilter = String.valueOf(meta.get("userName").getMappedTo()) + "=" + uid;
                String filter = mapping.contextFilter.trim().length() > 0 ? String.format("(&(%s)(%s))", mapping.contextFilter, userNameFilter) : userNameFilter;
                SearchControls constraints = new SearchControls();
                constraints.setSearchScope(mapping.contextSearchScope);
                constraints.setReturningAttributes(new String[0]);
                DirContext ctx = this.orgModelManager.getLdapAdapter().createContext();
                NamingEnumeration<SearchResult> nodes = ctx.search(mapping.contextDN, filter, constraints);
                if (!nodes.hasMore()) continue;
                SearchResult sr = nodes.next();
                agentDN = sr.getNameInNamespace();
                if (!nodes.hasMore()) continue;
                String msg = "More than one user found in LDAP with the name %s!";
                msg = String.format(msg, uid);
                throw new NamingException(msg);
            }
            if (agentDN == null) {
                String msg = "No user found in LDAP with the name '%s'!";
                msg = String.format(msg, uid);
                throw new NamingException(msg);
            }
            return agentDN;
        }
        catch (OrgModelException ex) {
            throw new NamingException(String.valueOf(ex.getClass().getName()) + ": " + ex.getMessage());
        }
        catch (DataSourceException ex) {
            throw new NamingException(String.valueOf(ex.getClass().getName()) + ": " + ex.getMessage());
        }
    }

    Set<LdapMapping> getMappings(EntityType entityType) {
        Set<LdapMapping> result = this.mappings.get((Object)entityType);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public static class ConfValidator
    extends ConfigurationValidator {
        @Override
        protected void validate(Configuration configuration) throws ConfigurationException {
            EntityType[] entityTypeArray = EntityType.values();
            int n = entityTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EntityType entityType = entityTypeArray[n2];
                String keyNodeRDN = String.valueOf(entityType.policyToken()) + "-ContextRDN";
                String keyFilter = String.valueOf(entityType.policyToken()) + "-ContextFilter";
                String keyScope = String.valueOf(entityType.policyToken()) + "-ContextSearchScope";
                String contextRDN = configuration.getString(keyNodeRDN);
                String contextFilter = configuration.getString(keyFilter);
                String scope = configuration.getString(keyScope);
                if (contextRDN != null) {
                    if (!(scope.equalsIgnoreCase("object") || scope.equalsIgnoreCase("onelevel") || scope.equalsIgnoreCase("subtree"))) {
                        String desc = "encountered '%s'; expected one of 'object', 'onelevel' or 'subtree'";
                        desc = String.format(desc, scope);
                        this.rebukeIllegalValue(configuration, keyScope, desc);
                    }
                    if (contextRDN.trim().length() == 0) {
                        this.rebukeIllegalValue(configuration, keyNodeRDN, "must not be blank");
                    }
                    if (contextFilter == null || contextFilter.trim().length() == 0) {
                        this.rebukeIllegalValue(configuration, keyFilter, "must not be null or blank");
                    }
                }
                ++n2;
            }
        }
    }

    static class LdapMapping {
        String contextDN;
        String contextFilter;
        int contextSearchScope;

        LdapMapping() {
        }
    }
}

