/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationDescriptionTools;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.ConfigurationValidator;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.AttributeMetaData;
import de.aristaflow.adept2.core.orgmodelmanager.ModelExplorer;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelException;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultModelChangeOperations;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultModelExplorer;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultOrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.LdapAdapter;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.LdapRelationResolver;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.SQLTableNames;
import de.aristaflow.adept2.model.orgmodel.CmpOperator;
import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.NavFunction;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.ExecutorTools;
import de.aristaflow.adept2.util.HashCalc;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="SyncInterval", description="The time between two synchronisation runs in minutes. 0: don't synchronise", type=Property.Type.INT, defaultValue="1800", restrictions={"range: 0 to x"}), @Property(name="BaseDN", isRequired=true), @Property(name="AutoGenOrgPosForAgents", type=Property.Type.BOOLEAN, defaultValue="false"), @Property(name="RelationResolver")}, validator=ConfValidator.class)
class LdapSynchroniser {
    final Logger logger = LoggerTools.getLogger(this);
    protected static final String CFG_SYNC_PERIOD = "SyncInterval";
    protected static final String CFG_BASE_DN = "BaseDN";
    protected static final String CFG_AUTOGEN_ORGPOS_FOR_AGENTS = "AutoGenOrgPosForAgents";
    protected static final String CFG_RELATION_RESOLVER = "RelationResolver";
    public static final String SEQID_SYNC_UPDATE_ID = "currentLDAPSyncUpdateID";
    public static final String ATTR_LDAP_DN = "ldapDN";
    public static final String ATTR_LDAP_SYNC_UPDATE_ID = "ldapSyncUpdateID";
    private DefaultOrgModelManager orgModelManager;
    private ScheduledExecutorService executor;
    private final int syncInterval;
    private final String baseDN;
    private final boolean autoGenOrgPosForAgents;
    private LdapRelationResolver relationResolver;
    private final ReentrantLock syncLock = new ReentrantLock();
    private boolean isSynchronising = false;

    public LdapSynchroniser(DefaultOrgModelManager orgModelManager, Configuration configuration) throws ConfigurationException {
        this.orgModelManager = orgModelManager;
        ConfigurationDescriptionTools.validateConfiguration(configuration, LdapSynchroniser.class, "LdapSynchroniser");
        this.syncInterval = configuration.getInt(CFG_SYNC_PERIOD);
        this.baseDN = configuration.getString(CFG_BASE_DN);
        this.autoGenOrgPosForAgents = configuration.getBoolean(CFG_AUTOGEN_ORGPOS_FOR_AGENTS);
        String relationResolverClass = configuration.getString(CFG_RELATION_RESOLVER);
        if (relationResolverClass.length() > 0) {
            Configuration resolverConfiguration = configuration.subset(CFG_RELATION_RESOLVER);
            try {
                Class<?> clazz = Class.forName(relationResolverClass);
                if (LdapRelationResolver.class.isAssignableFrom(clazz)) {
                    Class<LdapRelationResolver> resolverClass = clazz.asSubclass(LdapRelationResolver.class);
                    Constructor<LdapRelationResolver> resolverConstructor = resolverClass.getConstructor(Configuration.class);
                    this.relationResolver = resolverConstructor.newInstance(resolverConfiguration);
                }
            }
            catch (Exception ex) {
                throw new ConfigurationException("", ex);
            }
        }
    }

    void start() {
        Adept2ThreadFactory factory = new Adept2ThreadFactory("LdapSychroniser", this.logger);
        this.executor = ExecutorTools.createScheduledExecutor(1, factory);
        if (this.syncInterval > 0) {
            this.executor.scheduleWithFixedDelay(new SynchroniserTask(), 10L, (long)this.syncInterval * 60L, TimeUnit.SECONDS);
        } else {
            this.executor.schedule(new SynchroniserTask(), 10L, TimeUnit.SECONDS);
        }
    }

    void shutdown() {
        this.executor.shutdownNow();
        ExecutorTools.awaitTermination(this.executor);
        this.orgModelManager = null;
    }

    void emergencyShutdown() {
        this.executor.shutdownNow();
        ExecutorTools.awaitTermination(this.executor);
        this.orgModelManager = null;
    }

    public void synchronise(boolean blockUntilDone) {
        Future<?> future = this.executor.submit(new SynchroniserTask());
        if (blockUntilDone) {
            boolean syncFinished = false;
            while (!syncFinished) {
                try {
                    future.get();
                    syncFinished = true;
                }
                catch (CancellationException cancellationException) {
                    syncFinished = true;
                }
                catch (InterruptedException interruptedException) {
                    syncFinished = false;
                }
                catch (ExecutionException executionException) {
                    syncFinished = true;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private void synchronise() {
        this.syncLock.lock();
        if (this.isSynchronising) {
            return;
        }
        this.isSynchronising = true;
        this.syncLock.unlock();
        try {
            try {
                block95: {
                    this.logger.info("synchronisation run started");
                    SessionToken session = this.orgModelManager.createSessionToken();
                    DefaultModelExplorer exp = this.orgModelManager.getModelExplorer();
                    DefaultModelChangeOperations chop = this.orgModelManager.getModelChangeOperations();
                    ExtendedConnection con = null;
                    Statement stmt = null;
                    DirContext ctx = null;
                    try {
                        EntityType[] entityTypeArray;
                        NavFunction[] attrs;
                        String msg;
                        ctx = this.orgModelManager.getLdapAdapter().createContext();
                        con = this.orgModelManager.getDataSource().getConnection();
                        if (!con.sequenceExists(SEQID_SYNC_UPDATE_ID)) {
                            con.createSequence(SEQID_SYNC_UPDATE_ID, 1L, 1L);
                        }
                        long syncUpdateID = con.nextID(SEQID_SYNC_UPDATE_ID);
                        EntityType[] entityTypeArray2 = EntityType.values();
                        int n = entityTypeArray2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            EntityType entityType = entityTypeArray2[n2];
                            if (!exp.hasAttribute(session, entityType, ATTR_LDAP_DN)) {
                                chop.addAttribute(session, entityType, ATTR_LDAP_DN, DataType.STRING, 200);
                                stmt = con.createStatement();
                                String update = "CREATE INDEX IDX_%s_LDAP_DN ON %s (%s)";
                                update = String.format(update, new Object[]{entityType, SQLTableNames.getTableNameFor(entityType), ATTR_LDAP_DN});
                                stmt.executeUpdate(update);
                                stmt = JDBCTools.close(stmt);
                            }
                            if (!exp.hasAttribute(session, entityType, ATTR_LDAP_SYNC_UPDATE_ID)) {
                                chop.addAttribute(session, entityType, ATTR_LDAP_SYNC_UPDATE_ID, DataType.INTEGER);
                            }
                            ++n2;
                        }
                        con = JDBCTools.close(con);
                        if (Thread.interrupted()) {
                            throw new InterruptedException("LDAP synchronisation was cancelled.");
                        }
                        boolean agentSyncSkipped = false;
                        EntityType[] entityTypeArray3 = EntityType.values();
                        int n3 = entityTypeArray3.length;
                        n = 0;
                        while (n < n3) {
                            EntityType entityType = entityTypeArray3[n];
                            Set<LdapAdapter.LdapMapping> mappings = this.orgModelManager.getLdapAdapter().getMappings(entityType);
                            if (!mappings.isEmpty()) {
                                AttributeMetaData.MetaDataElement agentMeta;
                                msg = "synchronising %ss";
                                msg = String.format(msg, entityType.policyToken());
                                this.logger.info(msg);
                                if (entityType == EntityType.AGENT && !(agentMeta = exp.getAttributeMetaData(session, entityType).get("userName")).isImported()) {
                                    String msg2 = "To synchronise agents a mapping for the 'userName' attribute is required! Skipping agent synchronisation.";
                                    this.logger.severe(msg2);
                                    agentSyncSkipped = true;
                                } else {
                                    for (LdapAdapter.LdapMapping mapping : mappings) {
                                        if (Thread.interrupted()) {
                                            throw new InterruptedException("LDAP synchronisation was cancelled.");
                                        }
                                        SearchControls constraints = new SearchControls();
                                        constraints.setSearchScope(mapping.contextSearchScope);
                                        NamingEnumeration<SearchResult> nodes = ctx.search(mapping.contextDN, mapping.contextFilter, constraints);
                                        AttributeMetaData meta = exp.getAttributeMetaData(session, entityType);
                                        while (nodes.hasMore()) {
                                            long entityID;
                                            String userName;
                                            if (Thread.interrupted()) {
                                                throw new InterruptedException("LDAP synchronisation was cancelled.");
                                            }
                                            SearchResult sr = nodes.next();
                                            attrs = sr.getAttributes();
                                            Entity syncEntity = new Entity(entityType);
                                            for (AttributeMetaData.MetaDataElement omAttr : meta) {
                                                if (!omAttr.isImported()) continue;
                                                String omName = omAttr.getName();
                                                DataType dataType = omAttr.getDataType();
                                                String ldapName = omAttr.getMappedTo();
                                                Attribute attribute = attrs.get(ldapName);
                                                Object ldapValue = null;
                                                if (attribute != null) {
                                                    ldapValue = attribute.get();
                                                }
                                                String ldapValueString = null;
                                                if (ldapValue != null) {
                                                    ldapValueString = ldapValue.toString();
                                                }
                                                switch (dataType) {
                                                    case STRING: {
                                                        syncEntity.setString(omName, ldapValueString);
                                                        break;
                                                    }
                                                    case INTEGER: {
                                                        Long integer = null;
                                                        if (ldapValueString != null) {
                                                            try {
                                                                integer = Long.valueOf(ldapValueString);
                                                            }
                                                            catch (NumberFormatException numberFormatException) {
                                                                String msg3 = "The LDAP node '%s' has a value in its attribute '%s' that can't be mapped to the data type INTEGER: '%s'";
                                                                msg3 = String.format(msg3, sr.getNameInNamespace(), ldapName, ldapValueString);
                                                                this.logger.severe(msg3);
                                                            }
                                                        }
                                                        syncEntity.set(omName, integer);
                                                        break;
                                                    }
                                                    case NULL: {
                                                        throw new IllegalArgumentException("NULL as data type not allowed here");
                                                    }
                                                    default: {
                                                        throw new IllegalArgumentException("data type " + (Object)((Object)dataType) + " not yet implemented");
                                                    }
                                                }
                                            }
                                            syncEntity.setInteger(ATTR_LDAP_SYNC_UPDATE_ID, syncUpdateID);
                                            if (entityType == EntityType.AGENT && syncEntity.getString("userName") == null) {
                                                String msg4 = "The user name for '%s' is not set in LDAP, therefore the agent cannot be synchronised.";
                                                msg4 = String.format(msg4, sr.getNameInNamespace());
                                                this.logger.warning(msg4);
                                                continue;
                                            }
                                            List<Entity> result = exp.getEntities(session, entityType, ATTR_LDAP_DN, CmpOperator.EQUAL, (Serializable)((Object)sr.getNameInNamespace()), "id", ATTR_LDAP_DN);
                                            if (entityType == EntityType.AGENT && result.isEmpty() && !(result = exp.getEntities(session, entityType, "userName", CmpOperator.EQUAL, (Serializable)((Object)(userName = syncEntity.getString("userName"))), "id", ATTR_LDAP_DN)).isEmpty()) {
                                                Entity existingAgent = result.get(0);
                                                if (existingAgent.get(ATTR_LDAP_DN) == null) {
                                                    String msg5 = "The user name '%s' is already used for an unsynchronised agent. If the LDAP synchronisation should from now on update this agent, simply set its attribute '%s' to an arbitrary value.";
                                                    msg5 = String.format(msg5, userName, ATTR_LDAP_DN);
                                                    this.logger.warning(msg5);
                                                    continue;
                                                }
                                                syncEntity.setString(ATTR_LDAP_DN, sr.getNameInNamespace());
                                            }
                                            if (!result.isEmpty()) {
                                                entityID = result.get(0).getInteger("id");
                                                if (syncEntity.getAttributeCount() > 0) {
                                                    syncEntity.set("id", entityID);
                                                    chop.createOrUpdateEntity(session, syncEntity, false, true);
                                                }
                                            } else {
                                                syncEntity.setString(ATTR_LDAP_DN, sr.getNameInNamespace());
                                                try {
                                                    entityID = chop.createOrUpdateEntity(session, syncEntity, true, true);
                                                }
                                                catch (OrgModelException ex) {
                                                    String msg6 = "The LDAP entity '%s' could not be synchronised to the OrgModel.";
                                                    msg6 = String.format(msg6, sr.getNameInNamespace());
                                                    this.logger.log(Level.WARNING, msg6, ex);
                                                    continue;
                                                }
                                            }
                                            if (!this.autoGenOrgPosForAgents || entityType != EntityType.AGENT) continue;
                                            String autoOrgPosKey = "AutoGenFor:Agent(" + sr.getNameInNamespace() + ")";
                                            this.createDummyOrgPosition(autoOrgPosKey, syncEntity.getString("userName"), entityID, syncUpdateID, null, -1L, exp, chop, session);
                                        }
                                        nodes.close();
                                    }
                                }
                            }
                            ++n;
                        }
                        HashMap allRelations = new HashMap();
                        if (this.relationResolver != null) {
                            entityTypeArray = EntityType.values();
                            int n4 = entityTypeArray.length;
                            n3 = 0;
                            while (n3 < n4) {
                                EntityType entityType = entityTypeArray[n3];
                                if (!(this.orgModelManager.getLdapAdapter().getMappings(entityType).isEmpty() || entityType == EntityType.ORG_POSITION && this.relationResolver.getAutoGenerateOrgPositions())) {
                                    msg = "synchronising %s relations";
                                    msg = String.format(msg, entityType.policyToken());
                                    this.logger.info(msg);
                                    List<Entity> entities = exp.getEntities(session, entityType, ATTR_LDAP_DN, CmpOperator.NOT_EQUAL, null, "id", ATTR_LDAP_DN);
                                    for (Entity entity : entities) {
                                        attrs = entityType.getNavFunctions();
                                        int sr = attrs.length;
                                        int meta = 0;
                                        while (meta < sr) {
                                            NavFunction navFunction = attrs[meta];
                                            if (Thread.interrupted()) {
                                                throw new InterruptedException("LDAP synchronisation was cancelled.");
                                            }
                                            if (this.relationResolver.canProvideRelatedEntities(navFunction)) {
                                                HashSet<Tuple> relations = (HashSet<Tuple>)allRelations.get((Object)navFunction.relationType());
                                                if (relations == null) {
                                                    relations = new HashSet<Tuple>();
                                                    allRelations.put(navFunction.relationType(), relations);
                                                }
                                                EntityType targetEntityType = navFunction.target();
                                                boolean insertOrgPosition = false;
                                                if (targetEntityType == EntityType.ORG_POSITION && this.relationResolver.getAutoGenerateOrgPositions()) {
                                                    insertOrgPosition = true;
                                                    targetEntityType = entityType == EntityType.AGENT ? EntityType.ORG_UNIT : EntityType.AGENT;
                                                }
                                                List<String> relEntities = this.relationResolver.getRelatedEntities(entity.getString(ATTR_LDAP_DN), navFunction, ctx);
                                                for (String relEntityDN : relEntities) {
                                                    long id2;
                                                    long id1;
                                                    long targetID;
                                                    if (Thread.interrupted()) {
                                                        throw new InterruptedException("LDAP synchronisation was cancelled.");
                                                    }
                                                    List<Entity> targetEntity = exp.getEntities(session, targetEntityType, ATTR_LDAP_DN, CmpOperator.EQUAL, (Serializable)((Object)relEntityDN), "id");
                                                    if (targetEntity.size() == 0) {
                                                        String msg7 = "The LdapRelationResolver returned the entity DN '%s' which has not been mapped into the OrgModel or at least not as %s.";
                                                        msg7 = String.format(msg7, new Object[]{relEntityDN, targetEntityType});
                                                        this.logger.warning(msg7);
                                                        continue;
                                                    }
                                                    long sourceID = entity.getInteger("id");
                                                    if (insertOrgPosition) {
                                                        long otherID;
                                                        long agentID;
                                                        String dn1 = entity.getString(ATTR_LDAP_DN);
                                                        LdapName name1 = new LdapName(dn1);
                                                        String dn2 = relEntityDN;
                                                        LdapName name2 = new LdapName(dn2);
                                                        if (entityType == EntityType.AGENT) {
                                                            agentID = entity.getInteger("id");
                                                            otherID = targetEntity.get(0).getInteger("id");
                                                            String tempDN = dn1;
                                                            dn1 = dn2;
                                                            dn2 = tempDN;
                                                            LdapName tempName = name1;
                                                            name1 = name2;
                                                            name2 = tempName;
                                                        } else {
                                                            agentID = targetEntity.get(0).getInteger("id");
                                                            otherID = entity.getInteger("id");
                                                        }
                                                        String autoOrgPosKey = "AutoGenFor:%s(%s+%s)";
                                                        autoOrgPosKey = String.format(autoOrgPosKey, new Object[]{navFunction.relationType(), dn1, dn2});
                                                        String autoOrgPosName = name1.getRdn(name1.size() - 1).getValue() + ": " + name2.getRdn(name2.size() - 1).getValue();
                                                        targetID = this.createDummyOrgPosition(autoOrgPosKey, autoOrgPosName, agentID, syncUpdateID, navFunction.relationType(), otherID, exp, chop, session);
                                                    } else {
                                                        targetID = targetEntity.get(0).getInteger("id");
                                                    }
                                                    if (navFunction.isLeftToRight()) {
                                                        id1 = sourceID;
                                                        id2 = targetID;
                                                    } else {
                                                        id1 = targetID;
                                                        id2 = sourceID;
                                                    }
                                                    if (!exp.relationExists(session, navFunction.relationType(), id1, id2)) {
                                                        chop.addRelation(session, navFunction.relationType(), id1, id2);
                                                    }
                                                    relations.add(new Tuple(id1, id2));
                                                }
                                            }
                                            ++meta;
                                        }
                                    }
                                }
                                ++n3;
                            }
                        }
                        entityTypeArray = EntityType.values();
                        int n5 = entityTypeArray.length;
                        n3 = 0;
                        while (n3 < n5) {
                            EntityType entityType = entityTypeArray[n3];
                            if (Thread.interrupted()) {
                                throw new InterruptedException("LDAP synchronisation was cancelled.");
                            }
                            if ((!agentSyncSkipped || entityType != EntityType.AGENT && entityType != EntityType.ORG_POSITION) && (!this.orgModelManager.getLdapAdapter().getMappings(entityType).isEmpty() || entityType == EntityType.ORG_POSITION && this.autoGenOrgPosForAgents)) {
                                List<Entity> obsoleteEntities = exp.getEntities(session, entityType, ATTR_LDAP_SYNC_UPDATE_ID, CmpOperator.LESS_THAN, Long.valueOf(syncUpdateID), "id");
                                for (Entity entity : obsoleteEntities) {
                                    if (Thread.interrupted()) {
                                        throw new InterruptedException("LDAP synchronisation was cancelled.");
                                    }
                                    String msg8 = "deleting %s #%d";
                                    msg8 = String.format(msg8, entityType.policyToken(), entity.get("id"));
                                    this.logger.info(msg8);
                                    chop.deleteEntity(session, entityType, entity.getInteger("id"));
                                }
                            }
                            ++n3;
                        }
                        if (this.relationResolver != null) {
                            entityTypeArray = EntityType.values();
                            n5 = entityTypeArray.length;
                            n3 = 0;
                            while (n3 < n5) {
                                EntityType entityType = entityTypeArray[n3];
                                NavFunction[] navFunctionArray = entityType.getNavFunctions();
                                int n6 = navFunctionArray.length;
                                int n7 = 0;
                                while (n7 < n6) {
                                    NavFunction navFunction = navFunctionArray[n7];
                                    if (Thread.interrupted()) {
                                        throw new InterruptedException("LDAP synchronisation was cancelled.");
                                    }
                                    Set relations = (Set)allRelations.get((Object)navFunction.relationType());
                                    if (relations != null) {
                                        List<Entity> entities = exp.getEntities(session, entityType, ATTR_LDAP_DN, CmpOperator.NOT_EQUAL, null, "id");
                                        for (Entity entity : entities) {
                                            if (Thread.interrupted()) {
                                                throw new InterruptedException("LDAP synchronisation was cancelled.");
                                            }
                                            long id1 = entity.getInteger("id");
                                            List<Entity> relatedEntities = exp.getRelatedEntities(session, entityType, id1, navFunction, "id");
                                            for (Entity relatedEntity : relatedEntities) {
                                                String msg9;
                                                if (Thread.interrupted()) {
                                                    throw new InterruptedException("LDAP synchronisation was cancelled.");
                                                }
                                                long id2 = relatedEntity.getInteger("id");
                                                if (navFunction.isLeftToRight()) {
                                                    if (relations.contains(new Tuple(id1, id2))) continue;
                                                    msg9 = "deleting relation %s #%d -> %s #%d";
                                                    msg9 = String.format(msg9, new Object[]{navFunction.source(), id1, navFunction.target(), id2});
                                                    this.logger.info(msg9);
                                                    chop.deleteRelation(session, navFunction.relationType(), id1, id2);
                                                    continue;
                                                }
                                                if (relations.contains(new Tuple(id2, id1))) continue;
                                                msg9 = "deleting relation %s #%d -> %s #%d";
                                                msg9 = String.format(msg9, new Object[]{navFunction.source(), id1, navFunction.target(), id2});
                                                this.logger.info(msg9);
                                                chop.deleteRelation(session, navFunction.relationType(), id2, id1);
                                            }
                                        }
                                    }
                                    ++n7;
                                }
                                ++n3;
                            }
                        }
                        ctx.close();
                        ctx = null;
                    }
                    catch (DataSourceException ex) {
                        String msg = "An error occurred while synchronising.";
                        this.logger.log(Level.SEVERE, msg, ex);
                        JDBCTools.closeQuietly(con, stmt);
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (NamingException namingException) {}
                        }
                        break block95;
                    }
                    catch (NamingException ex) {
                        String msg = "An error occurred while synchronising.";
                        this.logger.log(Level.SEVERE, msg, ex);
                        JDBCTools.closeQuietly(con, stmt);
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (NamingException namingException) {}
                        }
                        break block95;
                    }
                    catch (SQLException ex) {
                        String msg = "An error occurred while synchronising.";
                        this.logger.log(Level.SEVERE, msg, ex);
                        {
                            catch (Throwable throwable) {
                                JDBCTools.closeQuietly(con, stmt);
                                if (ctx != null) {
                                    try {
                                        ctx.close();
                                    }
                                    catch (NamingException namingException) {}
                                }
                                throw throwable;
                            }
                        }
                        JDBCTools.closeQuietly(con, stmt);
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (NamingException namingException) {}
                        }
                        break block95;
                    }
                    JDBCTools.closeQuietly(con, stmt);
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (NamingException namingException) {}
                    }
                }
                this.logger.info("synchronisation run ended");
            }
            catch (InterruptedException interruptedException) {
                this.logger.info("synchronisation run has been cancelled");
                this.isSynchronising = false;
            }
        }
        finally {
            this.isSynchronising = false;
        }
    }

    private long createDummyOrgPosition(String orgPosKey, String orgPosName, long agentID, long syncUpdateID, RelationType relType, long otherID, ModelExplorer exp, DefaultModelChangeOperations chop, SessionToken session) throws OrgModelException, DataSourceException {
        Entity orgPos = new Entity(EntityType.ORG_POSITION);
        if (orgPosName != null) {
            orgPos.setString("name", orgPosName);
            orgPos.setString(ATTR_LDAP_DN, orgPosKey);
        }
        orgPos.setInteger(ATTR_LDAP_SYNC_UPDATE_ID, syncUpdateID);
        List<Entity> foundOrgPositions = exp.getRelatedEntities(session, EntityType.AGENT, agentID, RelationType.ORG_POSITION_OCCUPATION, false, "id", ATTR_LDAP_DN, ATTR_LDAP_SYNC_UPDATE_ID);
        long orgPosID = -1L;
        for (Entity foundOrgPos : foundOrgPositions) {
            if (foundOrgPos.isNull(ATTR_LDAP_DN) || foundOrgPos.getInteger(ATTR_LDAP_SYNC_UPDATE_ID) == syncUpdateID || !foundOrgPos.getString(ATTR_LDAP_DN).equals(orgPosKey)) continue;
            orgPosID = foundOrgPos.getInteger("id");
            break;
        }
        if (relType != null && orgPosID < 0L) {
            block1: for (Entity foundOrgPos : foundOrgPositions) {
                if (foundOrgPos.isNull(ATTR_LDAP_DN) || foundOrgPos.getInteger(ATTR_LDAP_SYNC_UPDATE_ID) == syncUpdateID) continue;
                List<Entity> relatedEntities = exp.getRelatedEntities(session, EntityType.ORG_POSITION, foundOrgPos.getInteger("id"), relType, false, "id");
                for (Entity relEntity : relatedEntities) {
                    if (relEntity.getInteger("id") != otherID) continue;
                    orgPosID = foundOrgPos.getInteger("id");
                    continue block1;
                }
            }
        }
        if (orgPosID < 0L) {
            orgPosID = chop.createOrUpdateEntity(session, orgPos, true, true);
        } else {
            orgPos.setInteger("id", orgPosID);
            chop.createOrUpdateEntity(session, orgPos, false, true);
        }
        if (!exp.relationExists(session, RelationType.ORG_POSITION_OCCUPATION, orgPosID, agentID)) {
            chop.addRelation(session, RelationType.ORG_POSITION_OCCUPATION, orgPosID, agentID);
        }
        return orgPosID;
    }

    @Deprecated
    static Properties parseRelationResolverConfiguration(Properties configuration) {
        Properties resolverConfiguration = new Properties();
        String prefix = "RelationResolver.";
        for (Object keyObj : configuration.keySet()) {
            String key = keyObj.toString();
            if (!key.startsWith(prefix)) continue;
            resolverConfiguration.setProperty(key.substring(prefix.length()), configuration.getProperty(key));
        }
        return resolverConfiguration;
    }

    public static class ConfValidator
    extends ConfigurationValidator {
        @Override
        protected void validate(Configuration configuration) throws ConfigurationException {
            String relationResolverClass = configuration.getString(LdapSynchroniser.CFG_RELATION_RESOLVER);
            if (relationResolverClass.length() > 0) {
                Configuration resolverConfiguration = configuration.subset(LdapSynchroniser.CFG_RELATION_RESOLVER);
                try {
                    Class<?> clazz = Class.forName(relationResolverClass);
                    if (LdapRelationResolver.class.isAssignableFrom(clazz)) {
                        Class<LdapRelationResolver> resolverClass = clazz.asSubclass(LdapRelationResolver.class);
                        Constructor<LdapRelationResolver> resolverConstructor = resolverClass.getConstructor(Configuration.class);
                        resolverConstructor.newInstance(resolverConfiguration);
                    } else {
                        this.rebukeIllegalValue(configuration, LdapSynchroniser.CFG_RELATION_RESOLVER, "no implementation of LdapRelationResolver");
                    }
                }
                catch (ConfigurationException ex) {
                    throw ex;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.rebukeIllegalValue(configuration, LdapSynchroniser.CFG_RELATION_RESOLVER, "appropriate constructor not found; maybe it's not public?");
                }
                catch (Exception ex) {
                    this.rebukeIllegalValue(configuration, LdapSynchroniser.CFG_RELATION_RESOLVER, String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getMessage());
                }
            }
        }
    }

    class SynchroniserTask
    implements Runnable {
        SynchroniserTask() {
        }

        @Override
        public void run() {
            try {
                LdapSynchroniser.this.synchronise();
            }
            catch (Exception ex) {
                String msg = "An error occurred while synchronising.";
                LdapSynchroniser.this.logger.log(Level.SEVERE, msg, ex);
            }
        }
    }

    private static class Tuple {
        long id1;
        long id2;

        public Tuple(long id1, long id2) {
            this.id1 = id1;
            this.id2 = id2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Tuple)) {
                return false;
            }
            Tuple otherTuple = (Tuple)obj;
            return this.id1 == otherTuple.id1 && this.id2 == otherTuple.id2;
        }

        public int hashCode() {
            return new HashCalc(Tuple.class).feed(this.id1).feed(this.id2).hashCode();
        }

        public String toString() {
            return "(" + this.id1 + "," + this.id2 + ")";
        }
    }
}

