/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.SQLTableNames;
import de.aristaflow.adept2.model.orgmodel.CmpOperator;
import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;

class OmmDefImplTools {
    protected static final Logger logger = LoggerTools.getLogger(OmmDefImplTools.class);

    OmmDefImplTools() {
    }

    static int dataTypeToJdbcTypeCode(DataType dataType) {
        if (dataType == null) {
            throw new NullArgumentException("The parameter 'dataType' must not be null!");
        }
        switch (dataType) {
            case NULL: {
                return 0;
            }
            case INTEGER: {
                return -5;
            }
            case FLOAT: {
                return 8;
            }
            case STRING: {
                return 12;
            }
            case DATE: {
                return 91;
            }
            case TIME: {
                return 92;
            }
            case TIMESTAMP: {
                return 93;
            }
        }
        String msg = "Unknown data type '" + (Object)((Object)dataType) + "' encountered! Add missing types here!";
        throw new AssertionError((Object)msg);
    }

    static String dataTypeToSqlType(DataType dataType, int sizeHint, ExtendedConnection con) {
        if (dataType == null) {
            throw new NullArgumentException("The parameter 'dataType' must not be null!");
        }
        switch (dataType) {
            case NULL: {
                throw new IllegalArgumentException("The DataType NULL can't be mapped to an SQL type!");
            }
            case INTEGER: {
                return con.getCorrespondingDBType(-5);
            }
            case FLOAT: {
                return con.getCorrespondingDBType(8);
            }
            case STRING: {
                return con.getCorrespondingDBType(12, sizeHint);
            }
            case DATE: {
                return con.getCorrespondingDBType(91);
            }
            case TIME: {
                return con.getCorrespondingDBType(92);
            }
            case TIMESTAMP: {
                return con.getCorrespondingDBType(93);
            }
        }
        String msg = "Unknown data type '" + (Object)((Object)dataType) + "' encountered! Add missing types here!";
        throw new AssertionError((Object)msg);
    }

    static String cmpOperatorToSqlSymbol(CmpOperator op) {
        switch (op) {
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "<>";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_OR_EQUAL: {
                return ">=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_OR_EQUAL: {
                return "<=";
            }
            case LIKE: 
            case LIKE_IGNORECASE: {
                return "LIKE";
            }
            case NOT_LIKE: 
            case NOT_LIKE_IGNORECASE: {
                return "NOT LIKE";
            }
        }
        String msg = "Unknown comparison operator '" + (Object)((Object)op) + "' encountered! Add missing operators here!";
        throw new AssertionError((Object)msg);
    }

    static String formatAsSqlCondition(ExtendedConnection con, String attribute, CmpOperator cmpOperator, Object value) {
        if (!cmpOperator.canCompare(DataType.getDataTypeForObject(value))) {
            throw new IllegalArgumentException("The CmpOperator and value object don't work together!");
        }
        if (value == null) {
            if (cmpOperator == CmpOperator.EQUAL) {
                return String.valueOf(attribute) + " IS NULL";
            }
            if (cmpOperator == CmpOperator.NOT_EQUAL) {
                return String.valueOf(attribute) + " IS NOT NULL";
            }
            String msg = "Encountered an unexpected comparison operator that is apparently able to deal with null!";
            throw new IllegalStateException(msg);
        }
        String cmpOperatorSymbol = OmmDefImplTools.cmpOperatorToSqlSymbol(cmpOperator);
        String preparedValue = con.formatValue(value, OmmDefImplTools.dataTypeToJdbcTypeCode(DataType.getDataTypeForObject(value)));
        if (cmpOperator == CmpOperator.LIKE_IGNORECASE || cmpOperator == CmpOperator.NOT_LIKE_IGNORECASE) {
            return "UPPER(" + attribute + ") " + cmpOperatorSymbol + " " + preparedValue.toUpperCase();
        }
        return String.valueOf(attribute) + " " + cmpOperatorSymbol + " " + preparedValue;
    }

    static String getColumnNameInNMRelation(EntityType entType) {
        String etString = SQLTableNames.getTableNameFor(entType);
        return String.valueOf(Character.toLowerCase(etString.charAt(0))) + etString.substring(1) + "Id";
    }

    static String getRecTableName(RelationType relType, boolean leftToRight) {
        String relTypeString = relType.toString();
        if (relTypeString.length() > 20) {
            relTypeString = relTypeString.substring(0, 20);
        }
        if (leftToRight) {
            return "OMMRT_" + relTypeString + "_ltr";
        }
        return "OMMRT_" + relTypeString + "_rtl";
    }

    static String hashPassword(String password) {
        if (password == null) {
            throw new NullArgumentException("The parameter 'password' must not be null!");
        }
        try {
            byte[] salt = new byte[]{-13, 97, 58, -128};
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(password.getBytes("UTF-16"));
            md.update(salt);
            byte[] pwhash = md.digest();
            StringBuilder pwhashhex = new StringBuilder();
            byte[] byArray = pwhash;
            int n = pwhash.length;
            int n2 = 0;
            while (n2 < n) {
                byte bite = byArray[n2];
                String hex = Integer.toHexString(bite & 0xFF);
                if (hex.length() == 1) {
                    pwhashhex.append("0");
                }
                pwhashhex.append(hex);
                ++n2;
            }
            return pwhashhex.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String msg = "The MessageDigest algorithm SHA-1 is not supported! Returning unhashed password.";
            logger.severe(msg);
            return password;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String msg = "The encoding UTF-16 is not supported! Returning unhashed password.";
            logger.severe(msg);
            return password;
        }
    }
}

