/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.DefaultOrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.OmmDefImplTools;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.RecTableRef;
import de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation.SQLTableNames;
import de.aristaflow.adept2.core.orgmodelmanager.parser.AtomicEntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.AtomicSelection;
import de.aristaflow.adept2.core.orgmodelmanager.parser.ComplexEntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.ComplexSelection;
import de.aristaflow.adept2.core.orgmodelmanager.parser.EntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.Selection;
import de.aristaflow.adept2.core.orgmodelmanager.parser.TransitivityType;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.NavFunction;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

class OrgPolicyQueryBuilder {
    protected final Logger logger;
    private DefaultOrgModelManager orgModelManager;
    private int tableCounter;
    private int finalOrgPositionTableIndex;
    private StringBuilder query = new StringBuilder();
    private StringBuilder from = new StringBuilder();
    private StringBuilder where = new StringBuilder();
    private List<RecTableRef> requiredRecTables = new ArrayList<RecTableRef>();

    public OrgPolicyQueryBuilder(DefaultOrgModelManager orgModelManager) {
        if (orgModelManager == null) {
            throw new NullArgumentException("The parameter 'orgModelManager' must not be null!");
        }
        this.orgModelManager = orgModelManager;
        this.logger = LoggerTools.getLogger(this);
    }

    public String buildSqlQuery(EntityExpression entExp) throws SQLException {
        if (entExp == null) {
            throw new NullArgumentException("The parameter 'entExp' must not be null!");
        }
        this.requiredRecTables.clear();
        this.query.setLength(0);
        this.toSql(entExp);
        return this.query.toString();
    }

    RecTableRef[] getRequiredRecursionTables() {
        return this.requiredRecTables.toArray(new RecTableRef[this.requiredRecTables.size()]);
    }

    private void toSql(EntityExpression exp) throws SQLException {
        if (exp == null) {
            throw new NullArgumentException();
        }
        if (exp instanceof AtomicEntityExpression) {
            int targetTableIndex;
            int sourceTableIndex;
            AtomicEntityExpression atomicExp = (AtomicEntityExpression)exp;
            this.resetTableIndex();
            this.finalOrgPositionTableIndex = -1;
            this.from.setLength(0);
            this.where.setLength(0);
            EntityType startType = atomicExp.getEntityTypeAt(0);
            String startTypeTableName = SQLTableNames.getTableNameFor(startType);
            this.from.append(startTypeTableName).append(" T").append(this.nextTableIndex());
            if (startType == EntityType.ORG_POSITION) {
                this.finalOrgPositionTableIndex = this.currentTableIndex();
            }
            boolean firstSelection = true;
            Selection sel = atomicExp.getSelectionAt(0);
            if (sel != null) {
                firstSelection = false;
                this.where.append("(");
                this.toSql(sel, startType);
                this.where.append(")");
            }
            if (startType == EntityType.SUBSTITUTION_RULE && sel != null) {
                sourceTableIndex = this.currentTableIndex();
                targetTableIndex = this.nextTableIndex();
                String roleTableName = SQLTableNames.getTableNameFor(EntityType.ROLE);
                this.from.append("\n   JOIN ").append(roleTableName).append(" T").append(targetTableIndex).append(" ON T").append(sourceTableIndex).append(".roleId = T").append(targetTableIndex).append(".id");
            }
            int i = 0;
            int count = atomicExp.getFunctionCount();
            while (i < count) {
                int targetTableIndex2;
                int sourceTableIndex2;
                NavFunction function = atomicExp.getFunctionAt(i).getFunction();
                String functionTargetEntityTypeTableName = SQLTableNames.getTableNameFor(function.target());
                RelationType relType = function.relationType();
                if (relType.isNMRelation()) {
                    sourceTableIndex2 = this.currentTableIndex();
                    int relTableIndex = this.nextTableIndex();
                    int targetTableIndex3 = this.nextTableIndex();
                    String relationTypeTableName = SQLTableNames.getTableNameFor(relType);
                    this.from.append("\n   JOIN ").append(relationTypeTableName).append(" T").append(relTableIndex).append(" ON T").append(sourceTableIndex2).append(".id = T").append(relTableIndex).append(".").append(OmmDefImplTools.getColumnNameInNMRelation(function.source()));
                    this.from.append(" JOIN ").append(functionTargetEntityTypeTableName).append(" T").append(targetTableIndex3).append(" ON T").append(relTableIndex).append(".").append(OmmDefImplTools.getColumnNameInNMRelation(function.target())).append(" = T").append(targetTableIndex3).append(".id");
                } else {
                    sourceTableIndex2 = function.source() == EntityType.SUBSTITUTION_RULE ? this.currentTableIndex() - 1 : this.currentTableIndex();
                    targetTableIndex2 = this.nextTableIndex();
                    if (atomicExp.getFunctionAt(i).getTransitivity() != TransitivityType.NONE) {
                        if (!function.hasTransitiveOption()) {
                            throw new IllegalStateException();
                        }
                        this.requiredRecTables.add(new RecTableRef(function.relationType(), function.isLeftToRight()));
                        String recTableName = OmmDefImplTools.getRecTableName(function.relationType(), function.isLeftToRight());
                        this.from.append("\n   JOIN ").append(recTableName).append(" T").append(targetTableIndex2).append(" ON T").append(sourceTableIndex2).append(".id = T").append(targetTableIndex2).append(".origin");
                        if (atomicExp.getFunctionAt(i).getTransitivity() == TransitivityType.REGULAR) {
                            if (!firstSelection) {
                                this.where.append(" AND ");
                            } else {
                                firstSelection = false;
                            }
                            this.where.append("(T").append(targetTableIndex2).append(".depth <> 0)");
                        }
                    } else if (function.isLeftToRight()) {
                        this.from.append("\n   JOIN ").append(functionTargetEntityTypeTableName).append(" T").append(targetTableIndex2).append(" ON T").append(sourceTableIndex2).append(".id = T").append(targetTableIndex2).append(".").append(relType.oneToMReferenceAttribute());
                    } else {
                        this.from.append("\n   JOIN ").append(functionTargetEntityTypeTableName).append(" T").append(targetTableIndex2).append(" ON T").append(sourceTableIndex2).append(".").append(relType.oneToMReferenceAttribute()).append(" = T").append(targetTableIndex2).append(".id");
                    }
                }
                if (function.target() == EntityType.ORG_POSITION) {
                    this.finalOrgPositionTableIndex = this.currentTableIndex();
                }
                if ((sel = atomicExp.getFunctionAt(i).getSelection()) != null) {
                    if (!firstSelection) {
                        this.where.append(" AND ");
                    } else {
                        firstSelection = false;
                    }
                    this.where.append("(");
                    this.toSql(sel, function.target());
                    this.where.append(")");
                }
                if (function.target() == EntityType.SUBSTITUTION_RULE && sel != null) {
                    sourceTableIndex2 = this.currentTableIndex();
                    targetTableIndex2 = this.nextTableIndex();
                    String roleTableName = SQLTableNames.getTableNameFor(EntityType.ROLE);
                    this.from.append("\n   JOIN ").append(roleTableName).append(" T").append(targetTableIndex2).append(" ON T").append(sourceTableIndex2).append(".roleId = T").append(targetTableIndex2).append(".id");
                }
                ++i;
            }
            if (this.finalOrgPositionTableIndex == -1) {
                sourceTableIndex = this.currentTableIndex();
                targetTableIndex = this.nextTableIndex();
                int orgPosNameTableIndex = this.nextTableIndex();
                this.query.append("SELECT DISTINCT T").append(targetTableIndex).append(".orgPositionId,").append(" T").append(orgPosNameTableIndex).append(".name,").append(" T").append(sourceTableIndex).append(".id,").append(" T").append(sourceTableIndex).append(".userName");
                this.from.append("\n   JOIN OrgPositionOccupation T").append(targetTableIndex).append(" ON T").append(sourceTableIndex).append(".id = T").append(targetTableIndex).append(".agentId");
                this.from.append("\n   JOIN OrgPosition T").append(orgPosNameTableIndex).append(" ON T").append(targetTableIndex).append(".orgPositionId = T").append(orgPosNameTableIndex).append(".id");
            } else {
                this.query.append("SELECT DISTINCT T").append(this.finalOrgPositionTableIndex).append(".id,").append(" T").append(this.finalOrgPositionTableIndex).append(".name,").append(" T").append(this.currentTableIndex()).append(".id,").append(" T").append(this.currentTableIndex()).append(".userName");
            }
            this.query.append("\n FROM ").append((CharSequence)this.from);
            if (this.where.length() > 0) {
                this.query.append("\n WHERE ").append((CharSequence)this.where);
            }
        } else if (exp instanceof ComplexEntityExpression) {
            ComplexEntityExpression cmplExp = (ComplexEntityExpression)exp;
            this.query.append("(");
            int i = 0;
            int count = cmplExp.getSubExpressionCount();
            while (i < count) {
                if (i > 0) {
                    this.query.append(" \n");
                    switch (cmplExp.getType()) {
                        case UNION: {
                            this.query.append("UNION");
                            break;
                        }
                        case INTERSECTION: {
                            this.query.append("INTERSECT");
                            break;
                        }
                        case DIFFERENCE: {
                            ExtendedConnection con = this.orgModelManager.getDataSource().getConnection();
                            this.query.append(con.getEXCEPTKeyword());
                            con.close();
                            break;
                        }
                        default: {
                            String msg = "Unrecognised type of ComplexEntityExpression encountered: " + (Object)((Object)cmplExp.getType());
                            this.logger.severe(msg);
                            throw new IllegalStateException(msg);
                        }
                    }
                    this.query.append(" \n");
                }
                this.toSql(cmplExp.getSubExpressionAt(i));
                ++i;
            }
            this.query.append(")");
        } else {
            String msg = "Unrecognised/unknown subclass of EntityExpression encountered: " + exp.getClass();
            this.logger.severe(msg);
            throw new IllegalStateException(msg);
        }
    }

    private void toSql(Selection sel, EntityType enclosingEntityType) throws SQLException {
        if (sel == null) {
            throw new NullArgumentException();
        }
        if (sel instanceof AtomicSelection) {
            AtomicSelection atomicSel = (AtomicSelection)sel;
            String qualifiedAttributeName = enclosingEntityType == EntityType.SUBSTITUTION_RULE && atomicSel.getEntityType() == EntityType.ROLE ? "T" + (this.currentTableIndex() + 1) + "." + atomicSel.getAttriubteName() : "T" + this.currentTableIndex() + "." + atomicSel.getAttriubteName();
            ExtendedConnection con = this.orgModelManager.getDataSource().getConnection();
            this.where.append(OmmDefImplTools.formatAsSqlCondition(con, qualifiedAttributeName, atomicSel.getCmpOperator(), atomicSel.getValue()));
            con.close();
        } else if (sel instanceof ComplexSelection) {
            ComplexSelection cmplSel = (ComplexSelection)sel;
            this.where.append("(");
            int i = 0;
            int count = cmplSel.getSubSelectionCount();
            while (i < count) {
                if (i > 0) {
                    this.where.append(" ");
                    switch (cmplSel.getType()) {
                        case DISJUNCTION: {
                            this.where.append("OR");
                            break;
                        }
                        case CONJUNCTION: {
                            this.where.append("AND");
                            break;
                        }
                        default: {
                            String msg = "Unrecognised type of ComplexSelection encountered: " + (Object)((Object)cmplSel.getType());
                            this.logger.severe(msg);
                            throw new IllegalStateException(msg);
                        }
                    }
                    this.where.append(" ");
                }
                this.toSql(cmplSel.getSubSelectionAt(i), enclosingEntityType);
                ++i;
            }
            this.where.append(")");
        } else {
            String msg = "Unrecognised/unknown subclass of Selection encountered: " + sel.getClass();
            this.logger.severe(msg);
            throw new IllegalStateException(msg);
        }
    }

    private int currentTableIndex() {
        if (this.tableCounter == 0) {
            throw new IllegalStateException("You must at least once call getNextTableIndex() before calling this method!");
        }
        return this.tableCounter - 1;
    }

    private int nextTableIndex() {
        return this.tableCounter++;
    }

    private void resetTableIndex() {
        this.tableCounter = 0;
    }
}

