/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.defaultimplementation;

import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;

public class SQLTableNames {
    protected static final Logger logger = LoggerTools.getLogger(SQLTableNames.class);

    static String getTableNameFor(EntityType entityType) {
        switch (entityType) {
            case AGENT: {
                return "Agent";
            }
            case ORG_POSITION: {
                return "OrgPosition";
            }
            case ORG_UNIT: {
                return "OrgUnit";
            }
            case ORG_GROUP: {
                return "OrgGroup";
            }
            case PROJECT_GROUP: {
                return "ProjectGroup";
            }
            case ABILITY: {
                return "Ability";
            }
            case ROLE: {
                return "Role";
            }
            case SUBSTITUTION_RULE: {
                return "SubstitutionRule";
            }
        }
        logger.severe("No table name defined for " + (Object)((Object)entityType) + "! Using policy token instead.");
        return entityType.policyToken();
    }

    static String getTableNameFor(RelationType relType) {
        switch (relType) {
            case ORG_POSITION_OCCUPATION: {
                return "OrgPositionOccupation";
            }
            case ORG_POSITION_DESCRIPTION: {
                return "OrgPositionDescription";
            }
            case ORG_GROUP_INVOLVEMENT: {
                return "OrgGroupInvolvement";
            }
            case PROJECT_INVOLVEMENT_ORG_POSITION: {
                return "ProjectInvolvementOrgPosition";
            }
            case PROJECT_INVOLVEMENT_ORG_UNIT: {
                return "ProjectInvolvementOrgUnit";
            }
            case AGENT_ABILITY: {
                return "AgentAbility";
            }
            case ROLE_DESCRIPTION: {
                return "RoleDescription";
            }
            case ORG_POSITION_AFFILIATION: 
            case ORG_UNIT_SUBORDINATION: 
            case ORG_UNIT_MANAGEMENT: 
            case ORG_GROUP_MANAGEMENT: 
            case PROJECT_GROUP_SUBORDINATION: 
            case PROJECT_GROUP_MANAGEMENT: 
            case ROLE_SPECIALISATION: 
            case ORG_POSITION_SUBSTITUTION: 
            case ORG_POSITION_SUBSTITUTE: 
            case ROLE_SUBSTITUTION: {
                throw new IllegalArgumentException("1:m relations don't have/need their own table!");
            }
        }
        logger.severe("No table name defined for " + (Object)((Object)relType) + "! Using display name instead.");
        return relType.name().replace("_", "");
    }

    static String getSequenceNameFor(EntityType entityType) {
        switch (entityType) {
            case AGENT: {
                return "AgentID";
            }
            case ORG_POSITION: {
                return "OrgPositionID";
            }
            case ORG_UNIT: {
                return "OrgUnitID";
            }
            case ORG_GROUP: {
                return "OrgGroupID";
            }
            case PROJECT_GROUP: {
                return "ProjectGroupID";
            }
            case ABILITY: {
                return "AbilityID";
            }
            case ROLE: {
                return "RoleID";
            }
            case SUBSTITUTION_RULE: {
                return "SubstitutionRuleID";
            }
        }
        logger.severe("No sequence name defined for " + (Object)((Object)entityType) + "! Using policy token instead.");
        return entityType.policyToken();
    }
}

