/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.parser;

import de.aristaflow.adept2.core.orgmodelmanager.parser.AtomicSelection;
import de.aristaflow.adept2.core.orgmodelmanager.parser.EntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.NavFunctionInstance;
import de.aristaflow.adept2.core.orgmodelmanager.parser.Selection;
import de.aristaflow.adept2.core.orgmodelmanager.parser.TransitivityType;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.NavFunction;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.ArrayList;

public class AtomicEntityExpression
extends EntityExpression {
    private EntityType startEntityType;
    private Selection startSelection;
    private ArrayList<NavFunctionInstance> functions = new ArrayList();

    public AtomicEntityExpression(EntityType startEntityType, Selection startSelection) {
        if (startEntityType == null) {
            throw new NullArgumentException("The parameter 'startEntity' must not be null!");
        }
        this.startEntityType = startEntityType;
        this.startSelection = startSelection;
    }

    public NavFunctionInstance appendFunction(NavFunction function, Selection selection) {
        return this.appendFunction(function, TransitivityType.NONE, selection);
    }

    public NavFunctionInstance appendFunction(NavFunction function, TransitivityType transitivity, Selection selection) {
        NavFunctionInstance funcInst = new NavFunctionInstance(function, transitivity, selection);
        this.appendFunction(funcInst);
        return funcInst;
    }

    public void appendFunction(NavFunctionInstance funcInst) {
        if (funcInst == null) {
            throw new NullArgumentException("The parameter 'funcInst' must not be null!");
        }
        if (this.getEndOfChainEntityType() != funcInst.getFunction().source()) {
            throw new IllegalArgumentException("The function " + (Object)((Object)funcInst.getFunction().source()) + "." + funcInst.getFunction() + "() cannot be applied to " + (Object)((Object)this.getEndOfChainEntityType()));
        }
        this.functions.add(funcInst);
    }

    public int getChainLength() {
        return this.functions.size() + 1;
    }

    public EntityType getEntityTypeAt(int chainIndex) {
        if (chainIndex == 0) {
            return this.startEntityType;
        }
        if (chainIndex < this.functions.size()) {
            return this.functions.get(chainIndex).getFunction().source();
        }
        return this.functions.get(this.functions.size() - 1).getFunction().target();
    }

    public Selection getSelectionAt(int chainIndex) {
        if (chainIndex == 0) {
            return this.startSelection;
        }
        return this.functions.get(chainIndex - 1).getSelection();
    }

    public EntityType getEndOfChainEntityType() {
        return this.getEntityTypeAt(this.getChainLength() - 1);
    }

    public int getFunctionCount() {
        return this.functions.size();
    }

    public NavFunctionInstance getFunctionAt(int index) {
        return this.functions.get(index);
    }

    public AtomicEntityExpression duplicate() {
        AtomicEntityExpression clone = new AtomicEntityExpression(this.startEntityType, this.startSelection);
        clone.functions = (ArrayList)this.functions.clone();
        return clone;
    }

    @Override
    public void format(StringBuilder s) {
        if (s == null) {
            throw new NullArgumentException("The parameter 's' must not be null!");
        }
        s.append((Object)this.startEntityType);
        this.formatSelection(s, this.startSelection);
        int i = 0;
        int count = this.functions.size();
        while (i < count) {
            NavFunctionInstance funcInst = this.functions.get(i);
            funcInst.format(s);
            this.formatSelection(s, funcInst.getSelection());
            ++i;
        }
    }

    private void formatSelection(StringBuilder s, Selection sel) {
        if (sel != null) {
            if (sel instanceof AtomicSelection) {
                s.append("(");
                sel.format(s, this.startEntityType);
                s.append(")");
            } else {
                sel.format(s, this.startEntityType);
            }
        } else {
            s.append("()");
        }
    }
}

