/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.parser;

import de.aristaflow.adept2.core.orgmodelmanager.parser.Selection;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.orgmodel.CmpOperator;
import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.OrgModelTools;
import de.aristaflow.adept2.util.NullArgumentException;

public class AtomicSelection
extends Selection {
    private EntityType entityType;
    private String attrName;
    private CmpOperator cmpOperator;
    private Object value;

    public AtomicSelection(EntityType entityType, String attrName, CmpOperator cmpOperator, Object value) {
        DataType odt;
        if (attrName == null) {
            throw new NullArgumentException("The parameter 'attrName' must not be null!");
        }
        if (!OrgModelTools.isValidAttributeName(attrName)) {
            throw new IllegalArgumentException("The attribute name '" + attrName + "' is not valid!");
        }
        if (cmpOperator == null) {
            throw new NullArgumentException("The parameter 'cmpOperator' must not be null!");
        }
        if (value instanceof ParameterRef) {
            odt = DataType.fromAdeptDataType(((ParameterRef)value).getDataType());
        } else {
            odt = DataType.getDataTypeForObject(value);
            if (odt == null) {
                throw new IllegalArgumentException("The value object (class = " + value.getClass() + ") is not a supported DataType!");
            }
        }
        if (!cmpOperator.canCompare(odt)) {
            throw new IllegalArgumentException("The comparison operator " + cmpOperator.symbol() + " can't be used for values with the DataType " + (Object)((Object)odt));
        }
        this.entityType = entityType;
        this.attrName = attrName;
        this.cmpOperator = cmpOperator;
        this.value = value;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String getAttriubteName() {
        return this.attrName;
    }

    public CmpOperator getCmpOperator() {
        return this.cmpOperator;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    void format(StringBuilder s, EntityType enclosingEntityType) {
        if (s == null) {
            throw new NullArgumentException("The parameter 's' must not be null!");
        }
        if (this.entityType != null && this.entityType != enclosingEntityType) {
            s.append(this.entityType.toString()).append(".");
        }
        s.append(this.attrName).append(" ").append(this.cmpOperator.symbol()).append(" ").append(OrgModelTools.toPolicyToken(this.value));
    }
}

