/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.parser;

import de.aristaflow.adept2.core.orgmodelmanager.parser.EntityExpression;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.ArrayList;
import java.util.List;

public class ComplexEntityExpression
extends EntityExpression {
    private Type type;
    private List<EntityExpression> entityExpressions = new ArrayList<EntityExpression>();

    public ComplexEntityExpression(Type type) {
        if (type == null) {
            throw new NullArgumentException("The parameter 'type' must not be null!");
        }
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public int getSubExpressionCount() {
        return this.entityExpressions.size();
    }

    public EntityExpression getSubExpressionAt(int index) {
        return this.entityExpressions.get(index);
    }

    public void addSubExpression(EntityExpression entExp) {
        if (entExp == null) {
            throw new NullArgumentException("The parameter 'entExp' must not be null!");
        }
        this.entityExpressions.add(entExp);
    }

    public void replaceSubExpressionAt(int index, EntityExpression entExp) {
        if (entExp == null) {
            throw new NullArgumentException("The parameter 'entExp' must not be null!");
        }
        this.entityExpressions.set(index, entExp);
    }

    @Override
    public void format(StringBuilder s) {
        if (s == null) {
            throw new NullArgumentException("The parameter 's' must not be null!");
        }
        s.append("(");
        boolean first = true;
        for (EntityExpression entExp : this.entityExpressions) {
            if (first) {
                first = false;
            } else {
                s.append(" ").append(this.type.policyToken()).append(" ");
            }
            entExp.format(s);
        }
        s.append(")");
    }

    public static enum Type {
        UNION("OR"),
        INTERSECTION("AND"),
        DIFFERENCE("EXCEPT");

        private final String policyToken;

        private Type(String policyToken) {
            this.policyToken = policyToken;
        }

        public String policyToken() {
            return this.policyToken;
        }
    }
}

