/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.parser;

import de.aristaflow.adept2.core.orgmodelmanager.parser.Selection;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.ArrayList;
import java.util.List;

public class ComplexSelection
extends Selection {
    private Type type;
    private List<Selection> selections = new ArrayList<Selection>();

    public ComplexSelection(Type type) {
        if (type == null) {
            throw new NullArgumentException("The parameter 'type' must not be null!");
        }
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public int getSubSelectionCount() {
        return this.selections.size();
    }

    public Selection getSubSelectionAt(int index) {
        return this.selections.get(index);
    }

    public void addSubSelection(Selection selection) {
        if (selection == null) {
            throw new NullArgumentException("The parameter 'selection' must not be null!");
        }
        this.selections.add(selection);
    }

    @Override
    void format(StringBuilder s, EntityType enclosingEntityType) {
        if (s == null) {
            throw new NullArgumentException("The parameter 's' must not be null!");
        }
        s.append("(");
        boolean first = true;
        for (Selection sel : this.selections) {
            if (first) {
                first = false;
            } else {
                s.append(" ").append(this.type.policyToken()).append(" ");
            }
            sel.format(s, enclosingEntityType);
        }
        s.append(")");
    }

    public static enum Type {
        CONJUNCTION("AND"),
        DISJUNCTION("OR");

        private final String policyToken;

        private Type(String policyToken) {
            this.policyToken = policyToken;
        }

        public String policyToken() {
            return this.policyToken;
        }
    }
}

