/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.parser;

import de.aristaflow.adept2.core.orgmodelmanager.parser.Selection;
import de.aristaflow.adept2.core.orgmodelmanager.parser.TransitivityType;
import de.aristaflow.adept2.model.orgmodel.NavFunction;
import de.aristaflow.adept2.util.NullArgumentException;

public class NavFunctionInstance {
    private NavFunction function;
    private TransitivityType transitivity;
    private Selection selection;

    public NavFunctionInstance(NavFunction function, TransitivityType transitivity, Selection selection) {
        if (function == null) {
            throw new NullArgumentException("The parameter 'function' must not be null!");
        }
        if (transitivity == null) {
            throw new NullArgumentException("The parameter 'transitivity' must not be null!");
        }
        if (!function.hasTransitiveOption() && transitivity != TransitivityType.NONE) {
            throw new IllegalArgumentException("The function " + function + "() cannot be used transitively for " + (Object)((Object)function.source()) + "!");
        }
        this.function = function;
        this.transitivity = transitivity;
        this.selection = selection;
    }

    public NavFunction getFunction() {
        return this.function;
    }

    public TransitivityType getTransitivity() {
        return this.transitivity;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void format(StringBuilder s) {
        s.append(".");
        s.append(this.getFunction().policyToken());
        switch (this.getTransitivity()) {
            case REGULAR: {
                s.append("+");
                break;
            }
            case INCLUDE_SOURCE: {
                s.append("*");
            }
        }
    }
}

