/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.parser.defaultimplementation;

import de.aristaflow.adept2.core.orgmodelmanager.parser.AtomicEntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.EntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.TokenInfoContainer;
import de.aristaflow.adept2.core.orgmodelmanager.parser.defaultimplementation.OrgPolicyParserCoreConstants;
import de.aristaflow.adept2.core.orgmodelmanager.parser.defaultimplementation.ParseException;
import de.aristaflow.adept2.core.orgmodelmanager.parser.defaultimplementation.Token;
import de.aristaflow.adept2.model.orgmodel.OrgModelTools;
import de.aristaflow.adept2.model.orgmodel.OrgPolicyReport;
import java.text.DateFormat;

abstract class OrgPolicyParserBase {
    OrgPolicyReport report;
    boolean reportOnly;
    boolean binaryReport;
    boolean rejectParameterRefs;
    TokenInfoContainer tokenInfos;
    boolean failed = false;
    DateFormat dateFormat;
    DateFormat timeFormat;
    DateFormat timestampFormat;
    static final int EXPECTED_IDENTIFIER_TYPE_ENTITY_TYPE = 0;
    static final int EXPECTED_IDENTIFIER_TYPE_FUNCTION = 1;
    static final int EXPECTED_IDENTIFIER_TYPE_ATTRIBUTE_NAME = 2;
    static final int EXPECTED_IDENTIFIER_TYPE_ENTITY_TYPE_OR_ATTRIBUTE_NAME = 3;
    int currentlyExpectedIdentifierType;

    OrgPolicyParserBase() {
    }

    void fail() throws ParseException {
        this.failed = true;
        if (this.binaryReport) {
            throw new ParseException();
        }
    }

    boolean build() {
        return !this.failed && !this.reportOnly;
    }

    boolean createReport() {
        return this.report != null && !this.binaryReport;
    }

    void reportWarning(String message, OrgPolicyReport.Range ... ranges) {
        if (this.createReport()) {
            this.report.addEntry(OrgPolicyReport.ResultType.WARNING, message, ranges);
        }
    }

    void reportError(String message, OrgPolicyReport.Range ... ranges) {
        this.failed = true;
        if (this.createReport()) {
            this.report.addEntry(OrgPolicyReport.ResultType.ERROR, message, ranges);
        }
    }

    DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = OrgModelTools.createDateFormat();
        }
        return this.dateFormat;
    }

    DateFormat getTimeFormat() {
        if (this.timeFormat == null) {
            this.timeFormat = OrgModelTools.createTimeFormat();
        }
        return this.timeFormat;
    }

    DateFormat getTimestampFormat() {
        if (this.timestampFormat == null) {
            this.timestampFormat = OrgModelTools.createTimestampFormat();
        }
        return this.timestampFormat;
    }

    public AtomicEntityExpression parseAtomicEntityExpression() {
        try {
            AtomicEntityExpression expr = this.inputAtomicEntityExpression();
            if (!this.build()) {
                return null;
            }
            AtomicEntityExpression atomicEntityExpression = expr;
            return atomicEntityExpression;
        }
        catch (ParseException e) {
            this.failed = true;
            if (this.createReport()) {
                this.createReportEntryFromException(e);
            }
            return null;
        }
        finally {
            if (this.failed && this.binaryReport) {
                this.report.addEntry(OrgPolicyReport.ResultType.ERROR, "The parsing failed!", new OrgPolicyReport.Range[0]);
            }
        }
    }

    public EntityExpression parseOrgPolicy() {
        try {
            EntityExpression expr = this.inputOrgPolicy();
            if (!this.build()) {
                return null;
            }
            EntityExpression entityExpression = expr;
            return entityExpression;
        }
        catch (ParseException e) {
            this.failed = true;
            if (this.createReport()) {
                this.createReportEntryFromException(e);
            }
            return null;
        }
        finally {
            if (this.failed && this.binaryReport) {
                this.report.addEntry(OrgPolicyReport.ResultType.ERROR, "The parsing failed!", new OrgPolicyReport.Range[0]);
            }
        }
    }

    private void createReportEntryFromException(ParseException e) {
        if (this.createReport() && e.specialConstructor) {
            StringBuilder s = new StringBuilder();
            Token enc = e.currentToken.next;
            s.append("Encountered ");
            if (enc.kind == 0) {
                s.append("end of policy");
            } else {
                s.append("'");
                s.append(enc.image);
                s.append("'");
            }
            s.append(" but expected ");
            boolean literalExpected = false;
            boolean first = true;
            int i = 0;
            int length = e.expectedTokenSequences.length;
            while (i < length) {
                String expected = null;
                switch (e.expectedTokenSequences[i][0]) {
                    case 29: {
                        break;
                    }
                    case 0: {
                        expected = "end of policy";
                        break;
                    }
                    case 9: {
                        expected = "'AND'";
                        break;
                    }
                    case 8: {
                        expected = "'OR'";
                        break;
                    }
                    case 5: {
                        expected = "'('";
                        break;
                    }
                    case 6: {
                        expected = "')'";
                        break;
                    }
                    case 7: {
                        expected = "comparison operator";
                        break;
                    }
                    case 10: {
                        expected = "'EXCEPT'";
                        break;
                    }
                    case 11: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        if (literalExpected) break;
                        expected = "a literal";
                        literalExpected = true;
                        break;
                    }
                    case 22: {
                        expected = "'.'";
                        break;
                    }
                    case 23: {
                        expected = "'+'";
                        break;
                    }
                    case 24: {
                        expected = "'*'";
                        break;
                    }
                    case 21: {
                        expected = "a parameter reference";
                        break;
                    }
                    case 25: {
                        switch (this.currentlyExpectedIdentifierType) {
                            case 0: {
                                expected = "an entity type";
                                break;
                            }
                            case 1: {
                                expected = "a function";
                                break;
                            }
                            case 2: {
                                expected = "an attribute name";
                                break;
                            }
                            case 3: {
                                expected = "an entity type or an attribute name";
                            }
                        }
                        break;
                    }
                    default: {
                        expected = OrgPolicyParserCoreConstants.tokenImage[e.expectedTokenSequences[i][0]];
                    }
                }
                if (expected != null) {
                    if (first) {
                        first = false;
                    } else {
                        s.append(" or ");
                    }
                    s.append(expected);
                }
                ++i;
            }
            s.append("!");
            this.reportError(s.toString(), new OrgPolicyReport.Range(enc.beginColumn, enc.endColumn));
        }
    }

    abstract EntityExpression inputOrgPolicy() throws ParseException;

    abstract AtomicEntityExpression inputAtomicEntityExpression() throws ParseException;
}

