/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.parser.defaultimplementation;

import de.aristaflow.adept2.core.orgmodelmanager.parser.defaultimplementation.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 4506852161902013584L;
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        if (expectedTokenSequencesVal != null) {
            this.expectedTokenSequences = (int[][])expectedTokenSequencesVal.clone();
        }
        if (tokenImageVal != null) {
            this.tokenImage = (String[])tokenImageVal.clone();
        }
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        int i = 0;
        while (i < this.expectedTokenSequences.length) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < this.expectedTokenSequences[i].length) {
                expected.append(this.tokenImage[this.expectedTokenSequences[i][j]]).append(" ");
                ++j;
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(this.eol).append("    ");
            ++i;
        }
        StringBuilder retval = new StringBuilder("Encountered \"");
        Token tok = this.currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                retval.append(" ");
            }
            if (tok.kind == 0) {
                retval.append(this.tokenImage[0]);
                break;
            }
            retval.append(this.add_escapes(tok.image));
            tok = tok.next;
            ++i2;
        }
        retval.append("\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn);
        retval.append("." + this.eol);
        if (this.expectedTokenSequences.length == 1) {
            retval.append("Was expecting:" + this.eol + "    ");
        } else {
            retval.append("Was expecting one of:" + this.eol + "    ");
        }
        retval.append(expected.toString());
        return retval.toString();
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

