/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.orgmodelmanager.parser.defaultimplementation;

import de.aristaflow.adept2.core.orgmodelmanager.parser.defaultimplementation.CharStream;
import de.aristaflow.adept2.util.NullArgumentException;
import java.io.EOFException;
import java.io.IOException;

public class StringCharStream
implements CharStream {
    private String string;
    private int nextChar;
    private int tokenStart;

    public StringCharStream(String string) {
        if (string == null) {
            throw new NullArgumentException("The parameter 'string' must not be null!");
        }
        this.string = string;
    }

    @Override
    public char readChar() throws IOException {
        if (this.nextChar >= this.string.length()) {
            throw new EOFException();
        }
        return this.string.charAt(this.nextChar++);
    }

    @Override
    public char beginToken() throws IOException {
        this.tokenStart = this.nextChar;
        return this.readChar();
    }

    @Override
    public void backup(int amount) {
        this.nextChar -= amount;
    }

    @Override
    public String getImage() {
        return this.string.substring(this.tokenStart, this.nextChar);
    }

    @Override
    public char[] getSuffix(int len) {
        char[] result = new char[len];
        this.string.getChars(this.nextChar - len, this.nextChar, result, 0);
        return result;
    }

    @Override
    public int getBeginLine() {
        return 1;
    }

    @Override
    public int getBeginColumn() {
        return this.tokenStart;
    }

    @Override
    public int getEndLine() {
        return 1;
    }

    @Override
    public int getEndColumn() {
        return this.nextChar;
    }

    @Override
    public void done() {
    }
}

