/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager;

import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import java.io.Serializable;

public final class CustomInstanceFilters {
    public static Filter getInstancesWithFailedNodesFilter() {
        return new InstancesWithFailedNodesFilter();
    }

    public static Filter getInstancesWithSuspendedNodesFilter() {
        return new InstancesWithSuspendedNodesFilter();
    }

    public static Filter getInstancesWithRunningNodesFilter() {
        return new InstancesWithRunningNodesFilter();
    }

    private CustomInstanceFilters() {
    }

    static class InstancesWithFailedNodesFilter
    implements Filter,
    Serializable {
        private static final long serialVersionUID = -74457698102586854L;

        InstancesWithFailedNodesFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            if (obj instanceof Instance) {
                Instance instance = (Instance)obj;
                for (Node node : instance.getTemplate().getNodes()) {
                    ProcessConstants.NodeState nodeState = instance.getNodeState(node.getID());
                    if (nodeState != ProcessConstants.NodeState.NS_FAILED) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class InstancesWithRunningNodesFilter
    implements Filter,
    Serializable {
        private static final long serialVersionUID = 2405234858435096046L;

        InstancesWithRunningNodesFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            if (obj instanceof Instance) {
                Instance instance = (Instance)obj;
                for (Node node : instance.getTemplate().getNodes()) {
                    ProcessConstants.NodeState nodeState = instance.getNodeState(node.getID());
                    if (nodeState != ProcessConstants.NodeState.NS_RUNNING) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class InstancesWithSuspendedNodesFilter
    implements Filter,
    Serializable {
        private static final long serialVersionUID = -8765533256588251259L;

        InstancesWithSuspendedNodesFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            if (obj instanceof Instance) {
                Instance instance = (Instance)obj;
                for (Node node : instance.getTemplate().getNodes()) {
                    ProcessConstants.NodeState nodeState = instance.getNodeState(node.getID());
                    if (nodeState != ProcessConstants.NodeState.NS_SUSPENDED) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

