/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager;

import de.aristaflow.adept2.base.communication.annotations.ProxyAllow;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeReport;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.util.LockException;
import java.util.Set;
import java.util.UUID;

@ProxyAllow
public interface InstanceManager {
    public static final String INSTANCE_EXECUTION_LOCK = "InstanceExecutionLock";
    public static final String INSTANCE_CHANGE_LOCK = "InstanceChangeLock";

    public UUID getLogicalInstanceID(SessionToken var1, UUID var2);

    public Instance getInstance(SessionToken var1, UUID var2);

    public InstanceReference getInstanceReference(SessionToken var1, UUID var2);

    public Set<InstanceReference> getAllInstanceReferencesOf(SessionToken var1, UUID var2);

    public Set<UUID> getAllInstanceIDsOf(SessionToken var1, UUID var2);

    public Set<InstanceReference> findInstances(SessionToken var1, Filter var2, Filter var3);

    public Set<InstanceReference> findInstances(SessionToken var1, UUID[] var2, Filter var3, Filter var4);

    public ExecutableInstance createInstanceOf(SessionToken var1, UUID var2, String var3, QualifiedAgent var4, long var5) throws LockException;

    public ExecutableInstance createSubInstanceOf(SessionToken var1, UUID var2, String var3, QualifiedAgent var4, EBPInstanceReference var5, long var6) throws LockException;

    public ExecutableInstance getAndLockInstanceForExecution(SessionToken var1, UUID var2) throws LockException;

    public void setExecutableInstance(SessionToken var1, ExecutableInstance var2) throws LockException;

    @Deprecated
    public void setAndUnlockExecutableInstance(SessionToken var1, ExecutableInstance var2) throws LockException;

    public void unlockExecutableInstance(SessionToken var1, UUID var2) throws LockException;

    public QualifiedAgent getChangeLockingAgent(UUID var1);

    public ChangeableInstance getAndLockInstanceForChanging(SessionToken var1, UUID var2) throws LockException;

    public ChangeReport changeInstance(SessionToken var1, ChangeableInstance var2) throws LockException;

    public ChangeReport changeAndUnlockInstance(SessionToken var1, ChangeableInstance var2) throws LockException;

    public void unlockChangeableInstance(SessionToken var1, UUID var2) throws LockException;

    public InstanceStatus getInstanceStatus(SessionToken var1, UUID var2);

    public void setExecutionStatus(SessionToken var1, UUID var2, ProcessConstants.InstanceExecutionStatus var3, String var4) throws LockException;

    public InstanceStatus getAndLockInstanceStatus(SessionToken var1, UUID var2) throws LockException;

    public void setInstanceStatus(SessionToken var1, InstanceStatus var2) throws LockException;

    @Deprecated
    public void setAndUnlockInstanceStatus(SessionToken var1, InstanceStatus var2) throws LockException;

    public void unlockInstanceStatus(SessionToken var1, UUID var2) throws LockException;
}

