/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.AttributeFactory;
import de.aristaflow.adept2.model.filter.ComparisonFilter;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.filter.MultipleFilterFilter;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.util.Version;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;

public class ProcessManagerTools {
    private ProcessManagerTools() {
    }

    public static TemplateReference getLatestTemplateVersion(SessionToken session, String processType, TemplateManager templMgr, FilterFactory filtFactory) {
        TemplateReference ret = null;
        AttributeFactory templateAF = filtFactory.createAttributeFactory(Template.class);
        ComparisonFilter templateFilter = filtFactory.createComparisonFilter(templateAF.selectAttribute("getProcessType"), ComparisonOperator.EQUALS, (Comparable<?>)((Object)processType));
        AttributeFactory statusAF = filtFactory.createAttributeFactory(TemplateStatus.class);
        ArrayList<ComparisonFilter> filterList = new ArrayList<ComparisonFilter>(4);
        Attribute attr = statusAF.selectAttribute("isTopLevelUsable");
        filterList.add(filtFactory.createComparisonFilter(attr, ComparisonOperator.EQUALS, Boolean.valueOf(true)));
        attr = statusAF.selectAttribute("isOutdated", Boolean.valueOf(false));
        filterList.add(filtFactory.createComparisonFilter(attr, ComparisonOperator.EQUALS, Boolean.valueOf(false)));
        attr = statusAF.selectAttribute("isInstantiable", Boolean.valueOf(false));
        filterList.add(filtFactory.createComparisonFilter(attr, ComparisonOperator.EQUALS, Boolean.valueOf(true)));
        attr = statusAF.selectAttribute("getBuildtimeState");
        filterList.add(filtFactory.createComparisonFilter(attr, ComparisonOperator.EQUALS, (Comparable<?>)((Object)ProcessConstants.TemplateBuildtimeState.RELEASED)));
        Filter[] filters = filterList.toArray(new Filter[filterList.size()]);
        MultipleFilterFilter templateStatusFilter = filtFactory.createAndFilter(filters);
        Set<TemplateReference> templates = templMgr.findTemplates(session, templateFilter, templateStatusFilter);
        if (templates.size() != 0) {
            TreeMap<String, TemplateReference> sortedTemplates = new TreeMap<String, TemplateReference>(Version.getVersionStringComparatorInstance());
            for (TemplateReference ref : templates) {
                sortedTemplates.put(ref.getVersion(), ref);
            }
            ret = (TemplateReference)sortedTemplates.get(sortedTemplates.lastKey());
        }
        return ret;
    }
}

