/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager;

import de.aristaflow.adept2.base.communication.annotations.ProxyAllow;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LockException;
import java.util.Set;
import java.util.UUID;

@ProxyAllow
public interface TemplateManager {
    public Template getTemplate(SessionToken var1, UUID var2);

    public TemplateReference getTemplateReference(SessionToken var1, UUID var2);

    public TemplateKind getTemplateKind(SessionToken var1, UUID var2);

    public Set<TemplateReference> getAllTemplateReferences(SessionToken var1);

    public Set<UUID> getAllTemplateIDs(SessionToken var1);

    public Set<TemplateReference> findTemplates(SessionToken var1, Filter var2, Filter var3);

    public CheckReport storeNewTemplate(SessionToken var1, Template var2, TemplateStatus var3);

    public CheckReport storeNewTemplates(SessionToken var1, Template[] var2, TemplateStatus[] var3);

    public TemplateStatus getTemplateStatus(SessionToken var1, UUID var2);

    public TemplateStatus getAndLockTemplateStatus(SessionToken var1, UUID var2) throws LockException;

    public void setTemplateStatus(SessionToken var1, TemplateStatus var2) throws LockException, InvalidTemplateStateException;

    @Deprecated
    public void setAndUnlockTemplateStatus(SessionToken var1, TemplateStatus var2) throws LockException, InvalidTemplateStateException;

    public void unlockTemplateStatus(SessionToken var1, UUID var2) throws LockException;

    public static enum TemplateKind {
        NORMAL,
        EMBEDDED,
        INSTANCE_SPECIFIC,
        EMBEDDED_INSTANCE_SPECIFIC;

    }
}

