/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.abstractimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionLock;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheckRunner;
import de.aristaflow.adept2.core.logmanager.LogManager;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.core.processmanager.TemplateStatusProvider;
import de.aristaflow.adept2.core.processmanager.abstractimplementation.EBPWrappingTemplate;
import de.aristaflow.adept2.core.processmanager.checks.LWPReferenceCheck;
import de.aristaflow.adept2.core.processmanager.storage.ExecutableProcessModelFactory;
import de.aristaflow.adept2.core.processmanager.storage.InstanceStorage;
import de.aristaflow.adept2.core.processmanager.storage.TemplateStorage;
import de.aristaflow.adept2.core.processmanager.storage.cachingstorage.CachingStorage;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstancePropertyTracker;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeReport;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.IDWrappingTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.TemplateReferenceComparator;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.ArrayTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.ExecutorTools;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.UUIDTools;
import de.aristaflow.adept2.util.locking.AcquireLockException;
import de.aristaflow.adept2.util.locking.ReentrantLock;
import de.aristaflow.adept2.util.locking.ReleaseLockException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="TestMode", type=Property.Type.BOOLEAN, defaultValue="NO", description="Specifies whether to use the test client checks instead of the production checks for all existing and new templates."), @Property(name="CacheSize", type=Property.Type.INT, defaultValue="250", description="Specifies the size for the cache to use. If this value is 0 or less, no caching will be used. Whether caching applies and how the size is used(for instance the size specifies the whole cache or the size per cached object type) depends on the used storage implementation."), @Property(name="SkipChecks", type=Property.Type.BOOLEAN, defaultValue="false", description="Specifies whether the initial template and instance checks should be performed (default) or if they should be skipped for performance reasons."), @Property(name="EagerLoading", type=Property.Type.BOOLEAN, defaultValue="false", description="Specifies whether all templates should be loaded at startup. This may be useful along with skipped checks to speed up methods like findTemplates. If the initial template checks are performed, this setting will be ignored, since all templates will be loaded for the checks anyway. This setting will also be ignored, if the cache is disabled, i.e. CacheSize = 0.")})
public abstract class AbstractProcessManager
extends AbstractADEPT2Service
implements ProcessManager,
TemplateManager,
InstanceManager,
TemplateStatusProvider {
    protected static final String CONF_TEST_MODE_STATUS = "TestMode";
    protected static final String CONF_CACHE_SIZE = "CacheSize";
    protected static final String CONF_SKIP_CHECKS = "SkipChecks";
    protected static final String CONF_EAGER_LOADING = "EagerLoading";
    private static final String CHECK_REPORT_ID = "Template Storage Checks";
    protected static final long LOCK_TIMEOUT = 60000L;
    protected final boolean TEST_MODE;
    protected final int CACHE_SIZE;
    protected final boolean SKIP_CHECKS;
    protected final boolean EAGER_LOADING;
    protected final Object intermediateTemplateLock;
    protected Map<UUID, QualifiedAgent> templateUpdateLocks;
    protected final Object intermediateInstanceLock;
    protected Map<UUID, QualifiedAgent> instanceChangeLocks;
    protected final Map<UUID, SessionLock> instanceExecutionLocks;
    protected final Map<UUID, Integer> instanceExecutionWaitingLockCount;
    protected TemplateStorage templateStorage;
    protected InstanceStorage instanceStorage;
    protected LogManager logManager;
    protected ProcessCheckService processChecks;
    protected Map<UUID, List<StackTraceElement[]>> instanceLockStackTraces = new HashMap<UUID, List<StackTraceElement[]>>();
    protected Map<UUID, List<StackTraceElement[]>> instanceUnlockStackTraces = new HashMap<UUID, List<StackTraceElement[]>>();
    protected ExecutorService cacheTemplateExecutor;

    protected AbstractProcessManager(Configuration configuration, Registry registry) {
        this(configuration, registry, new String[0], new String[0]);
    }

    protected AbstractProcessManager(Configuration configuration, Registry registry, String[] startupRequiredServices, String[] runtimeRequiredServices) {
        super(configuration, registry, ArrayTools.join(startupRequiredServices, {"LogManager", "ProcessChecks"}), runtimeRequiredServices);
        this.TEST_MODE = configuration.getBoolean(CONF_TEST_MODE_STATUS);
        this.CACHE_SIZE = configuration.getInt(CONF_CACHE_SIZE);
        this.SKIP_CHECKS = configuration.getBoolean(CONF_SKIP_CHECKS);
        this.EAGER_LOADING = configuration.getBoolean(CONF_EAGER_LOADING);
        this.intermediateTemplateLock = new Object();
        this.intermediateInstanceLock = new Object();
        this.instanceExecutionLocks = new HashMap<UUID, SessionLock>();
        this.instanceExecutionWaitingLockCount = new HashMap<UUID, Integer>();
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        try {
            this.sessionFactory = this.registry.getSecurityManager().authenticatePrivileged(-2L, -2L, "password");
        }
        catch (AuthenticationException ae) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to wrongauthentication data. Check the configuration of this ProcessManager.", ae);
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to unavailability of the data.", dse);
        }
        this.logManager = this.registry.getServiceOfType(this.sessionFactory.getSessionToken(myURIs), "LogManager", LogManager.class);
        this.processChecks = this.registry.getServiceOfType(this.sessionFactory.getSessionToken(myURIs), "ProcessChecks", ProcessCheckService.class);
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        if (this.SKIP_CHECKS && this.CACHE_SIZE > 0 && this.EAGER_LOADING) {
            Adept2ThreadFactory atf = new Adept2ThreadFactory("CacheTemplatesThread", 1, this.logger);
            this.cacheTemplateExecutor = Executors.newSingleThreadExecutor(atf);
            final SessionToken session = this.sessionFactory.getSessionToken(this.getURIs());
            Runnable cacheTemplates = new Runnable(){

                @Override
                public void run() {
                    for (UUID id : AbstractProcessManager.this.getTemplateManager().getAllTemplateIDs(session)) {
                        Template template = AbstractProcessManager.this.getTemplateManager().getTemplate(session, id);
                        String msg = "Load template %s (%s) into cache.";
                        msg = String.format(msg, template.getName(), template.getID());
                        AbstractProcessManager.this.getLogger().fine(msg);
                        if (Thread.interrupted()) break;
                    }
                    AbstractProcessManager.this.cacheTemplateExecutor.shutdown();
                }
            };
            this.cacheTemplateExecutor.execute(cacheTemplates);
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.cacheTemplateExecutor != null) {
            this.cacheTemplateExecutor.shutdownNow();
            ExecutorTools.awaitTermination(this.cacheTemplateExecutor);
        }
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        if (this.cacheTemplateExecutor != null) {
            this.cacheTemplateExecutor.shutdownNow();
            ExecutorTools.awaitTermination(this.cacheTemplateExecutor);
        }
    }

    @Override
    public TemplateManager getTemplateManager() {
        return this;
    }

    @Override
    public InstanceManager getInstanceManager() {
        return this;
    }

    @Override
    public URI[] getExecutionLogManager(SessionToken session) {
        return this.logManager.getURIs();
    }

    @Override
    public Template getTemplate(SessionToken session, UUID templateID) {
        super.sessionActive(session);
        try {
            Template ret;
            try {
                Template unreplaced = this.templateStorage.getTemplate(templateID);
                UUID parentID = this.templateStorage.getParentTemplateID(unreplaced.getID());
                ret = parentID != null ? new IDWrappingTemplate(unreplaced, parentID) : unreplaced;
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the template storage for retrieval of template '%1$s'.", templateID);
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
            Template template = ret;
            return template;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public TemplateReference getTemplateReference(SessionToken session, UUID templateID) {
        super.sessionActive(session);
        try {
            TemplateReference reference;
            try {
                reference = this.templateStorage.getTemplateReference(templateID, this);
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the template storage for retrieval of template reference for '%1$s'.", templateID);
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
            TemplateReference templateReference = reference;
            return templateReference;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Set<TemplateReference> getAllTemplateReferences(SessionToken session) {
        super.sessionActive(session);
        try {
            TreeSet<TemplateReference> references = new TreeSet<TemplateReference>(new TemplateReferenceComparator());
            try {
                for (UUID templateID : this.getAllTemplateIDs(session)) {
                    references.add(this.templateStorage.getTemplateReference(templateID, this));
                }
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the template storage for retrieval of all template references.", new Object[0]);
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
            TreeSet<TemplateReference> treeSet = references;
            return treeSet;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public TemplateManager.TemplateKind getTemplateKind(SessionToken session, UUID templateID) {
        super.sessionActive(session);
        try {
            TemplateManager.TemplateKind kind;
            try {
                boolean isInstanceSpecific;
                boolean isEmbedded = this.templateStorage.getParentTemplateID(templateID) != null;
                boolean bl = isInstanceSpecific = !this.templateStorage.getBaseTemplateID(templateID).equals(templateID);
                kind = isEmbedded && isInstanceSpecific ? TemplateManager.TemplateKind.EMBEDDED_INSTANCE_SPECIFIC : (isEmbedded ? TemplateManager.TemplateKind.EMBEDDED : (isInstanceSpecific ? TemplateManager.TemplateKind.INSTANCE_SPECIFIC : TemplateManager.TemplateKind.NORMAL));
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the template storage for retrieval of template kind for '%1$s'.", templateID);
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
            TemplateManager.TemplateKind templateKind = kind;
            return templateKind;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Set<UUID> getAllTemplateIDs(SessionToken session) {
        super.sessionActive(session);
        try {
            TreeSet<UUID> ret = new TreeSet<UUID>();
            try {
                for (UUID templateID : this.templateStorage.getAllTemplateIDs()) {
                    if (UUIDTools.isNegative(templateID)) continue;
                    ret.add(templateID);
                }
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the template storage for retrieval of all template IDs.", new Object[0]);
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
            TreeSet<UUID> treeSet = ret;
            return treeSet;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Set<TemplateReference> findTemplates(SessionToken session, Filter templateFilter, Filter templateStatusFilter) {
        HashSet<TemplateReference> results = new HashSet<TemplateReference>();
        Set<UUID> templateIDs = this.getAllTemplateIDs(session);
        for (UUID templateID : templateIDs) {
            TemplateStatus status;
            Template template = this.getTemplate(session, templateID);
            if (templateFilter != null && !templateFilter.matches(template) || templateStatusFilter != null && !templateStatusFilter.matches(status = this.getTemplateStatus(session, templateID))) continue;
            results.add(this.getTemplateReference(session, templateID));
        }
        return results;
    }

    @Override
    public CheckReport storeNewTemplate(SessionToken session, Template template, TemplateStatus templateStatus) {
        return this.storeNewTemplates(session, new Template[]{template}, new TemplateStatus[]{templateStatus});
    }

    @Override
    public CheckReport storeNewTemplates(SessionToken session, Template[] templates, TemplateStatus[] templateStatuses) {
        Set<UUID> templateIDs;
        ArgChecks.checkForNulls(templates, "templates");
        ArgChecks.checkForNulls(templateStatuses, "templateStatus");
        try {
            templateIDs = this.templateStorage.getAllTemplateIDs();
        }
        catch (DataSourceException e) {
            throw new InternalServiceException("Error while accessing the storage!", e);
        }
        CheckReport ret = new CheckReport(this.getURIs()[0]);
        if (this.checkNewTemplates(session, templates, templateStatuses, ret)) {
            int i = 0;
            while (i < templates.length) {
                if (templateIDs.contains(templates[i].getID())) {
                    URI templateURI = ProcessElementIdentifierTools.getTemplateIdentifier(templates[i], this.registry.getInstanceName());
                    String msg = String.format("The template with ID %s (Name: %s) already exists, won't store it.", templates[i].getID(), templates[i].getName());
                    ret.addReportEntry(CHECK_REPORT_ID, CheckReport.ResultType.INFO, msg, templateURI);
                } else {
                    this.internalStoreNewTemplate(session, templates[i], templateStatuses[i], templates[i].getID(), null);
                }
                ++i;
            }
        }
        return ret;
    }

    protected boolean checkNewTemplates(SessionToken session, Template[] templates, TemplateStatus[] templateStatuses, CheckReport report) {
        super.sessionActive(session);
        try {
            boolean ret = true;
            ProcessTemplateCheck[] checks = this.getChecks(session, templates);
            ProcessTemplateCheckRunner checkRunner = new ProcessTemplateCheckRunner(checks);
            HashMap<UUID, TemplateStatus> childTemplateStatuses = new HashMap<UUID, TemplateStatus>(templates.length);
            int i = 0;
            while (i < templates.length) {
                String msg;
                Template template = templates[i];
                URI templateURI = ProcessElementIdentifierTools.getTemplateIdentifier(template, this.registry.getInstanceName());
                childTemplateStatuses.put(template.getID(), templateStatuses[i]);
                ret &= checkRunner.performCheck(template, new NodeRelations(template), report);
                if (templateStatuses[i] != null) {
                    if (templateStatuses[i].getBuildtimeState() != ProcessConstants.TemplateBuildtimeState.RELEASED) {
                        msg = String.format("Template %s is not in buildtime state RELEASED but in state %s. Cannot store template.", new Object[]{template.getID(), templateStatuses[i].getBuildtimeState()});
                        report.addReportEntry(CHECK_REPORT_ID, CheckReport.ResultType.FAILURE, msg, templateURI);
                        ret &= false;
                    }
                    if (!templateStatuses[i].isInstantiable(false)) {
                        msg = String.format("Template %s is not instantiable yet. It will be stored anyway.", template.getID());
                        report.addReportEntry(CHECK_REPORT_ID, CheckReport.ResultType.INFO, msg, templateURI);
                    }
                    if (!templateStatuses[i].isTopLevelUsable()) {
                        msg = String.format("Template %s is not usable as top-level process. It will be stored for subprocess-usage only.", template.getID());
                        report.addReportEntry(CHECK_REPORT_ID, CheckReport.ResultType.INFO, msg, templateURI);
                    }
                }
                for (Node node : template.getNodes()) {
                    ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
                    if (ebp instanceof VariableParallelismEBP) {
                        ebp = ((VariableParallelismEBP)ebp).getLightWeightProcess();
                    }
                    if (!(ebp instanceof ReferencedProcess)) continue;
                    UUID childTemplateID = ((ReferencedProcess)ebp).getTemplateID();
                    msg = String.format("Template %s references the child template %s but this is unknown to this process manager. Cannot store template.", template.getID(), childTemplateID);
                    TemplateStatus childTemplateStatus = null;
                    if (!childTemplateStatuses.containsKey(childTemplateID)) {
                        try {
                            childTemplateStatus = this.getTemplateStatus(session, childTemplateID);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            report.addReportEntry(CHECK_REPORT_ID, CheckReport.ResultType.FAILURE, msg, templateURI);
                            ret &= false;
                        }
                    } else {
                        childTemplateStatus = (TemplateStatus)childTemplateStatuses.get(childTemplateID);
                    }
                    if (childTemplateStatus == null) continue;
                    boolean fork = ((ReferencedProcess)ebp).fork();
                    if (fork) {
                        if (!childTemplateStatus.isTopLevelUsable()) {
                            msg = String.format("Template %s used as forked sub-process is not allowed to be used as top-level subprocess. Cannot store parent template %s.", childTemplateID, template.getID());
                            report.addReportEntry(CHECK_REPORT_ID, CheckReport.ResultType.FAILURE, msg, templateURI);
                            ret &= false;
                        }
                    } else if (childTemplateStatus.getUsageAsSubprocess() != ProcessConstants.TemplateUsage.AS_REFERENCE && childTemplateStatus.getUsageAsSubprocess() != ProcessConstants.TemplateUsage.COPY_OR_REFERENCE) {
                        msg = String.format("Template %s is not allowed to be used as referenced subprocess. Cannot store parent template %s.", childTemplateID, template.getID());
                        report.addReportEntry(CHECK_REPORT_ID, CheckReport.ResultType.FAILURE, msg, templateURI);
                        ret &= false;
                    }
                    if (childTemplateStatus.isInstantiable(!fork)) continue;
                    msg = String.format("Template %s is not allowed to be instantiated as %sprocess. Cannot store parent template %s.", childTemplateID, fork ? "top-level " : "sub-", template.getID());
                    report.addReportEntry(CHECK_REPORT_ID, CheckReport.ResultType.FAILURE, msg, templateURI);
                    ret &= false;
                }
                ++i;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected Template internalStoreNewTemplate(SessionToken session, Template template, TemplateStatus templateStatus, UUID embeddedID, Set<UUID> embeddedIDList) {
        super.sessionActive(session);
        try {
            boolean needToStoreEmbeddedMapping;
            HashMap<Integer, ExecutableBusinessProcess> embeddedEBPs = new HashMap<Integer, ExecutableBusinessProcess>();
            ExecutableProcessModelFactory epmf = new ExecutableProcessModelFactory(null);
            boolean bl = needToStoreEmbeddedMapping = embeddedIDList == null;
            if (embeddedIDList == null) {
                embeddedIDList = new HashSet<UUID>();
            }
            for (Node node : template.getNodes()) {
                ExecutableBusinessProcess oldEBP = node.getExecutableBusinessProcess();
                boolean varPar = oldEBP instanceof VariableParallelismEBP;
                if (varPar) {
                    oldEBP = ((VariableParallelismEBP)oldEBP).getLightWeightProcess();
                }
                if (!(oldEBP instanceof EmbeddedProcess)) continue;
                EmbeddedProcess embeddedProcess = (EmbeddedProcess)oldEBP;
                UUID newID = UUIDTools.createNegativeRandomUUID();
                embeddedIDList.add(newID);
                Template storedEmbeddedTemplate = this.internalStoreNewTemplate(session, embeddedProcess.getTemplate(), null, newID, embeddedIDList);
                ExecutableBusinessProcess newEBP = epmf.createEmbeddedProcess(storedEmbeddedTemplate, embeddedProcess.getTemplate().getID(), newID, null, null, embeddedProcess.getExecutionControlProperties(), embeddedProcess, embeddedProcess.getUserAttributes());
                if (varPar) {
                    VariableParallelismEBP outerEBP = (VariableParallelismEBP)node.getExecutableBusinessProcess();
                    newEBP = epmf.createVariableParallelismEBP((LightWeightProcess)newEBP, outerEBP.getIndexedInputParameters(), null, null, outerEBP.getExecutionControlProperties(), outerEBP.getParameters(ActivityConstants.AccessType.READ), outerEBP.getParameters(ActivityConstants.AccessType.WRITE), outerEBP, outerEBP.getUserAttributes());
                }
                embeddedEBPs.put(node.getID(), newEBP);
            }
            if (embeddedEBPs.size() > 0) {
                template = new EBPWrappingTemplate(template, embeddedEBPs);
            }
            if (!template.getID().equals(embeddedID)) {
                template = new IDWrappingTemplate(template, embeddedID);
            }
            this.templateStorage.createTemplate(template, templateStatus);
            if (needToStoreEmbeddedMapping) {
                for (UUID id : embeddedIDList) {
                    this.templateStorage.updateEmbeddedTemplateIDs(id, template.getID());
                }
            }
            Template template2 = template;
            return template2;
        }
        catch (DataSourceException dse) {
            String msg = String.format("Failed when accessing the template storage for storing template '%s'.", embeddedID != null ? embeddedID : template.getID());
            this.logger.severe(msg);
            throw new InternalServiceException(msg, dse);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public TemplateStatus getTemplateStatus(SessionToken session, UUID templateID) {
        super.sessionActive(session);
        try {
            TemplateStatus templateStatus = this.getTemplateStatus(templateID);
            return templateStatus;
        }
        catch (DataSourceException dse) {
            String msg = String.format("Failed when accessing the template storage for retrieving the template status of '%1$s'.", templateID);
            this.logger.severe(msg);
            throw new InternalServiceException(msg, dse);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public TemplateStatus getTemplateStatus(UUID templateID) throws DataSourceException {
        UUID parentTemplateID = this.templateStorage.getParentTemplateID(templateID);
        UUID templateStatusID = parentTemplateID != null ? parentTemplateID : templateID;
        if (UUIDTools.isNegative(templateStatusID)) {
            templateStatusID = this.templateStorage.getBaseTemplateID(templateStatusID);
        }
        TemplateStatus ret = this.templateStorage.getTemplateStatus(templateStatusID);
        return ret;
    }

    /*
     * Exception decompiling
     */
    @Override
    public TemplateStatus getAndLockTemplateStatus(SessionToken session, UUID templateID) throws AcquireLockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean findTemplatesReferencingRecursive(SessionToken session, Template template, UUID referencedTemplateID, boolean topRefs, boolean subRefs) {
        boolean subOutdated;
        TemplateStatus status = this.getTemplateStatus(session, template.getID());
        boolean topOutdated = !status.isTopLevelUsable() || status.isOutdated(false);
        boolean bl = subOutdated = status.getUsageAsSubprocess() == ProcessConstants.TemplateUsage.NO_SUBPROCESS || status.isOutdated(true);
        if (!topOutdated || !subOutdated) {
            for (Node n : template.getNodes()) {
                boolean fork;
                ExecutableBusinessProcess ebp = n.getExecutableBusinessProcess();
                if (ebp instanceof VariableParallelismEBP) {
                    ebp = ((VariableParallelismEBP)ebp).getLightWeightProcess();
                }
                if (!(ebp instanceof EmbeddedProcess ? this.findTemplatesReferencingRecursive(session, ((EmbeddedProcess)ebp).getTemplate(), referencedTemplateID, topRefs, subRefs) : ebp instanceof ReferencedProcess && ((ReferencedProcess)ebp).getTemplateID().equals(referencedTemplateID) && ((fork = ((ReferencedProcess)ebp).fork()) && topRefs || !fork && subRefs))) continue;
                return true;
            }
        }
        return false;
    }

    protected List<String> findTemplatesReferencing(SessionToken session, UUID referencedTemplateID, boolean topRefs, boolean subRefs) {
        this.logMethodEntry("Generic finding referencing templates", session, "method entry", referencedTemplateID, null, null, null, null);
        try {
            Set<UUID> ids = this.getAllTemplateIDs(session);
            LinkedList<String> ret = new LinkedList<String>();
            for (UUID id : ids) {
                Template t = this.getTemplate(session, id);
                if (!this.findTemplatesReferencingRecursive(session, t, referencedTemplateID, topRefs, subRefs)) continue;
                StringBuilder msg = new StringBuilder();
                msg.append("- ");
                msg.append(t.getName());
                msg.append(" v");
                if (t.getVersion().length() > 0) {
                    msg.append(t.getVersion());
                } else {
                    msg.append("0");
                }
                msg.append(" [");
                msg.append(t.getID());
                msg.append("]");
                ret.add(msg.toString());
            }
            LinkedList<String> linkedList = ret;
            return linkedList;
        }
        finally {
            this.logMethodExit("method exit");
        }
    }

    @Override
    public void setTemplateStatus(SessionToken session, TemplateStatus templateStatus) throws ReleaseLockException, InvalidTemplateStateException {
        super.sessionActive(session);
        try {
            try {
                List<String> references;
                boolean topChanged;
                if (!this.hasUpdateLock(session, templateStatus.getTemplateID())) {
                    throw new ReleaseLockException((Object)templateStatus.getTemplateID(), false, (Object)session, "TemplateStatusUpdateLock");
                }
                TemplateStatus oldStatus = this.getTemplateStatus(session, templateStatus.getTemplateID());
                boolean usageChanged = (oldStatus.getUsageAsSubprocess() == ProcessConstants.TemplateUsage.AS_REFERENCE || oldStatus.getUsageAsSubprocess() == ProcessConstants.TemplateUsage.COPY_OR_REFERENCE) && templateStatus.getUsageAsSubprocess() != ProcessConstants.TemplateUsage.AS_REFERENCE && templateStatus.getUsageAsSubprocess() != ProcessConstants.TemplateUsage.COPY_OR_REFERENCE;
                boolean topUsageChanged = oldStatus.isTopLevelUsable() && !templateStatus.isTopLevelUsable();
                boolean outdatedChanged = !oldStatus.isOutdated(true) && templateStatus.isOutdated(true);
                boolean topOutdatedChanged = !oldStatus.isOutdated(false) && templateStatus.isOutdated(false);
                boolean instantiableChanged = oldStatus.isInstantiable(true) && !templateStatus.isInstantiable(true);
                boolean topInstantiableChanged = oldStatus.isInstantiable(false) && !templateStatus.isInstantiable(false);
                boolean subChanged = usageChanged || outdatedChanged || instantiableChanged;
                boolean bl = topChanged = topUsageChanged || topOutdatedChanged || topInstantiableChanged;
                if ((subChanged || topChanged) && (references = this.findTemplatesReferencing(session, templateStatus.getTemplateID(), topChanged, subChanged)).size() > 0) {
                    StringBuilder msg = new StringBuilder();
                    boolean first = true;
                    for (String template : references) {
                        if (!first) {
                            msg.append("\n");
                        }
                        msg.append(template);
                        first = false;
                    }
                    String message = String.format("The template status of template %s may not be changed in this manner because the template is referenced by other templates:\n%s", templateStatus.getTemplateID(), msg.toString());
                    throw new InvalidTemplateStateException(message);
                }
                this.templateStorage.updateTemplateStatus(templateStatus);
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the template storage for updating template status of '%1$s'.", templateStatus.getTemplateID());
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void setAndUnlockTemplateStatus(SessionToken session, TemplateStatus templateStatus) throws ReleaseLockException, InvalidTemplateStateException {
        super.sessionActive(session);
        try {
            this.setTemplateStatus(session, templateStatus);
            this.unlockTemplateForUpdates(session, templateStatus.getTemplateID());
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void unlockTemplateStatus(SessionToken session, UUID templateID) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            this.unlockTemplateForUpdates(session, templateID);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockTemplateForUpdates(SessionToken session, UUID templateID) throws AcquireLockException {
        super.sessionActive(session);
        try {
            try {
                Object object = this.intermediateTemplateLock;
                synchronized (object) {
                    QualifiedAgent requestingAgent = this.sessionFactory.checkAndGetTopLevelAgent(session);
                    if (this.templateUpdateLocks.containsKey(templateID) && !this.hasUpdateLock(session, templateID)) {
                        throw new AcquireLockException(templateID, session, "TemplateUpdateLock");
                    }
                    try {
                        this.templateStorage.lockTemplateForUpdates(templateID, requestingAgent);
                        this.templateUpdateLocks.put(templateID, requestingAgent);
                        String msg = String.format("Template '%1$s' locked for updates for '%2$s'.", templateID, requestingAgent);
                        this.logger.fine(msg);
                    }
                    catch (DataSourceException dse) {
                        String msg = String.format("Failed to lock template '%1$s' for updates for '%2$s'.", templateID, requestingAgent);
                        this.logger.severe(msg);
                        throw new InternalServiceException(msg, dse);
                    }
                }
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("Failed to verify the session token when locking template '%1$s' for updates.", templateID);
                this.logger.severe(msg);
                throw new ServiceAccessControlException(msg, stie);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean hasUpdateLock(SessionToken session, UUID templateID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockTemplateForUpdates(SessionToken session, UUID templateID) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            try {
                Object object = this.intermediateTemplateLock;
                synchronized (object) {
                    if (!this.templateUpdateLocks.containsKey(templateID)) {
                        String msg = String.format("Template '%1$s' has no update lock, unlocking impossible.", templateID);
                        this.logger.severe(msg);
                        throw new ReleaseLockException((Object)templateID, false, (Object)session, "TemplateUpdateLock");
                    }
                    QualifiedAgent lockingAgent = this.templateUpdateLocks.get(templateID);
                    QualifiedAgent requestingAgent = this.sessionFactory.checkAndGetTopLevelAgent(session);
                    if (!requestingAgent.equals(lockingAgent)) {
                        String msg = String.format("'1%s' has not locked template '%2$s' for updates. Refusing unlock.", requestingAgent, templateID);
                        this.logger.severe(msg);
                        throw new ReleaseLockException((Object)templateID, lockingAgent, (Object)session, "TemplateUpdateLock");
                    }
                    try {
                        String msg;
                        int lockCount = this.templateStorage.unlockTemplateForUpdates(templateID);
                        if (lockCount > 0) {
                            msg = String.format("Template '%1$s' is not unlocked for updates since '%2$s' still has %3$d update locks.", templateID, requestingAgent, lockCount);
                        } else {
                            this.templateUpdateLocks.remove(templateID);
                            msg = String.format("Template '%1$s' unlocked for updates for '%2$s'.", templateID, requestingAgent);
                        }
                        this.logger.fine(msg);
                    }
                    catch (DataSourceException dse) {
                        String msg = String.format("Failed to unlock template '%1$s' for updates for '%2$s'.", templateID, requestingAgent);
                        this.logger.severe(msg);
                        throw new InternalServiceException(msg, dse);
                    }
                }
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("Failed to verify the session token when unlocking template '%1$s' for updates.", templateID);
                this.logger.severe(msg);
                throw new ServiceAccessControlException(msg, stie);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public UUID getLogicalInstanceID(SessionToken session, UUID logID) {
        super.sessionActive(session);
        try {
            UUID ret;
            try {
                ret = this.instanceStorage.getLogicalInstanceID(logID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ret = null;
            }
            UUID uUID = ret;
            return uUID;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Instance getInstance(SessionToken session, UUID instanceID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(instanceID, "instanceID");
        super.sessionActive(session);
        try {
            ExecutableInstance ret;
            try {
                ret = this.instanceStorage.getInstance(instanceID);
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the instance storage for retrieval of instance '%1$s'.", instanceID);
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
            ExecutableInstance executableInstance = ret;
            return executableInstance;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public InstanceReference getInstanceReference(SessionToken session, UUID instanceID) {
        super.sessionActive(session);
        try {
            InstanceReference reference;
            try {
                reference = this.instanceStorage.getInstanceReference(instanceID, this);
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the instance storage for retrieval of the status of instance '%1$s'.", instanceID);
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
            InstanceReference instanceReference = reference;
            return instanceReference;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Set<InstanceReference> getAllInstanceReferencesOf(SessionToken session, UUID templateID) {
        super.sessionActive(session);
        try {
            HashSet<InstanceReference> references = new HashSet<InstanceReference>();
            for (UUID instanceID : this.instanceStorage.getInstanceIDsForTemplate(templateID)) {
                try {
                    references.add(this.instanceStorage.getInstanceReference(instanceID, this));
                }
                catch (DataSourceException dse) {
                    String msg = String.format("Failed when accessing the instance storage for retrieval instance references of template '%1$s'.", templateID);
                    this.logger.severe(msg);
                    throw new InternalServiceException(msg, dse);
                }
            }
            HashSet<InstanceReference> hashSet = references;
            return hashSet;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Set<UUID> getAllInstanceIDsOf(SessionToken session, UUID templateID) {
        super.sessionActive(session);
        try {
            Set<UUID> instances = this.instanceStorage.getInstanceIDsForTemplate(templateID);
            if (instances == null) {
                String msg = String.format("No instance found while looking for instances of template '%1$s'.", templateID);
                this.logger.info(msg);
                instances = new HashSet<UUID>();
            }
            Set<UUID> set = instances;
            return set;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Set<InstanceReference> findInstances(SessionToken session, Filter instanceFilter, Filter instanceStatusFilter) {
        Set<UUID> templateIDs = this.getAllTemplateIDs(session);
        return this.findInstances(session, templateIDs.toArray(new UUID[templateIDs.size()]), instanceFilter, instanceStatusFilter);
    }

    @Override
    public Set<InstanceReference> findInstances(SessionToken session, UUID[] templateIDs, Filter instanceFilter, Filter instanceStatusFilter) {
        if (templateIDs == null) {
            return this.findInstances(session, instanceFilter, instanceStatusFilter);
        }
        HashSet<InstanceReference> results = new HashSet<InstanceReference>();
        UUID[] uUIDArray = templateIDs;
        int n = templateIDs.length;
        int n2 = 0;
        while (n2 < n) {
            UUID templateID = uUIDArray[n2];
            HashSet<UUID> instanceIDs = new HashSet<UUID>(this.getAllInstanceIDsOf(session, templateID));
            for (UUID instanceID : instanceIDs) {
                Instance instance;
                InstanceStatus status;
                if (instanceStatusFilter != null && !instanceStatusFilter.matches(status = this.getInstanceStatus(session, instanceID)) || instanceFilter != null && !instanceFilter.matches(instance = this.getInstance(session, instanceID))) continue;
                results.add(this.getInstanceReference(session, instanceID));
            }
            ++n2;
        }
        return results;
    }

    @Override
    public ExecutableInstance createInstanceOf(SessionToken session, UUID templateID, String instanceName, QualifiedAgent supervisorAgent, long creationTime) throws LockException {
        super.sessionActive(session);
        try {
            ExecutableInstance executableInstance = this.createSubInstanceOf(session, templateID, instanceName, supervisorAgent, null, creationTime);
            return executableInstance;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ExecutableInstance createSubInstanceOf(SessionToken session, UUID templateID, String instanceName, QualifiedAgent supervisorAgent, EBPInstanceReference superInstanceActivity, long creationTime) throws LockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public ExecutableInstance getAndLockInstanceForExecution(SessionToken session, UUID instanceID) throws AcquireLockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setExecutableInstance(SessionToken session, ExecutableInstance executableInstance) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            try {
                if (!this.hasExecutionLock(session, executableInstance.getID())) {
                    String s = String.format("Tried to unlock an executable instance that was not locked. Available stacktraces, that locked/unlocked the instance:\n%s", this.getStackTracesOfInstance(executableInstance.getID()));
                    this.logger.log(Level.SEVERE, s);
                    throw new ReleaseLockException((Object)executableInstance.getID(), false, (Object)session, "InstanceExecutionLock");
                }
                this.instanceStorage.updateInstance(executableInstance);
                if (executableInstance instanceof ExecutableInstancePropertyTracker) {
                    ((ExecutableInstancePropertyTracker)((Object)executableInstance)).clearChangedProperties();
                }
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the instance storage for updating executed instance '%1$s'.", executableInstance.getID());
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void setAndUnlockExecutableInstance(SessionToken session, ExecutableInstance executableInstance) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            this.setExecutableInstance(session, executableInstance);
            this.unlockInstanceForExecution(session, executableInstance.getID());
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void unlockExecutableInstance(SessionToken session, UUID instanceID) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            this.unlockInstanceForExecution(session, instanceID);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QualifiedAgent getChangeLockingAgent(UUID instanceID) {
        Object object = this.intermediateInstanceLock;
        synchronized (object) {
            return this.instanceChangeLocks.get(instanceID);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ChangeableInstance getAndLockInstanceForChanging(SessionToken session, UUID instanceID) throws LockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ChangeReport changeInstance(SessionToken session, ChangeableInstance instance) throws ReleaseLockException {
        return this.changeInstance(session, instance, false);
    }

    @Override
    public ChangeReport changeAndUnlockInstance(SessionToken session, ChangeableInstance instance) throws ReleaseLockException {
        return this.changeInstance(session, instance, true);
    }

    protected ChangeReport changeInstance(SessionToken session, ChangeableInstance instance, boolean releaseLock) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            URI base;
            ChangeReport ret;
            if (!this.hasChangeLock(session, instance.getID())) {
                throw new ReleaseLockException((Object)instance.getID(), false, (Object)session, "InstanceChangeLock");
            }
            Template template = instance.getTemplate();
            ProcessTemplateCheck[] checks = this.getChecks(session, new Template[]{template});
            ProcessTemplateCheckRunner checkRunner = new ProcessTemplateCheckRunner(checks);
            boolean checkSuccess = checkRunner.performCheck(template, new NodeRelations(template), ret = new ChangeReport(base = this.getURIs()[0], instance.getID()));
            if (checkSuccess) {
                String message = String.format("Checks successful, changing instance %s.", instance.getID());
                this.logger.log(Level.INFO, message, ret.getReportSummary());
                ret.setNewInstanceID(this.instanceStorage.updateChangeableInstance(instance));
                ret.setNewInstance(this.instanceStorage.getInstanceChangeable(ret.newInstanceID));
                this.changeChangeLock(ret.oldInstanceID, ret.newInstanceID);
                if (releaseLock) {
                    this.unlockInstanceForChanges(session, ret.newInstanceID);
                }
            } else {
                String message = String.format("The checks on instance %s failed! It will not be changed. Reason: %s", instance.getID(), ret.getReportSummary());
                this.logger.log(Level.INFO, message, ret.getReportSummary());
            }
            ChangeReport changeReport = ret;
            return changeReport;
        }
        catch (DataSourceException dse) {
            String msg = String.format("Failed when accessing the instance storage for updating changeable instance '%1$s'.", instance.getID());
            this.logger.severe(msg);
            throw new InternalServiceException(msg, dse);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void unlockChangeableInstance(SessionToken session, UUID instanceID) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            this.unlockInstanceForChanges(session, instanceID);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public InstanceStatus getInstanceStatus(SessionToken session, UUID instanceID) {
        super.sessionActive(session);
        try {
            InstanceStatus instanceStatus = this.instanceStorage.getInstanceStatus(instanceID);
            return instanceStatus;
        }
        catch (DataSourceException dse) {
            String msg = String.format("Failed when accessing the instance storage for retrieving the instance status of '%1$s'.", instanceID);
            this.logger.severe(msg);
            throw new InternalServiceException(msg, dse);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void setExecutionStatus(SessionToken session, UUID instanceID, ProcessConstants.InstanceExecutionStatus executionStatus, String comment) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            try {
                if (!this.hasExecutionLock(session, instanceID)) {
                    throw new ReleaseLockException((Object)instanceID, false, (Object)session, "InstanceExecutionLock");
                }
                InstanceStatus status = this.getInstanceStatus(session, instanceID);
                status.setExecutionStatus(executionStatus, comment);
                this.instanceStorage.updateInstanceStatus(status);
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the instance storage for updating execution status of '%1$s'.", instanceID);
                this.logger.log(Level.SEVERE, msg);
                throw new InternalServiceException(msg, dse);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public InstanceStatus getAndLockInstanceStatus(SessionToken session, UUID instanceID) throws LockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setInstanceStatus(SessionToken session, InstanceStatus instanceStatus) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            try {
                if (!this.hasChangeLock(session, instanceStatus.getInstanceID())) {
                    throw new ReleaseLockException((Object)instanceStatus.getInstanceID(), false, (Object)session, "InstanceStatusChangeLock");
                }
                this.instanceStorage.updateInstanceStatus(instanceStatus);
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the instance storage for updating instance status of '%1$s'.", instanceStatus.getInstanceID());
                this.logger.log(Level.SEVERE, msg);
                throw new InternalServiceException(msg, dse);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void setAndUnlockInstanceStatus(SessionToken session, InstanceStatus instanceStatus) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            this.setInstanceStatus(session, instanceStatus);
            this.unlockInstanceForChanges(session, instanceStatus.getInstanceID());
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void unlockInstanceStatus(SessionToken session, UUID instanceID) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            this.unlockInstanceForChanges(session, instanceID);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockInstanceForExecution(SessionToken session, UUID instanceID) throws AcquireLockException {
        block28: {
            super.sessionActive(session);
            try {
                try {
                    String msg;
                    boolean registeredAsWaiter = false;
                    try {
                        SessionLock executionLock;
                        Object object = this.intermediateInstanceLock;
                        synchronized (object) {
                            if (this.instanceChangeLocks.containsKey(instanceID)) {
                                QualifiedAgent lockingAgent = this.instanceChangeLocks.get(instanceID);
                                QualifiedAgent requestingAgent = this.sessionFactory.checkAndGetTopLevelAgent(session);
                                if (!requestingAgent.equals(lockingAgent)) {
                                    throw new AcquireLockException(instanceID, lockingAgent, "InstanceChangeLock", requestingAgent, "InstanceExecutionLock");
                                }
                            }
                            if (this.instanceExecutionLocks.containsKey(instanceID)) {
                                executionLock = this.instanceExecutionLocks.get(instanceID);
                                this.incrementLockWaitCount(instanceID);
                                registeredAsWaiter = true;
                                msg = String.format("Execution lock exists for instance '%1$s'. Registered to prevent removal.", instanceID);
                                this.logger.log(Level.INFO, msg);
                            } else {
                                msg = String.format("Creating new execution lock for instance '%1$s'. Registering as waiter.", instanceID);
                                this.logger.log(Level.INFO, msg);
                                try {
                                    executionLock = new SessionLock((Class<? extends ReentrantLock.LockCountManager<SessionToken>>)SessionLock.UUIDLockCount.class, true);
                                }
                                catch (InstantiationException ie) {
                                    msg = "Could not instantiate lock count manager for session lock. Please provide one with a parameterless public constructor.";
                                    throw new InternalServiceException(msg, ie);
                                }
                                catch (IllegalAccessException iae) {
                                    msg = "Could not access lock count manager for session lock. Please provide one with a parameterless public constructor.";
                                    throw new InternalServiceException(msg, iae);
                                }
                                this.instanceExecutionLocks.put(instanceID, executionLock);
                                this.incrementLockWaitCount(instanceID);
                                registeredAsWaiter = true;
                            }
                        }
                        try {
                            executionLock.writeLock().lock(session, 60000L);
                            msg = String.format("Instance '%s' locked for execution by '%s'.", instanceID, session);
                            this.logger.log(Level.INFO, msg);
                            this.rememberCurrentStackTrace(this.instanceLockStackTraces, instanceID);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            msg = String.format("Interrupted while retrieving an instance execution lock for instance '%s' for session '%s'.", instanceID, session);
                            this.logger.log(Level.SEVERE, msg);
                            throw new InvalidServiceStateException(msg, ie);
                        }
                        catch (TimeoutException te) {
                            msg = String.format("Got a timeout while waiting for the execution lock for instance '%s' for session '%s'. This is possibly a deadlock. Information about the positions locking/unlocking the instance:\n%s", instanceID, session, this.getStackTracesOfInstance(instanceID));
                            throw new InvalidServiceStateException(msg, te);
                        }
                    }
                    catch (Throwable throwable) {
                        if (registeredAsWaiter) {
                            Object object = this.intermediateInstanceLock;
                            synchronized (object) {
                                this.decrementLockWaitCount(instanceID);
                                String msg2 = String.format("Execution lock for instance '%1$s' acquired. Deregistered to allow removal again.", instanceID);
                                this.logger.log(Level.INFO, msg2);
                            }
                        }
                        throw throwable;
                    }
                    if (!registeredAsWaiter) break block28;
                    Object object = this.intermediateInstanceLock;
                    synchronized (object) {
                        this.decrementLockWaitCount(instanceID);
                        msg = String.format("Execution lock for instance '%1$s' acquired. Deregistered to allow removal again.", instanceID);
                        this.logger.log(Level.INFO, msg);
                    }
                }
                catch (SecurityTokenIntegrityException stie) {
                    String msg = String.format("Failed to verify the session token when locking instance '%1$s' for execution.", instanceID);
                    this.logger.severe(msg);
                    throw new ServiceAccessControlException(msg, stie);
                }
            }
            finally {
                super.sessionFinished(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasExecutionLock(SessionToken session, UUID instanceID) {
        super.sessionActive(session);
        try {
            Object object = this.intermediateInstanceLock;
            synchronized (object) {
                SessionLock executionLock = this.instanceExecutionLocks.get(instanceID);
                boolean bl = executionLock != null && executionLock.writeLock().hasLock(session);
                return bl;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockInstanceForExecution(SessionToken session, UUID instanceID) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            Object object = this.intermediateInstanceLock;
            synchronized (object) {
                boolean unlocked;
                SessionLock executionLock = this.instanceExecutionLocks.get(instanceID);
                if (executionLock == null) {
                    String msg = String.format("Instance '%s' has no execution lock, unlocking impossible. Available stacktraces:\n%s", instanceID, this.getStackTracesOfInstance(instanceID));
                    this.logger.log(Level.SEVERE, msg);
                    throw new ReleaseLockException((Object)instanceID, false, (Object)session, "InstanceExecutionLock");
                }
                if (!executionLock.writeLock().hasLock(session)) {
                    String lockingObject = executionLock.writeLock().currentLockingObject();
                    String msg = String.format("Instance '%s' has no execution lock by session '%s', but by '%s'. Available stacktraces:\n%s", instanceID, session, lockingObject, this.getStackTracesOfInstance(instanceID));
                    this.logger.log(Level.SEVERE, msg);
                    throw new ReleaseLockException((Object)instanceID, lockingObject, (Object)session, "InstanceExecutionLock");
                }
                boolean lockWaiterNotified = executionLock.writeLock().unlock(session);
                String msg = String.format("Instance '%s' unlocked for execution by '%s'.", instanceID, session);
                this.logger.log(Level.INFO, msg);
                this.rememberCurrentStackTrace(this.instanceUnlockStackTraces, instanceID);
                boolean bl = unlocked = !executionLock.writeLock().hasLock(session);
                if (unlocked && this.instanceStorage instanceof CachingStorage) {
                    ((CachingStorage)this.instanceStorage).invalidateUnsavedChanges(instanceID);
                }
                if (!lockWaiterNotified && unlocked && this.getLockWaitCount(instanceID) == 0) {
                    this.instanceExecutionLocks.remove(instanceID);
                    msg = String.format("Execution lock for instance '%s' removed by '%s' since there are no waiters.", instanceID, session);
                    this.logger.log(Level.INFO, msg);
                }
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int incrementLockWaitCount(UUID instanceID) {
        int ret;
        Map<UUID, Integer> map = this.instanceExecutionWaitingLockCount;
        synchronized (map) {
            ret = this.instanceExecutionWaitingLockCount.containsKey(instanceID) ? this.instanceExecutionWaitingLockCount.get(instanceID) + 1 : 1;
            this.instanceExecutionWaitingLockCount.put(instanceID, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLockWaitCount(UUID instanceID) {
        int ret;
        Map<UUID, Integer> map = this.instanceExecutionWaitingLockCount;
        synchronized (map) {
            ret = this.instanceExecutionWaitingLockCount.containsKey(instanceID) ? this.instanceExecutionWaitingLockCount.get(instanceID) : 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int decrementLockWaitCount(UUID instanceID) {
        int ret;
        Map<UUID, Integer> map = this.instanceExecutionWaitingLockCount;
        synchronized (map) {
            ret = this.instanceExecutionWaitingLockCount.get(instanceID) - 1;
            if (ret > 0) {
                this.instanceExecutionWaitingLockCount.put(instanceID, ret);
            } else {
                this.instanceExecutionWaitingLockCount.remove(instanceID);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockInstanceForChanges(SessionToken session, UUID instanceID) throws LockException {
        super.sessionActive(session);
        try {
            try {
                QualifiedAgent requestingAgent = this.sessionFactory.checkAndGetTopLevelAgent(session);
                ExecutableInstance instance = this.instanceStorage.getInstance(instanceID);
                Object object = this.intermediateTemplateLock;
                synchronized (object) {
                    if (this.templateUpdateLocks.containsKey(instance.getBaseTemplateID())) {
                        throw new AcquireLockException((Object)instanceID, "TemplateUpdateLock", (Object)requestingAgent, "InstanceChangeLock");
                    }
                }
                SessionToken executionLockSession = this.sessionFactory.getSubstituteSessionToken(session, session.getSecurityToken());
                this.lockInstanceForExecution(executionLockSession, instanceID);
                try {
                    Object object2 = this.intermediateInstanceLock;
                    synchronized (object2) {
                        try {
                            if (this.instanceChangeLocks.containsKey(instanceID)) {
                                throw new AcquireLockException((Object)instanceID, this.instanceChangeLocks.get(instanceID), (Object)requestingAgent, "InstanceChangeLock");
                            }
                            this.instanceStorage.lockInstanceForChanging(instanceID, requestingAgent);
                            this.instanceChangeLocks.put(instanceID, requestingAgent);
                            this.rememberCurrentStackTrace(this.instanceLockStackTraces, instanceID);
                            String msg = String.format("Instance '%1$s' locked for changes for '%2$s'.", instanceID, requestingAgent);
                            this.logger.log(Level.FINE, msg);
                        }
                        catch (DataSourceException dse) {
                            String msg = String.format("Failed to lock instance '%1$s' for changes for '%2$s'.", instanceID, requestingAgent);
                            this.logger.log(Level.SEVERE, msg);
                            throw new InternalServiceException(msg, dse);
                        }
                    }
                }
                finally {
                    this.unlockInstanceForExecution(executionLockSession, instanceID);
                }
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("Failed to verify the session token when locking instance '%1$s' for changes.", instanceID);
                this.logger.log(Level.SEVERE, msg);
                throw new ServiceAccessControlException(msg, stie);
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed when accessing the template storage when locking instance '%1$s' for changes.", instanceID);
                this.logger.log(Level.SEVERE, msg);
                throw new InternalServiceException(msg, dse);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeChangeLock(UUID oldID, UUID newID) {
        Object object = this.intermediateInstanceLock;
        synchronized (object) {
            int lockCount;
            QualifiedAgent lockingAgent = this.instanceChangeLocks.get(oldID);
            try {
                lockCount = this.instanceStorage.unlockInstanceForChanging(oldID);
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed to unlock instance for ID change (new ID: '%1$s', old ID: '%2$s'. Aborting.", newID, oldID);
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
            if (lockCount != 0) {
                String msg = String.format("The IDs of the instance '%1$s' (old: '%2$s') can not be changed since the change lock for the old ID is held  %3$d times. This is a serious error, since change locks are not reentrant. Aborting.", newID, oldID, lockCount);
                this.logger.severe(msg);
                throw new InternalServiceException(msg);
            }
            this.instanceChangeLocks.remove(oldID);
            try {
                this.instanceStorage.lockInstanceForChanging(newID, lockingAgent);
            }
            catch (DataSourceException dse) {
                String msg = String.format("Failed to relock instance for ID change (new ID: '%1$s', old ID: '%2$s'. Aborting. Instance has no change lock any more.", newID, oldID);
                this.logger.severe(msg);
                throw new InternalServiceException(msg, dse);
            }
            this.instanceChangeLocks.put(newID, lockingAgent);
        }
        String msg = String.format("The lock for the ID change of instance '%1$s' (old: '%2$s') has successfully been migrated to the new ID.", newID, oldID);
        this.logger.fine(msg);
    }

    /*
     * Exception decompiling
     */
    protected boolean hasChangeLock(SessionToken session, UUID instanceID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockInstanceForChanges(SessionToken session, UUID instanceID) throws ReleaseLockException {
        super.sessionActive(session);
        try {
            try {
                Object object = this.intermediateInstanceLock;
                synchronized (object) {
                    if (!this.instanceChangeLocks.containsKey(instanceID)) {
                        String msg = String.format("Instance '%s' has no change lock, unlocking impossible. Available stacktraces:\n%s", instanceID, this.getStackTracesOfInstance(instanceID));
                        this.logger.severe(msg);
                        throw new ReleaseLockException((Object)instanceID, false, (Object)session, "InstanceChangeLock");
                    }
                    QualifiedAgent lockingAgent = this.instanceChangeLocks.get(instanceID);
                    QualifiedAgent requestingAgent = this.sessionFactory.checkAndGetTopLevelAgent(session);
                    if (!requestingAgent.equals(lockingAgent)) {
                        String msg = String.format("'%s' has not locked instance '%s' for changes. Refusing unlock. Available stacktraces:\n%s", requestingAgent, instanceID, this.getStackTracesOfInstance(instanceID));
                        this.logger.severe(msg);
                        throw new ReleaseLockException((Object)instanceID, lockingAgent, (Object)session, "InstanceChangeLock");
                    }
                    try {
                        String msg;
                        int lockCount = this.instanceStorage.unlockInstanceForChanging(instanceID);
                        this.rememberCurrentStackTrace(this.instanceUnlockStackTraces, instanceID);
                        if (lockCount > 0) {
                            msg = String.format("Instance '%1$s' is not unlocked for changes since '%2$s' still has %3$d change locks.", instanceID, requestingAgent, lockCount);
                        } else {
                            this.instanceChangeLocks.remove(instanceID);
                            msg = String.format("Instance '%1$s' unlocked for changes for '%2$s'.", instanceID, requestingAgent);
                        }
                        this.logger.fine(msg);
                    }
                    catch (DataSourceException dse) {
                        String msg = String.format("Failed to unlock instance '%1$s' for changes for '%2$s'.", instanceID, requestingAgent);
                        this.logger.severe(msg);
                        throw new InternalServiceException(msg, dse);
                    }
                }
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("Failed to verify the session token when locking instance '%1$s' for changes.", instanceID);
                this.logger.severe(msg);
                throw new ServiceAccessControlException(msg, stie);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected ProcessTemplateCheck[] getChecks(SessionToken session, Template[] templates) {
        ProcessTemplateCheck checks = this.TEST_MODE ? this.processChecks.getExecutionTestClientChecks() : this.processChecks.getExecutionProductionChecks();
        return new ProcessTemplateCheck[]{this.processChecks.getConsistencyChecks(), this.processChecks.getStructureChecks(), checks, new LWPReferenceCheck(this, templates, this.sessionFactory, this.getURIs())};
    }

    protected StackTraceElement[] getCurrentStackTrace(int skips) {
        int numberOfElements = 10;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (stackTrace.length < numberOfElements + skips + 2 && (numberOfElements = stackTrace.length - (skips + 2)) < 0) {
            numberOfElements = 0;
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[numberOfElements];
        if (numberOfElements > 0) {
            System.arraycopy(stackTrace, skips + 2, newStackTrace, 0, numberOfElements);
        }
        return newStackTrace;
    }

    protected void rememberCurrentStackTrace(Map<UUID, List<StackTraceElement[]>> where, UUID id) {
        List<Object> stackList;
        if (!SystemProperties.getDebugConfig()) {
            return;
        }
        if (where.containsKey(id)) {
            stackList = where.get(id);
        } else {
            stackList = new ArrayList();
            where.put(id, stackList);
        }
        stackList.add(this.getCurrentStackTrace(2));
    }

    protected String getStackTracesOfInstance(UUID instanceID) {
        boolean first;
        if (!SystemProperties.getDebugConfig()) {
            return "No stacktraces available, because DEBUG mode is deactivated.";
        }
        ByteArrayOutputStream str = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(str, true);
        Throwable t = new Throwable();
        String s = String.format("Instance %s locked at ", instanceID);
        this.writeToByteArrayOutputStream(str, s);
        if (this.instanceLockStackTraces.containsKey(instanceID)) {
            first = true;
            for (StackTraceElement[] stack : this.instanceLockStackTraces.get(instanceID)) {
                if (!first) {
                    this.writeToByteArrayOutputStream(str, " and ");
                }
                first = false;
                if (stack.length > 0) {
                    t.setStackTrace(stack);
                    t.printStackTrace(stream);
                    continue;
                }
                this.writeToByteArrayOutputStream(str, "no stacktrace available");
            }
        } else {
            this.writeToByteArrayOutputStream(str, "None.");
        }
        s = String.format("Instance %s unlocked at ", instanceID);
        this.writeToByteArrayOutputStream(str, s);
        if (this.instanceUnlockStackTraces.containsKey(instanceID)) {
            first = true;
            for (StackTraceElement[] stack : this.instanceUnlockStackTraces.get(instanceID)) {
                if (!first) {
                    this.writeToByteArrayOutputStream(str, " and ");
                }
                first = false;
                if (stack.length > 0) {
                    t.setStackTrace(stack);
                    t.printStackTrace(stream);
                    continue;
                }
                this.writeToByteArrayOutputStream(str, "no stacktrace available");
            }
        } else {
            this.writeToByteArrayOutputStream(str, "None.");
        }
        return str.toString();
    }

    protected void writeToByteArrayOutputStream(ByteArrayOutputStream stream, String message) {
        try {
            stream.write(message.getBytes());
        }
        catch (IOException iOException) {}
    }
}

