/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.checks;

import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.checks.processmodel.CompositeProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.DefaultProcessCheckService;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.processmanager.checks.DecisionActivityCheck;
import de.aristaflow.adept2.core.processmanager.checks.NullNodeCheck;
import de.aristaflow.adept2.core.processmanager.checks.NullNodeParameterCheck;
import de.aristaflow.adept2.core.processmanager.checks.StaffAssignmentRuleCheck;
import de.aristaflow.adept2.core.processmanager.checks.UnusedDataElementCheck;
import de.aristaflow.adept2.util.DataSourceException;
import org.apache.commons.configuration.Configuration;

public class AllProductionChecks
extends CompositeProcessTemplateCheck {
    public AllProductionChecks(Configuration configuration, DefaultProcessCheckService checkService, Registry registry) throws ServiceNotKnownException {
        super(new NullNodeCheck(), new DecisionActivityCheck(), new UnusedDataElementCheck(), new StaffAssignmentRuleCheck(AllProductionChecks.getSessionToken(checkService, registry), AllProductionChecks.getPolicyResolution(AllProductionChecks.getSessionToken(checkService, registry), registry)), new NullNodeParameterCheck());
    }

    private static SessionToken getSessionToken(DefaultProcessCheckService checkService, Registry registry) {
        try {
            SessionFactory sessionFactory = registry.getSecurityManager().authenticatePrivileged(-2L, -2L, "password");
            return sessionFactory.getSessionToken(checkService.getURIs());
        }
        catch (AuthenticationException ae) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to wrongauthentication data. Check the configuration of this ProcessManager.", ae);
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to unavailability of the data.", dse);
        }
    }

    private static PolicyResolution getPolicyResolution(SessionToken session, Registry registry) throws ServiceNotKnownException {
        return registry.getServiceOfType(session, "OrgModelManager", OrgModelManager.class).getPolicyResolution();
    }
}

