/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.checks;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class DecisionActivityCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Decision activity check.";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            ProcessConstants.NodeType type = template.getNodeType(node.getID());
            switch (type) {
                case NT_XOR_SPLIT: 
                case NT_ENDLOOP: {
                    if (node.getExecutableBusinessProcess() != null) break;
                    allOK = false;
                    String message = String.format("The node '%s' with ID %s must have a decision activity assigned.", node.getName(), node.getID());
                    if (checkReport != null) {
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    this.logger.info(message);
                    break;
                }
            }
        }
        return allOK;
    }
}

