/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.checks;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.Collection;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LWPReferenceCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "LWP reference consistency check.";
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final TemplateManager templateManager;
    protected final SessionFactory sessionFactory;
    private final ThreadLocal<Template[]> templates = new ThreadLocal();
    private final URI[] serviceURIs;

    public LWPReferenceCheck(TemplateManager templateManager, Template[] templates, SessionFactory sessionFactory, URI[] serviceURIs) {
        this.templateManager = templateManager;
        this.serviceURIs = (URI[])serviceURIs.clone();
        this.templates.set((Template[])templates.clone());
        this.sessionFactory = sessionFactory;
    }

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
            if (ebp instanceof VariableParallelismEBP) {
                ebp = ((VariableParallelismEBP)ebp).getLightWeightProcess();
            }
            if (ebp == null || !(ebp instanceof LightWeightProcess)) continue;
            LightWeightProcess lwp = (LightWeightProcess)ebp;
            if (!(lwp instanceof ReferencedProcess)) {
                if (lwp instanceof EmbeddedProcess) continue;
                throw new IllegalArgumentException("The sub type of the given EBP is unknown!");
            }
            UUID templateID = ((ReferencedProcess)lwp).getTemplateID();
            Template subProcess = null;
            Object[] objectArray = this.templates.get();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Template otherTemplate = objectArray[n2];
                if (otherTemplate == template) break;
                if (otherTemplate.getID().equals(templateID)) {
                    subProcess = otherTemplate;
                }
                ++n2;
            }
            if (subProcess == null) {
                try {
                    subProcess = this.templateManager.getTemplate(this.sessionFactory.getSessionToken(this.serviceURIs), templateID);
                }
                catch (InternalServiceException ise) {
                    allOK = false;
                    String message = String.format("Found invalid reference to sub process with ID '%s' at node '%s' (#%s). An InternalServiceException was thrown (%s).", templateID, node.getName(), node.getID(), ise.getMessage());
                    if (checkReport != null) {
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    this.logger.log(Level.INFO, message, ise);
                }
                catch (IllegalArgumentException iae) {
                    allOK = false;
                    String message = String.format("Found invalid reference to sub process with ID '%s' at node '%s' (#%s). An IllegalArgumentException was thrown (%s).", templateID, node.getName(), node.getID(), iae.getMessage());
                    if (checkReport != null) {
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    this.logger.log(Level.INFO, message, iae);
                }
            }
            if (subProcess == null) continue;
            objectArray = ActivityConstants.AccessType.activityRelatedValues();
            n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Template accessType = objectArray[n3];
                if (!this.compareParameters(lwp.getParameters((ActivityConstants.AccessType)((Object)accessType)), subProcess.getParameters((ActivityConstants.AccessType)((Object)accessType)), checkReport)) {
                    allOK = false;
                }
                ++n3;
            }
        }
        if (allOK) {
            this.logger.info("LWP reference consistency check. ok.");
        } else {
            this.logger.info("LWP reference consistency check. not ok.");
        }
        return allOK;
    }

    protected boolean compareParameters(Collection<ProcessModelParameter> lwp, Collection<ProcessModelParameter> subp, CheckReport checkReport) {
        boolean allOK = true;
        return allOK;
    }
}

