/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.checks;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class NullNodeCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Null node check.";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            URI[] affectedElements;
            String message;
            ProcessConstants.NodeType type = template.getNodeType(node.getID());
            if (ProcessModelTools.isNullNode(type)) {
                if (node.getExecutableBusinessProcess() == null) continue;
                allOK = false;
                message = String.format("The node '%s' with ID %s must not have an EBP assigned.", node.getName(), node.getID());
                if (checkReport != null) {
                    affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.info(message);
                continue;
            }
            if (node.getExecutableBusinessProcess() != null) continue;
            allOK = false;
            message = String.format("The node '%s' with ID %s must have an EBP assigned.", node.getName(), node.getID());
            if (checkReport != null) {
                affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.WARNING, message, affectedElements);
            }
            this.logger.info(message);
        }
        return allOK;
    }
}

