/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.checks;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.Arrays;
import java.util.logging.Logger;

public class NullNodeParameterCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Null node parameter check.";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            int[] writtenDataElements;
            int nodeID;
            if (node.getExecutableBusinessProcess() != null || template.getNodeType(nodeID = node.getID()) == ProcessConstants.NodeType.NT_ENDFLOW || template.getNodeType(nodeID) == ProcessConstants.NodeType.NT_STARTFLOW) continue;
            int[] readDataElements = template.getAccessedDataElementIDsForNode(nodeID, ActivityConstants.AccessType.READ);
            if (readDataElements.length > 0) {
                allOK = false;
                String message = String.format("The node with ID %s reads data of data element(s) %s, but does not have an EBP attached.", nodeID, Arrays.toString(readDataElements));
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.WARNING, message, affectedElements);
                }
                this.logger.info(message);
            }
            if ((writtenDataElements = template.getAccessedDataElementIDsForNode(nodeID, ActivityConstants.AccessType.WRITE)).length <= 0) continue;
            allOK = false;
            String message = String.format("The node with ID %s writes data to data element(s) %s, but does not have an EBP attached.", nodeID, Arrays.toString(writtenDataElements));
            if (checkReport != null) {
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.WARNING, message, affectedElements);
            }
            this.logger.info(message);
        }
        return allOK;
    }
}

