/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.checks;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.orgmodel.OrgPolicyReport;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class StaffAssignmentRuleCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Staff assignment rule check.";
    protected final Logger logger = LoggerTools.getLogger(this);
    private SessionToken session;
    private final PolicyResolution policyResolution;

    public StaffAssignmentRuleCheck(SessionToken session, PolicyResolution policyResolution) {
        this.session = session;
        this.policyResolution = policyResolution;
    }

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        block5: for (Node node : template.getNodes()) {
            ProcessConstants.NodeType type = template.getNodeType(node.getID());
            String sar = node.getStaffAssignmentRule();
            switch (type) {
                case NT_NORMAL: 
                case NT_XOR_SPLIT: 
                case NT_ENDLOOP: {
                    URI[] affectedElements;
                    String message;
                    OrgPolicyReport policyReport;
                    URI[] affectedElements2;
                    String message2;
                    if (sar.equals("")) {
                        allOK = false;
                        message2 = String.format("The node '%s' with ID %s is missing a staffassignment rule.", node.getName(), node.getID());
                        if (checkReport != null) {
                            affectedElements2 = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.WARNING, message2, affectedElements2);
                        }
                        this.logger.info(message2);
                        break;
                    }
                    try {
                        policyReport = this.policyResolution.checkResolvability(this.session, sar, false, false);
                    }
                    catch (DataSourceException dataSourceException) {
                        allOK = false;
                        message = String.format("Exception resolving staff assignment rule of node %s.", node.getID());
                        if (checkReport != null) {
                            affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                        }
                        this.logger.severe(message);
                        break;
                    }
                    if (policyReport.getOverallResult() != OrgPolicyReport.ResultType.ERROR && policyReport.getOverallResult() != OrgPolicyReport.ResultType.WARNING) continue block5;
                    allOK = false;
                    message = String.format("Error resolving staff assignment rule of node %s, %s errors, SAR: '%s'.", node.getID(), policyReport.getEntries().length, sar);
                    if (checkReport != null) {
                        affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    this.logger.severe(message);
                    break;
                }
                default: {
                    URI[] affectedElements2;
                    if (sar.equals("")) continue block5;
                    allOK = false;
                    String message2 = String.format("The node '%s' with ID %s is of type %s (i.e. a null node), but has a staff assignment rule: '%s' .", new Object[]{node.getName(), node.getID(), type, node.getStaffAssignmentRule()});
                    if (checkReport != null) {
                        affectedElements2 = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message2, affectedElements2);
                    }
                    this.logger.info(message2);
                }
            }
        }
        return allOK;
    }
}

