/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.processmanager.checks;

import de.aristaflow.adept2.core.checks.processmodel.AbstractProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.CheckReport;

public class UnusedDataElementCheck
extends AbstractProcessTemplateCheck {
    private static final String ID = "Unused Data Element Check";

    protected UnusedDataElementCheck() {
        super(ID);
    }

    @Override
    public void performCheckSpi(Template template, NodeRelations relations, CheckReport checkReport) {
        for (DataElement dataElement : template.getDataElements()) {
            String message;
            int dataElementID = dataElement.getID();
            int[] readers = template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.READ);
            int[] systemReaders = template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.SYSTEM_READ);
            int[] writers = template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.WRITE);
            int[] systemWriters = template.getAccessingNodeIDsForDataElement(dataElementID, ActivityConstants.AccessType.SYSTEM_WRITE);
            boolean isDecisionDataElement = ProcessModelTools.isDecisionDataElement(template, dataElementID);
            if (readers.length == 0 && systemReaders.length == 0 && writers.length == 0 && systemWriters.length == 0) {
                message = String.format("The data element '%s' (%s) is unused.", dataElement.getName(), dataElement.getID());
                this.addReportEntry(CheckReport.ResultType.FAILURE, message, dataElement);
                continue;
            }
            if (isDecisionDataElement || readers.length != 0 || systemReaders.length != 0) continue;
            message = String.format("The data element '%s' (%s) is never read.", dataElement.getName(), dataElement.getID());
            this.addReportEntry(CheckReport.ResultType.INFO, message, dataElement);
        }
    }
}

